<?php

/*
 * This file is part of Laravel Exceptions.
 *
 * (c) Graham Campbell <graham@mineuk.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace GuoJiangClub\EC\Open\Backend\Store\Exceptions\Displayers;

use Exception;

/**
 * This is the displayer interface.
 *
 * @author Graham Campbell <graham@mineuk.com>
 */
interface DisplayerInterface
{
    /**
     * Get the content associated with the given exception.
     *
     * @param \Exception $exception
     * @param int        $code
     *
     * @return string|array
     */
    public function display(Exception $exception, $code);
}
