SET FOREIGN_KEY_CHECKS=0;


-- ----------------------------
-- Table structure for `ibrand_category`
-- ----------------------------
DROP TABLE IF EXISTS `ibrand_category`;
CREATE TABLE `ibrand_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `sort` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `parent_id` int(10) unsigned DEFAULT NULL,
  `level` int(11) DEFAULT '1',
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '/',
  `_lft` int(10) unsigned DEFAULT '0',
  `_rgt` int(10) unsigned DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ibrand_category__lft__rgt_parent_id_index` (`_lft`,`_rgt`,`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of ibrand_category
-- ----------------------------
INSERT INTO `ibrand_category` VALUES ('1', '男童专区', null, '2', '1', '0', '1', '/1/', null, null, '2017-05-11 11:30:20', '2017-09-22 13:07:52', null);
INSERT INTO `ibrand_category` VALUES ('2', '女童专区', null, '3', '1', '0', '1', '/2/', null, null, '2017-05-11 11:45:26', '2017-09-22 13:07:52', null);
INSERT INTO `ibrand_category` VALUES ('3', '男童T恤/衬衫', null, '0', '1', '1', '2', '/1/3/', null, null, '2017-05-11 11:46:11', '2018-05-16 15:57:36', null);
INSERT INTO `ibrand_category` VALUES ('4', '休闲裤', null, '0', '1', '1', '2', '/1/4/', null, null, '2017-05-11 11:46:36', '2017-09-22 13:07:52', null);
INSERT INTO `ibrand_category` VALUES ('5', '套装', null, '0', '1', '1', '2', '/1/5/', null, null, '2017-05-11 11:46:54', '2017-09-22 13:07:52', null);
INSERT INTO `ibrand_category` VALUES ('6', '女童T恤/衬衫', null, '0', '1', '2', '2', '/2/6/', null, null, '2017-05-11 11:47:11', '2018-05-16 15:57:46', null);
INSERT INTO `ibrand_category` VALUES ('7', '裙装', null, '0', '1', '2', '2', '/2/7/', null, null, '2017-05-11 11:47:21', '2017-09-22 13:07:52', null);
INSERT INTO `ibrand_category` VALUES ('8', '裤装', null, '0', '1', '2', '2', '/2/8/', null, null, '2017-05-11 11:47:58', '2017-09-22 13:07:52', null);
INSERT INTO `ibrand_category` VALUES ('9', '外套', null, '0', '1', '2', '2', '/2/9/', null, null, '2017-05-11 11:48:05', '2017-09-22 13:07:52', null);
INSERT INTO `ibrand_category` VALUES ('10', '促销专区', null, '999', '1', '0', '1', '/10/', null, null, '2017-05-11 11:48:49', '2019-01-23 11:28:02', null);
INSERT INTO `ibrand_category` VALUES ('11', '热卖专区', null, '1', '1', '0', '1', '/11/', null, null, '2017-05-11 11:49:00', '2017-09-22 13:07:52', null);
INSERT INTO `ibrand_category` VALUES ('12', '套装', null, '0', '1', '2', '2', '/2/12/', null, null, '2017-05-11 11:50:52', '2017-09-22 13:07:52', null);
INSERT INTO `ibrand_category` VALUES ('13', '5.11伞', null, '0', '1', '0', '1', '/13/', null, null, '2017-09-22 13:13:18', '2017-09-22 13:13:18', null);
INSERT INTO `ibrand_category` VALUES ('14', '玩具', null, '0', '1', '0', '1', '/14/', null, null, '2017-10-16 15:02:28', '2017-10-16 15:02:28', null);
INSERT INTO `ibrand_category` VALUES ('15', '亲子装', null, '0', '1', '0', '1', '/15/', null, null, '2018-05-15 15:51:10', '2018-05-15 15:51:10', null);
INSERT INTO `ibrand_category` VALUES ('16', '母女亲子装', null, '0', '1', '15', '2', '/15/16/', null, null, '2018-05-15 15:51:49', '2018-05-15 15:51:49', null);
INSERT INTO `ibrand_category` VALUES ('17', '一家三口亲子装', null, '0', '1', '15', '2', '/15/17/', null, null, '2018-05-15 15:52:05', '2018-05-15 15:52:05', null);
INSERT INTO `ibrand_category` VALUES ('18', '新品', null, '1', '1', '0', '1', '/18/', null, null, '2018-05-21 11:20:08', '2018-08-10 16:52:40', null);
INSERT INTO `ibrand_category` VALUES ('19', '5.22上新第一波', null, '2', '1', '18', '2', '/18/19/', null, null, '2018-05-21 11:21:21', '2018-08-10 16:52:49', null);
INSERT INTO `ibrand_category` VALUES ('20', '家居服', null, '0', '1', '0', '1', '/20/', null, null, '2018-05-21 13:56:40', '2018-05-21 13:56:40', null);
INSERT INTO `ibrand_category` VALUES ('21', '防晒服', null, '0', '1', '0', '1', '/21/', null, null, '2018-05-21 13:56:48', '2018-05-21 13:56:48', null);
INSERT INTO `ibrand_category` VALUES ('23', '春夏款', null, '0', '1', '20', '2', '/20/23/', null, null, '2018-05-21 14:56:13', '2018-05-21 14:56:13', null);
INSERT INTO `ibrand_category` VALUES ('24', '秋冬款', null, '0', '1', '20', '2', '/20/24/', null, null, '2018-05-21 14:56:29', '2018-05-21 14:56:29', null);
INSERT INTO `ibrand_category` VALUES ('25', '背心', null, '0', '1', '1', '2', '/1/25/', null, null, '2018-05-25 14:06:41', '2018-05-25 14:07:09', null);
INSERT INTO `ibrand_category` VALUES ('26', '5.28上新第二波', null, '3', '1', '18', '2', '/18/26/', null, null, '2018-05-31 16:52:18', '2018-08-10 16:53:18', null);
INSERT INTO `ibrand_category` VALUES ('27', '防蚊防晒', null, '0', '1', '41', '2', '/41/27/', null, null, '2018-06-05 15:43:20', '2018-06-11 10:55:10', null);
INSERT INTO `ibrand_category` VALUES ('28', '午睡毯', null, '0', '1', '32', '3', '/41/32/28/', null, null, '2018-06-05 15:43:55', '2018-06-11 12:34:13', null);
INSERT INTO `ibrand_category` VALUES ('29', '防蚊', null, '0', '1', '27', '3', '/41/27/29/', null, null, '2018-06-07 11:08:49', '2018-06-11 10:55:10', null);
INSERT INTO `ibrand_category` VALUES ('31', '防晒', null, '0', '1', '27', '3', '/41/27/31/', null, null, '2018-06-07 11:09:18', '2018-06-11 10:55:10', null);
INSERT INTO `ibrand_category` VALUES ('32', '居家收纳', null, '0', '1', '41', '2', '/41/32/', null, null, '2018-06-07 14:51:39', '2018-06-11 10:55:01', null);
INSERT INTO `ibrand_category` VALUES ('33', '上装', null, '0', '1', '0', '1', '/33/', null, null, '2018-06-08 11:43:05', '2018-06-08 11:43:05', null);
INSERT INTO `ibrand_category` VALUES ('34', 'T恤', null, '0', '1', '33', '2', '/33/34/', null, null, '2018-06-08 11:43:16', '2018-06-08 11:43:16', null);
INSERT INTO `ibrand_category` VALUES ('35', '背心', null, '0', '1', '33', '2', '/33/35/', null, null, '2018-06-08 11:43:26', '2018-06-08 11:43:26', null);
INSERT INTO `ibrand_category` VALUES ('36', '上装', null, '0', '1', '0', '1', '/36/', null, null, '2018-06-08 11:43:44', '2018-06-08 11:43:44', null);
INSERT INTO `ibrand_category` VALUES ('37', 'T恤', null, '0', '1', '36', '2', '/36/37/', null, null, '2018-06-08 11:44:07', '2018-06-08 11:44:07', null);
INSERT INTO `ibrand_category` VALUES ('38', '背心', null, '0', '1', '36', '2', '/36/38/', null, null, '2018-06-08 11:44:17', '2018-06-08 11:44:26', null);
INSERT INTO `ibrand_category` VALUES ('39', '连衣裙', null, '0', '1', '7', '3', '/2/7/39/', null, null, '2018-06-11 10:21:47', '2018-06-11 10:21:47', null);
INSERT INTO `ibrand_category` VALUES ('40', '短裙', null, '0', '1', '7', '3', '/2/7/40/', null, null, '2018-06-11 10:22:05', '2018-06-11 10:22:05', null);
INSERT INTO `ibrand_category` VALUES ('41', '夏季爆款', null, '0', '1', '0', '1', '/41/', null, null, '2018-06-11 10:53:19', '2018-09-03 14:36:21', null);
INSERT INTO `ibrand_category` VALUES ('42', '6.8上新第三波', null, '3', '1', '18', '2', '/18/42/', null, null, '2018-06-11 12:37:16', '2018-06-11 12:37:16', null);
INSERT INTO `ibrand_category` VALUES ('43', '2018秋新品', null, '4', '1', '18', '2', '/18/43/', null, null, '2018-08-10 16:50:45', '2018-08-10 16:53:03', null);
INSERT INTO `ibrand_category` VALUES ('44', '外套', null, '0', '1', '1', '2', '/1/44/', null, null, '2018-08-10 16:51:05', '2018-08-10 16:51:05', null);
INSERT INTO `ibrand_category` VALUES ('45', '儿童配饰', null, '0', '1', '0', '1', '/45/', null, null, '2018-08-16 16:12:35', '2018-09-19 11:08:30', null);
INSERT INTO `ibrand_category` VALUES ('46', '渔夫帽', null, '0', '1', '45', '2', '/45/46/', null, null, '2018-08-16 16:12:45', '2018-08-16 16:12:45', null);
INSERT INTO `ibrand_category` VALUES ('47', '棒球帽', null, '0', '1', '45', '2', '/45/47/', null, null, '2018-08-16 16:12:58', '2018-08-16 16:12:58', null);
INSERT INTO `ibrand_category` VALUES ('48', '童鞋', null, '0', '1', '0', '1', '/48/', null, null, '2018-09-03 14:36:34', '2018-09-03 14:36:34', null);
INSERT INTO `ibrand_category` VALUES ('49', '帆布鞋', null, '1', '1', '48', '2', '/48/49/', null, null, '2018-09-03 14:37:07', '2018-09-03 14:37:07', null);
INSERT INTO `ibrand_category` VALUES ('50', '儿童内裤', null, '0', '1', '0', '1', '/50/', null, null, '2018-09-04 19:40:41', '2018-09-04 19:40:41', null);
INSERT INTO `ibrand_category` VALUES ('51', '女童内裤', null, '0', '1', '50', '2', '/50/51/', null, null, '2018-09-04 19:41:06', '2018-09-04 19:41:06', null);
INSERT INTO `ibrand_category` VALUES ('52', '男童内裤', null, '0', '1', '50', '2', '/50/52/', null, null, '2018-09-04 19:41:29', '2018-09-04 19:41:29', null);
INSERT INTO `ibrand_category` VALUES ('53', '儿童袜子', null, '0', '1', '0', '1', '/53/', null, null, '2018-09-05 09:13:20', '2018-09-05 09:13:20', null);
INSERT INTO `ibrand_category` VALUES ('54', '女童打底裤', null, '0', '1', '8', '3', '/2/8/54/', null, null, '2018-09-11 17:01:33', '2018-09-11 17:01:33', null);
INSERT INTO `ibrand_category` VALUES ('55', '围巾', null, '0', '1', '45', '2', '/45/55/', null, null, '2018-09-18 10:23:32', '2018-09-19 11:07:08', null);
INSERT INTO `ibrand_category` VALUES ('56', '儿童包包', null, '0', '1', '45', '2', '/45/56/', null, null, '2018-09-18 10:47:59', '2018-09-19 11:08:16', null);
INSERT INTO `ibrand_category` VALUES ('57', '水杯', null, '0', '1', '0', '1', '/57/', null, null, '2018-09-18 13:10:43', '2018-09-18 13:10:43', null);

-- ----------------------------
-- Table structure for ibrand_goods
-- ----------------------------
DROP TABLE IF EXISTS `ibrand_goods`;
CREATE TABLE `ibrand_goods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `goods_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `brand_id` int(10) unsigned NOT NULL,
  `model_id` int(10) unsigned NOT NULL,
  `min_price` decimal(15,2) NOT NULL,
  `max_price` decimal(15,2) NOT NULL,
  `sell_price` decimal(15,2) NOT NULL,
  `market_price` decimal(15,2) DEFAULT NULL,
  `min_market_price` decimal(15,2) DEFAULT NULL,
  `cost_price` decimal(15,2) DEFAULT NULL,
  `weight` decimal(15,2) DEFAULT NULL,
  `store_nums` int(11) NOT NULL DEFAULT '0',
  `img` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` mediumtext COLLATE utf8mb4_unicode_ci,
  `contentpc` mediumtext COLLATE utf8mb4_unicode_ci,
  `sync` tinyint(4) NOT NULL DEFAULT '0',
  `comment_count` int(11) NOT NULL DEFAULT '0',
  `visit_count` int(11) NOT NULL DEFAULT '0',
  `favorite_count` int(11) NOT NULL DEFAULT '0',
  `sale_count` int(11) NOT NULL DEFAULT '0',
  `grade` int(11) NOT NULL DEFAULT '0',
  `tags` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_del` tinyint(4) NOT NULL DEFAULT '0',
  `is_largess` tinyint(4) NOT NULL DEFAULT '0',
  `is_commend` tinyint(4) NOT NULL DEFAULT '0',
  `is_new` tinyint(4) NOT NULL DEFAULT '0',
  `collocation` text COLLATE utf8mb4_unicode_ci,
  `extra` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=173 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of ibrand_goods
-- ----------------------------
INSERT INTO `ibrand_goods` VALUES ('2', '2017新款夏季韩版儿童纯棉公主裙', 'YLY142', '1', '2', '99.00', '99.00', '99.00', '199.00', '199.00', null, null, '265', 'http://admin.viperky.com/uploads/fHKf65Xc6F.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/328/942/4106249823_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/226/552/4106255622_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/998/642/4106246899_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/957/252/4106252759_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/569/003/4110300965_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/206/398/4106893602_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/410/762/4106267014_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/407/303/4110303704_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/313/162/4106261313_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/407/852/4106258704_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/902/903/4110309209_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/663/462/4106264366_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/976/603/4110306679_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/150/998/4106899051_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/868/552/4106255868_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '4', '0', '潮范', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-05-11 16:06:19', '2017-09-22 12:55:00', null);
INSERT INTO `ibrand_goods` VALUES ('3', '女童短裤夏季2017新款纯白韩版破洞女短裤宝宝沙滩短裤薄款', 'YDK42', '1', '1', '99.00', '99.00', '99.00', '199.00', '199.00', null, null, '147', 'http://admin.viperky.com/uploads/WW5Ye37FvP.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/345/747/4106747543_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/391/957/4106759193_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/972/147/4110741279_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/297/103/4107301792_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/474/703/4107307474_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/145/057/4106750541_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/826/403/4107304628_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/661/447/4110744166_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/071/267/4106762170_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/288/147/4106741882_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/700/567/4106765007_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/593/657/4106756395_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/569/837/4110738965_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/717/747/4106747717_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/943/957/4106759349_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '8', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-05-15 15:22:03', '2017-09-22 12:55:00', null);
INSERT INTO `ibrand_goods` VALUES ('4', '女童短裤2017夏季新款儿童中腰牛裤短裤', 'YDK43', '1', '1', '120.00', '120.00', '120.00', '239.00', '239.00', null, null, '154', 'http://admin.viperky.com/uploads/kvcOIzDzVA.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/522/382/4174283225_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/912/682/4174286219_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/778/365/4175563877_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/594/379/4178973495_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/397/079/4178970793_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/756/082/4174280657_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/309/769/4178967903_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/087/665/4175566780_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/440/185/4175581044_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/662/575/4175575266_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/858/679/4178976858_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/442/485/4175584244_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/070/499/4178994070_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '4', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-05-15 15:29:10', '2017-09-22 12:55:00', null);
INSERT INTO `ibrand_goods` VALUES ('5', '2017新款韩版儿童网纱连衣裙 吊带裙公主裙', 'YLY100', '1', '2', '135.00', '135.00', '135.00', '269.00', '269.00', null, null, '109', 'http://admin.viperky.com/uploads/AXRYRIOOgt.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/814/621/4068126418_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/282/657/4064756282_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/638/411/4068114836_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/252/957/4064759252_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/760/874/4065478067_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/148/711/4068117841_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/582/574/4065475285_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/275/747/4064747572_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/859/274/4065472958_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/799/357/4064753997_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/283/484/4065484382_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/071/867/4064768170_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/848/921/4068129848_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/252/957/4064759252_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '7', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-05-15 15:36:23', '2017-09-22 12:55:00', null);
INSERT INTO `ibrand_goods` VALUES ('6', '女童连衣裙夏季新款2017韩版儿童公主无袖裙', 'YLY130', '1', '2', '135.00', '135.00', '135.00', '269.00', '269.00', null, null, '245', 'http://admin.viperky.com/uploads/rGP6aqDWdc.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/142/033/4015330241_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/656/683/4014386656_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/102/333/4015333201_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/523/444/4017444325_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/719/123/4015321917_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/708/723/4015327807_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/096/383/4014383690_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/640/593/4014395046_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/039/813/4015318930_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/359/773/4014377953_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/635/293/4014392536_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/947/144/4017441749_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/523/444/4017444325_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '7', '0', '潮范,公主,可爱', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-05-15 15:45:37', '2017-09-22 12:55:00', null);
INSERT INTO `ibrand_goods` VALUES ('7', '2017新款夏季撞色拼接绣花纱裙', 'YLY104', '1', '2', '85.00', '85.00', '85.00', '169.00', '169.00', null, null, '225', 'http://admin.viperky.com/uploads/pd8GFZNwWK.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/372/835/4076538273_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/757/925/4076529757_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/284/235/4076532482_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/604/284/4073482406_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/193/145/4076541391_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/732/884/4073488237_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/212/900/4073009212_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/146/535/4076535641_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/857/000/4073000758_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/031/584/4073485130_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/065/974/4073479560_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/599/325/4076523995_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/018/625/4076526810_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/604/284/4073482406_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '5', '0', '公主,可爱', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-05-15 16:00:54', '2017-09-22 12:55:00', null);
INSERT INTO `ibrand_goods` VALUES ('8', '女童连衣裙夏季2017新款韩版卡通无袖公主连衣裙', 'YLY103', '1', '2', '135.00', '135.00', '135.00', '269.00', '269.00', null, null, '178', 'http://admin.viperky.com/uploads/rDJ3wYd7qK.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/844/753/3971357448_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/600/442/3974244006_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/356/271/3972172653_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/964/571/3972175469_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/553/063/3971360355_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/011/142/3974241110_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/839/661/3972166938_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/760/871/3972178067_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/517/922/3974229715_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/743/832/3974238347_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/328/232/3974232823_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/128/453/3971354821_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/894/532/3974235498_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/195/753/3971357591_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '8', '0', '卡通,公主', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-05-15 16:07:30', '2017-09-22 12:55:00', null);
INSERT INTO `ibrand_goods` VALUES ('9', '女童夏季连衣裙2017新款儿童韩版女宝宝吊带裙', 'YLY125', '1', '2', '135.00', '135.00', '135.00', '269.00', '269.00', null, null, '228', 'http://admin.viperky.com/uploads/ZHujwnos8f.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/289/059/3987950982_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/179/749/3987947971_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/020/569/3987965020_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/435/659/3987956534_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/726/279/3990972627_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/191/959/3987959191_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/020/468/3988864020_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/573/168/3988861375_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/861/269/3987962168_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/856/858/3988858658_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/911/579/3990975119_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/911/879/3990978119_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/435/659/3987956534_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '4', '0', '潮范,花边', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-05-15 16:13:34', '2017-09-22 12:55:00', null);
INSERT INTO `ibrand_goods` VALUES ('10', '女童短裙套装2017夏季新品韩版无袖卡通蓬蓬纱裙两件套', 'YTZ114', '1', '2', '125.00', '125.00', '125.00', '249.00', '249.00', null, null, '212', 'http://admin.viperky.com/uploads/uCXuuuBI4U.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/535/845/4016548535_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/262/497/4018794262_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/463/517/4015715364_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/335/907/4015709533_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/690/455/4016554096_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/704/197/4018791407_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/354/217/4015712453_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/194/155/4016551491_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/818/545/4016545818_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/885/887/4018788588_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/009/287/4018782900_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/526/587/4018785625_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/543/817/4015718345_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/066/845/4016548660_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/690/455/4016554096_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '5', '0', '套装,公主', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-05-15 16:41:51', '2017-09-22 12:55:00', null);
INSERT INTO `ibrand_goods` VALUES ('11', '夏装2017新款儿童纯棉公主裙背心裙吊带裙', 'YLY108', '1', '2', '99.00', '99.00', '99.00', '199.00', '199.00', null, null, '500', 'http://admin.viperky.com/uploads/hUcpOHtNJ8.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/946/756/4049657649_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/143/366/4049663341_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/110/889/4052988011_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/004/391/4050193400_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/623/991/4050199326_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/032/666/4049666230_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/257/456/4049654752_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/355/289/4052982553_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/120/966/4049669021_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><img src=\"http://admin.viperky.com/uploads/ueditor/php/upload/image/20170515/1494838354941908.jpeg\" style=\"\" title=\"1494838354941908.jpeg\"/></p><p><img src=\"http://admin.viperky.com/uploads/ueditor/php/upload/image/20170515/1494838355986795.jpeg\" style=\"\" title=\"1494838355986795.jpeg\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/506/691/4050196605_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/682/589/4052985286_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/251/499/4052994152_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/141/199/4052991141_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/798/756/4049657897_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '11', '0', '运动,公主,可爱', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-05-15 16:52:45', '2017-09-22 12:55:00', null);
INSERT INTO `ibrand_goods` VALUES ('12', '夏季2017新款韩版卡通印花无袖小童公主连衣裙', 'YLY116', '1', '2', '99.00', '99.00', '99.00', '199.00', '199.00', null, null, '183', 'http://admin.viperky.com/uploads/k8OKH0uDdh.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/055/659/3971956550_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/086/681/3971186680_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/177/081/3971180771_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/842/291/3971192248_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/445/981/3971189544_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/495/359/3971953594_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/463/269/3971962364_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/272/569/3971965272_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/129/771/3971177921_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/166/820/3974028661_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/299/520/3974025992_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/518/381/3971183815_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/370/591/3971195073_885594632.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '7', '0', '卡通,印花,公主', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-05-15 17:24:01', '2017-09-22 12:55:00', null);
INSERT INTO `ibrand_goods` VALUES ('13', '5.11网红伞', '77000', '2', '4', '298.00', '298.00', '298.00', '298.00', '298.00', null, null, '95', 'https://cdn.viperky.com/storage/images/20170922/zkxPM8kQP5.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20170922/1506074997743261.jpeg\" style=\"\" title=\"1506074997743261.jpeg\"/></p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20170922/1506074998439720.jpeg\" style=\"\" title=\"1506074998439720.jpeg\"/></p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20170922/1506074998754948.jpeg\" style=\"\" title=\"1506074998754948.jpeg\"/></p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20170922/1506074998712176.jpeg\" style=\"\" title=\"1506074998712176.jpeg\"/></p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20170922/1506074998933688.jpeg\" style=\"\" title=\"1506074998933688.jpeg\"/></p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20170922/1506074998924112.jpeg\" style=\"\" title=\"1506074998924112.jpeg\"/></p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20170922/1506074998901924.jpeg\" style=\"\" title=\"1506074998901924.jpeg\"/></p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20170922/1506074998912948.jpeg\" style=\"\" title=\"1506074998912948.jpeg\"/></p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20170922/1506074998922665.jpeg\" style=\"\" title=\"1506074998922665.jpeg\"/></p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20170922/1506074998254980.jpeg\" style=\"\" title=\"1506074998254980.jpeg\"/></p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20170922/1506074998669268.jpeg\" style=\"\" title=\"1506074998669268.jpeg\"/></p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20170922/1506074998109744.jpeg\" style=\"\" title=\"1506074998109744.jpeg\"/></p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20170922/1506074998953364.jpeg\" style=\"\" title=\"1506074998953364.jpeg\"/></p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20170922/1506074999954885.jpeg\" style=\"\" title=\"1506074999954885.jpeg\"/></p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20170922/1506074999749107.jpeg\" title=\"1506074999749107.jpeg\" style=\"white-space: normal;\"/></p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20170922/1506074999122238.jpeg\" style=\"\" title=\"1506074999122238.jpeg\"/></p><p><br/></p>', null, '0', '0', '0', '0', '8', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-09-22 13:26:08', '2018-08-14 16:43:20', null);
INSERT INTO `ibrand_goods` VALUES ('14', '迪士尼球拍小学生双拍亲子互动小孩宝宝玩具3-12岁儿童羽毛球拍', 'SD21001', '3', '5', '28.00', '28.00', '28.00', '37.00', '37.00', null, null, '5', 'https://cdn.viperky.com/storage/images/20171016/16KrfmUqvK.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171019/1508426232406895.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171019/1508426238551490.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171019/1508426244545440.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171019/1508426248841405.jpg\"/></p>', null, '0', '0', '0', '0', '6', '0', '', '', '', '0', '1', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-10-16 15:09:03', '2018-03-30 08:08:07', null);
INSERT INTO `ibrand_goods` VALUES ('15', '韩国正品进口jumony sillymann思利满儿童硅胶水袋水壶便携300ml', 'jumony300', '3', '5', '145.00', '145.00', '145.00', '145.00', '145.00', null, null, '20', 'https://cdn.viperky.com/storage/images/20171018/TPNPxi1IAQ.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508335830615807.jpg\" align=\"absmiddle\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; max-width: 750px; background-color: rgb(255, 255, 255);\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508335830921969.jpg\" align=\"absmiddle\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; max-width: 750px; background-color: rgb(255, 255, 255);\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508335830428752.jpg\" align=\"absmiddle\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; max-width: 750px; background-color: rgb(255, 255, 255);\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508335830556123.jpg\" align=\"absmiddle\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; max-width: 750px; background-color: rgb(255, 255, 255);\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508335830961045.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; max-width: 750px; background-color: rgb(255, 255, 255);\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508335830601756.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; max-width: 750px; background-color: rgb(255, 255, 255);\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508335830898747.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; max-width: 750px; background-color: rgb(255, 255, 255);\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508335831698072.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; max-width: 750px; background-color: rgb(255, 255, 255);\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508335831579086.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; max-width: 750px; background-color: rgb(255, 255, 255);\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508335831997639.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; max-width: 750px; background-color: rgb(255, 255, 255);\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508335831141484.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; max-width: 750px; background-color: rgb(255, 255, 255);\"/></p>', null, '0', '0', '0', '0', '6', '0', '', '', '', '0', '1', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-10-18 22:12:12', '2017-10-18 22:12:12', null);
INSERT INTO `ibrand_goods` VALUES ('16', 'THERMOS膳魔师 保温杯 儿童 吸管杯不锈钢宝宝学饮杯婴儿水杯便携', 'theroms305', '3', '5', '159.00', '159.00', '159.00', '198.00', '198.00', null, null, '40', 'https://cdn.viperky.com/storage/images/20171018/2HSs7xcIuS.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px;\"><img src=\"https://img.alicdn.com/imgextra/i2/202980389/TB2NJdGbRE_1uJjSZFOXXXNwXXa_!!202980389.jpg\" align=\"absmiddle\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i4/202980389/TB23wyypEF7MKJjSZFLXXcMBVXa_!!202980389.jpg\" align=\"absmiddle\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i3/202980389/TB23t1Dp8cHL1JjSZJiXXcKcpXa_!!202980389.jpg\" align=\"absmiddle\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i2/202980389/TB2LARcgtXXWeJjSZFvXXa6lpXa_!!202980389.jpg\" align=\"absmiddle\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i2/202980389/TB2Eh3hamsQ2uJjSZFFXXXYUFXa_!!202980389.jpg\" class=\"\" align=\"absmiddle\" width=\"750\" height=\"319\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i4/202980389/TB22NqCp43IL1JjSZPfXXcrUVXa_!!202980389.jpg\" class=\"\" align=\"absmiddle\" width=\"750\" height=\"699\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i1/202980389/TB2B8xwdIhmZKJjSZFPXXc5_XXa_!!202980389.jpg\" class=\"\" align=\"absmiddle\" width=\"750\" height=\"480\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i4/202980389/TB2329npyFTMKJjSZFAXXckJpXa_!!202980389.jpg\" class=\"\" align=\"absmiddle\" width=\"750\" height=\"489\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i4/202980389/TB2BJ05XIGg21JjSZFyXXXIZVXa_!!202980389.jpg\" class=\"\" align=\"absmiddle\" width=\"750\" height=\"488\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i2/202980389/TB2LTiwb2nW1eJjSZFqXXa8sVXa_!!202980389.jpg\" class=\"\" align=\"absmiddle\" width=\"750\" height=\"465\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i2/202980389/TB2nOAhamsQ2uJjSZFFXXXYUFXa_!!202980389.jpg\" class=\"\" align=\"absmiddle\" width=\"750\" height=\"462\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i3/202980389/TB2.x1Cp43IL1JjSZPfXXcrUVXa_!!202980389.jpg\" class=\"\" align=\"absmiddle\" width=\"750\" height=\"400\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i2/202980389/TB2iR0BjTJ_SKJjSZPiXXb3LpXa_!!202980389.jpg\" class=\"\" align=\"absmiddle\" width=\"750\" height=\"408\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i2/202980389/TB2Clnup.UIL1JjSZFrXXb3xFXa_!!202980389.jpg\" class=\"\" align=\"absmiddle\" width=\"750\" height=\"270\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i3/202980389/TB2.t77iE1HTKJjSZFmXXXeYFXa_!!202980389.jpg\" class=\"\" align=\"absmiddle\" width=\"750\" height=\"506\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i2/202980389/TB2xKVGbRE_1uJjSZFOXXXNwXXa_!!202980389.jpg\" class=\"\" align=\"absmiddle\" width=\"750\" height=\"289\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i1/202980389/TB2gK8GbRE_1uJjSZFOXXXNwXXa_!!202980389.jpg\" class=\"\" align=\"absmiddle\" width=\"750\" height=\"825\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i4/202980389/TB2Ndvhh2MTUeJjSZFKXXagopXa_!!202980389.jpg\" class=\"\" align=\"absmiddle\" width=\"750\" height=\"471\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i4/202980389/TB2gauvmMn.PuJjSZFkXXc_lpXa_!!202980389.jpg\" class=\"\" align=\"absmiddle\" width=\"750\" height=\"468\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i3/202980389/TB2lmO5p.QIL1JjSZFhXXaDZFXa_!!202980389.jpg\" class=\"\" align=\"absmiddle\" width=\"750\" height=\"600\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i1/202980389/TB2_cE6lamWQ1JjSZPhXXXCJFXa_!!202980389.jpg\" class=\"\" align=\"absmiddle\" width=\"750\" height=\"412\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i4/202980389/TB2VIMhgfNZWeJjSZFpXXXjBFXa_!!202980389.jpg\" class=\"\" align=\"absmiddle\" width=\"750\" height=\"467\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i4/202980389/TB2wHTop5AKL1JjSZFoXXagCFXa_!!202980389.jpg\" class=\"\" align=\"absmiddle\" width=\"750\" height=\"498\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/><img src=\"https://img.alicdn.com/imgextra/i2/202980389/TB25SPup.UIL1JjSZFrXXb3xFXa_!!202980389.jpg\" class=\"\" align=\"absmiddle\" width=\"750\" height=\"527\" style=\"border: 0px; vertical-align: top; max-width: 750px;\"/></p><p><span style=\"overflow: visible;text-decoration:line-through;\"><strong style=\"overflow: visible;\"></strong></span></p><p><span style=\"overflow: visible;\"></span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; overflow: visible; line-height: 1.4;\"><img src=\"https://gdp.alicdn.com/imgextra/i1/202980389/TB28o7xXerAQeBjSZFwXXa_RpXa_!!202980389.jpg\" style=\"border: 0px; vertical-align: middle; overflow: visible;\"/></p><p></p><p><br/></p>', null, '0', '0', '0', '0', '8', '0', '', '', '', '0', '1', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-10-18 22:22:04', '2017-10-18 22:22:04', null);
INSERT INTO `ibrand_goods` VALUES ('17', '日本进口锦化成迪士尼米妮米奇 婴儿童宝宝/餐盘/餐具套装', 'dismk12', '3', '5', '98.00', '98.00', '98.00', '121.00', '121.00', null, null, '60', 'https://cdn.viperky.com/storage/images/20171018/QRikr21Ozc.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><span style=\"font-size: 24px;\"><span style=\"color: rgb(204, 0, 0);\"><strong><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337970769971.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337971283944.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337971561644.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337971563682.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337971853902.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337971501516.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337971554437.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337971735787.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337971946165.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337971442333.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337971589148.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337972708574.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337972984044.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337972315549.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337972881595.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337972544439.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337972877043.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337972192066.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337972833942.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337972587984.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337972516192.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; max-width: 750px;\"/></strong></span></span></p><p><a style=\"color: rgb(51, 102, 204); outline: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\" name=\"hn_mobiact_desc_1964805622_start\"></a></p><table cellpadding=\"0\" cellspacing=\"0\"><tbody><tr class=\"firstRow\"><td style=\"margin: 0px; padding: 0px;\"><br/></td></tr></tbody></table><p><a style=\"color: rgb(51, 102, 204); outline: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\" name=\"hn_mobiact_desc_1964805622_end\"></a></p><p><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337972431327.png\" class=\"\" style=\"border: 0px; vertical-align: middle;\"/></p><p>&nbsp;</p><p><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337972733340.png\" class=\"\" style=\"border: 0px; vertical-align: middle;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337972828199.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: middle; text-align: center; line-height: 1.5; max-width: 750px;\"/></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; text-align: center; background-color: rgb(255, 255, 255);\">&nbsp;<img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508337973346568.jpg\" class=\"\" style=\"border: 0px; vertical-align: top; width: 700px; float: none; margin: 0px;\"/>&nbsp;</p><p><br/></p>', null, '0', '0', '0', '0', '11', '0', '', '', '', '0', '1', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-10-18 22:46:49', '2017-10-18 22:46:49', null);
INSERT INTO `ibrand_goods` VALUES ('18', '狮王儿童牙膏0日本1进口2婴儿3宝宝4可吞咽-食5防蛀6含氟12食用岁', 'lionyg', '3', '5', '32.00', '32.00', '32.00', '60.00', '60.00', null, null, '60', 'https://cdn.viperky.com/storage/images/20171018/w0gVpGtQL2.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338228810180.jpg\" class=\"\" width=\"750\" height=\"962\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"/></p><p><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338260977261.jpg\" class=\"\" width=\"750\" height=\"563\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338297461563.jpg\" class=\"\" width=\"750\" height=\"434\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"/><span style=\"font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; background-color: rgb(255, 255, 255);\"></span><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338297942342.jpg\" class=\"\" width=\"750\" height=\"578\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338297175965.jpg\" class=\"\" width=\"750\" height=\"787\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338297300444.jpg\" class=\"\" width=\"750\" height=\"760\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338297934672.jpg\" class=\"\" width=\"750\" height=\"552\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"/></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px;\"><span style=\"font-family: 宋体;\"><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338312584369.jpg\" class=\"\" width=\"750\" height=\"480\" style=\"border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;\"/><br/></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px;\"><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338312376250.jpg\" class=\"\" width=\"730\" height=\"121\" style=\"border: 0px; vertical-align: top;\"/></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px;\"><img alt=\"\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338313118289.png\" class=\"\" width=\"750\" height=\"380\" style=\"border: 0px; vertical-align: top;\"/></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px;\">&nbsp;</p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px;\">如果大家觉得不够直观，也可以参见下图：左边为3岁以下的用量，右边为三岁以上的用量。</p><p><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338326377246.jpg\" class=\"\" align=\"absmiddle\" width=\"698\" height=\"395\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; max-width: 750px; background-color: rgb(255, 255, 255);\"/></p>', null, '0', '0', '0', '0', '9', '0', '', '', '', '0', '1', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-10-18 22:52:47', '2017-10-18 22:52:47', null);
INSERT INTO `ibrand_goods` VALUES ('19', '日本LION狮王细齿洁声波振动电动牙刷成人情侣旅行儿童小头软毛', 'liont', '3', '5', '109.00', '109.00', '109.00', '149.00', '149.00', null, null, '40', 'https://cdn.viperky.com/storage/images/20171018/ilPacpXOTu.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; line-height: 1.4; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; text-align: center; background-color: rgb(255, 255, 255);\"><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i4/3038150213/TB2m9heiEF7MKJjSZFLXXcMBVXa_!!3038150213.gif\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i1/3038150213/TB2xRKlayb_F1JjSZFzXXc6KXXa_!!3038150213.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i3/3038150213/TB2yFGle_SPY1JjSZPcXXXIwpXa_!!3038150213.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i4/3038150213/TB2GAKgarL9F1JjSZFwXXcSuVXa_!!3038150213.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i2/3038150213/TB21711lbsTMeJjy1zeXXcOCVXa_!!3038150213.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i2/3038150213/TB2hJi1fEUIL1JjSZFrXXb3xFXa_!!3038150213.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i3/3038150213/TB211mjaCz9F1JjSZFMXXXmNXXa_!!3038150213.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i3/3038150213/TB2Yt99gvJNTKJjSspoXXc6mpXa_!!3038150213.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i4/3038150213/TB2Tc1hap6.F1JjSZFpXXcZjXXa_!!3038150213.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i2/3038150213/TB2r3yiaC_9F1JjSZFhXXbadVXa_!!3038150213.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i4/3038150213/TB2KJzNaS_9F1JjSZFrXXcrVFXa_!!3038150213.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i1/3038150213/TB2FfV7X.yfF1Jjy0FbXXXSupXa_!!3038150213.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i1/3038150213/TB2zKShaxz_F1JjSZFIXXcxHVXa_!!3038150213.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/></p><p><img class=\"desc_anchor img-ks-lazyload\" id=\"desc-module-2\" src=\"https://assets.alicdn.com/kissy/1.0.0/build/imglazyload/spaceball.gif\" style=\"margin: 0px; padding: 0px; border: 0px; height: 1px; display: block; clear: both; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"/></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; line-height: 1.4; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; text-align: center; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; line-height: 1.4; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; text-align: center; background-color: rgb(255, 255, 255);\"><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i2/3038150213/TB2Iyagasr_F1JjSZFvXXcmJVXa_!!3038150213.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '9', '0', '', '', '', '0', '1', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-10-18 22:57:27', '2017-10-18 22:57:27', null);
INSERT INTO `ibrand_goods` VALUES ('20', '20寸卡通儿童拉杆箱小黄人男女宝宝行李箱万向轮旅行箱小孩可坐骑', 'XHR02', '3', '5', '258.00', '258.00', '258.00', '258.00', '258.00', null, null, '39', 'https://cdn.viperky.com/storage/images/20171018/zVj1XjxeRP.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"text-align: center;\"><span style=\"color: rgb(204, 0, 0); font-family: simhei; font-size: 48px; text-align: center; background-color: rgb(255, 255, 255);\">2016新款360度旋转飞机轮登机箱，配有美国海关认证TSA密码锁，高强度铝合金拉杆适合不同身高年龄段使用，成年人也可以用哦！！！内衬采用高档亲肤抗皱免烫涤纶面料。附送3种表情贴</span></p><p><span style=\"color: rgb(204, 0, 0); font-family: simhei; font-size: 48px; text-align: center; background-color: rgb(255, 255, 255);\"><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338671460082.jpg\"/></span></p><p><span style=\"color: rgb(204, 0, 0); font-family: simhei; font-size: 48px; text-align: center; background-color: rgb(255, 255, 255);\"><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338678431073.jpg\"/></span></p><p><span style=\"color: rgb(204, 0, 0); font-family: simhei; font-size: 48px; text-align: center; background-color: rgb(255, 255, 255);\"><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338682965585.jpg\"/></span></p><p><span style=\"color: rgb(204, 0, 0); font-family: simhei; font-size: 48px; text-align: center; background-color: rgb(255, 255, 255);\"><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338687465606.jpg\"/></span></p><p><span style=\"color: rgb(204, 0, 0); font-family: simhei; font-size: 48px; text-align: center; background-color: rgb(255, 255, 255);\"><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338693348398.jpg\"/></span></p><p><span style=\"color: rgb(204, 0, 0); font-family: simhei; font-size: 48px; text-align: center; background-color: rgb(255, 255, 255);\"><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338696798862.jpg\"/></span></p><p><span style=\"color: rgb(204, 0, 0); font-family: simhei; font-size: 48px; text-align: center; background-color: rgb(255, 255, 255);\"><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338701965823.jpg\"/></span></p><p><span style=\"color: rgb(204, 0, 0); font-family: simhei; font-size: 48px; text-align: center; background-color: rgb(255, 255, 255);\"><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338709760491.jpg\"/></span></p><p><span style=\"color: rgb(204, 0, 0); font-family: simhei; font-size: 48px; text-align: center; background-color: rgb(255, 255, 255);\"><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338718736194.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338722408327.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338728869826.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338740749280.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508338750552516.jpg\"/></span></p><p><span style=\"color: rgb(204, 0, 0); font-family: simhei; font-size: 48px; text-align: center; background-color: rgb(255, 255, 255);\"><br/></span></p>', null, '0', '0', '0', '0', '8', '0', '', '', '', '2', '1', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-10-18 22:59:15', '2018-09-10 15:26:44', null);
INSERT INTO `ibrand_goods` VALUES ('21', '甘尼克宝贝BabyGanics 免洗洗手液便携儿童 无香柑橘两支装洗手液', 'BabyGanics', '3', '5', '79.00', '79.00', '79.00', '148.00', '148.00', null, null, '20', 'https://cdn.viperky.com/storage/images/20171018/xHFmGwCdvZ.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><span style=\"margin: 0px; padding: 0px;\"></span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.4;\"><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339020775455.jpg\" alt=\"\" border=\"0\" usemap=\"#Map2\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: middle;\"/><map name=\"Map2\" style=\"margin: 0px; padding: 0px;\"><area coords=\"480,558,598,811\" href=\"https://detail.tmall.com/item.htm?spm=a1z10.3-b-s.w4011-14862618943.77.46f16db0nQij7f&id=14652190384&rn=0b6fa00e45c13f0187ea2895bba2bf29&abbucket=5&scene=taobao_shop\" target=\"_blank\" style=\"margin: 0px; padding: 0px;\"/><area coords=\"623,560,749,808\" href=\"https://detail.tmall.com/item.htm?spm=a1z10.3-b-s.w4011-14862618943.116.46f16db0nQij7f&id=21906951185&rn=0b6fa00e45c13f0187ea2895bba2bf29&abbucket=5&scene=taobao_shop\" target=\"_blank\" style=\"margin: 0px; padding: 0px;\"/></map><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339020900256.jpg\" border=\"0\" usemap=\"#Map\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: middle;\"/><map name=\"Map\" style=\"margin: 0px; padding: 0px;\"><area coords=\"458,522,610,813\" href=\"https://detail.tmall.com/item.htm?spm=a1z10.5-b-s.w4011-14862618940.57.kkE69i&id=14652190384&rn=a037ff5112b0ce3b18a0d55119253dba&abbucket=5&scene=taobao_shop\" target=\"_blank\" style=\"margin: 0px; padding: 0px;\"/><area coords=\"617,526,751,818\" href=\"https://detail.tmall.com/item.htm?spm=a1z10.5-b-s.w4011-14862618940.66.kkE69i&id=21906951185&rn=a037ff5112b0ce3b18a0d55119253dba&abbucket=5&scene=taobao_shop\" target=\"_blank\" style=\"margin: 0px; padding: 0px;\"/><area coords=\"18,942,181,1248\" href=\"https://detail.tmall.com/item.htm?spm=a1z10.3-b-s.w4011-14862618943.135.QP1I2K&id=44279511472&rn=50ec3ce8f0c207c152f69fcc4bce2a01&abbucket=5&scene=taobao_shop\" target=\"_blank\" style=\"margin: 0px; padding: 0px;\"/><area coords=\"190,944,355,1245\" href=\"https://detail.tmall.com/item.htm?spm=a1z10.3-b-s.w4011-14862618943.84.QP1I2K&id=17274696248&rn=50ec3ce8f0c207c152f69fcc4bce2a01&abbucket=5&scene=taobao_shop\" target=\"_blank\" style=\"margin: 0px; padding: 0px;\"/><area coords=\"22,1292,181,1536\" href=\"https://detail.tmall.com/item.htm?spm=a1z10.3-b-s.w4011-14862618943.96.QP1I2K&id=18051368670&rn=50ec3ce8f0c207c152f69fcc4bce2a01&abbucket=5&scene=taobao_shop\" target=\"_blank\" style=\"margin: 0px; padding: 0px;\"/><area coords=\"188,1294,321,1536\" href=\"https://detail.tmall.com/item.htm?spm=a1z10.3-b-s.w4011-14862618943.72.QP1I2K&id=17274452071&rn=50ec3ce8f0c207c152f69fcc4bce2a01&abbucket=5&scene=taobao_shop\" target=\"_blank\" style=\"margin: 0px; padding: 0px;\"/></map></p><p></p><p><span style=\"margin: 0px; padding: 0px;text-decoration:line-through;\"><strong style=\"margin: 0px; padding: 0px;\"></strong></span></p><p><img class=\"desc_anchor img-ks-lazyload\" id=\"desc-module-1\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339020399934.gif\" style=\"margin: 0px; padding: 0px; border: 0px; height: 1px; display: block; clear: both; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%;\"/></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; line-height: 1.4;\"><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339020707050.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/></p><p><img class=\"desc_anchor img-ks-lazyload\" id=\"desc-module-2\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339020399934.gif\" style=\"margin: 0px; padding: 0px; border: 0px; height: 1px; display: block; clear: both; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%;\"/></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; line-height: 1.4;\"><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339020823850.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339020132571.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339020209800.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339020753017.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339020711685.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/></p><p><img class=\"desc_anchor img-ks-lazyload\" id=\"desc-module-3\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339020399934.gif\" style=\"margin: 0px; padding: 0px; border: 0px; height: 1px; display: block; clear: both; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%;\"/></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; line-height: 1.4;\"><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339020645269.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339020588880.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339020156352.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339020219890.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339020515753.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339020885555.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339021397046.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '5', '0', '', '', '', '0', '1', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-10-18 23:04:10', '2017-10-18 23:04:10', null);
INSERT INTO `ibrand_goods` VALUES ('22', '女宝宝1-2-3周岁小女孩子4-5男6儿童过家家玩具生日礼物女童7早教', '668-25', '3', '5', '88.00', '88.00', '88.00', '88.00', '88.00', null, null, '20', 'https://cdn.viperky.com/storage/images/20171018/mL9DUMJGGv.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><br/></p><p><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339026430253.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339032671252.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339037845302.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339041401359.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339047406993.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339051651924.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339057161535.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339061521869.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339065959228.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339068670597.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339073224416.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339079307551.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339083680612.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339088162365.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339108985565.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339094802607.jpg\" style=\"white-space: normal;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339115419469.jpg\" style=\"white-space: normal;\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339147779829.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339151309703.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339157419745.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339162923021.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339167550270.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339189143012.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339195677878.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339204218810.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339210194646.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339215821624.jpg\"/></p><p><br/></p>', null, '0', '0', '0', '0', '11', '0', '', '', '', '0', '1', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-10-18 23:07:04', '2017-10-18 23:07:04', null);
INSERT INTO `ibrand_goods` VALUES ('23', '日本进口狮王婴儿洗手液 儿童泡沫清洁液 宝宝免洗药用型消毒除菌', '49796001', '3', '5', '35.00', '35.00', '35.00', '40.00', '40.00', null, null, '20', 'https://cdn.viperky.com/storage/images/20171018/CKkCuuLJZc.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339263575678.jpg\" align=\"absmiddle\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; max-width: 750px; background-color: rgb(255, 255, 255);\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339263588473.jpg\" align=\"absmiddle\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; max-width: 750px; background-color: rgb(255, 255, 255);\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339263227771.jpg\" align=\"absmiddle\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; max-width: 750px; background-color: rgb(255, 255, 255);\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339264680044.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; max-width: 750px; background-color: rgb(255, 255, 255);\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339264987773.jpg\" class=\"\" align=\"absmiddle\" style=\"border: 0px; vertical-align: top; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; max-width: 750px; background-color: rgb(255, 255, 255);\"/></p>', null, '0', '0', '0', '0', '8', '0', '', '', '', '0', '1', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-10-18 23:08:06', '2017-10-18 23:08:06', null);
INSERT INTO `ibrand_goods` VALUES ('24', '日本正品vape婴幼儿3倍持久防蚊水/驱蚊止痒喷雾200ml', 'vapejp', '3', '5', '78.00', '78.00', '78.00', '82.00', '82.00', null, null, '19', 'https://cdn.viperky.com/storage/images/20171018/ByvnR9pZcf.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; text-align: -webkit-center; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color: rgb(12, 52, 61);\"><strong><span style=\"font-family: arial;\">日本代购正品vape婴幼儿3倍持久防蚊水/驱蚊止痒喷雾200ml</span></strong></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; text-align: -webkit-center; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color: rgb(204, 0, 0);\"><strong><span style=\"font-family: arial;\">规格：杏桃香味（粉色瓶装）/清爽柑橘（绿色瓶装）</span></strong></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; text-align: -webkit-center; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; text-align: -webkit-center; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; text-align: -webkit-center; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; text-align: -webkit-center; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color: rgb(12, 52, 61);\"><strong><span style=\"font-family: arial;\">含量：200ml</span></strong></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; text-align: -webkit-center; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; text-align: -webkit-center; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; text-align: -webkit-center; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color: rgb(12, 52, 61);\"><strong><span style=\"font-family: arial;\">产地：日本</span></strong></span></p><p><span style=\"color: rgb(180, 95, 6);\"><strong><span style=\"font-family: arial;\">阴暗处保存</span></strong></span></p><p>&nbsp;</p><p>&nbsp;</p><p><span style=\"color: rgb(180, 95, 6);\"><strong><span style=\"font-family: arial;\">&nbsp;</span></strong></span></p><p><span style=\"color: rgb(180, 95, 6);\"><strong><span style=\"font-family: arial;\">含天然保湿成分，对皮肤低刺激</span></strong></span></p><p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; text-align: -webkit-center; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color: rgb(180, 95, 6);\"><strong><span style=\"font-family: arial;\">驱避蚊子、跳蚤、螨、蝇、臭虫</span></strong></span></p><p><strong><span style=\"font-family: arial;\"><span style=\"color: rgb(111, 168, 220);\">&nbsp;</span></span></strong></p><p><span style=\"color: rgb(166, 77, 121);\"><strong><span style=\"font-family: arial;\">使用方法：</span></strong></span></p><p><span style=\"color: rgb(166, 77, 121);\"><strong><span style=\"font-family: arial;\">&nbsp;</span></strong></span></p><p><span style=\"color: rgb(166, 77, 121);\"><strong><span style=\"font-family: arial;\">1、将白色的扳手转到OPEN的位置。</span></strong></span></p><p><span style=\"color: rgb(166, 77, 121);\"><strong><span style=\"font-family: arial;\">&nbsp;</span></strong></span></p><p><span style=\"color: rgb(166, 77, 121);\"><strong><span style=\"font-family: arial;\">2、距离皮肤10cm左右适量的喷到皮肤露出的部位。</span></strong></span></p><p><span style=\"color: rgb(166, 77, 121);\"><strong><span style=\"font-family: arial;\">&nbsp;</span></strong></span></p><p><span style=\"color: rgb(166, 77, 121);\"><strong><span style=\"font-family: arial;\">3、脸，脖子部，可先喷到手心上后，再用手涂抹。</span></strong></span></p><p><span style=\"color: rgb(166, 77, 121);\"><strong><span style=\"font-family: arial;\">&nbsp;</span></strong></span></p><p><span style=\"color: rgb(166, 77, 121);\"><strong><span style=\"font-family: arial;\">4、使用后将白色的扳手，转回原处后保存。</span></strong></span></p><p>&nbsp;</p><p><strong><span style=\"font-family: arial;\"><span style=\"color: rgb(111, 168, 220);\">&nbsp;</span></span></strong></p><p><span style=\"color: rgb(180, 95, 6);\"><strong><span style=\"font-family: arial;\">使用量：</span></strong></span></p><p><span style=\"color: rgb(180, 95, 6);\"><strong><span style=\"font-family: arial;\">&nbsp;</span></strong></span></p><p><span style=\"color: rgb(180, 95, 6);\"><strong><span style=\"font-family: arial;\">6个月之内的新生婴儿请勿用。</span></strong></span></p><p><span style=\"color: rgb(180, 95, 6);\"><strong><span style=\"font-family: arial;\">&nbsp;</span></strong></span></p><p><span style=\"color: rgb(180, 95, 6);\"><strong><span style=\"font-family: arial;\">6个月-2岁：一天一次</span></strong></span></p><p><span style=\"color: rgb(180, 95, 6);\"><strong><span style=\"font-family: arial;\">&nbsp;</span></strong></span></p><p><span style=\"color: rgb(180, 95, 6);\"><strong><span style=\"font-family: arial;\">2岁-12岁：一天三次以内</span></strong></span></p><p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px;\"><strong><span style=\"font-family: arial;\"><span style=\"color: rgb(255, 0, 0);\">注意事项:</span></span></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px;\"><strong><span style=\"font-family: arial;\"><span style=\"color: rgb(255, 0, 0);\">&nbsp;&nbsp; 1、本品请存放于宝宝不能拿到的地方，勿让宝宝自行取用；</span></span></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px;\"><strong><span style=\"font-family: arial;\"><span style=\"color: rgb(255, 0, 0);\">&nbsp;&nbsp; 2、小儿（未满12岁）请在成人监护下使用，并按照规定用法次数使用；</span></span></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px;\"><strong><span style=\"font-family: arial;\"><span style=\"color: rgb(255, 0, 0);\">&nbsp;&nbsp; 3、本品只可外用，不可内服。肤质容易过敏的宝宝，可先在上臂内侧喷少量观察24小时</span></span></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px;\"><strong><span style=\"font-family: arial;\"><span style=\"color: rgb(255, 0, 0);\">如无异常情况方可以正常使用。</span></span></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px;\"><strong><span style=\"font-family: arial;\"><span style=\"color: rgb(255, 0, 0);\">&nbsp;&nbsp; 4、请勿喷于伤口和脸部周围。喷涂于宝宝手部时应避免宝宝舔手或用手揉眼睛。</span></span></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px;\"><strong><span style=\"font-family: arial;\"><span style=\"color: rgb(255, 0, 0);\">若不慎进入眼部应立即用大量清水冲洗并看医生；</span></span></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px;\"><strong><span style=\"font-family: arial;\"><span style=\"color: rgb(255, 0, 0);\">&nbsp;&nbsp; 5、本品请于干燥阴凉处保存，勿放置于靠近火源、高温、阳光直射处。</span></span></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; text-align: -webkit-center; white-space: normal; background-color: rgb(255, 255, 255);\"><img height=\"61\" width=\"204\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339476862615.gif\" style=\"border: 0px; vertical-align: top; padding: 0px; margin: 0px;\"/></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; text-align: -webkit-center; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; text-align: -webkit-center; white-space: normal; background-color: rgb(255, 255, 255);\"><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339476414045.gif\" class=\"\" width=\"300\" height=\"300\" style=\"border: 0px; vertical-align: top;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339476720345.jpg\" class=\"\" width=\"300\" height=\"300\" style=\"border: 0px; vertical-align: top;\"/></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; text-align: -webkit-center; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;<img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339476141267.jpg\" class=\"\" width=\"600\" height=\"700\" style=\"border: 0px; vertical-align: top;\"/></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; text-align: -webkit-center; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; text-align: -webkit-center; white-space: normal; background-color: rgb(255, 255, 255);\"><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339476331169.jpg\" class=\"\" width=\"616\" height=\"652\" style=\"border: 0px; vertical-align: top;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '12', '0', '', '', '', '0', '1', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-10-18 23:11:32', '2018-05-07 17:11:12', null);
INSERT INTO `ibrand_goods` VALUES ('25', '小医生玩具套装工具箱打针护士男孩北美儿童医院过家家女孩听诊器', '3325', '3', '5', '39.90', '39.90', '39.90', '39.90', '39.90', null, null, '20', 'https://cdn.viperky.com/storage/images/20171018/VYnD5WaK1Y.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339512826209.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339458685666.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339466563092.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339476348924.jpg\"/></p>', null, '0', '0', '0', '0', '7', '0', '', '', '', '0', '1', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-10-18 23:11:54', '2017-10-18 23:11:54', null);
INSERT INTO `ibrand_goods` VALUES ('26', '日本和光堂驱蚊贴 婴儿童天然卡通宝宝防蚊贴成人户外蚊子贴60枚', 'hgt60', '3', '5', '53.00', '53.00', '53.00', '53.00', '53.00', null, null, '20', 'https://cdn.viperky.com/storage/images/20171018/CnMiKyuRUF.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color:#0000ff\"><span style=\"font-size: 24px; line-height: 36px;\"><strong>品牌：wakodo/和光堂</strong></span></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color:#0000ff\"><span style=\"font-size: 24px; line-height: 36px;\"><strong>名称：天然桉树精油驱蚊贴</strong></span></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color:#0000ff\"><span style=\"font-size: 24px; line-height: 36px;\"><strong>产品规格：60枚（需要66枚的可以订货噢）</strong></span></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color:#0000ff\"><span style=\"font-size: 24px; line-height: 36px;\"><strong>保质期：3年，日本和光堂只标批号，和国内不同，标注生产日期。</strong></span></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color:#0000ff\"><span style=\"font-size: 24px; line-height: 36px;\"><strong>使用年龄：出生宝宝及以上</strong></span></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color:#0000ff\"><span style=\"font-size: 24px; line-height: 36px;\"><strong>产品时效：6-8小时</strong></span></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color:#0000ff\"><span style=\"font-size: 24px; line-height: 36px;\"><strong>采购地：日本药妆店</strong></span></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color:#0000ff\"><span style=\"font-size: 24px; line-height: 36px;\"><strong><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339730389460.jpg\" style=\"border: 0px; vertical-align: top;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339730823989.jpg\" style=\"border: 0px; vertical-align: top;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339730675989.jpg\" style=\"border: 0px; vertical-align: top;\"/></strong></span></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color:#0000ff\"><span style=\"font-size: 24px; line-height: 36px;\"><strong><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339730623783.jpg\" style=\"border: 0px; vertical-align: top;\"/></strong></span></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color:#0000ff\"><span style=\"font-size: 24px; line-height: 36px;\"></span></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color:#0000ff\"><span style=\"font-size: 24px; line-height: 36px;\"></span></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color:#0000ff\"><span style=\"font-size: 24px; line-height: 36px;\"><strong><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339730919600.jpg\" class=\"\" width=\"960\" height=\"1280\" style=\"border: 0px; vertical-align: top;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339730203964.jpg\" class=\"\" width=\"450\" height=\"800\" style=\"border: 0px; vertical-align: top;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339730331053.jpg\" class=\"\" width=\"450\" height=\"800\" style=\"border: 0px; vertical-align: top;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339730563541.jpg\" class=\"\" width=\"450\" height=\"800\" style=\"border: 0px; vertical-align: top;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339730415808.jpg\" class=\"\" width=\"450\" height=\"800\" style=\"border: 0px; vertical-align: top;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339731554389.jpg\" class=\"\" width=\"450\" height=\"800\" style=\"border: 0px; vertical-align: top;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339731953520.jpg\" class=\"\" width=\"450\" height=\"800\" style=\"border: 0px; vertical-align: top;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339731704734.jpg\" class=\"\" width=\"750\" height=\"1000\" style=\"border: 0px; vertical-align: top;\"/></strong></span></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color:#0000ff\"><span style=\"font-size: 24px; line-height: 36px;\"><strong><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339731590153.jpg\" class=\"\" width=\"620\" height=\"960\" style=\"border: 0px; vertical-align: top;\"/></strong></span></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color:#0000ff\"><span style=\"font-size: 24px; line-height: 36px;\"><strong><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339731917033.jpg\" class=\"\" width=\"620\" height=\"960\" style=\"border: 0px; vertical-align: top;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339731259706.jpg\" class=\"\" width=\"620\" height=\"960\" style=\"border: 0px; vertical-align: top;\"/>&nbsp;<img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339731814581.jpg\" class=\"\" width=\"620\" height=\"960\" style=\"border: 0px; vertical-align: top;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339731323768.jpg\" class=\"\" width=\"960\" height=\"1280\" style=\"border: 0px; vertical-align: top;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339731698797.jpg\" class=\"\" width=\"960\" height=\"1280\" style=\"border: 0px; vertical-align: top;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339731383570.jpg\" class=\"\" width=\"960\" height=\"1280\" style=\"border: 0px; vertical-align: top;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339732277018.jpg\" class=\"\" width=\"960\" height=\"1280\" style=\"border: 0px; vertical-align: top;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339732102752.jpg\" class=\"\" width=\"960\" height=\"1280\" style=\"border: 0px; vertical-align: top;\"/></strong></span></span></p><p><br/></p>', null, '0', '0', '0', '0', '4', '0', '', '', '', '0', '1', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-10-18 23:16:04', '2017-10-18 23:16:04', null);
INSERT INTO `ibrand_goods` VALUES ('27', '雪花片儿童大号1000片数字益智拼插兼容乐高安全无毒塑料积木玩具', 'XHP001', '3', '5', '59.00', '59.00', '59.00', '59.00', '59.00', null, null, '10', 'https://cdn.viperky.com/storage/images/20171018/86j9I2u3AU.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339658479189.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339670463142.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339682643911.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339696710376.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339700619426.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339706364880.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339712240724.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339717497982.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339734769748.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339739985054.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339772711439.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339777639332.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339782208864.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339788938823.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339795649493.jpg\"/></p>', null, '0', '0', '0', '0', '7', '0', '', '', '', '2', '1', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-10-18 23:16:49', '2018-09-10 15:29:25', null);
INSERT INTO `ibrand_goods` VALUES ('28', '喜多植物精油婴儿驱蚊贴54片 宝宝防蚊贴 日本儿童夏季用品蚊香贴', 'H33751', '3', '5', '22.90', '22.90', '22.90', '48.00', '48.00', null, null, '18', 'https://cdn.viperky.com/storage/images/20171018/9MnoG0V4aJ.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><table cellpadding=\"0\" cellspacing=\"0\" height=\"30\" width=\"750\"><tbody><tr class=\"firstRow\"><td style=\"margin: 0px; padding: 0px; word-break: break-all;\"><strong><span style=\"font-size: 24px;\"><span style=\"color: rgb(255, 0, 0);\"></span></span></strong><p style=\"margin-top: 1.12em; margin-bottom: 1.12em;\"><strong><span style=\"font-size: 24px;\"><a target=\"_blank\" href=\"https://item.taobao.com/item.htm?spm=a1z10.3-c.w4002-13323623004.10.9vmpGx&id=531252917426\" style=\"text-decoration: none; color: rgb(51, 102, 204); outline: 0px;\"></a></span></strong></p><strong><span style=\"font-size: 24px;\"><span style=\"color: rgb(255, 0, 0);\"></span></span></strong><p style=\"margin-top: 1.12em; margin-bottom: 1.12em;\"><strong><span style=\"font-size: 24px;\"><a target=\"_blank\" href=\"http://meal.taobao.com/mealDetail.htm?meal_id=468345104&seller_id=145397&mt=&meal_id=468345104&seller_id=145397\" style=\"text-decoration: none; color: rgb(51, 102, 204); outline: 0px;\"></a></span></strong></p><strong><span style=\"font-size: 24px;\"><span style=\"color: rgb(255, 0, 0);\"></span></span></strong><p style=\"margin-top: 1.12em; margin-bottom: 1.12em;\"><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339911932152.jpg\" class=\"\" style=\"border: 0px; vertical-align: top; line-height: 1.5; width: 750px;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339911800138.jpg\" class=\"\" width=\"790\" height=\"595\" style=\"border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339911585131.jpg\" class=\"\" width=\"750\" height=\"223\" style=\"border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339911420926.jpg\" class=\"\" width=\"750\" height=\"461\" style=\"border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339911235110.jpg\" class=\"\" width=\"790\" height=\"571\" style=\"border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339911810632.jpg\" class=\"\" width=\"790\" height=\"691\" style=\"border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339912551582.jpg\" class=\"\" width=\"790\" height=\"592\" style=\"border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339912502975.jpg\" class=\"\" width=\"790\" height=\"647\" style=\"border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339912957769.jpg\" class=\"\" width=\"790\" height=\"553\" style=\"border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339912923409.jpg\" class=\"\" width=\"790\" height=\"393\" style=\"border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339912950731.jpg\" class=\"\" width=\"790\" height=\"364\" style=\"border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508339912994122.jpg\" class=\"\" width=\"790\" height=\"519\" style=\"border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;\"/></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em;\"><br/></p></td></tr></tbody></table><p><br/></p>', null, '0', '0', '0', '0', '10', '0', '', '', '', '0', '1', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-10-18 23:18:53', '2017-12-16 16:22:40', null);
INSERT INTO `ibrand_goods` VALUES ('29', '磁力片积木二代精钢1-2-3-6-8-10周岁男孩女孩益智拼搭装儿童玩具', 'TI-2021', '3', '5', '79.00', '79.00', '79.00', '79.00', '79.00', null, null, '8', 'https://cdn.viperky.com/storage/images/20171018/qD7B2cr1m0.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340013869302.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340020688277.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340027249521.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340032863170.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340044718059.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340050832320.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340056779720.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340064554706.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340085190330.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340096943657.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340104821892.jpg\"/></p>', null, '0', '0', '0', '0', '8', '0', '', '', '', '2', '1', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-10-18 23:19:57', '2018-09-10 15:30:27', null);
INSERT INTO `ibrand_goods` VALUES ('30', '军事战争野战军团拼装玩具儿童智力拼插兼容乐高积木男孩6-8-12岁', 'ENLIGHTEN', '3', '5', '128.00', '128.00', '128.00', '128.00', '128.00', null, null, '10', 'https://cdn.viperky.com/storage/images/20171018/I9DTSELLnn.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340268886197.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340272494133.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340278547017.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340282640287.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340287709374.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340293874991.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340298844397.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340302355964.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340309942358.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340313235448.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340328486147.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340332611380.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340337160619.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340341214049.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340348916334.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340352353526.jpg\"/></p>', null, '0', '0', '0', '0', '10', '0', '', '', '', '2', '1', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-10-18 23:25:57', '2018-09-10 15:31:02', null);
INSERT INTO `ibrand_goods` VALUES ('31', '好孩子婴儿洗护礼盒 新生儿护肤品用品套装 宝宝洗发沐浴露爽身粉', 'Goodbaby2502', '3', '5', '118.00', '118.00', '118.00', '118.00', '118.00', null, null, '10', 'https://cdn.viperky.com/storage/images/20171018/7pvIhHhle9.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340678746773.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340682546540.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340689559525.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340694906783.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340699537816.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340709190950.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340717491584.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340722822646.jpg\"/></p>', null, '0', '0', '0', '0', '9', '0', '', '', '', '0', '1', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-10-18 23:32:08', '2017-10-18 23:32:08', null);
INSERT INTO `ibrand_goods` VALUES ('32', 'gb好孩子婴儿湿巾新生儿宝宝手口湿纸巾海洋10片*10包随身装100抽', '6901755336458', '3', '5', '25.00', '25.00', '25.00', '25.00', '25.00', null, null, '10', 'https://cdn.viperky.com/storage/images/20171018/5zAmDVa5he.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340943628584.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340946647990.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340951386225.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340958610145.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340972674389.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340976186201.jpg\"/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171018/1508340981904993.jpg\"/></p>', null, '0', '0', '0', '0', '12', '0', '', '', '', '0', '1', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-10-18 23:36:24', '2017-10-18 23:36:24', null);
INSERT INTO `ibrand_goods` VALUES ('33', '11.11 秒杀柔软百搭围脖', 'WEIBO1101', '4', '5', '16.11', '16.11', '16.11', '48.00', '48.00', null, null, '21', 'https://cdn.viperky.com/storage/images/20171109/GsGOskbHQB.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510216830107646.jpeg\" title=\"1510216830107646.jpeg\" alt=\"双十一详情页规则说明.jpg\"/><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510216460661894.jpeg\" title=\"1510216460661894.jpeg\" alt=\"围巾_秒杀商品简介_微信商城_01.jpg\"/><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510216462704784.jpeg\" title=\"1510216462704784.jpeg\" alt=\"围巾_秒杀商品简介_微信商城_02.jpg\"/><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510216465219513.jpeg\" title=\"1510216465219513.jpeg\" alt=\"围巾_秒杀商品简介_微信商城_03.jpg\"/><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510216468669501.jpeg\" title=\"1510216468669501.jpeg\" alt=\"围巾_秒杀商品简介_微信商城_04.jpg\"/><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510216470445419.jpeg\" title=\"1510216470445419.jpeg\" alt=\"围巾_秒杀商品简介_微信商城_05.jpg\"/><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510216472322195.jpeg\" title=\"1510216472322195.jpeg\" alt=\"围巾_秒杀商品简介_微信商城_06.jpg\"/><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510216475285733.jpeg\" title=\"1510216475285733.jpeg\" alt=\"围巾_秒杀商品简介_微信商城_07.jpg\"/><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510216478925059.jpeg\" title=\"1510216478925059.jpeg\" alt=\"围巾_秒杀商品简介_微信商城_08.jpg\"/></p>', null, '0', '0', '0', '0', '9', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-11-09 16:39:47', '2017-12-27 15:57:48', null);
INSERT INTO `ibrand_goods` VALUES ('34', '儿童袜子全棉秋冬韩版新款糖果色宽条纹堆堆袜【双11】', 'WAZI001', '4', '5', '2.11', '2.11', '2.11', '15.00', '15.00', null, null, '92', 'https://cdn.viperky.com/storage/images/20171109/eeRMsXwZ5q.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510216830107646.jpeg\" title=\"1510216830107646.jpeg\" alt=\"双十一详情页规则说明.jpg\"/> &nbsp; &nbsp;<img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510220160672988.jpeg\" title=\"1510220160672988.jpeg\" alt=\"袜子_秒杀商品简介_微信商城_01.jpg\"/><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510220166981314.jpeg\" title=\"1510220166981314.jpeg\" alt=\"袜子_秒杀商品简介_微信商城_02.jpg\"/><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510220172441759.jpeg\" title=\"1510220172441759.jpeg\" alt=\"袜子_秒杀商品简介_微信商城_03.jpg\"/><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510220174322840.jpeg\" title=\"1510220174322840.jpeg\" alt=\"袜子_秒杀商品简介_微信商城_04.jpg\"/><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510220177660275.jpeg\" title=\"1510220177660275.jpeg\" alt=\"袜子_秒杀商品简介_微信商城_05.jpg\"/><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510220179722402.jpeg\" title=\"1510220179722402.jpeg\" alt=\"袜子_秒杀商品简介_微信商城_06.jpg\"/><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510220182878976.jpeg\" title=\"1510220182878976.jpeg\" alt=\"袜子_秒杀商品简介_微信商城_07.jpg\"/><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510220184626163.jpeg\" title=\"1510220184626163.jpeg\" alt=\"袜子_秒杀商品简介_微信商城_08.jpg\"/><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510220187457767.jpeg\" title=\"1510220187457767.jpeg\" alt=\"袜子_秒杀商品简介_微信商城_09.jpg\"/><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510220189545093.jpeg\" title=\"1510220189545093.jpeg\" alt=\"袜子_秒杀商品简介_微信商城_10.jpg\"/></p>', null, '0', '0', '0', '0', '9', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-11-09 17:38:05', '2017-12-15 12:35:05', null);
INSERT INTO `ibrand_goods` VALUES ('35', '品质玩具【双11秒杀】', 'WANJU001', '4', '5', '2.11', '2.11', '2.11', '15.00', '15.00', null, null, '10', 'https://cdn.viperky.com/storage/images/20171109/JmZuys1UCw.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510216830107646.jpeg\" title=\"1510216830107646.jpeg\" alt=\"双十一详情页规则说明.jpg\"/> &nbsp; &nbsp;<img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20171109/1510220381731456.jpeg\" title=\"1510220381731456.jpeg\" alt=\"玩具页面.jpg\"/></p>', null, '0', '0', '0', '0', '6', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-11-09 17:40:33', '2017-12-15 12:35:05', null);
INSERT INTO `ibrand_goods` VALUES ('36', '迪士尼儿童保温杯带吸管防摔两用不锈钢宝宝水壶', 'TW-3035', '3', '5', '49.00', '49.00', '49.00', '228.00', '228.00', null, null, '300', 'https://cdn.viperky.com/storage/images/20171213/Tw89NLzAYY.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171213/1513158220477802.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171213/1513158220799399.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171213/1513158220878192.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171213/1513158220265961.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171213/1513158220345860.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171213/1513158220210034.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171213/1513158220799421.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171213/1513158221141403.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171213/1513158221570673.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171213/1513158221986812.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171213/1513158221444181.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171213/1513158221485479.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171213/1513158221735421.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171213/1513158221792667.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/></p>', null, '0', '0', '0', '0', '11', '0', '', '', '', '0', '1', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-12-13 17:43:51', '2017-12-13 17:43:51', null);
INSERT INTO `ibrand_goods` VALUES ('37', '2017秋冬新款圣诞条纹儿童袜子全棉抗起球加厚', 'b070', '4', '5', '2.90', '2.90', '2.90', '15.00', '15.00', null, null, '21', 'https://cdn.viperky.com/storage/images/20171215/51pjpQSEi2.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513312834113441.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513312834561374.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513312834377172.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513312834334129.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513312835158425.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513312835371987.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513312835436936.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513312835445985.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513312835405795.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513312835952266.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513312835680994.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513312835569277.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513312835234357.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513312835741054.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513312835537521.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513312835395853.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513312835424568.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513312835879744.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"070_07\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513312835371987.jpg\" data-spm-anchor-id=\"a261y.7663282.0.i6.6856f173ZovbJi\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '5', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-12-15 12:40:38', '2018-05-15 18:06:55', null);
INSERT INTO `ibrand_goods` VALUES ('38', '2017韩国秋冬季新款针织帽儿童帽子小熊耳朵毛线帽婴儿帽宝宝帽子', 'mz12', '4', '5', '15.90', '15.90', '15.90', '39.00', '39.00', null, null, '9', 'https://cdn.viperky.com/storage/images/20171215/P9lqHL8zlE.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513313024444486.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513313024691111.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513313024156792.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513313025545645.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513313025877564.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513313025713054.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513313025391828.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513313025543051.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513313025846980.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513313025680903.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513313025884849.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513313025999398.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513313025403607.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '10', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-12-15 12:44:50', '2018-05-15 18:06:55', null);
INSERT INTO `ibrand_goods` VALUES ('39', '儿童帽子秋冬季2-3-5岁宝宝帽子护耳保暖小孩毛线帽儿童帽子', '5239', '4', '5', '19.90', '19.90', '19.90', '69.00', '69.00', null, null, '6', 'https://cdn.viperky.com/storage/images/20171215/kNYJhuJvWQ.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/238/295/4919592832_1567721775.jpg\" data-spm-anchor-id=\"a261y.7663282.0.i7.1f29d8c3DXDeLh\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/291/106/4919601192_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/786/595/4919595687_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/502/106/4919601205_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/396/595/4919595693_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/854/911/4914119458_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/007/011/4914110700_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/622/106/4919601226_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/320/699/4915996023_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/374/911/4914119473_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/670/701/4914107076_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/592/999/4915999295_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/852/106/4919601258_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/367/099/4915990763_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/899/401/4914104998_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/539/295/4919592935_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/897/895/4919598798_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/155/611/4914116551_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/663/999/4915999366_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/865/611/4914116568_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/218/011/4914110812_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/933/106/4919601339_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/099/295/4919592990_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/560/821/4914128065_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img align=\"absmiddle\" src=\"https://cbu01.alicdn.com/img/ibank/2017/558/895/4919598855_1567721775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '3', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-12-15 14:01:39', '2018-05-15 18:06:55', null);
INSERT INTO `ibrand_goods` VALUES ('40', '儿童手套冬季男童保暖手套 男女宝宝包指手套小孩手套', 'st020', '4', '5', '12.90', '12.90', '12.90', '35.00', '35.00', null, null, '28', 'https://cdn.viperky.com/storage/images/20171215/XMly6hP24W.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"三扣深灰色\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513317909229803.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513317909703948.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513317909944069.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" height=\"447\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513317909253508.jpg\" width=\"908\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513317909358030.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513317909826299.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513317909135805.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513317909540452.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20171215/1513317909559609.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '11', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2017-12-15 14:05:10', '2018-05-15 18:06:55', null);
INSERT INTO `ibrand_goods` VALUES ('41', '2018夏季童装新品纯棉儿童短袖T恤', '9063', '6', '3', '29.00', '29.00', '29.00', '39.00', '39.00', null, null, '69', 'https://cdn.viperky.com/storage/images/20180515/06U5YKLgVa.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"9063_02.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526353986226235.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9063_04.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526353986841080.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9063_05.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526353986621882.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9063_06.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526353987514917.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9063_07.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526353987995599.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9063_08.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526353987171678.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9063_09.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526353987312802.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9063_10.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526353987623201.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9063_12.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526353987997737.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9063_13.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526353987157480.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"9063_14.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526353987934023.jpg\" data-spm-anchor-id=\"a261y.7663282.descBanner.i1.5c66764b7Q011Z\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '3', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 11:13:51', '2018-08-14 16:43:20', null);
INSERT INTO `ibrand_goods` VALUES ('42', '2018 夏季新款韩版儿童T恤', '9315', '6', '3', '29.00', '29.00', '29.00', '39.00', '39.00', null, null, '93', 'https://cdn.viperky.com/storage/images/20180515/2rhsyEGDp7.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"9315_01\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526354926524585.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9315_05\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526354926596050.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9315_09\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526354926509510.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9315_10\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526354926181172.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9315_11\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526354926398289.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9315_12\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526354926914640.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9315_13\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526354926114038.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9315_14\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526354926367385.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"9315_15\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526354926649543.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '11', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 11:29:26', '2018-08-14 16:43:20', null);
INSERT INTO `ibrand_goods` VALUES ('43', '2018夏季新款男童短袖T恤', '9053', '6', '3', '28.00', '28.00', '28.00', '38.00', '38.00', null, null, '2398', 'https://cdn.viperky.com/storage/images/20180515/IWJVuSIh2H.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526356700723860.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526356700160990.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526356700680687.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526356700152518.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526356700949233.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526356700819316.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526356700120388.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526356700796431.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526356700638616.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526356700702002.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526356700197437.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526356700741530.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '4', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 11:58:44', '2018-08-14 16:43:20', null);
INSERT INTO `ibrand_goods` VALUES ('44', '2018男童动物可爱卡通印花短袖T恤儿', '9076', '6', '3', '29.00', '29.00', '29.00', '39.00', '39.00', null, null, '939', 'https://cdn.viperky.com/storage/images/20180515/f3IQAITVcu.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"9076_01.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526358074532215.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9076_02.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526358074611629.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9076_04.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526358074202769.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9076_05.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526358074619331.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9076_06.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526358074862035.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9076_07.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526358074506133.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9076_08.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526358074932747.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9076_09.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526358074735399.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9076_10.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526358074451461.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9076_12.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526358074817926.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9076_13.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526358074191327.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"9076_14.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526358074720485.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '11', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 12:21:58', '2018-08-14 16:43:20', null);
INSERT INTO `ibrand_goods` VALUES ('45', '2018夏季儿童纯棉短袖T恤', '9061', '6', '3', '28.00', '28.00', '28.00', '38.00', '38.00', null, null, '476', 'https://cdn.viperky.com/storage/images/20180515/TFSugfseeD.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"9061_01.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526364066513176.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526364066510093.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><img alt=\"9061_03.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526364066564596.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9061_04.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526364066554287.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9061_05.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526364066529215.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9061_06.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526364066596247.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9061_07.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526364066998238.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9061_08.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526364066255140.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9061_09.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526364066187590.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9061_10.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526364066467155.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9061_12.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526364066656527.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9061_13.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526364066751616.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"9061_14.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526364066288462.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '13', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 14:23:36', '2018-08-14 16:43:19', null);
INSERT INTO `ibrand_goods` VALUES ('46', '2018夏款儿童短袖T恤', '9099', '6', '3', '29.00', '29.00', '29.00', '39.00', '39.00', null, null, '10', 'https://cdn.viperky.com/storage/images/20180515/Dxjc9SuHEz.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"9099_01.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366454460511.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9099_02.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366454561433.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9099_04.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366454275523.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9099_05.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366454430293.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9099_09.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366454675623.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9099_10.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366454247103.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9099_12.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366454509732.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9099_13.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366454837135.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"9099_14.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366454790936.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '10', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 14:41:16', '2018-08-14 16:43:19', null);
INSERT INTO `ibrand_goods` VALUES ('47', '2017夏季新品中小童棉质短袖T恤条纹字母卡通亲子装', 'KS364', '7', '7', '28.00', '28.00', '28.00', '38.00', '38.00', null, null, '0', 'https://cdn.viperky.com/storage/images/20180515/0nleBBvhdt.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366998397513.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366998867328.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366998678873.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366998801729.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366998234786.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366998190958.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366999893563.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366999465364.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366999693529.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366999491769.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366999354352.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366999171234.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366999453836.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526367000127773.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526367000580392.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526367000732541.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526367000131933.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526367000220155.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"2017亲子详情版_04\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526366998397513.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '5', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 14:53:04', '2018-05-28 09:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('48', '2018夏季童装爱心印花纯棉中袖T恤一家三口亲子装', 'KS1702', '7', '7', '68.00', '98.00', '68.00', '146.00', '99.00', null, null, '1799', 'https://cdn.viperky.com/storage/images/20180515/j9Bhz4nNM9.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p data-spm-anchor-id=\"a261y.7663282.descBanner.i2.2ff81702erP8Ii\" style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375953851.jpg\" data-spm-anchor-id=\"a261y.7663282.descBanner.i0.2ff81702erP8Ii\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375102135.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375476050.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375648769.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375232750.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375642940.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375269858.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375451343.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375946360.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375550840.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375957568.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375860092.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375892208.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375705779.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375189383.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375184960.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375844605.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375714833.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375105101.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375937696.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375940268.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375661161.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526369375682269.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/></p><p><br/></p>', null, '0', '6', '0', '0', '23', '30', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 15:37:43', '2018-08-14 16:43:19', null);
INSERT INTO `ibrand_goods` VALUES ('49', '2018夏季新款韩版女童潮范字母短袖T恤', 'KS1602', '7', '3', '69.00', '69.00', '69.00', '99.00', '99.00', null, null, '799', 'https://cdn.viperky.com/storage/images/20180515/VwxPV2leXu.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413861439.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413579800.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413315641.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413895678.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413641349.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413745241.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413122439.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413914515.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413808207.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413949773.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413443180.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413439001.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413322183.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413489681.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413116228.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413101146.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413769646.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413302717.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413892037.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413364386.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413287812.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"商标吊牌.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413878200.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"质检\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413260023.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"质检2.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526370413748846.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '9', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 15:47:55', '2018-08-14 16:43:19', null);
INSERT INTO `ibrand_goods` VALUES ('50', '2018夏季新款纯棉男女宝宝卡通香蕉短袖t恤韩版亲子装', 'KS1705', '7', '7', '69.00', '69.00', '89.00', '99.00', '99.00', null, null, '600', 'https://cdn.viperky.com/storage/images/20180515/XUTaKafW3Y.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540551379.jpg\" data-spm-anchor-id=\"a261y.7663282.descBanner.i0.6f1465949ZzHq2\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540654123.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540743457.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540448964.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540245929.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540869126.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540141656.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540316255.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540974260.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540344661.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540199085.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540838433.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540459534.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540177092.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540418197.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540222844.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540124425.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540554902.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540220359.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540705142.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540523843.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526371540402739.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '10', '0', '0', '17', '50', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 16:07:11', '2018-08-14 16:43:19', null);
INSERT INTO `ibrand_goods` VALUES ('52', '2018夏款童装韩版 纯棉儿童短袖T恤', '9097', '6', '3', '29.00', '29.00', '29.00', '39.00', '39.00', null, null, '560', 'https://cdn.viperky.com/storage/images/20180515/BTU3qg1nB6.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"9097_01.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526372383867500.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9097_02.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526372383771859.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9097_04.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526372383267488.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9097_05.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526372383760853.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9097_06.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526372383756845.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9097_07.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526372383375526.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9097_09.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526372383487381.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9097_10.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526372383410433.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9097_12.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526372383960694.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9097_13.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526372383279012.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"9097_14.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526372383384857.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '10', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 16:21:01', '2018-08-14 16:43:19', null);
INSERT INTO `ibrand_goods` VALUES ('53', '2018夏季新款韩版儿童棉麻短裙中小童裙子', 'KS496', '7', '2', '89.00', '89.00', '89.00', '139.00', '139.00', null, null, '799', 'https://cdn.viperky.com/storage/images/20180515/i7jPcwDA1K.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373571569951.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373571346831.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373571861722.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373571312148.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373571206970.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373571692109.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373571879317.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373571669493.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373571811307.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373572425453.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373572182341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373572177222.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373572469116.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373572506776.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373572612686.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373572509474.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373572768423.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373572899473.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373572797225.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373572889451.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373572305546.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"商标吊牌.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373572924998.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"质检\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373572930270.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"质检2.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373572787818.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '8', '0', '0', '29', '40', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 16:40:20', '2018-08-14 16:43:19', null);
INSERT INTO `ibrand_goods` VALUES ('54', '新款韩版童装一家三口亲子装春夏字母短袖T恤', 'KS580', '7', '7', '59.00', '88.00', '59.00', '136.00', '90.00', null, null, '25', 'https://cdn.viperky.com/storage/images/20180515/lQxXEZJaD1.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373645777703.jpg\" data-spm-anchor-id=\"a261y.7663282.descBanner.i0.3c626d4c1aOL0A\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646495353.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646676611.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646505108.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646709957.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646832873.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646106667.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646632585.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646865413.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646261782.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646782610.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646183224.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646224451.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646959491.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646310099.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646203535.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646705254.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646933655.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646177479.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646720289.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646870187.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646112933.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526373646169368.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/></p>', null, '0', '0', '0', '0', '7', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 16:42:45', '2018-08-14 16:43:19', null);
INSERT INTO `ibrand_goods` VALUES ('55', '2018夏季新款棉质独特可爱口袋中小童撞色荷叶边短裙', 'KS342', '7', '2', '89.00', '89.00', '89.00', '149.00', '149.00', null, null, '15', 'https://cdn.viperky.com/storage/images/20180515/ECIp0U54Wu.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526374503870309.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526374503163311.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526374503348509.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526374503499919.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526374503148059.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526374503878693.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526374503783373.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526374503640137.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526374503827085.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526374503819232.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526374503274997.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526374503788106.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526374503961733.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526374503986035.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526374504407788.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526374504148070.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526374504611716.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526374504165893.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '5', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 16:57:14', '2018-08-14 16:43:19', null);
INSERT INTO `ibrand_goods` VALUES ('56', '2018夏款韩版女童连衣裙中小童拼色俏皮可爱休闲裙', 'KS1681', '7', '2', '99.00', '99.00', '99.00', '169.00', '169.00', null, null, '1', 'https://cdn.viperky.com/storage/images/20180515/960DVtExN2.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526375492492688.jpg\" data-spm-anchor-id=\"a261y.7663282.descBanner.i0.7f956f3cX1ecn6\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526375492948621.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526375492520656.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526375492333470.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526375492814985.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526375492831773.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526375492732226.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526375492582854.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526375492520466.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526375492392306.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526375492990552.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526375492285997.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526375492913305.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526375492974863.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526375492883048.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526375492566041.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526375492434056.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526375492185788.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '12', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 17:13:24', '2018-08-14 16:44:16', null);
INSERT INTO `ibrand_goods` VALUES ('57', '2018夏季新款童装波点印花棉质内衬三层网纱童裙', 'KS448', '7', '2', '89.00', '89.00', '89.00', '139.00', '139.00', null, null, '50', 'https://cdn.viperky.com/storage/images/20180515/mgbZazUWIt.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376312492045.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376312261620.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376313325040.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"原创模板_01\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376313317290.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"原创模板_02\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376313263171.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"原创模板_03\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376313570962.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"原创模板_04\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376314779373.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"原创模板_05\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376314328991.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376314468759.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376314254113.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376314642247.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376314770343.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376314500054.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376314531041.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376315700656.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376315141314.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376315294367.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376315870102.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376315387785.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '11', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 17:26:20', '2018-08-14 16:44:32', null);
INSERT INTO `ibrand_goods` VALUES ('58', '2018夏季家庭亲子装时尚圆领T恤', 'KS1794', '7', '7', '68.00', '98.00', '68.00', '146.00', '99.00', null, null, '1593', 'https://cdn.viperky.com/storage/images/20180515/QnAzriQw35.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376595837194.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376595106340.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376595460214.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376595408348.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376595138250.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376595360121.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376595204179.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376595588751.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376595881854.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376595262407.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376595842472.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376595728334.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376595717215.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376595447023.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376596449313.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376596164581.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376596643892.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376596950872.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376596895526.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376596106155.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376596807011.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376596383394.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376596456022.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376596725444.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526376596953634.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '15', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 17:30:56', '2018-08-14 16:44:32', null);
INSERT INTO `ibrand_goods` VALUES ('59', '新款韩版休闲百搭假两件裤裙', 'KS1637', '7', '2', '69.00', '69.00', '69.00', '119.00', '119.00', null, null, '499', 'https://cdn.viperky.com/storage/images/20180515/Tz6uyb6PIE.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209367400.jpg\" data-spm-anchor-id=\"a261y.7663282.descBanner.i0.24793a4blOhLwn\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209399023.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209767463.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209261574.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209175872.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209962952.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209999245.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209436557.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209713569.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209174869.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209297097.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209651037.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209114323.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209689342.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209720097.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209360074.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209626116.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209435825.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209971372.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209938858.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377209450766.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377210461186.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377210866884.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377210126820.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377210458284.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377210734690.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377210459470.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377210495630.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377210747784.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377210242596.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377210722790.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377210495857.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377210776135.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377210889078.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377210340447.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377210672225.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377210549631.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '4', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 17:41:25', '2018-08-14 16:44:32', null);
INSERT INTO `ibrand_goods` VALUES ('60', '2018夏装新款纯棉韩版中小童背心裙纯色拼接荷叶边女童裙子', 'KS1717', '7', '2', '79.00', '79.00', '79.00', '129.00', '129.00', null, null, '19', 'https://cdn.viperky.com/storage/images/20180515/q6nihEXE4U.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377856855712.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377856105075.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377856496749.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377856371681.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377856338616.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377856405677.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377856441157.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377856200859.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377856638628.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377856809868.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377856257952.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377856497526.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377856954556.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377856566008.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377856928572.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377856865307.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377856423637.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377856412510.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377856579865.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377856582553.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><br/><br/><img alt=\"质检2.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377857987696.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"商标吊牌.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377857790693.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"质检\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526377857985189.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '10', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 17:51:34', '2018-08-14 16:44:32', null);
INSERT INTO `ibrand_goods` VALUES ('61', '2018夏季新款全棉儿童套装字母印花一家三口亲子装', 'KS1612', '7', '7', '79.00', '129.00', '129.00', '199.00', '125.00', null, null, '320', 'https://cdn.viperky.com/storage/images/20180515/3aeigfciq6.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/458/190/8684091854_592962341.jpg\" data-spm-anchor-id=\"a261y.7663282.descBanner.i0.7e0e3a38y4iWXb\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/311/271/8719172113_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/724/841/8719148427_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/564/121/8684121465_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/708/742/8703247807_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/417/652/8703256714_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/752/751/8719157257_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/602/361/8719163206_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/715/811/8684118517_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/702/661/8719166207_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/552/331/8684133255_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/103/472/8703274301_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/477/952/8703259774_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/498/121/8719121894_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/511/571/8719175115_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/962/061/8719160269_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/104/151/8719151401_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/179/580/8684085971_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/246/331/8719133642_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/910/892/8703298019_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/166/601/8684106661_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/322/682/8703286223_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/702/982/8703289207_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/442/241/8684142244_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/118/790/8684097811_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '12', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 17:58:37', '2018-08-14 16:44:53', null);
INSERT INTO `ibrand_goods` VALUES ('62', '2018夏季童装新款韩版半身儿童公主裙子', 'KS1581', '7', '2', '79.00', '79.00', '79.00', '129.00', '129.00', null, null, '0', 'https://cdn.viperky.com/storage/images/20180515/vvyDoN4Cqx.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446803597.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446879090.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446110477.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446593686.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446719900.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446143150.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446479297.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446575353.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446304361.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446505643.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446454938.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446916343.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446514049.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446973657.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446928126.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446938377.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446860990.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446802330.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446509199.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446785340.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446384601.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446895859.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446366318.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446948781.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446498681.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446525322.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446410707.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446556358.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446948586.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446784800.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180515/1526378446511016.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '10', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-15 18:01:29', '2018-08-14 16:44:53', null);
INSERT INTO `ibrand_goods` VALUES ('63', '2018夏季新款童装海魂衫字母条纹T恤韩版母女亲子装', 'KS1729', '7', '7', '69.00', '88.00', '69.00', '136.00', '99.00', null, null, '700', 'https://cdn.viperky.com/storage/images/20180516/9CH0ykc9Pv.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434790594252.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434790520887.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434790666179.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434790900822.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434790901169.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434790820315.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434790792429.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434790590035.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434790163164.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434790784784.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434790346111.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434790477433.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434790283106.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434790282913.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434790639130.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434791459627.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434791168924.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434791297265.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434791233278.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434791807119.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526434791292874.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '3', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-16 09:41:38', '2018-08-14 16:44:53', null);
INSERT INTO `ibrand_goods` VALUES ('64', '2018夏季新款欧美童装儿童套装', '9700', '6', '3', '49.00', '49.00', '49.00', '79.00', '79.00', null, null, '165', 'https://cdn.viperky.com/storage/images/20180516/HU3jWIl7Vv.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"9700_01\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526435378627086.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9700_05\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526435378407189.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9700_06\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526435378288435.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9700_07\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526435378392012.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9700_08\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526435378547559.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9700_09\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526435378122979.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9700_10\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526435378570541.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9700_11\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526435378513125.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9700_12\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526435378837593.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9700_13\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526435378229048.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"9700_14\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526435378642569.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9700_15\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526435378652154.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/></p><p><br/></p>', null, '0', '0', '0', '0', '3', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-16 09:50:24', '2018-08-14 16:44:53', null);
INSERT INTO `ibrand_goods` VALUES ('65', '2018新款纯色全棉一家三口童装中袖T恤', 'KS1636', '7', '7', '49.00', '79.00', '79.00', '120.00', '75.00', null, null, '3200', 'https://cdn.viperky.com/storage/images/20180516/rtKPDHPXgX.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057075981769.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057075668912.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057075119190.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057075871913.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057075177622.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057075728144.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057075901303.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057075588395.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057075370546.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057075290748.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057075413005.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057075534479.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057075848770.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057075847389.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057075451512.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057075336129.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057075689027.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057075433351.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057075624042.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057075790127.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057076743034.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057076439626.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057076685352.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057076774308.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057076663597.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057076377570.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057076662951.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180523/1527057076198508.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '3', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-16 09:53:33', '2018-08-14 16:44:53', null);
INSERT INTO `ibrand_goods` VALUES ('66', '2018夏季新款韩版洗水加软麻料纯色系带装饰中小童短裤', 'Ks1694', '7', '1', '78.00', '78.00', '78.00', '118.00', '118.00', null, null, '300', 'https://cdn.viperky.com/storage/images/20180516/5qeqUlrb8C.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436361612865.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436361769660.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436361175587.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436361441138.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436361576616.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436361782225.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436361147693.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436361172336.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436362581660.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436362228156.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436362435262.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436362977645.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436362951027.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436362408984.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436362574415.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436362187980.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436362257584.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><br/><br/><img alt=\"质检2.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436362621853.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"商标吊牌.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436362340082.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"质检\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436362189865.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '9', '0', '0', '12', '45', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-16 10:08:51', '2018-08-14 16:44:53', null);
INSERT INTO `ibrand_goods` VALUES ('67', '2018夏季新款母女装全棉宽松潮范童T恤套头衫', 'KS1677', '7', '7', '68.00', '79.00', '68.00', '125.00', '98.00', null, null, '0', 'https://cdn.viperky.com/storage/images/20180516/15fX573g5k.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436581380833.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436581955753.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436581599927.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436581338507.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436581350470.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436581138406.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436619983661.jpg\" data-spm-anchor-id=\"a261y.7663282.descBanner.i2.4b1964d7L7Mue3\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436619856039.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436619890585.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436619168723.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436619395990.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436619647122.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436619815231.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436619604647.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436619365297.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436619618248.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436619728110.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436619167490.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436619566476.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436619851406.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436619863703.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526436619481813.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '8', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-16 10:12:03', '2018-08-14 16:44:53', null);
INSERT INTO `ibrand_goods` VALUES ('68', '潮爆韩版连帽波点印花男女两件套装', 'KS1610', '7', '3', '139.00', '139.00', '139.00', '219.00', '219.00', null, null, '50', 'https://cdn.viperky.com/storage/images/20180516/PC00HvwETk.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526437274539939.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526437274979758.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526437274605053.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526437274479289.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526437274206088.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526437274563589.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526437274674575.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526437274601120.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526437274186344.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526437274849624.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526437274625111.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526437274921374.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526437274876369.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526437274617823.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526437274643331.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526437274665728.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"商标吊牌.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526437274970618.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"质检\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526437274633386.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"质检2.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526437274129037.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '12', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-16 10:21:53', '2018-08-14 16:44:53', null);
INSERT INTO `ibrand_goods` VALUES ('69', '2018夏季新款韩版全棉拼接贴布绣拼色中小童套装', 'KS670', '7', '3', '98.00', '98.00', '98.00', '158.00', '158.00', null, null, '600', 'https://cdn.viperky.com/storage/images/20180516/xDgHzuODM5.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438093495323.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438093440578.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438093195105.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438025469917.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438025937458.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438025698653.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438025154437.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438025929686.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438025840001.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438025140162.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438025241467.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438025897590.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438025402674.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438025219949.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438025354561.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438025728981.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438025977016.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438025776434.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438026926448.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438026403543.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438026333644.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438026849361.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438026765351.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438026361963.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438026542619.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438026186748.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438026969837.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438026864145.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438026225299.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438026168267.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438026138345.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438026798288.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438027599900.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"商标吊牌.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438027170533.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"质检\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438027945537.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"质检2.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526438027596999.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '12', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-16 10:38:51', '2018-08-14 16:44:53', null);
INSERT INTO `ibrand_goods` VALUES ('70', '新款韩版中性百搭宽松五分裤', 'KS1707', '7', '1', '79.00', '79.00', '79.00', '129.00', '129.00', null, null, '80', 'https://cdn.viperky.com/storage/images/20180516/gnh2LyQm46.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"KS1707_02\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763596574.jpg\" data-spm-anchor-id=\"a261y.7663282.descBanner.i1.53ad1d89vVcaxi\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><img alt=\"KS1707_04\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763842516.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"KS1707_05\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763624523.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"KS1707_06\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763682405.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"KS1707_07\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763773782.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"KS1707_08\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763938246.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"KS1707_09\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763941209.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"KS1707_10\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763829507.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"KS1707_11\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763484822.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"KS1707_12\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763253406.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"KS1707_13\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763191593.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"KS1707_14\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763192243.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"KS17072_01\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763911245.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"KS17072_02\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763610008.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"KS17072_03\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763582174.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"KS17072_04\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763564576.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"KS17072_05\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763138482.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"KS17072_06\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763487270.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"KS17072_07\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763505666.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763431403.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763418225.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763607349.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526440763960115.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '3', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-16 11:37:01', '2018-08-14 16:44:53', null);
INSERT INTO `ibrand_goods` VALUES ('72', '20178夏季新款韩版纯色猫须边斜插袋男女童高弹短裤', 'KS316', '7', '1', '78.00', '78.00', '78.00', '128.00', '128.00', null, null, '0', 'https://cdn.viperky.com/storage/images/20180516/fY4pK8sA8N.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/851/297/4057792158_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 22pt;\">设计师解说</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">短裤是宝宝夏季必备的应季装备；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">因为宝宝活动量大，到了夏季更容易出汗；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">所以很多宝妈在夏季都会选择短袖短裤来给自己的宝宝；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">短裤简单，但我们把简单的东西细节化；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">短裤简单，但我们把简单的东西品质化；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">面料我们采用高弹赛络纺，裤子挺括有型，面料舒适弹力好；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">酵洗加软工艺让裤子，穿着亲肤柔软不刺激，颜色牢固度强；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">腰部宽度的丝光橡筋加橡筋定位，不勒宝宝腰身，洗涤不移位；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">裤脚猫须边设计显得简单而又不失时尚；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">后袋添加柳丁装饰，小心意大改观哦~~</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/669/979/4359979966_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/843/289/4359982348_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/560/589/4359985065_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/378/780/4358087873_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/110/889/4359988011_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/654/318/4362813456_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/></span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/166/387/4057783661_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/538/338/4056833835_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/946/164/4060461649_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/714/687/4057786417_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/877/777/4057777778_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/003/464/4060464300_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/243/987/4057789342_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/987/087/4057780789_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/295/248/4056842592_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2017/330/548/4056845033_592962341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '7', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-16 11:55:31', '2018-08-14 16:44:53', null);
INSERT INTO `ibrand_goods` VALUES ('73', '2018夏季新款纯色高弹赛络纺棉质磨破弹力韩版小童儿童短裤', 'KS174', '7', '1', '88.00', '88.00', '88.00', '158.00', '158.00', null, null, '0', 'https://cdn.viperky.com/storage/images/20180516/prLOpI6GEe.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526443646572281.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 22pt;\">设计师解说</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">盛夏来临；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">各种服饰形形色色在街头展露出来；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">夏季的缤纷多彩、夏季的热情似火；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">都是属于这个季节的颜色；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">我们也为宝宝设计了简单颜色艳丽的夏季五分裤作为出行装；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">面料采用了高弹赛络纺；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">这种面料具有优秀的弹力；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">全棉的属性给了它透气、舒适、干爽的特性；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">裤子采用了酵素洗加软工艺；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">使得裤子更亲肤，更柔软，色牢度更强；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">还运用了当下裤子最为流行的元素之一--磨破；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">真实的前后插袋让整条裤子更具立体感和饱满度；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">配色的大气门襟纽扣让整条裤子所有细节都展露出来；</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"font-size: 18pt;\">炎炎夏日，宝妈们是不是已经准备好给自己宝宝一条这样的裤子呢?</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526443646411313.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526443646835264.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526443646218123.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526443646720210.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526443646250956.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526443646448145.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526443646154814.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526443646758902.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526443646400090.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526443646345528.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '4', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-16 12:11:45', '2018-08-14 16:44:53', null);
INSERT INTO `ibrand_goods` VALUES ('74', '2018夏季新款童装三色棉短裤韩版男女童百搭童裤', 'KS1591', '7', '1', '49.00', '49.00', '49.00', '79.00', '79.00', null, null, '60', 'https://cdn.viperky.com/storage/images/20180516/oSmerYZcLg.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447830207714.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447830805083.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447830794683.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447830363995.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447830634810.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447830500171.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447830304348.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447830211118.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447830246337.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447830603269.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447830337517.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447830511227.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447830363833.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447830645160.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447830268751.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447830124909.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447830453527.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447831444871.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447831391137.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><br/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><br/><br/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"商标吊牌.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447831819473.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"质检\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447831712500.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"质检2.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526447831395194.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '7', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-16 13:21:41', '2018-08-14 16:44:53', null);
INSERT INTO `ibrand_goods` VALUES ('75', '2018夏季新款洗水固色加软牛仔棉男女童中性潮范儿童短裤', 'KS1607', '7', '1', '78.00', '78.00', '78.00', '128.00', '128.00', null, null, '10', 'https://cdn.viperky.com/storage/images/20180516/A5fJXdPrxF.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526448581620670.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526448582698801.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526448582306150.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526448582204061.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526448582313347.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526448582171270.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526448582651439.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526448582846309.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526448582750350.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526448582990365.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526448582917582.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"商标吊牌.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526448582484791.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"质检\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526448582704536.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><img alt=\"质检2.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526448582236245.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '11', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-16 13:30:20', '2018-08-14 16:46:04', null);
INSERT INTO `ibrand_goods` VALUES ('76', '2018韩版夏季新款童装潮范插袋猫须边中小童牛仔裤', 'KS666', '7', '1', '89.00', '89.00', '89.00', '139.00', '139.00', null, null, '400', 'https://cdn.viperky.com/storage/images/20180516/yCKKnaesUe.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449155571705.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449155114504.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449156736275.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449156292870.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449156252656.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449156380765.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449156475836.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449156931192.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449156551614.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449156394795.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449156663255.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449157829939.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449157433958.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449157632352.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449157422125.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449157240895.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449157524440.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449157110408.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449157536816.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449158750765.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both;\"><img alt=\"商标吊牌.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449158292960.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both;\"><img alt=\"质检\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449158164339.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"质检2.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180516/1526449158347152.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p>', null, '0', '0', '0', '0', '9', '0', '', '', '', '2', '0', '1', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-16 13:39:59', '2018-08-14 16:46:04', null);
INSERT INTO `ibrand_goods` VALUES ('77', '测试商品勿下单-暴暴', 'test', '6', '3', '9.00', '9.00', '9.00', '29.00', '29.00', null, null, '4', 'https://cdn.viperky.com/storage/images/20180516/26dpZEjppG.jpg', null, null, '0', '0', '0', '0', '3', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-16 14:33:59', '2018-05-19 17:11:52', null);
INSERT INTO `ibrand_goods` VALUES ('78', '2018夏季新款中小童宝宝T恤男童纯棉文艺时尚休闲短袖', '8172101193', '10', '3', '58.00', '58.00', '58.00', '79.00', '79.00', null, null, '60', 'https://cdn.viperky.com/storage/images/20180521/4pjdI5JrCY.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887945502895.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887945925344.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887945798855.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887945799498.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887945156123.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887946190042.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887946994804.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887946918810.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887946618403.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887946521578.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887946993155.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887947508465.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887947554943.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887947990167.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887947653021.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887948230683.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887948100584.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887948902620.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887948915626.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887948535338.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887948213810.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887949537471.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887949778287.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887949858896.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887949258475.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887949251214.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887950813823.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887950346748.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887950326874.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887950505878.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887950565086.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887950352799.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887950682188.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887951647389.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887951809448.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887951795473.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '3', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-21 15:34:49', '2018-08-14 16:46:04', null);
INSERT INTO `ibrand_goods` VALUES ('79', '2018夏季新款洗水加软毛边韩版中性牛仔短裤', 'KS1781', '7', '1', '88.00', '88.00', '88.00', '134.00', '134.00', null, null, '500', 'https://cdn.viperky.com/storage/images/20180521/UKEAjlCBA7.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887955713692.jpg\" data-spm-anchor-id=\"a261y.7663282.descBanner.i0.64a93d40EJwQWS\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887955567620.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887955637693.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887955523223.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887955977640.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887956218901.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887956348403.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887956755988.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887956300516.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887956200932.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887956786750.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887957998302.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887957312862.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887957730923.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887957471419.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887957940487.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887957873529.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887957129695.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887957679824.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887957761051.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526887957247667.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '12', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-21 15:35:37', '2018-08-14 16:46:25', null);
INSERT INTO `ibrand_goods` VALUES ('80', '2018新款韩版中小女童纯色宽松九分牛仔裤', 'KS1582', '7', '1', '98.00', '98.00', '98.00', '150.00', '150.00', null, null, '500', 'https://cdn.viperky.com/storage/images/20180521/4yxNr0Z2wQ.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889111120563.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889111870083.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889111679042.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889111198655.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889111693394.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889111161080.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889111628258.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889111271845.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889111104593.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889111845043.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889111879984.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889111518318.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889111103204.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889112475280.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889112789066.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889112523107.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '11', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-21 15:53:00', '2018-08-14 16:45:52', null);
INSERT INTO `ibrand_goods` VALUES ('81', '2018韩版新款纯色打孔轻薄透气防晒服外套', '17189打孔佩奇', '9', '9', '69.00', '69.00', '69.00', '99.00', '99.00', null, null, '2000', 'https://cdn.viperky.com/storage/images/20180521/xYFWSXF9DI.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889221691881.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889221471305.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889221426977.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889221388562.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889221297694.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889221202113.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889221124637.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"2详情_12\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889221553839.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"2详情_13\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889221907261.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"2详情_16\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889221908782.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"2详情_17\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889221252805.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"2详情_19\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889221817891.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"19\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889221342878.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '11', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-21 15:54:33', '2018-08-14 16:45:52', null);
INSERT INTO `ibrand_goods` VALUES ('82', '2018韩版新款纯色打孔轻薄透气防晒服外套', '17078', '9', '9', '68.00', '68.00', '68.00', '98.00', '98.00', null, null, '1000', 'https://cdn.viperky.com/storage/images/20180525/OwUQuZk6W8.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889832975164.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889832392712.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889832144023.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889832170753.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889832317650.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889832985142.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889832519374.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889832850430.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889832768425.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889832576454.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"_13\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889832183790.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"_14\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889832810772.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"_15\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889832196604.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"_01\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889832975164.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '11', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-21 16:04:42', '2018-08-14 16:45:52', null);
INSERT INTO `ibrand_goods` VALUES ('83', '2018夏新款女童韩版童装潮流纯色无袖T恤', 'KS1710', '7', '3', '59.00', '59.00', '59.00', '90.00', '90.00', null, null, '1000', 'https://cdn.viperky.com/storage/images/20180521/l1cMiDYS0h.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889917563633.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889917780138.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889917977450.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889917225047.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889917317473.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889917164046.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889917174203.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889917299565.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918429084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918620792.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918740835.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918875883.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918941433.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918555119.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918415806.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918999062.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918517860.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918997364.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918393617.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918232741.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918262337.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918500111.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918193330.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918531549.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918246444.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918868956.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918450226.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918429178.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918361211.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918827333.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918643023.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918408536.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526889918402232.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '11', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-21 16:06:29', '2018-08-14 21:08:59', null);
INSERT INTO `ibrand_goods` VALUES ('84', '韩系范糖果色儿童防晒服可变背包', '17180', '9', '9', '59.00', '59.00', '59.00', '118.00', '118.00', null, null, '1000', 'https://cdn.viperky.com/storage/images/20180521/YvhTF5FavK.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890394427026.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890394559246.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" height=\"606.1580680570801\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890394731299.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890394259881.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890394341550.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890394641516.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890394640852.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890394407028.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890394588161.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890394603796.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890394546451.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"2详情_12\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890394320489.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"2详情_13\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890394965820.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"2详情_14\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890394330628.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890394108485.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '6', '0', '0', '11', '30', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-21 16:14:34', '2018-08-14 21:08:59', null);
INSERT INTO `ibrand_goods` VALUES ('87', '2018夏季韩版一家三口亲子装纯棉短袖T恤', 'KS1773', '7', '7', '59.00', '88.00', '88.00', '136.00', '90.00', null, null, '1400', 'https://cdn.viperky.com/storage/images/20180521/fg6XhS0P3a.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890718308265.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890718255373.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890718301428.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890718158306.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890718369319.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890718563031.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890718133321.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890718851390.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890719680094.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890719232556.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890719698886.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890719936790.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890719342768.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890719238409.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890719576968.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890719447402.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890719478218.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890719625031.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890719928580.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890719514782.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890719878387.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890719590832.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890719139187.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890719916649.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890719332393.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890719354073.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890720296254.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890720867719.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890720539696.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890720341634.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890720951355.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526890720505854.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '7', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-21 16:19:54', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('88', '2018韩版夏季韩版字母短袖T恤家庭亲子装', 'KS1782', '7', '7', '59.00', '89.00', '89.00', '145.00', '95.00', null, null, '1800', 'https://cdn.viperky.com/storage/images/20180521/0vPCfgHqU0.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891555593805.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556121859.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556542167.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556521971.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556927420.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556668046.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556504717.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556816071.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556378759.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556806390.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556993137.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556462339.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556356969.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556192913.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556612629.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556137867.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556766834.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556829698.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556323011.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556988363.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556904351.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556840209.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556920505.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891556384459.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '10', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-21 16:33:38', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('89', '2018夏季新童装5分超薄短袖男女儿童卡通纯棉家居服', 'un8ssiw061501', '8', '8', '98.00', '98.00', '98.00', '158.00', '158.00', null, null, '600', 'https://cdn.viperky.com/storage/images/20180521/toq7Uq3HA1.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"color: rgb(255, 0, 0); line-height: 1.5; font-family: simhei; font-size: 24pt;\"><img alt=\"undefined\" height=\"3643\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891539949884.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" height=\"2202\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891539278225.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><img alt=\"undefined\" height=\"3418\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891539986167.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" height=\"3103\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891539370868.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><img alt=\"undefined\" height=\"4616\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891540412836.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" height=\"4246\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891540286860.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><img alt=\"undefined\" height=\"4006\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891540775587.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" height=\"4050\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891541799210.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><img alt=\"undefined\" height=\"2741\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891541270180.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" height=\"3228\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891541559195.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><img alt=\"undefined\" height=\"3502\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891542952300.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" height=\"2369\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891542763260.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/></span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"color: rgb(255, 0, 0); font-family: simhei; font-size: 24pt; background-color: rgb(255, 204, 153);\"><br/><br/><br/><br/><br/><br/><br/><br/><br/><br/><br/></span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"温馨提示：修改后是安全的\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891542117420.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" height=\"968\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891542598744.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" height=\"899\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526891543310246.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '8', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-21 16:39:49', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('90', '2018夏季新款欧美风儿童纯棉T恤', '9092', '6', '3', '28.00', '28.00', '28.00', '38.00', '38.00', null, null, '12', 'https://cdn.viperky.com/storage/images/20180521/1SKwXtshhX.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"9092_01.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526892520412316.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9092_02.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526892520387560.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9092_04.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526892520542503.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9092_05.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526892520614129.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9092_06.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526892520843115.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9092_07.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526892520269428.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9092_09.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526892520987215.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9092_10.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526892520760184.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9092_12.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526892520751903.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9092_13.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526892520680299.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"9092_14.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526892520314524.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '8', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-21 16:49:43', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('91', '2018夏款进口男女童短袖5分超薄竹节棉空调房家居服套装', 'un8sssw020501', '8', '8', '88.00', '88.00', '88.00', '138.00', '138.00', null, null, '620', 'https://cdn.viperky.com/storage/images/20180521/z6Gz0H9Hzp.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20180521/1526893339277901.png\" title=\"1526893339277901.png\" alt=\"2.png\"/></p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20180521/1526893349505883.png\" title=\"1526893349505883.png\" alt=\"1.png\"/></p><p><img alt=\"undefined\" height=\"1074\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893370112026.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img alt=\"undefined\" height=\"907\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893370906709.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"温馨提示：修改后是安全的\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893370229005.jpg\" data-spm-anchor-id=\"a261y.7663282.descBanner.i1.52374b28oJmXIs\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '11', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-21 17:03:06', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('92', '韩版童装夏季新款宝宝短袖男童T恤', '9075', '6', '3', '28.00', '28.00', '28.00', '38.00', '38.00', null, null, '389', 'https://cdn.viperky.com/storage/images/20180521/Wl3BMd2mQR.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"9075_01.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893055743218.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9075_02.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893055575514.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9075_04.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893055630571.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9075_05.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893055315130.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9075_07.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893055720638.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9075_09.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893055433447.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9075_10.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893055206913.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9075_12.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893055533947.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"9075_13.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893055890462.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"9075_14.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893055972324.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/></p><p><br/></p>', null, '0', '0', '0', '0', '13', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-21 17:03:14', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('93', '2018夏季新品 男童欧美风五分裤', '6205', '6', '1', '38.00', '38.00', '38.00', '55.00', '55.00', null, null, '563', 'https://cdn.viperky.com/storage/images/20180521/8YFEp3Q6Uo.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"6205_01.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893678907697.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"6205_02.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893678909736.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"6205_04.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893678906705.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"6205_05.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893678330517.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"6205_06.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893678279105.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"6205_07.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893678217759.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"6205aa.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893678806293.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><img alt=\"6205_09.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893678891583.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"6205_10.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893679298264.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"6205_12.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893679285271.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"6205_13.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893679408377.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"6205_14.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526893679675075.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/></p><p><br/></p>', null, '0', '0', '0', '0', '11', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-21 17:17:38', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('94', '2018夏季新品童装背心男女宝宝儿童纯棉内衣套装', 'un8sssw060601', '8', '8', '79.00', '79.00', '79.00', '129.00', '129.00', null, null, '240', 'https://cdn.viperky.com/storage/images/20180521/Tv7mOtqpk5.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"color: rgb(255, 0, 0); line-height: 1.5; font-family: simhei; font-size: 24pt;\"><img alt=\"undefined\" height=\"3785\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526894348608513.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" height=\"4131\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526894348636475.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><img alt=\"undefined\" height=\"4254\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526894348317377.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" height=\"3333\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526894349713373.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><img alt=\"undefined\" height=\"4210\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526894349673080.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" height=\"2617\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526894350533270.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><img alt=\"undefined\" height=\"3541\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526894350255826.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" height=\"2994\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526894350177375.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/></span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"color: rgb(255, 0, 0); font-family: simhei; font-size: 24pt; background-color: rgb(255, 204, 0);\"><br/><br/></span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" height=\"1023\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526894350823558.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" height=\"899\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526894359940142.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"温馨提示：修改后是安全的\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180521/1526894359490806.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '8', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-21 17:20:46', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('95', '本比小熊2018夏季新款韩版全棉短袖舒适百搭', '8172100283', '10', '3', '59.00', '59.00', '59.00', '79.00', '79.00', null, null, '90', 'https://cdn.viperky.com/storage/images/20180525/Xsoj2c7PDx.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224552198056.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224552898567.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224552729544.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224552961420.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224552853233.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224553255717.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224553427506.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224553559836.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224553623690.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224553703073.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224553388974.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224554851880.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224554419765.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224554934799.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224554755606.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224554188177.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224555764072.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224555268485.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224555575240.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224555585915.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224555100568.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224555741824.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224556352108.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224556641282.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224556689486.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224556921213.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224556843149.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527224556619482.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '4', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-25 13:03:56', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('96', '本比小熊2018新款中小童卡通动物印花纯棉衬衫', '8182100133', '10', '3', '99.00', '99.00', '99.00', '145.00', '145.00', null, null, '75', 'https://cdn.viperky.com/storage/images/20180525/p70wPeToIb.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"细节展示\" src=\"https://cbu01.alicdn.com/img/ibank/2016/775/840/2785048577_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/735/665/8811566537_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/846/515/8795515648_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/308/845/8811548803_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/857/905/8795509758_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"模特展示\" src=\"https://cbu01.alicdn.com/img/ibank/2016/714/755/2788557417_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/015/245/8795542510_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/201/365/8795563102_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/880/395/8811593088_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/553/485/8811584355_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/149/657/8775756941_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/459/455/8811554954_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/957/267/8775762759_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/372/387/8775783273_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/268/425/8795524862_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/189/957/8775759981_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/296/635/8795536692_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/403/065/8795560304_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/357/035/8795530753_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/490/695/8811596094_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/025/155/8795551520_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/040/185/8795581040_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/785/477/8775774587_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/264/455/8795554462_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/731/897/8775798137_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/207/245/8795542702_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/762/365/8795563267_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/542/395/8811593245_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/415/485/8811584514_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/421/506/8811605124_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/501/408/8775804105_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/818/635/8795536818_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/224/065/8795560422_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/188/035/8795530881_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/722/695/8811596227_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/521/185/8795581125_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/746/155/8795551647_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://cbu01.alicdn.com/img/ibank/2018/412/275/8795572214_1011975084.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '12', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-25 13:12:50', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('97', '本比小熊2018夏季新品韩版童装宝宝夏装短裤薄款', '8182101293', '10', '1', '89.00', '89.00', '89.00', '135.00', '135.00', null, null, '100', 'https://cdn.viperky.com/storage/images/20180525/w9YOk1KX3W.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225426681272.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225426266288.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225426817960.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225427382385.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225427269531.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225427512340.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225427685493.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225428951462.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225428619007.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225428819918.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225428333593.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225428613064.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225429951378.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225429904933.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225429228637.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225429717763.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225429677782.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225430942634.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225430326043.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225430802861.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225430697274.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225430328660.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225431714163.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225431715109.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225431201265.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225431165259.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225431818069.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225431475527.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225432213666.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225432534358.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225432567533.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225432546989.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225433118762.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225433916747.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225433888868.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225433906577.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225433652312.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225434670597.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225434797240.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225434708545.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225434918502.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225434424751.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225435565404.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225435267205.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225435465383.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225435148871.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225435388624.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225436749400.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225436849666.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225436265018.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527225436745475.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '8', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-25 13:46:09', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('98', '本比小熊2018新款韩版棉布潮流舒适短裤', '18182101333', '10', '1', '99.00', '99.00', '99.00', '145.00', '145.00', null, null, '82', 'https://cdn.viperky.com/storage/images/20180525/64tu3JIY7D.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227956971623.jpg\" data-spm-anchor-id=\"a261y.7663282.descBanner.i2.75b363609NyCs7\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227956589767.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"模特展示\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227956545728.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227956856683.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227956410143.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227957443310.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227957442323.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227957750596.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227957625124.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227957985874.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227957965567.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227958785268.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227958223883.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227958938024.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227959259501.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227959632917.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227959250930.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227959419596.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227959998977.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227959435445.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227960858001.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227960381178.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227960402407.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227960860272.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227960703933.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227960727478.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227961789961.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227961960041.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227961889288.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227961351265.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227961188489.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227962616359.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227962140968.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227962449212.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227962184032.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227962638445.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227962108283.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227963409570.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227963500283.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227963956749.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227963673644.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227963969936.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227964206119.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227964629380.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227964295287.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227964938978.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227964413170.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227964900406.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227965848637.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227965674399.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527227965596755.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '11', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-25 14:00:05', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('99', '本比小熊新品童装无袖背心中小童宝宝棉布衫', '8182101323', '10', '3', '69.00', '69.00', '69.00', '105.00', '105.00', null, null, '200', 'https://cdn.viperky.com/storage/images/20180525/UlcXjFBp6R.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228706900118.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228706205013.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228706290936.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228706879296.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228706387165.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"模特展示\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228706282536.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228707167653.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228707188656.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228707536813.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228707221986.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228708793936.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228708115608.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228708479246.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228709280712.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228709869619.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228709429115.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228709190974.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228709449591.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228710240861.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228710837267.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228710399272.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228711308339.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"细节展示\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228711515791.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228711181773.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228711701318.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228711298195.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228712612172.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228712141895.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228712505113.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228712730281.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228712624201.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228713384362.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228713536643.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228713780668.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228713227435.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228714170366.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228714835250.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527228714798573.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '7', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-25 14:18:24', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('100', '本比小熊夏季宝宝背心2018新款休闲百搭夏装潮衣', '18172100373', '10', '3', '49.00', '49.00', '49.00', '75.00', '75.00', null, null, '50', 'https://cdn.viperky.com/storage/images/20180525/fBOKr15rw6.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527230071753374.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527230071491575.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527230071127561.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527230071824219.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527230072775994.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527230072304864.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527230072522432.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527230072842042.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527230073939546.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527230073467122.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527230073881449.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527230073516859.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527230073910114.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527230074255636.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527230074464478.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527230074314989.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527230074443772.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527230074233151.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '11', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-25 14:35:24', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('101', '本比小熊2018新品韩版童装宝宝运动休闲套装两件套', '8182101223', '10', '3', '119.00', '119.00', '119.00', '190.00', '190.00', null, null, '16', 'https://cdn.viperky.com/storage/images/20180525/bqA0rkDnxp.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231267103616.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231267647962.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231267236572.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231268348926.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"模特展示\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231268112374.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231268507906.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231268394955.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231268940970.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231269186325.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231269483647.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231269980674.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231269428622.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231270580635.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231270258241.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231270755806.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231270488250.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231271266283.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231271903087.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231271755673.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231272777530.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img alt=\"细节展示\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231272179421.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231272956993.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231272988326.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231272593536.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231272614248.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231272386082.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231273286673.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231273452927.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231273776331.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231273769851.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231274301295.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231274300796.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231274835210.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231274879031.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231274380408.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231274950981.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231275833435.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231275570130.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231275308481.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231275218133.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231276371853.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231276136303.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231276362698.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231276346652.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231276874636.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231277257682.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231277724808.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231277326333.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231278275853.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527231278315394.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '12', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-25 14:57:19', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('102', '本比小熊2018夏季新品韩版宝宝运动套装中小男童夏装两件套', '8182101533', '10', '3', '119.00', '119.00', '119.00', '190.00', '190.00', null, null, '35', 'https://cdn.viperky.com/storage/images/20180525/4h4mxaCOwx.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232338964386.jpg\" data-spm-anchor-id=\"a261y.7663282.descBanner.i1.2ec45ad02QpdZf\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232339644450.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"模特展示\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232339379805.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232339522805.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232339937247.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232339605971.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232339496710.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232340759529.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232340164103.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232340707272.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232340609323.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232341343533.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232341184316.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232341368119.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232341411764.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232342192284.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><img alt=\"细节展示\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232342542788.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232342860510.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232342770338.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232342641012.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232342744637.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232342997151.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232343410654.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232343322590.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232343154930.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232343242870.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232343610568.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232343488602.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232344395287.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232344998303.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232344370636.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232344381775.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232344940650.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232344918138.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232345840832.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232345167363.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232345573943.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232345324808.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232345745147.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232345497240.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232346997543.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232346778793.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232346408109.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232346829192.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180525/1527232346580685.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '5', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-25 15:13:58', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('103', '2018夏季新款中小童宝宝棉背心套装', '18182101233', '10', '3', '139.00', '139.00', '139.00', '219.00', '219.00', null, null, '90', 'https://cdn.viperky.com/storage/images/20180528/ivncB2qDQz.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527492767562673.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527492767328517.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527492768773059.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527492768635730.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527492768919834.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527492768755548.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527492768674790.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527492769541416.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527492769688331.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527492769138740.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527492769817849.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527492770188782.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527492770261713.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527492770786065.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527492770206972.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '0', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-28 15:36:29', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('104', '2018夏季新品韩版中小童短袖T恤', '18172100073', '10', '3', '78.00', '78.00', '78.00', '118.00', '118.00', null, null, '19', 'https://cdn.viperky.com/storage/images/20180528/ObCG8FzWP8.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494042955951.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494042115476.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494042452538.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494042166077.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494043847110.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494043632188.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494043962599.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494043636690.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494043427884.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494043733668.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494044655767.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494044873374.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494044899144.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494044439302.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494044791573.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494045400743.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494045351374.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494045736836.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494045213828.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494045616397.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494046361296.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494046572514.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527494046409685.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '0', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-28 15:55:08', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('105', '2018夏季新款全棉儿童短裤', '18182101553', '10', '1', '119.00', '119.00', '119.00', '179.00', '179.00', null, null, '27', 'https://cdn.viperky.com/storage/images/20180528/ZrXYaODeKs.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501086428606.jpg\" data-spm-anchor-id=\"a261y.7663282.descBanner.i0.7ac989aeovsRkJ\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501086425096.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501086864355.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501087240335.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501087175724.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501087190617.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501087828962.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501087299490.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501087729716.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501087690714.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501087929904.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501087123799.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501087642400.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501087670741.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501088983023.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '0', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-28 17:52:26', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('106', '2018夏季新款中小童短袖T恤半袖衫', '8172100553', '10', '3', '59.00', '59.00', '59.00', '79.00', '79.00', null, null, '55', 'https://cdn.viperky.com/storage/images/20180528/QZiWe55bKD.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501729670852.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501729170049.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501729909220.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501729564620.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501729693478.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501730955672.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501730367561.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501730229523.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501730370456.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501731943545.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501731493104.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501731608570.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501731926341.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501731496140.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501731644048.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501731652056.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501731748533.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501731559852.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501731995492.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501732421368.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501732144152.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501732110953.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501732247899.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501732398577.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501732836217.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501733967523.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501733704726.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501733791862.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501733439637.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501733875996.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501733479544.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501733763171.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501733837618.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501733817365.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527501734374007.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '0', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-28 18:03:05', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('107', '2018夏季新款中小童全棉T恤圆领短袖', '8172101393', '10', '3', '49.00', '49.00', '49.00', '75.00', '75.00', null, null, '75', 'https://cdn.viperky.com/storage/images/20180528/d0mi2NQVGH.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502211695094.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502211627208.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502211494144.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502211506963.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502211134752.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502212947246.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502212592227.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502212353647.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502212157622.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502212664694.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502212578081.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502213305019.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502213236551.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502213178899.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502214736035.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502214971360.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502214896719.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502214643566.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502214298896.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502215633571.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502215922743.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502215555049.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502215351943.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502216927754.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502216896469.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502216193300.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502216795982.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502216736222.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502216937972.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502217326820.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502217588687.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502217466189.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502217420836.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180528/1527502217380257.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '0', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-05-28 18:11:36', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('108', 'KINCHO日本金鸟儿童孕婴天然花草防蚊手环', '54080/54081', '11', '11', '79.00', '79.00', '79.00', '119.00', '119.00', null, null, '200', 'https://cdn.viperky.com/storage/images/20180607/A8vgL13Tsw.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"新海报参考\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528187014708661.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"日本金鸟驱蚊手环4（独家卖点）\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528187014841079.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"使用场景（改字体）_01\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528187014888263.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"日本金鸟驱蚊手环-3(防水与全家共享)改动字体侵权_02\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528187014703391.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"日本金鸟驱蚊手环-3(防水与全家共享)改动字体侵权_01\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528187015100570.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"使用场景（改字体）_02\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528187015497835.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; text-align: center; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '0', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-06-05 16:26:04', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('109', '爆款ins婴儿萌萌兔子午睡毯宝宝空调毛线毯子', '201865', '12', '8', '89.00', '89.00', '89.00', '139.00', '139.00', null, null, '3000', 'https://cdn.viperky.com/storage/images/20180605/CfzFIjxPZo.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: &quot;microsoft yahei&quot;; color: rgb(255, 0, 0); font-size: 16pt; background-color: rgb(255, 255, 255);\">本品材质为 纯棉，不是晴纶的，请注意区分。</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: &quot;microsoft yahei&quot;;\">ins火爆滴针织毛线毯子 空调房~出门推车</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: &quot;microsoft yahei&quot;;\">超可爱立体兔兔造型 幼儿园拉风小毯子</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: &quot;microsoft yahei&quot;;\">大小宝宝都能盖~幼儿园盖毯实在是太独特</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: &quot;microsoft yahei&quot;;\">卖萌上班族~萌妹纸~美妈~当午睡毯也无压力</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: &quot;microsoft yahei&quot;;\">可以当挂毯&nbsp;婴儿推车毯&nbsp;婴儿床盖毯或床单&nbsp;&nbsp;在户外可以当地毯&nbsp;</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: &quot;microsoft yahei&quot;;\">重要的是可以当拍照的背景毯哈 &nbsp; &nbsp;&nbsp;装饰婴儿房儿童房也是非常的美丽</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: &quot;microsoft yahei&quot;;\">我们家毛线都用纯棉滴~整体线细致~更精密~垂感较好~不起球！</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: &quot;microsoft yahei&quot;;\">精品棉作为此款的面料，</span><span style=\"line-height: 1.5; font-family: &quot;microsoft yahei&quot;;\">棉线不会扎手，而且柔软，</span><span style=\"line-height: 1.5; font-family: &quot;microsoft yahei&quot;;\">是小宝宝的忠实伴侣。</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; text-align: center;\"><span style=\"line-height: 1.5; font-family: &quot;microsoft yahei&quot;;\">&nbsp;<span style=\"font-size: 26pt;\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span style=\"font-family: 楷体_gb2312;\">&nbsp; &nbsp;羊羔绒图片</span></span></span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: &quot;microsoft yahei&quot;;\">&nbsp;<img alt=\"undefined\" height=\"525.4322916666666\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528190772560803.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" height=\"790\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528190772807629.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: &quot;microsoft yahei&quot;;\">&nbsp;<br/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528190772283690.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528190772602703.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><br/><br/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528190772298468.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528190773483481.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528190773716098.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528190773956875.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528190773870897.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528190773281402.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528190774210901.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528190774421767.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528190774849042.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></span></p><p><br/></p>', null, '0', '0', '0', '0', '0', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-06-05 17:27:17', '2018-08-14 16:41:32', null);
INSERT INTO `ibrand_goods` VALUES ('110', '韩国进口 新款宝露露儿童西瓜防晒霜60ml啵乐乐防晒SPF45正品', '0040000010', '13', '11', '89.00', '89.00', '89.00', '149.00', '149.00', null, null, '50', 'https://cdn.viperky.com/storage/images/20180605/hcBoMVlioh.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-size: 12pt;\"><span style=\"font-weight: 700;\"><span style=\"background-color: rgb(255, 255, 255); color: rgb(255, 0, 0);\">严正通知：</span></span></span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-size: 12pt;\">&nbsp; &nbsp; &nbsp; &nbsp;以下产品详情所描述的为产品所含（植物）成分功效，（植物）成分功效全部引自百度.百科，仅供参考！（植物）成分功效，不代表产品功效，不能作为一些职业打假人的投诉理由，请亲们知悉！</span></span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-size: 12pt;\">如遇职业欺诈，我们公司将保留对其追究法律责任的权利！！！</span></span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-size: 12pt;\"><img alt=\"宝露露防晒霜_01_01\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528192933853948.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"宝露露防晒霜_01_02\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528192934772773.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"宝露露防晒霜_01_03\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528192934377989.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"宝露露防晒霜_01_04\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528192934281732.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"宝露露防晒霜_01_05\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528192934866178.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"宝露露防晒霜_01_07\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528192934499839.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"宝露露防晒霜_01_09\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528192935233655.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"宝露露防晒霜_01_10\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528192935809613.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"宝露露防晒霜_09\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180605/1528192935755297.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></span></span></p><p><br/></p>', null, '0', '0', '0', '0', '0', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-06-05 18:03:14', '2018-08-14 21:08:59', null);
INSERT INTO `ibrand_goods` VALUES ('111', 'Kocotree新款儿童夏季男女童太阳帽亲子空顶防晒帽', 'KQ15431', '14', '11', '39.00', '39.00', '39.00', '98.00', '98.00', null, null, '1280', 'https://cdn.viperky.com/storage/images/20180606/ugnCsOgI7j.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; \n\ncolor: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, \n\nsans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-size: 16pt;\">儿童款帽围：50-54cm</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; \n\ncolor: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, \n\nsans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-size: 16pt;\"><span style=\"font-size: 16pt;\">成人款帽围：54-\n\n57cm</span></span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; \n\ncolor: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, \n\nsans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-size: 16pt;\"><span style=\"font-size: 16pt;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/152826004370\n\n8198.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; \n\nzoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/152826004468\n\n7196.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; \n\nzoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/152826004437\n\n0176.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; \n\nzoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/152826004416\n\n4362.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; \n\nzoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/152826004484\n\n6867.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; \n\nzoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/152826004497\n\n6100.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; \n\nzoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/152826004594\n\n4524.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; \n\nzoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/152826004522\n\n6445.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; \n\nzoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/152826004553\n\n5091.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; \n\nzoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/152826004565\n\n5307.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; \n\nzoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/152826004553\n\n1198.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; \n\nzoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/152826004535\n\n0962.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; \n\nzoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/152826004650\n\n3513.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; \n\nzoom: 1;\"/><br/></span></span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; \n\ncolor: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, \n\nsans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/152826004653\n\n1762.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; \n\nzoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/152826004681\n\n4583.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; \n\nzoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/152826004686\n\n5831.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; \n\nzoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/152826004636\n\n0205.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; \n\nzoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/152826004636\n\n1019.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; \n\nzoom: 1;\"/></p><p><br/></p>', null, '0', '21', '0', '0', '0', '105', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-06-06 12:43:28', '2018-08-14 21:08:58', null);
INSERT INTO `ibrand_goods` VALUES ('112', '儿童时尚户外防晒遮阳鸭舌帽空顶帽', 'MR369', '15', '11', '35.00', '35.00', '35.00', '68.00', '68.00', null, null, '700', 'https://cdn.viperky.com/storage/images/20180606/qR9DWv1w2S.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><a href=\"https://fuzhuang.1688.com/524peishi.html\" target=\"_blank\" style=\"text-decoration-line: none; color: rgb(34, 34, 34); transition: color 0.3s ease 0s;\"><img style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px;\"/></a></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/1528267347703895.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/1528267348592809.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/1528267348449305.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180606/1528267348665478.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '0', '0', '0', '0', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-06-06 14:44:42', '2018-08-14 16:40:54', null);
INSERT INTO `ibrand_goods` VALUES ('113', '【江疏影力荐网红防晒霜】coppertone水宝宝温和纯净防晒霜spf50', '2018671', '17', '11', '88.00', '88.00', '88.00', '230.00', '230.00', null, null, '100', 'https://cdn.viperky.com/storage/images/20180607/opfRYLZJwy.jpg', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"02.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528351755738487.jpg\" class=\"img-ks-lazyload\" data-spm-anchor-id=\"a220o.1000855.0.i4.63f03af5epncq5\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255); line-height: 1.5;\"/></p><p><img alt=\"详情页2.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528351767486469.jpg\" class=\"img-ks-lazyload\" data-spm-anchor-id=\"a220o.1000855.0.i5.63f03af5epncq5\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/></p><p><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528352171194462.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/></p><p><img alt=\"详情页4.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528352185453538.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/></p><p><img alt=\"06.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528352195851195.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/></p><p><img alt=\"07.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528352208695874.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"margin: 0px; padding: 0px; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"08.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528352208630490.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/></p><p><img alt=\"09.jpg\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528352220477334.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/></p><p><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528352232390498.jpg\" class=\"img-ks-lazyload\" style=\"margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; max-width: 100%; float: none; color: rgb(64, 64, 64); font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"/></p><p><br/></p><p><br/></p><p><br/></p>', null, '0', '21', '0', '0', '0', '105', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-06-07 12:02:47', '2018-08-14 16:40:54', null);
INSERT INTO `ibrand_goods` VALUES ('114', '【驱蚊神器】创意卡通驱蚊扣10块3个颜色随机发', '2018672', '18', '11', '10.00', '10.00', '10.00', '28.80', '28.80', null, null, '298', 'https://cdn.viperky.com/storage/images/20180607/IREjBpFLfp.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353871331121.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353871429619.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353871300310.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353871320135.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353871400726.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\">&nbsp;</p><p data-spm-anchor-id=\"a261y.7663282.descBanner.i4.7d7f7b29PjJdeX\" style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353871359577.jpg\" data-spm-anchor-id=\"a261y.7663282.descBanner.i3.7d7f7b29PjJdeX\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p data-spm-anchor-id=\"a261y.7663282.descBanner.i1.7d7f7b29PjJdeX\" style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353871904980.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353871639519.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353872155198.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353872844283.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353872637761.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353872551550.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353872780178.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353871400726.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353872817217.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353872495461.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353872474526.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353872558251.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353872566098.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353872925025.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528353872445260.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p><br/></p>', null, '0', '18', '0', '0', '2', '90', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-06-07 14:50:10', '2018-08-14 16:40:54', null);
INSERT INTO `ibrand_goods` VALUES ('115', 'ins爆款收纳桶儿童提式玩具桶北欧家居真皮提手可站立帆布收纳袋', 'T006', '20', '8', '39.00', '39.00', '39.00', '98.00', '98.00', null, null, '700', 'https://cdn.viperky.com/storage/images/20180607/GKofa2jVIG.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img alt=\"H17B0314_副本\" height=\"790\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528358945506014.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"H17B0315_副本\" height=\"790\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528358945249958.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"H17B0346_副本\" height=\"790\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528358945413026.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"H17B0316_副本\" height=\"790\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528358945705100.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"H17B0347_副本\" height=\"790\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528358945728777.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"12\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528358945374784.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"A7B01F2A2DC05241A9FCEA00E792A6\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528358945221975.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"H17B0725_副本\" height=\"790\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528358945367533.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"H17B0319_副本\" height=\"714.95\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528358945302253.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 29.3333px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '0', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-06-07 16:09:15', '2018-08-14 16:40:54', null);
INSERT INTO `ibrand_goods` VALUES ('116', '新款zakka棉麻布艺花盆小麻袋 悬挂式黄麻点点条纹储物篮收纳挂袋', 'D002', '21', '8', '18.80', '18.80', '18.80', '58.80', '58.80', null, null, '600', 'https://cdn.viperky.com/storage/images/20180607/C6GaygKkc7.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20180607/1528361958226635.png\" title=\"1528361958226635.png\" alt=\"1.png\"/></p><p><img src=\"https://admin.viperky.com/uploads/ueditor/php/upload/image/20180607/1528361967895996.png\" title=\"1528361967895996.png\" alt=\"2.png\"/></p><p><img alt=\"IMG_0551\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528361915518936.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"IMG_0546\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528361915855358.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"IMG_0544\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528361915341976.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"IMG_0543\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528361915103004.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"IMG_0541\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528361915680228.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"IMG_0547\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528361915724838.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"IMG_0549\" height=\"526.3375\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528361915963619.jpg\" width=\"790\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"IMG_0548\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528361915490825.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"/><img alt=\"IMG_0545\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528361915562511.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255); zoom: 1;\"/></p>', null, '0', '0', '0', '0', '0', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-06-07 17:01:15', '2018-08-14 16:40:54', null);
INSERT INTO `ibrand_goods` VALUES ('117', '韩国进口pororo啵乐乐夏日宝宝止痒喷雾 进口儿童止痒喷雾50ml', '2018673', '13', '11', '58.00', '58.00', '58.00', '128.00', '128.00', null, null, '100', 'https://cdn.viperky.com/storage/images/20180607/J8eJOGzhVX.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528363141331835.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"1产品描述\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528363141681883.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/>&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: 微软雅黑; font-size: 14pt;\">产品名称：韩国啵乐乐儿童止痒喷雾</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: 微软雅黑; font-size: 14pt;\">产地：韩国</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: 微软雅黑; font-size: 14pt;\">容量：50ml</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: 微软雅黑; font-size: 14pt;\">主要材质：甘油，水，芦荟提取液，薄荷醇等</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: 微软雅黑; font-size: 14pt;\">保质期：3年</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: 微软雅黑; font-size: 14pt;\">使用方法：</span><span style=\"font-family: 微软雅黑; font-size: 14pt;\">涂于患处。有止痒、镇定、保湿的作用 。</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"2特点介绍\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528363141428995.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></p><p style=\"text-align: left; margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: 微软雅黑; font-size: 14pt;\">1.含有天然的芦荟成分</span></p><p style=\"text-align: left; margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: 微软雅黑; font-size: 14pt;\">2.具有很强的保湿作用</span></p><p style=\"text-align: left; margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: 微软雅黑; font-size: 14pt;\">3.能起到止痒的效果</span></p><p style=\"text-align: left; margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: 微软雅黑; font-size: 14pt;\">4.产品性质温和，天然芦荟提取成分，安全无刺激。</span></p><p style=\"text-align:center;margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\">&nbsp;</p><p style=\"text-align:center;margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-size: 12px;\"><br/>&nbsp;</span>&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><img alt=\"3产品展示\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528363141857313.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; float: left; zoom: 1;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: Tahoma, Arial, 宋体, sans-serif; font-size: 12px; white-space: normal;\"><span style=\"font-family: 微软雅黑; font-size: 14pt;\"><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528363141726375.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528363141201909.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img align=\"absmiddle\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528363141857720.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528363141302280.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/><br/><img alt=\"undefined\" src=\"https://admin.viperky.com/storage/uploads/ueditor/php/upload/image/20180607/1528363141481183.jpg\" style=\"border: none; visibility: visible; vertical-align: bottom; max-width: 790px; zoom: 1;\"/></span></p><p><br/></p>', null, '0', '0', '0', '0', '0', '0', '', '', '', '2', '0', '0', '0', null, '{\"video\":{\"status\":\"0\",\"url\":\"\"}}', '2018-06-07 17:19:29', '2018-08-14 16:40:54', null);
INSERT INTO `ibrand_goods` VALUES ('118', '2018春夏新款童装无痕T恤 纯色纯棉 中小童一片式高弹T恤', 'C0121', '22', '3', '29.90', '29.90', '29.90', '88.00', '88.00', null, null, '2160', 'https://cdn.viperky.com/storage/images/20180607/d2HdZEM01M.png', '<p style=\"text-align: center\">此商品仅用于交易流程测试，不退款，不发货！不小心拍了商品，请联系 ibrandshjchen 退款！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.5; clear: both; color: rgb(51, 51, 51); font-family: &quot;Hiragino Sans GB&quot;, Tahoma, Arial, 宋体, sans-serif; font-size: 