<?php

/*
 * This file is part of ibrand/EC-Open-Server.
 *
 * (c) 果酱社区 <https://guojiang.club>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace GuoJiangClub\EC\Open\Server\Seeders;

use GuoJiangClub\Component\Advert\Models\Advert;
use GuoJiangClub\Component\Advert\Models\AdvertItem;
use Illuminate\Database\Seeder;

class AdvertTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        $carousel = Advert::create(['code' => 'home.carousel', 'name' => '首页轮播']);

        AdvertItem::create(['advert_id' => $carousel->id, 'name' => '背带裤', 'image' => url('img/banner.png'), 'link' => '/pages/store/detail/detail?id=150']);

        $category = Advert::create(['code' => 'home.categories', 'name' => '首页分类']);

        AdvertItem::create(['advert_id' => $category->id, 'name' => '男童 T恤/衬衫', 'image' => url('img/c1.png'), 'link' => '/pages/store/list/list?c_id=3']);
        AdvertItem::create(['advert_id' => $category->id, 'name' => '女童 T恤/衬衫', 'image' => url('img/c2.png'), 'link' => '/pages/store/list/list?c_id=6']);
        AdvertItem::create(['advert_id' => $category->id, 'name' => '男童 裤装', 'image' => url('img/c3.png'), 'link' => '/pages/store/list/list?c_id=52']);
        AdvertItem::create(['advert_id' => $category->id, 'name' => '女童 裤装', 'image' => url('img/c4.png'), 'link' => '/pages/store/list/list?c_id=54']);
        AdvertItem::create(['advert_id' => $category->id, 'name' => '连衣裙', 'image' => url('img/c5.png'), 'link' => '/pages/store/list/list?c_id=39']);
        AdvertItem::create(['advert_id' => $category->id, 'name' => '亲子装', 'image' => url('img/c6.png'), 'link' => '/pages/store/list/list?c_id=15']);
    }
}
