<?php

/*
 * This file is part of ibrand/balace.
 *
 * (c) GuoJiangClub <https://www.ibrand.cc>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace GuoJiangClub\Component\Balance\Test;

use GuoJiangClub\Component\Balance\Balance;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Orchestra\Testbench\TestCase;

/**
 * Class BaseTest.
 */
abstract class BaseTest extends TestCase
{
	use DatabaseMigrations;

	/**
	 * set up test.
	 */
	protected function setUp()
	{
		parent::setUp(); // TODO: Change the autogenerated stub

		$this->seedBalances();
	}

	/**
	 * @param \Illuminate\Foundation\Application $app
	 */
	protected function getEnvironmentSetUp($app)
	{
		// Setup default database to use sqlite :memory:
		$app['config']->set('database.default', 'testing');
		$app['config']->set('database.connections.testing', [
			'driver'   => 'sqlite',
			'database' => ':memory:',
		]);
		$app['config']->set('repository.cache.enabled', true);
	}

	/**
	 * @param $paths
	 */
	protected function loadMigrationsFrom($paths)
	{
		$this->artisan('migrate', ['--database' => 'testing']);
	}

	/**
	 * @param \Illuminate\Foundation\Application $app
	 *
	 * @return array
	 */
	protected function getPackageProviders($app)
	{
		return [
			\Orchestra\Database\ConsoleServiceProvider::class,
			\GuoJiangClub\Component\Balance\BalanceServiceProvider::class,
			\GuoJiangClub\Component\Balance\Test\BalanceServiceProvider::class,
		];
	}

	/**
	 * seed some balance.
	 */
	public function seedBalances()
	{
		Balance::create(['user_id' => 1, 'type' => 'recharge', 'origin_id' => '1', 'origin_type' => 'ElementVip\Distribution\Core\Models\AgentOrder', 'value' => '5000']);
		Balance::create(['user_id' => 1, 'type' => 'expend', 'origin_id' => '2', 'origin_type' => 'ElementVip\Distribution\Core\Models\AgentOrder', 'value' => '-1000']);
		Balance::create(['user_id' => 1, 'type' => 'expend', 'origin_id' => '3', 'origin_type' => 'ElementVip\Distribution\Core\Models\AgentOrder', 'value' => '-2000']);
		Balance::create(['user_id' => 2, 'type' => 'recharge', 'origin_id' => '4', 'origin_type' => 'ElementVip\Distribution\Core\Models\AgentOrder', 'value' => '6000']);
		Balance::create(['user_id' => 2, 'type' => 'expend', 'origin_id' => '5', 'origin_type' => 'ElementVip\Distribution\Core\Models\AgentOrder', 'value' => '-2000']);
		Balance::create(['user_id' => 2, 'type' => 'expend', 'origin_id' => '6', 'origin_type' => 'ElementVip\Distribution\Core\Models\AgentOrder', 'value' => '-3000']);
	}
}
