<?php

/*
 * This file is part of ibrand/category.
 *
 * (c) GuoJiangClub <https://www.ibrand.cc>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace GuoJiangClub\Component\Category\Test;

use GuoJiangClub\Component\Category\Category;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Orchestra\Testbench\TestCase;

/**
 * Class BaseTest.
 */
abstract class BaseTest extends TestCase
{
    use DatabaseMigrations;

    protected $repository;

    /**
     * set up test.
     */
    protected function setUp()
    {
        parent::setUp(); // TODO: Change the autogenerated stub

        $this->repository = $this->app->make(\GuoJiangClub\Component\Category\RepositoryContract::class);

        $this->loadMigrationsFrom(__DIR__ . '/database');

        $this->seedCategorys();
    }

    /**
     * seed some seedCategorys.
     */
    public function seedCategorys()
    {

        $data = [
            'name' => '女装',
            'sort' => 1,
            'children' => [
                [
                    'name' => '卫衣',
                    'sort' => 1,
                    'children' => [
                        ['name' => '2016卫衣', 'sort' => 2],
                        ['name' => '2017卫衣', 'sort' => 1]]


                ],

                [
                    'name' => '短裤',
                    'sort' => 3,
                    'children' => [
                        ['name' => '2018短裤', 'sort' => 1]]

                ],

                [
                    'name' => '短袖',
                    'sort' => 2,
                    'children' => [
                        ['name' => '2018短袖', 'sort' => 1]]

                ],

            ],

        ];


        Category::create($data);


    }

    /**
     * @param \Illuminate\Foundation\Application $app
     */
    protected function getEnvironmentSetUp($app)
    {
        // Setup default database to use sqlite :memory:
        $app['config']->set('database.default', 'testing');
        $app['config']->set('database.connections.testing', [
            'driver' => 'sqlite',
            'database' => ':memory:',
        ]);
        $app['config']->set('repository.cache.enabled', true);

    }

    /**
     * @param \Illuminate\Foundation\Application $app
     *
     * @return array
     */
    protected function getPackageProviders($app)
    {
        return [
            \Prettus\Repository\Providers\RepositoryServiceProvider::class,
            \Orchestra\Database\ConsoleServiceProvider::class,
            \GuoJiangClub\Component\Category\ServiceProvider::class,
            \Kalnoy\Nestedset\NestedSetServiceProvider::class,
        ];
    }
}
