<?php

/*
 * This file is part of ibrand/favorite.
 *
 * (c) GuoJiangClub <https://www.ibrand.cc>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace GuoJiangClub\Component\Favorite\Test;

use GuoJiangClub\Component\Favorite\Favorite;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Orchestra\Testbench\TestCase;

/**
 * Class BaseTest.
 */
abstract class BaseTest extends TestCase
{
    use DatabaseMigrations;

    public $repository;

    /**
     * set up test.
     */
    protected function setUp()
    {
        parent::setUp(); // TODO: Change the autogenerated stub

        $this->loadMigrationsFrom(__DIR__ . '/database');

        $this->repository = $this->app->make(\GuoJiangClub\Component\Favorite\RepositoryContract::class);

        $this->seedFavorite();
        $this->seedGoods();
        $this->seedActivitys();
    }
    /**
     * @param \Illuminate\Foundation\Application $app
     */
    protected function getEnvironmentSetUp($app)
    {
        // Setup default database to use sqlite :memory:
        $app['config']->set('database.default', 'testing');
        $app['config']->set('database.connections.testing', [
            'driver' => 'sqlite',
            'database' => ':memory:',
        ]);
        $app['config']->set('repository.cache.enabled', false);
        $app['config']->set('ibrand.favorite', require __DIR__.'/../config/favorite.php');

        $models = [
	    'goods' => Goods::class,
	    'activity' => Activity::class,
    ];

	    $app['config']->set('ibrand.favorite.models', $models);
    }


    /**
     * @param \Illuminate\Foundation\Application $app
     *
     * @return array
     */
    protected function getPackageProviders($app)
    {
        return [
            \Prettus\Repository\Providers\RepositoryServiceProvider::class,
            \Orchestra\Database\ConsoleServiceProvider::class,
            \GuoJiangClub\Component\Favorite\FavoriteServiceProvider::class,
        ];
    }

    /**
     * seed some seedFavorite.
     */
    public function seedFavorite()
    {
        Favorite::create(['user_id' => 1, 'favoriteable_id' => 1, 'favoriteable_type' => 'goods']);
        Favorite::create(['user_id' => 1, 'favoriteable_id' => 2, 'favoriteable_type' => 'goods']);
        Favorite::create(['user_id' => 1, 'favoriteable_id' => 1, 'favoriteable_type' => 'activity']);

        Favorite::create(['user_id' => 2, 'favoriteable_id' => 1, 'favoriteable_type' => 'activity']);
        Favorite::create(['user_id' => 2, 'favoriteable_id' => 2, 'favoriteable_type' => 'activity']);
        Favorite::create(['user_id' => 2, 'favoriteable_id' => 3, 'favoriteable_type' => 'activity']);
    }

    /**
     * seed some seedGoods.
     */
    public function seedGoods()
    {
        Goods::create(['name' => 'goods1']);
	    Goods::create(['name' => 'goods2']);
    }

    /**
     * seed some seedActivitys.
     */
    public function seedActivitys()
    {
        Activity::create(['title' => 'activity1']);
        Activity::create(['title' => 'activity2']);
        Activity::create(['title' => 'activity3']);
    }
}
