# 果酱小店开源电商系统

果酱小店是一个免费的开源电子商务解决方案，使用 PHP 基于 Laravel 框架进行编写。基于模块化开发，易扩展，可基于个性需求快速实现定制化需求，功能符合国内电商绝大部分使用场景。

> 基于目前移动互联网的发展趋势，目前只提供 API 和 后端管理，不提供PC端商城。如有需要可理解项目架构后自行实现。

管理后台：[果酱小店管理后台]( https://demo-open-admin.ibrand.cc/admin)

后台账号密码请关注公众号 [PHP果酱](https://iyoyo.oss-cn-hangzhou.aliyuncs.com/post/wechat.jpg)  (微信号：phpjam) ，并回复关键词：password 获取。

扫码体验小程序：

![体验小店](https://iyoyo.oss-cn-hangzhou.aliyuncs.com/post/miniprogramcode/ec.qrcode.png)

## 更新计划
1. 9月份预计更新拼团，分销以及微页面功能
2. 10月预计更新砍价功能
3. 11月预计更新 swoole 版本

## 更新日志

目前 2.x 版本正在更新中，更新日志请见此[文档](./CHANGELOG.md) （2019-03-10 release 2.0.2）

## 功能清单

[开源版本功能清单](https://iyoyo.oss-cn-hangzhou.aliyuncs.com/post/iBrand%20%E5%BC%80%E6%BA%90%E7%94%B5%E5%95%86.png)

## 小程序

小程序端源码在此：[miniprogram-open-source](https://github.com/guojiangclub/miniprogram-ecommerce-open-source)

## 文档
- [Wiki](https://github.com/guojiangclub/ecommerce-open-api/wiki)
- [API 文档](https://guojiangclub/docs/api/)
- [配套小册](https://www.ibrand.cc/open/article)
- [设计稿](https://lanhuapp.com/url/v7Bfb)  密码： YgK7

## 特性

- 使用 Laravel + dingo/api 完成接口开发。
- 基于 Modules 或者 Package 开发模式，每个模块都是一个 Package，并且基础模块完成了单元测试，可复用性和可扩展性高。
- 基于 Laravel-admin 实现管理后台。
- 符合国内绝大部分B2C电商需求，同时可以轻易改造成 B2B、O2O、S2B2C模式。
- 完整的API文档+系统使用教程+业务说明文档。
- 配套的小程序解决方案+源码。
- docker 实现自动化部署、负载均衡、自动扩容等。（待更新）
- swoole 结合提高并发。（待更新）

## 贡献源码

该项目正在持续迭代更新中，如果你想参与到本项目中来，请提交 Pull Request !

如果你发现任何问题或者需求，请[提交ISSUE](https://github.com/guojiangclub/ecommerce-open-api/issues)

## 开源系列

[Laravel 社交电商](https://github.com/guojiangclub/ecommerce-open-api)    ·    [社交电商微信小程序](https://github.com/guojiangclub/miniprogram-ecommerce-open-source)    ·  [微信第三方平台](https://github.com/guojiangclub/laravel-wechat-platform)

## 社交账号

[Laravel-China](https://learnku.com/blog/ibrand)   ·  [掘金](https://juejin.im/user/5aab2cfa518825556534407a/posts)    ·  [segmentfault](https://segmentfault.com/u/guojiang_club)  

## 讨论交流

![联系我们](https://iyoyo.oss-cn-hangzhou.aliyuncs.com/post/qrcodenew.jpg)
