<?php
error_reporting(0);

function resize_image($img_src, $new_img_path, $new_width, $new_height)  
{  
    $img_info = @getimagesize($img_src);  
    if (!$img_info || $new_width < 1 || $new_height < 1 || empty($new_img_path)) {  
        return false;  
    }  
    if (strpos($img_info['mime'], 'jpeg') !== false) {  
        $pic_obj = imagecreatefromjpeg($img_src);  
    } else if (strpos($img_info['mime'], 'gif') !== false) {  
        $pic_obj = imagecreatefromgif($img_src);  
    } else if (strpos($img_info['mime'], 'png') !== false) {  
        $pic_obj = imagecreatefrompng($img_src);  
    } else {  
        return false;  
    }  
    $pic_width = imagesx($pic_obj);  
    $pic_height = imagesy($pic_obj);  
    if (function_exists("imagecopyresampled")) {  
        $new_img = imagecreatetruecolor($new_width,$new_height);  
        imagecopyresampled($new_img, $pic_obj, 0, 0, 0, 0, $new_width, $new_height, $pic_width, $pic_height);  
    } else {  
        $new_img = imagecreate($new_width, $new_height);  
        imagecopyresized($new_img, $pic_obj, 0, 0, 0, 0, $new_width, $new_height, $pic_width, $pic_height);  
    }  
    if (preg_match('~.([^.]+)$~', $new_img_path, $match)) {  
        $new_type = strtolower($match[1]);  
        switch ($new_type) {  
            case 'jpg':  
                imagejpeg($new_img, $new_img_path);  
                break;  
            case 'gif':  
                imagegif($new_img, $new_img_path);  
                break;  
            case 'png':  
                imagepng($new_img, $new_img_path);  
                break;  
            default:  
                imagejpeg($new_img, $new_img_path);  
        }  
    } else {  
        imagejpeg($new_img, $new_img_path);  
    }  
    imagedestroy($pic_obj);  
    imagedestroy($new_img);  
    return true;  
}  
 

$cc=date("Ymd");
$dir='./upload/'.$cc.'/';
if (!file_exists($dir)){
	mkdir ($dir,0777,true);	
}

    $picname = $_FILES['uploadfile']['name']; 
    $picsize = $_FILES['uploadfile']['size']; 
    if ($picname != "") { 
        if ($picsize > 1024000) { //限制上传大小 
            echo '{"status":0,"content":"图片不能超过1M"}';
            exit; 
        } 
		$info = pathinfo($picname);      
        $type = '.'.$info['extension']; //限制上传格式 
		$type = strtolower($type); //转换大小写
        if ($type != ".gif" && $type != ".jpg" && $type != ".png" && $type != ".jpeg") {
            echo '{"status":2,"content":"图片格式不对！"}';
            exit; 
        }
        $rand = rand(100, 999); 
        $pics = uniqid() . $type; //命名图片名称 
        //上传路径 
        $pic_path = $dir . $pics; 
        move_uploaded_file($_FILES['uploadfile']['tmp_name'], $pic_path); 
		$ret = resize_image($pic_path, $pic_path, '100', '80');  //压缩图片
    } 
    $size = round($picsize/1024,2); //转换成kb 	
	$pic_path="/upload/".$cc."/".$pics;	
    echo '{"status":1,"name":"'.$picname.'","url":"'.$pic_path.'","size":"'.$size.'","content":"上传成功"}';     
?>