# c9cms bakfile
# version:c9cms x1 
# time:2019-03-14 21:36:01
# http://www.c9cms.com
# ----------------------------------------


DROP TABLE IF EXISTS `c9_admin`;
CREATE TABLE `c9_admin` (
  `userid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(20) DEFAULT NULL,
  `password` varchar(32) DEFAULT NULL,
  `roleid` smallint(5) DEFAULT '0',
  `realname` varchar(50) NOT NULL DEFAULT '',
  `auth` text NOT NULL,
  `list_size` smallint(5) NOT NULL,
  `left_width` smallint(5) NOT NULL DEFAULT '150',
  PRIMARY KEY (`userid`),
  KEY `username` (`username`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `c9_admin` VALUES('1','admin','c3284d0f94606de1fd2af172aba15bf3','1','超级管理员','','10','150');

DROP TABLE IF EXISTS `c9_block`;
CREATE TABLE `c9_block` (
  `id` smallint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL,
  `name` varchar(50) NOT NULL,
  `content` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `c9_block` VALUES('1','1','首页简介','微莎狗狗工作室专业从事狗狗喂养研究工作，集狗粮配置，手工制作，狗粮零售，狗粮批发为一体。\r\n天然新鲜的食材运用科学的成分配比，多重口味，多重营养，让狗狗吃的香，吃的健康。丰富完整的钙\r\n\r\n磷比例，提供爱犬快速成长时期的骨骼以及牙齿所需要的营养元素。\r\n微莎狗狗工作室主要产品有幼犬狗粮，小型犬狗粮，中型犬狗粮，以及大型犬狗粮，说制作的手工狗粮\r\n\r\n有效的为广大养狗者解决爱犬的毛发暗淡，营养不良，泪痕严重，快速衰老，皮肤炎症等问题，微莎手\r\n\r\n工自制狗粮不仅仅是解决狗狗温饱的粮食更是狗狗营养均衡健康发育的“保健品”。');
INSERT INTO `c9_block` VALUES('2','2','首页简介图片','/data/upload/image/201903/a549bb82fa5199a0fea6031526682564.png');
INSERT INTO `c9_block` VALUES('3','2','狗狗百科banner','/data/upload/image/201903/e110aeb0c5bfbdd47ef396c0aa247a73.png');
INSERT INTO `c9_block` VALUES('4','2','产品中心banner','/data/upload/image/201903/d99d97cab0493c8cc60603473f0643e6.png');

DROP TABLE IF EXISTS `c9_category`;
CREATE TABLE `c9_category` (
  `catid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `typeid` tinyint(1) NOT NULL,
  `modelid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `parentid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `child` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `childids` varchar(255) NOT NULL,
  `catname` varchar(30) NOT NULL,
  `image` varchar(100) NOT NULL,
  `content` mediumtext NOT NULL,
  `seo_title` varchar(255) NOT NULL,
  `seo_keywords` varchar(255) NOT NULL,
  `seo_description` varchar(255) NOT NULL,
  `catdir` varchar(30) NOT NULL,
  `http` varchar(255) NOT NULL,
  `items` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `listorder` smallint(5) unsigned NOT NULL DEFAULT '0',
  `ismenu` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `ispost` smallint(2) NOT NULL,
  `verify` smallint(2) NOT NULL DEFAULT '0',
  `islook` smallint(2) NOT NULL,
  `listtpl` varchar(50) NOT NULL,
  `showtpl` varchar(50) NOT NULL,
  `pagetpl` varchar(50) NOT NULL,
  `pagesize` smallint(5) NOT NULL,
  PRIMARY KEY (`catid`),
  KEY `listorder` (`listorder`,`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

INSERT INTO `c9_category` VALUES('1','2','0','0','0','','关于我们','/data/upload/image/201903/5ea4433e5eafd9c1e6813e759f08b69f.png','&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	微莎狗狗工作室专业从事狗狗喂养研究工作，集狗粮配置，手工制作，狗粮零售，狗粮批发为一体。&lt;br /&gt;\r\n天然新鲜的食材运用科学的成分配比，多重口味，多重营养，让狗狗吃的香，吃的健康。丰富完整的钙磷比例，提供爱犬快速成长时期的骨骼以及牙齿所需要的营养元素。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	微莎狗狗工作室主要产品有幼犬狗粮，小型犬狗粮，中型犬狗粮，以及大型犬狗粮，说制作的手工狗粮有效的为广大养狗者解决爱犬的毛发暗淡，营养不良，泪痕严重，快速衰老，皮肤炎症等问题，微莎手工自制狗粮不仅仅是解决狗狗温饱的粮食更是狗狗营养均衡健康发育的“保健品”。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	微莎狗狗工作室网站于2019年3月10日正式上线，主要栏目有产品介绍，狗狗百科资讯（狗狗喂养知识，狗狗日常训练以及狗狗疾病的常识，还整理一些关于狗狗美丽搭配的知识，为广大养狗者提供一个全方位的养狗知识平台），网站和工作室开创性提出定制狗粮的设想，根据养狗的喜好和要求以及我们的建议让养狗者自己选择食材，我们来生产的定制狗粮的方式！\r\n&lt;/p&gt;','','','','about','','0','10','1','0','0','0','','','page.html','10');
INSERT INTO `c9_category` VALUES('2','2','0','0','0','','联系我们','/data/upload/image/201903/408b9a5987520fd329a1912c3922ad64.png','&lt;p&gt;\r\n	微莎狗狗工作室\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	网址：&lt;a href=&quot;http://www.wysha.cn&quot;&gt;http://www.wysha.cn&lt;/a&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	电话：&amp;nbsp;0517-83499820\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	手机：18552605560\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	地址：江苏省淮安市清河区经济开发区福州路清枫花苑西区\r\n&lt;/p&gt;','','','','contact','','0','4','1','0','0','0','','','page.html','10');
INSERT INTO `c9_category` VALUES('3','2','0','0','0','','品质保证','/data/upload/image/201903/c681e61f9f9dd0e82bfe93c7ee33df9e.png','&lt;p&gt;\r\n	一.食材的选择\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	精选新鲜食材，拒绝冷冻产品！\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	二.工艺的精湛\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	绝无任何添加剂，在防腐方面微莎工作室郑重承诺绝不使用任何防腐剂，我们采用维E来提供狗粮的保质期。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	三.拒绝使用粉类成品以及杂质肉\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	骨粉选择用骨头工作室自己研磨，肉类选用精品肉类，绝不采用所谓的鸡架子！\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	四.膨化致熟，颗粒模具成型\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	我们采用的专业狗粮机器来保证食材手工选配后提高产量，绝非个人采用小型牛羊饲料颗粒机，饲料颗粒机没有经过高温高压所生产的颗粒是生的\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	五.逗宠奖励食品以及饼干制作\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	逗宠奖励食品采用高温蒸煮，干果机脱水烘干。饼干制作采用纯手工烤箱制作\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	综上所述，我们目标采用手工自制方式科学的成分配比，多重口味，多重营养，让狗狗吃的香，吃的健康！\r\n&lt;/p&gt;','','','','quality','','0','7','1','0','0','0','','','page.html','10');
INSERT INTO `c9_category` VALUES('4','2','0','0','0','','定制狗粮','/data/upload/image/201903/ee653ce7a85f2aac3cc90610cd54ca49.png','','','','','customized','','0','6','1','0','0','0','','','form.html','10');
INSERT INTO `c9_category` VALUES('5','1','1','0','1','6,9,7,8,13,14,','狗狗百科','/static/picture/cc04718c8e3937bfa754f619f0d68593.jpg','','','','','news','','19','8','1','0','0','0','list_news.html','show_news.html','','10');
INSERT INTO `c9_category` VALUES('6','1','1','5','0','','微莎动态','','','','','','newsws','','2','4','1','0','0','0','list_news.html','show_news.html','','10');
INSERT INTO `c9_category` VALUES('7','1','1','5','0','','狗狗喂养','','','','','','newswy','','3','2','1','0','0','0','list_news.html','show_news.html','','10');
INSERT INTO `c9_category` VALUES('8','1','1','5','0','','狗狗训练','','','','','','newsxl','','4','1','1','0','0','0','list_news.html','show_news.html','','10');
INSERT INTO `c9_category` VALUES('9','1','1','5','0','','宠物资讯','','','','','','newszx','','4','3','1','0','0','0','list_news.html','show_news.html','','10');
INSERT INTO `c9_category` VALUES('10','1','2','0','1','11,12,','产品介绍','','','','','','product','','3','9','1','0','0','0','list_product.html','show_product.html','','10');
INSERT INTO `c9_category` VALUES('11','1','2','10','0','','狗粮','','','','','','productgl','','2','2','1','0','0','0','list_product.html','show_product.html','','10');
INSERT INTO `c9_category` VALUES('12','1','2','10','0','','逗宠','','','','','','productdc','','1','1','1','0','0','0','list_product.html','show_product.html','','10');
INSERT INTO `c9_category` VALUES('13','1','1','5','0','','狗狗疾病','','','','','','newsjb','','5','0','1','0','0','0','list_news.html','show_news.html','','10');
INSERT INTO `c9_category` VALUES('14','1','1','5','0','','狗狗美搭','','','','','','newsmd','','1','0','1','0','0','0','list_news.html','show_news.html','','10');
INSERT INTO `c9_category` VALUES('15','2','0','0','0','','地图','','','','','','map','','0','0','0','0','0','0','','','map.html','10');

DROP TABLE IF EXISTS `c9_content`;
CREATE TABLE `c9_content` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `catid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `modelid` smallint(5) NOT NULL,
  `title` varchar(80) NOT NULL DEFAULT '',
  `thumb` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL,
  `listorder` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '1',
  `hits` smallint(5) unsigned NOT NULL DEFAULT '0',
  `username` char(20) NOT NULL,
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `catid` (`catid`,`listorder`,`time`),
  KEY `time` (`catid`,`time`),
  KEY `status` (`catid`,`status`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;

INSERT INTO `c9_content` VALUES('10','6','1','微莎狗狗工作室官方网站上线','','','微莎狗狗工作室官方网站上线\r\n\r\n\r\n	网址为：http://www.wysha.cn\r\n\r\n\r\n	为自适应屏幕网站，为广大狗狗主人们提供一个多平台都能有良好视觉感受的网站！','0','1','8','admin','1552221086');
INSERT INTO `c9_content` VALUES('11','8','1','狗狗喜欢乱叫怎么办？微莎为您支招：六招给你一个安静的狗狗','/data/upload/image/201903/28c7161c763e9fe4908119e2e17bd4f0.jpg','','\r\n	狗狗喜欢吵闹是一个比较常见的问题了，针对于这个问题，解决方法其实也是比较多的，那么今天微莎狗狗工作室的小编就来告诉大家六个方式，让狗狗快速安静下来。\r\n\r\n\r\n	\r\n\r\n\r\n	方法一，奖励\r\n\r\n\r\n	其实是一种训练手段，就是说','0','3','6','admin','1552307686');
INSERT INTO `c9_content` VALUES('12','9','1','关于狗狗这六点常识，如果你不知道，就真的是白养狗了！','/data/upload/image/201903/2ad967e1f1010bbd09466b3be03ccb53.jpg','','\r\n	不少人都有在养狗吗？但是关于狗狗自身的一些基本常识，你们又知道多少呢？今天要来说说关于狗狗自身的一些小常识，看下你们自己知道多少呢？\r\n\r\n\r\n	\r\n\r\n\r\n	第一、狗狗为什么和主人越来越像？\r\n\r\n\r\n	相处久了，狗狗会越来越','0','1','15','admin','1552308066');
INSERT INTO `c9_content` VALUES('13','7','1','作为一个合格的主人饲养泰迪需要注意这几点','/data/upload/image/201903/d865b61a9b7dc8118de77bd85e2f0226.jpg','','在众多的宠物种类中，娇小可爱而又聪明活泼的泰迪，成为很多家庭的新宠，在宠物市场的销量也遥遥领先。其实泰迪只是贵宾犬的一种美容方式，因为它的长相酷似泰迪熊，所以很多人亲切地称它泰迪，在市场上购买泰迪的人','0','3','4','admin','1552372143');
INSERT INTO `c9_content` VALUES('14','8','1','如何强化训练让幼年的腊肠犬成才','','','和人类一样成年后的腊肠犬一切生活习惯都是从小养成的，如果饲主一味的保护腊肠犬而忽视训练这件事情，这样它以后的坏毛病会越来越多，时间久了腊肠犬会成为一只人见人厌的狗狗了，因此我们要适当的训练它，这样才能','0','1','8','admin','1552372268');
INSERT INTO `c9_content` VALUES('15','7','1','比熊犬在生活中哪些食物是不可缺少的','/data/upload/image/201903/6b4cbf10c8caca9602e722f7d3c59de2.jpg','','\r\n	\r\n\r\n\r\n	为了让比熊犬的身体健康成长，主人们总是会给它准备很多的食物，不同的食物给比熊犬带来的影响都是不同的，想要它正常发育，我们就要认真的照顾比熊犬，比熊犬的身体每天要消耗很多的能量，因此为了比熊犬的身','0','3','3','admin','1552433320');
INSERT INTO `c9_content` VALUES('16','13','1','萨摩耶厌食原因，萨摩耶在食物面前提不起兴趣的四大原因','/data/upload/image/201903/84105663c5554b6dee6f2946f15621a3.jpg','','\r\n	\r\n\r\n\r\n	狗主人在平时对萨摩耶的身体情况很重视，平时萨摩耶的食欲很好，但是最近萨摩耶会出现不吃东西的情况，萨摩耶的身体每天要消耗很多的能量，如果萨摩耶没有得到及时的补充能量，这会对萨摩耶的身体健康产生不利','0','3','13','admin','1552433508');
INSERT INTO `c9_content` VALUES('17','7','1','饲养藏獒需要注意哪些常识？','','','\r\n	藏獒的身体需要养狗人科学的喂养，很多养狗人面对饲养藏獒的问题上，总是不能很好的抓住饲养方法，这样很容易导致藏獒的身体出现问题，随着藏獒与我们生活时间越来越长，我们对它的重视程度也越深，不想要它的身体','0','1','7','admin','1552465284');
INSERT INTO `c9_content` VALUES('18','14','1','时尚狗主人给萨摩耶美容造型的方法','/data/upload/image/201903/e028f088fbdf29c040fa1d6ba5874444.jpg','','\r\n	萨摩耶犬本身是一种长毛犬，在日常护理当中，如果家长们给它适当的修饰，那么它的造型是非常漂亮的。微莎狗狗工作室将跟所有的家长们来分享一下萨摩耶犬美容造型方面的小知识。\r\n\r\n\r\n	\r\n\r\n\r\n	在给摩耶犬做造型的时候，','0','3','5','admin','1552469747');
INSERT INTO `c9_content` VALUES('19','13','1','宠物狗有臭味或者异味作为狗主人应该怎么办？','/data/upload/image/201903/cbe0cbd80e54d46c4ecc26f74206f55c.jpeg','','\r\n	随着人们生活的越来越好，不少人已经不再局限于物质还是更加注重在精神层面上了，宠物开始走进人们的生活中，成为人们可靠而又贴心的伴侣。而狗狗无疑是众多宠物中最受欢迎的一个品类了。今天小编不是发一些可爱的','0','3','14','admin','1552546717');
INSERT INTO `c9_content` VALUES('20','11','2','牛肉狗粮通用型-手工湿粮','/data/upload/image/201903/762919e2de7785e85b5847c9566f4213.jpg','','\r\n	&amp;nbsp;\r\n\r\n\r\n	牛肉&amp;nbsp;提供能量，免疫力提升\r\n天然谷物将多种粮食谷物混合食用或将谷物与动物性食物混合食用以便提高谷类蛋白质的生理价值\r\n维生素帮助消化，促进营养吸收，保护肠道菌群\r\n鸡蛋健康活力，高蛋白富含','0','3','7','admin','1552561517');
INSERT INTO `c9_content` VALUES('21','11','2','鸡肉狗粮通用型-手工湿粮','/data/upload/image/201903/956660b68486fe33ca702bdc1853f783.jpg','','\r\n	&amp;nbsp;\r\n\r\n\r\n	鸡肉&amp;nbsp;提供能量，免疫力提升，利于消化\r\n天然谷物将多种粮食谷物混合食用或将谷物与动物性食物混合食用以便提高谷类蛋白质的生理价值\r\n维生素帮助消化，促进营养吸收，保护肠道菌群\r\n鸡蛋健康活力，','0','3','6','admin','1552561652');
INSERT INTO `c9_content` VALUES('22','8','1','宠物狗狗一出门就叫不回来怎么办','/data/upload/image/201903/91684ff4b1428ccb0770431b830ec4f2.png','','\r\n	\r\n\r\n\r\n	狗狗出门叫不回来怎么办？这是很多养狗人无奈，特别狗狗对外界好奇心重，完全把狗主人放在一边了。无乱狗主人怎么叫也不回。所以，狗狗叫回训练是必要的。\r\n\r\n\r\n	1、狗狗出门叫不回来形成原因\r\n\r\n\r\n	狗从小被狗主人','0','3','6','admin','1552562179');
INSERT INTO `c9_content` VALUES('23','8','1','宠物狗怎么训练才听懂人话','/data/upload/image/201903/4ef6b87667d01cce98e41968f5f49de9.jpg','','\r\n	\r\n\r\n\r\n	&amp;nbsp;\r\n\r\n\r\n	宠物狗怎么训练才听懂人话？其实养狗的问题主要是观念问题，城市养宠物犬其实也是一种奢侈消费，是衣食住行之外的消费，可养可不养，养了之后狗狗的吃喝拉撒就变成了刚需消费，你想继续养好，还得把','0','3','7','admin','1552562585');
INSERT INTO `c9_content` VALUES('24','9','1','事实证明养狗是可以提高人的幸福感','/data/upload/image/201903/b813ac5a8c2b9b184719b30400b4558f.jpg','','\r\n	养狗真的可以提高人的幸福感吗？从心理学的角度来看，如果我们在家里饲养小动物，实际过程中可能会为你增加一些小麻烦，但确实是可以增加人与人之间的幸福感指数的，特别是人类最忠诚的朋友——狗狗。那下面我们就','0','1','8','admin','1552562820');
INSERT INTO `c9_content` VALUES('25','9','1','家中有小孩子可以养狗吗？盘点哪些狗狗可以陪伴孩子玩耍','/data/upload/image/201903/8a5d041dbb4c6afaa75c41af3101ce6c.jpg','','\r\n	目前社会现在大多数的家庭都是独生子女，很多家长考虑买只狗狗来陪伴孩子一起成长，要知道从小喂养狗狗的孩子要比没有喂养宠物的孩子更加优秀，喂养狗狗可以给孩子带来很多好处，现在我们具体了解下哪些狗狗适合陪','0','1','6','admin','1552562982');
INSERT INTO `c9_content` VALUES('26','9','1','你知道狗狗是通过什么方式来辨认自己主人的','/data/upload/image/201903/9deb937ab6cd9b700be6297cd4516ce7.jpg','','\r\n	很多人都知道狗狗会认路也会识别谁是自己的主人，可是你知道狗狗是通过什么方式来辨认自己主人的？相信这个问题大家一定很好奇，有养狗的朋友们应该都知道，当我们每天下班回家时候或者是长时间外出没有见到主人，','0','1','5','admin','1552563095');
INSERT INTO `c9_content` VALUES('27','6','1','微莎狗狗工作室新进设备-研磨机','/data/upload/image/201903/0c80c08d5190911c7e9a36a927dcd2ec.jpg','','\r\n	微莎狗狗工作室新进设备绝不采用骨粉成品材料研磨机\r\n\r\n\r\n	研磨机主要作用：研磨骨头成粉，中草药研磨成粉（主要是金银草，用于解决狗狗泪痕问题。海藻，用于美毛。）\r\n\r\n\r\n	\r\n','0','1','8','admin','1552563421');
INSERT INTO `c9_content` VALUES('28','13','1','铲屎官们要注意了：警惕狗狗也会得糖尿病','/data/upload/image/201903/d13949c0379ab8dabcb07e4f6d4423dd.jpg','','\r\n	宠物狗会得糖尿病吗?答案是肯定的，其实人和狗是动物中相当容易得糖尿病的种类，虽然一般人的观念，认为狗狗肥胖才是狗狗的糖尿病的真正元凶，要知道有时体质的差异也会造成，比如胰岛素缺乏症。\r\n\r\n\r\n	\r\n\r\n\r\n	宠物犬胰','0','1','7','admin','1552564443');
INSERT INTO `c9_content` VALUES('29','12','2','狗狗零食牛肉块','/data/upload/image/201903/74693c376bd2cb52c2a7d0c48dd18141.jpg','','狗狗零食牛肉块，采用新鲜牛肉切块蒸煮致熟，干果机脱水烘干！','0','3','155','admin','1552564918');
INSERT INTO `c9_content` VALUES('30','13','1','宠物主人必须知道犬细小病毒的常识','/data/upload/image/201903/dd05ec6494d3fd15e9a748d7b853354c.jpg','','\r\n	一、关于“犬细小病毒”\r\n\r\n\r\n	1.犬细小病毒概念\r\n\r\n\r\n	犬细小病毒(CPV)属细小病毒科。细小病毒科是已发现的真病毒中个体最小﹑结构最简单的DNA病毒。犬细小病毒感染是20世纪70年代发现的一种烈性传染病，临床表现为急性','0','1','6','admin','1552565584');
INSERT INTO `c9_content` VALUES('31','13','1','狗狗嘴巴臭怎么办','','','要是你家狗狗出现牙黄、发出异味的时候就要帮它祛口臭了，建议每天帮狗狗刷下牙，还有平常给它啃下大骨头或者购买一些有助磨牙的狗零食（推荐使用微莎狗狗工作室手工自制的鸡肉干）给它吃，这样就能帮助狗狗祛口臭、','0','1','7','admin','1552565768');

DROP TABLE IF EXISTS `c9_content_news`;
CREATE TABLE `c9_content_news` (
  `id` mediumint(8) NOT NULL,
  `catid` smallint(5) NOT NULL,
  `content` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `catid` (`catid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `c9_content_news` VALUES('10','6','&lt;p&gt;\r\n	微莎狗狗工作室官方网站上线\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	网址为：http://www.wysha.cn\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	为自适应屏幕网站，为广大狗狗主人们提供一个多平台都能有良好视觉感受的网站！\r\n&lt;/p&gt;');
INSERT INTO `c9_content_news` VALUES('11','8','&lt;p&gt;\r\n	狗狗喜欢吵闹是一个比较常见的问题了，针对于这个问题，解决方法其实也是比较多的，那么今天微莎狗狗工作室的小编就来告诉大家六个方式，让狗狗快速安静下来。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;img src=&quot;/data/upload/image/201903/28c7161c763e9fe4908119e2e17bd4f0.jpg&quot; alt=&quot;狗狗喜欢乱叫怎么办？六招给你一个安静的狗狗&quot; title=&quot;狗狗喜欢乱叫怎么办？六招给你一个安静的狗狗&quot; style=&quot;height:auto;&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;strong&gt;方法一，奖励&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	其实是一种训练手段，就是说在狗狗乱叫的时候，主人需要告诉它们闭嘴，一旦狗狗停下来，主人就需要立刻给予它们奖励，奖励可以是零食也可以是玩具。久了以后狗狗在听到闭嘴的口令之后就会立刻安静下来。但是就要注意训练是需要花时间的，千万不能两天打鱼三天晒网。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;strong&gt;方法二，惩罚&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	并不是说体罚，主人可以准备一个报纸卷，或者小喷壶。在狗狗叫个不停的时候拿报纸卷轻敲它，或者拿小喷壶对它们喷一下水，对于狗狗来说，这个方法可以算得上是屡试不爽。因为主人只要运用这两个方法对它们稍加惩罚，它们就会立刻停止后叫。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;img src=&quot;/data/upload/image/201903/30cea50a0c2f5f497d28f342bc2c86f1.jpg&quot; alt=&quot;狗狗喜欢乱叫怎么办？六招给你一个安静的狗狗&quot; title=&quot;狗狗喜欢乱叫怎么办？六招给你一个安静的狗狗&quot; style=&quot;height:auto;&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;strong&gt;方法三，大量运动&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	在某些情况下，狗狗乱叫就是因为精力太过旺盛，所以主人可以带着它们出门多跑动，让狗狗消耗掉那些多余的体力。这样不仅可以满足狗狗身体对于运动的需求，也可以很好的防止它们乱叫。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;strong&gt;方法四，无视&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	狗狗叫有时候只是想引起主人的注意，此时如果你转身离开，不闻不问，狗狗就会自讨没趣的停止吼叫了。但是注意，还在训练期的狗狗这招只能在白天使用，如果是晚上，不仅会吵到自己还会吵到邻居。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;strong&gt;方法五，转移注意力&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	很多狗狗之所以乱叫是因为无聊，所以主人可以在狗狗乱叫的时候给它们玩具或者骨头，只要将它们的注意力成功转移了，就不会再听到叫声了。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;img src=&quot;/data/upload/image/201903/549e5e214f976d335b91e14f9f2c0ecd.jpg&quot; alt=&quot;狗狗喜欢乱叫怎么办？六招给你一个安静的狗狗&quot; title=&quot;狗狗喜欢乱叫怎么办？六招给你一个安静的狗狗&quot; style=&quot;height:auto;&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;strong&gt;方法六，噪音刺激&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	狗狗的听觉特别灵敏，较强的噪音对它们来说可能就无法忍受，所以在狗狗狂叫不止的时候，主人可以制造一些更强烈的噪音刺激狗狗几次基本就可以制止吼叫行为了。\r\n&lt;/p&gt;');
INSERT INTO `c9_content_news` VALUES('12','9','&lt;p&gt;\r\n	不少人都有在养狗吗？但是关于狗狗自身的一些基本常识，你们又知道多少呢？今天要来说说关于狗狗自身的一些小常识，看下你们自己知道多少呢？&lt;img src=&quot;/data/upload/image/201903/2ad967e1f1010bbd09466b3be03ccb53.jpg&quot; alt=&quot;&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	第一、狗狗为什么和主人越来越像？\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	相处久了，狗狗会越来越像主人，狗狗其实和人一样，在成长的过程中会不断的学习，和主人相处的时间长，所以有些时候会模仿主人的举止和神态，在国外有些狗狗甚至和主人的长相十分相似，性格也会有些相同，这都是长时间养宠物造成的。\r\n&lt;/p&gt;\r\n&lt;img src=&quot;/data/upload/image/201903/4d96de46409222f33428109a39ac0f21.jpg&quot; alt=&quot;&quot; /&gt; \r\n&lt;p&gt;\r\n	第二、狗狗为什么总能找到回家的路？\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	狗狗一般是不会迷路的，它有着自己独特的记路方式，它们可以听到部分超声波，还能感受到地球磁场，还有超级厉害的嗅觉。这使得它们有时候能穿越很长的路程找到家的方向。现在很多城市中丢的狗狗，好多都会被别人捡到，以至于狗狗没法自己找到回家的路了。\r\n&lt;/p&gt;\r\n&lt;img src=&quot;/data/upload/image/201903/344cd1ac46c434498264edb6ccee4fc5.jpg&quot; alt=&quot;&quot; /&gt;\r\n&lt;p&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	第三、狗狗不运动的后果\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	其实再怎么懒的狗狗，每天都是需要一定的运动的，长期不溜的狗狗没有一定的运动量，身体本身免疫力会有所下降，狗狗的毛发等方面也是会有所影响，而且在性格上也会变得胆小而且过分神经质，无论是对身体还是心理也是有一定的影响的。所以一定要每天带狗狗外出运动遛弯，适当训练和奖励小零食，确保狗狗每天有适合自己的运动量。\r\n&lt;/p&gt;\r\n&lt;img src=&quot;/data/upload/image/201903/ee2af381c78f99566a859decd251e844.jpg&quot; alt=&quot;&quot; /&gt; \r\n&lt;p&gt;\r\n	第四、狗狗可以吃米饭吗？\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	严格来说，狗狗是可以吃米饭的，但是如果只单单给狗狗吃白米饭，那对狗狗的身体健康也有影响。白米饭毕竟与专业的狗粮不一样，狗粮是根据狗狗成长对营养的需求专业研制而成的，能满足狗狗成长的需求。所以，如果给长期给狗狗吃米饭，很可能会造成狗狗某些营养元素缺乏而引发一些问题。所以主食最好还是喂食狗狗一些专业的狗粮吧。\r\n&lt;/p&gt;\r\n&lt;img src=&quot;/data/upload/image/201903/b21a8722a58166c5011431b982bdf2b1.jpg&quot; alt=&quot;&quot; /&gt; \r\n&lt;p&gt;\r\n	第五、狗狗便便为什么会转圈？\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	狗狗在大小便的时候，总是会在选好的地方绕几圈，非常有仪式感，即使憋的不行了也要坚持这样的动作。原因竟然是它们可以感知地磁场，寻找磁场方向，从而避免切割磁感线产生感应电流引发不必要的自然灾害。\r\n&lt;/p&gt;\r\n&lt;img src=&quot;/data/upload/image/201903/53205db620cf0e1744d6c3662ab2802e.jpg&quot; alt=&quot;&quot; /&gt; \r\n&lt;p&gt;\r\n	第六、狗狗有分左右吗？\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	狗狗也分左撇子和右撇子的，入过你认真观察狗狗的话，你就会发现狗狗也是分左右撇子的。最简单的观察方法就是看狗狗起身后先迈那边的腿，或者平时看狗狗经常用那只爪子，就可以清楚地判断出狗狗撇那边。这个发现后可以根据狗狗的撇的程度来教它一些握手、打招呼的动作。\r\n&lt;/p&gt;\r\n&lt;img src=&quot;/data/upload/image/201903/16baa1653b85a36252703a354f72c0c9.jpg&quot; alt=&quot;&quot; /&gt; \r\n&lt;p&gt;\r\n	狗狗饮食注意事项：\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	其实无论是饲养什么狗狗，我们都应该要好好照顾它们，给予充足的营养。小编这里给大家推荐一些对应的产品，推荐微莎狗狗工作室自制的狗粮，为什么推荐这个狗粮，是小编养狗多年来，更换了多种狗粮之后，最后一直给家里的狗狗一直喂食，馋不腻狗粮提出：不仅是饱，更关注健康的理念，狗粮采用的是鸡肉，牛肉粉碎，并非肉粉，营养放心，值得推荐！\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;');
INSERT INTO `c9_content_news` VALUES('13','7','&lt;span style=&quot;color:#333333;font-family:微软雅黑;font-size:16px;background-color:#FFFFFF;&quot;&gt;在众多的宠物种类中，娇小可爱而又聪明活泼的泰迪，成为很多家庭的新宠，在宠物市场的销量也遥遥领先。其实泰迪只是贵宾犬的一种美容方式，因为它的长相酷似泰迪熊，所以很多人亲切地称它泰迪，在市场上购买泰迪的人绝不在少数，又以女性消费者居多。作为家庭的一员，饲养泰迪就需要我们尽心尽力啦，今天我们就一起来了解下饲养泰迪需要注意哪些事项吧！&amp;nbsp;&lt;/span&gt;&lt;span id=&quot;att_5491532&quot; style=&quot;font-family:微软雅黑;color:#333333;font-size:16px;background-color:#FFFFFF;&quot;&gt;&lt;br /&gt;\r\n&lt;img src=&quot;/data/upload/image/201903/d865b61a9b7dc8118de77bd85e2f0226.jpg&quot; alt=&quot;饲养泰迪注意这几点 你会成为更好的主人5&quot; width=&quot;600px&quot; height=&quot;391&quot; style=&quot;width:600px;height:300px;&quot; /&gt;&lt;/span&gt;&lt;span style=&quot;color:#333333;font-family:微软雅黑;font-size:16px;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;br /&gt;\r\n&lt;span style=&quot;color:#333333;font-family:微软雅黑;font-size:16px;background-color:#FFFFFF;&quot;&gt; 首先，泰迪的被毛比较密集且丰厚，因而我们在喂养泰迪的时候一定要注意给它补充足量的蛋白质，新鲜的肉类食物每天不能少于150g，当然也不能只喂肉，应当搭配一定的素食或者饼干来调和，这样能够保证泰迪拥有健康的体魄。&lt;/span&gt;&lt;br /&gt;\r\n&lt;span style=&quot;color:#333333;font-family:微软雅黑;font-size:16px;background-color:#FFFFFF;&quot;&gt; 其次，护理工作一定要做到位，作为犬类中的颜值担当，对贵宾的毛发梳理也是身为主人的我们每天要做的，建议大家用软钢丝刷给贵宾刷毛，每月给它进行一次修剪并且定期给它洗澡，别小看这些细节护理，泰迪很贪玩，它自己又不懂清理，只有辛苦我们咯。&lt;/span&gt;&lt;br /&gt;\r\n&lt;span style=&quot;color:#333333;font-family:微软雅黑;font-size:16px;background-color:#FFFFFF;&quot;&gt; 再次，泰迪后躯的毛也要经常修剪，还有一个非常容易被忽视的问题，那就是泰迪的耳道内也会长毛，我们也要定期小心地给它清理掉哦，不然很容易滋生细菌，从而带来耳炎等问题，那可就麻烦咯。&lt;/span&gt;&lt;br /&gt;\r\n&lt;span style=&quot;color:#333333;font-family:微软雅黑;font-size:16px;background-color:#FFFFFF;&quot;&gt; 最后，泰迪生性活泼爱动，决不能一直放在笼子里观赏，要经常放它出来跑跑，也要让它结交新的伙伴，这样有助于培养它的性格，对它的成长也会大有好处。下班后、周末时，多带泰迪出去遛遛，当然一定要牵好狗绳，防止其受到刺激咬人。&amp;nbsp;&lt;/span&gt;&lt;span id=&quot;att_5491533&quot; style=&quot;font-family:微软雅黑;color:#333333;font-size:16px;background-color:#FFFFFF;&quot;&gt;&lt;br /&gt;\r\n&lt;img src=&quot;/data/upload/image/201903/b3f8721514da843ba01978527422fdf7.jpg&quot; alt=&quot;饲养泰迪注意这几点 你会成为更好的主人6&quot; width=&quot;600px&quot; height=&quot;402&quot; style=&quot;width:600px;height:300px;&quot; /&gt;&lt;/span&gt;&lt;span style=&quot;color:#333333;font-family:微软雅黑;font-size:16px;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;br /&gt;\r\n&lt;span style=&quot;color:#333333;font-family:微软雅黑;font-size:16px;background-color:#FFFFFF;&quot;&gt; 总之，随着宠物市场的发展壮大，越来越多的人喜欢养宠物，一旦我们也加入养宠物的大军，就一定要对宠物负责，照顾好它，毕竟是我们家庭中的一员，它给我们带来了快乐，也该享受我们的温柔以待，机智聪敏的泰迪很容易训练，只要你耐得住性子，它会给你带来很多惊喜哦。&lt;/span&gt;');
INSERT INTO `c9_content_news` VALUES('14','8','和人类一样成年后的腊肠犬一切生活习惯都是从小养成的，如果饲主一味的保护腊肠犬而忽视训练这件事情，这样它以后的坏毛病会越来越多，时间久了腊肠犬会成为一只人见人厌的狗狗了，因此我们要适当的训练它，这样才能保证腊肠犬纠正坏毛病，训练腊肠犬需要方法，我们要认真的训练，如果方法不当会直接影响着腊肠犬的以后成长，因此我们要慎重。&lt;br /&gt;\r\n幼腊肠犬训练 幼腊肠犬训练是指对3-6月龄的腊肠犬进行训练。这个阶段的训练是整个服从性训练的基础，充分了解有关训练的基本知识熟练掌握这套训练方法，把整个训练的模式框图牢牢记在心中再去训练，将会收到事半功倍的效果，并将会全面理解为何要花如此大的精力和时间去训练幼腊肠犬。&lt;br /&gt;\r\n然而训练这么小的幼腊肠犬，需要有充分的耐心。训练对幼腊肠犬来说将是件趣事，但这与在家里和腊肠犬玩耍是有区别的。用一种能让腊肠犬理解的方式来训腊肠犬需要我们付出极大的努力，训练的思路必须清晰明了。整个训练过程中，要尽可能使用赞扬和鼓励，避免批评 与消极的纠正。带来固执偏激，低落情绪或其他错误的想法去训腊肠犬，都会导致训练的失败，要让腊肠犬轻松愉快地学习。&lt;br /&gt;\r\n训练方法 幼腊肠犬训练是一项充满爱心的劳动。在训练中，要有耐心、遵守训练规则，具有奉献精神，而且必须精力充沛地投入。 不要在疲劳，烦燥时训练腊肠犬，要在冷静和身心愉快的状态下训腊肠犬。不要在有压力的情况下进行训练，如感觉有压力时要停止训练，可先与腊肠犬玩耍一会儿。而且不能用愤怒的音调粗鲁无理地恐吓腊肠犬。&lt;br /&gt;\r\n必须记住，在训练中不能用力推腊肠犬、拉腊肠犬，避免用重复唠叨的语言。开始训练时，腊肠犬可能会心不在焉、不予合作，但只要耐心调教，经过一定时间之后，腊肠犬最后是会合作的。&amp;nbsp;&lt;br /&gt;\r\n年幼很调皮，适当的训练可以帮助它纠正坏习惯，训练腊肠犬不是一件很容易的事情，因此我们要做好心理准备，训练期间，不只需要腊肠犬的努力，我们在训练期间也要做好自身的事情，这样腊肠犬才能更有兴趣的喜欢训练，只要我们认真训练，腊肠犬变优秀时刻离我们不远了。');
INSERT INTO `c9_content_news` VALUES('15','7','&lt;p&gt;\r\n	&lt;img src=&quot;/data/upload/image/201903/6b4cbf10c8caca9602e722f7d3c59de2.jpg&quot; alt=&quot;&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	为了让比熊犬的身体健康成长，主人们总是会给它准备很多的食物，不同的食物给比熊犬带来的影响都是不同的，想要它正常发育，我们就要认真的照顾比熊犬，比熊犬的身体每天要消耗很多的能量，因此为了比熊犬的身体营养需要，我们给它挑选食物要按照科学方法，我们在生活中也要知道哪些食物对比熊犬身体有好处，饲养比熊犬不容易，我们要认真照顾它。\r\n&lt;/p&gt;\r\n1、大蒜&lt;br /&gt;\r\n配餐方法：将大蒜捣成蒜泥，放十五分钟后加入食物中。大蒜素与空气接触十五分钟后才能发挥其作用。&lt;br /&gt;\r\n益处：高蛋白质，丰富维生素，可以促进皮毛生长并减少皮屑预防皮肤病。&lt;br /&gt;\r\n2、蛋黄&lt;br /&gt;\r\n配餐方法：将鸡蛋煮熟后，取出一半蛋黄捣碎加入食物中&lt;br /&gt;\r\n益处：使毛发变的光泽&lt;br /&gt;\r\n3、胡萝卜&lt;br /&gt;\r\n配餐方法：切丁煮熟后拌入食物中&lt;br /&gt;\r\n益处：改善毛色，补充胡萝卜素，明目&lt;br /&gt;\r\n4、土豆&lt;br /&gt;\r\n配餐方法：切丝或切丁，煮熟后拌入食物中&lt;br /&gt;\r\n益处：含有丰富蛋白质，营养价值高&lt;br /&gt;\r\n5、燕麦片&lt;br /&gt;\r\n配餐方法：开水煮或者泡&lt;br /&gt;\r\n益处：含有丰富矿物质和维生素，能清洁肠道&lt;br /&gt;\r\n不同的食物给纯种比熊带来的影响也是不同的，因此我们在给比熊犬准备食物时要注意含有的营养物质，这样才能保证它健康成长，食物种类很多，但给比熊犬带来好处的却很少，因此我们不要随意给比熊犬搭配食物，稍不注意就会给比熊犬带来伤害，为了比熊犬的成长，我们要好好的照顾它。');
INSERT INTO `c9_content_news` VALUES('16','13','&lt;p&gt;\r\n	&lt;img src=&quot;/data/upload/image/201903/84105663c5554b6dee6f2946f15621a3.jpg&quot; alt=&quot;&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	狗主人在平时对萨摩耶的身体情况很重视，平时萨摩耶的食欲很好，但是最近萨摩耶会出现不吃东西的情况，萨摩耶的身体每天要消耗很多的能量，如果萨摩耶没有得到及时的补充能量，这会对萨摩耶的身体健康产生不利的影响，想要萨摩耶健康成长，我们就要及时的查出萨摩耶不进食的原因，这样我们才能对症下药，饲养萨摩耶不容易，发现它有什么异常时，我们要及时的解决。\r\n&lt;/p&gt;\r\n原因一：萨摩耶生病。&lt;br /&gt;\r\n解决方法：先观察萨摩耶是否生病，看看除了不吃东西还有没有其他症状。如果萨摩耶长时间不进食有可能感染了细菌性肠道炎或者其他疾病。这种情况就不要私自给萨摩耶喂药，并且应该尽早带萨摩耶去看医生。&lt;br /&gt;\r\n原因二：食物不合萨摩耶胃口&lt;br /&gt;\r\n解决方法：一些萨摩耶的饮食习惯不会不同，例如有的要吃家庭配餐，萨摩耶的要吃瘦肉鸡蛋等比较讲究的食物，所以要看你养的是什么狗，要了解清楚萨摩耶的饮食习惯，不是所有萨摩耶都可以随意的用狗粮喂食。&lt;br /&gt;\r\n原因三：夏季天气炎热，萨摩耶的肠胃蠕动比较缓慢，导致胃口不好。&lt;br /&gt;\r\n解决方法：此类属于正常情况，可适当让萨摩耶喝点板蓝根，但是不可以过多。&lt;br /&gt;\r\n原因四：萨摩耶吃得太饱&lt;br /&gt;\r\n解决方法一：萨摩耶耐饿不耐饱，可先饿饿萨摩耶，让它停食24小时。停食期间给足饮水（可在水中加入少量糖），正常情况下一般第二天可恢复食欲。为了确保其旺盛的食欲，每周可停食一天。一般给萨摩耶喂食只需给喂到七八分饱就好，要让萨摩耶保持一定的饥饿状态，这样可以长久保持食物对萨摩耶的吸引力。&lt;br /&gt;\r\n饲养萨摩耶期间总是会出现各种各样的问题，现在我们知道萨摩耶不进食的原因是什么了，那么我们要根据萨摩耶的饮食习惯来想出办法，萨摩耶是我们的朋友，对于它出现的各种异常情况，我们要及时的处理，只有这样才能保证它健康成长。');
INSERT INTO `c9_content_news` VALUES('17','7','&lt;p&gt;\r\n	藏獒的身体需要养狗人科学的喂养，很多养狗人面对饲养藏獒的问题上，总是不能很好的抓住饲养方法，这样很容易导致藏獒的身体出现问题，随着藏獒与我们生活时间越来越长，我们对它的重视程度也越深，不想要它的身体出现问题，我们在护理时就要注意方法和态度，很多养狗人面对藏獒时总是以一种随便的态度对待它，这样对它的身体成长是不利的，&lt;br /&gt;\r\n藏獒饲养注意：&lt;br /&gt;\r\n1.藏獒因为皮肤有很多褶皱，很容易藏赃物细菌，要定期护理。&lt;br /&gt;\r\n2.他们天生怕水，不要带他去游泳。要养藏獒不可同时养猫。&lt;br /&gt;\r\n3.藏獒很怕热，夏天的时候，要给他吹冷气。&lt;br /&gt;\r\n4.有时候皱纹太多的藏獒，睫毛会倒睫刺到眼睛，必需要请兽医开刀。&lt;br /&gt;\r\n5.喜寒能适应寒冷的气候，需要经常梳理毛发，不容易训练，不容易与别的犬相处。&lt;br /&gt;\r\n饲养宠物狗不是一件容易的事情，如果我们在照顾时它注意方法，这很容易导致它的身体出现问题，饲养藏獒需要科学的方法，为了它的健康，我们要定期给清洁卫生和梳理毛发，这些对藏獒的身体健康都是有帮助的，藏獒是我们的朋友，我们要认真的照顾它。\r\n&lt;/p&gt;');
INSERT INTO `c9_content_news` VALUES('18','14','&lt;p&gt;\r\n	萨摩耶犬本身是一种长毛犬，在日常护理当中，如果家长们给它适当的修饰，那么它的造型是非常漂亮的。微莎狗狗工作室将跟所有的家长们来分享一下萨摩耶犬美容造型方面的小知识。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;img style=&quot;width:550px;height:363px;&quot; title=&quot;萨摩耶美容造型的方法&quot; alt=&quot;萨摩耶美容造型的方法&quot; src=&quot;/data/upload/image/201903/e028f088fbdf29c040fa1d6ba5874444.jpg&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	在给摩耶犬做造型的时候，家长们一定要按照一定的美容步骤来进行才可以。这样做也会让萨摩耶犬看起来更加的美丽、优雅有气质。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	首先第一步，家长们一定要用专业的刷子，帮助狗狗祛除掉身上的灰尘和死毛，非常的重要也是基础。第二步需要家长们按照狗狗的毛发生长方向，梳理狗狗的毛发，直到没有任何的结节。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;img style=&quot;height:auto;&quot; title=&quot;萨摩耶美容造型的方法&quot; alt=&quot;萨摩耶美容造型的方法&quot; src=&quot;/data/upload/image/201903/2216dec26827a6f24f6e24733cbfdd7f.jpg&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	另外，做完上面那两步之后，家长们一定要及时清洁狗狗的眼睛和耳朵，这样看起来才会更加的整洁一些。再就是给狗狗修剪一下，脚底下的饰毛，修剪指甲，修剪腹部的饰毛，最后别忘记帮助狗狗把肛门附近的毛发给剪断，\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	然后，做完这些最基础的修剪之后，就需要专业的美容师，帮助狗狗去挤掉肛门腺内的残留物，这样也能够有效的消除狗狗身上的体味。下一步就是进行洗澡和吹风处理。最后就是把狗狗交由美容师进行美容造型。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;img style=&quot;height:auto;&quot; title=&quot;萨摩耶美容造型的方法&quot; alt=&quot;萨摩耶美容造型的方法&quot; src=&quot;/data/upload/image/201903/2b0c69653cd091f350b155115b1ff49b.jpg&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	这里需要提醒家长们，在给狗狗做造型之前，上面的这些步骤完全可以在家中自行解决。而且在给狗狗洗澡的过程当中，一定要用去污力比较强的犬用香波，这样才能够有效的防止狗狗的毛发出现断毛和打结。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	为什么不让家长们自己给萨摩耶犬做美容造型呢?因为一旦做坏了，狗狗将会非常生气，再想挽回花的钱更多，再说也不安全。\r\n&lt;/p&gt;');
INSERT INTO `c9_content_news` VALUES('19','13','&lt;p&gt;\r\n	随着人们生活的越来越好，不少人已经不再局限于物质还是更加注重在精神层面上了，宠物开始走进人们的生活中，成为人们可靠而又贴心的伴侣。而狗狗无疑是众多宠物中最受欢迎的一个品类了。今天小编不是发一些可爱的狗狗图片，而是为大家讲述几个非常现实的问题，宠物狗的臭味和异味问题！\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/data/upload/image/201903/cbe0cbd80e54d46c4ecc26f74206f55c.jpeg&quot; /&gt;&lt;br /&gt;\r\n狗狗的屁股就是尤其严重的臭味、异味的“臭源”。因为狗本身是非常喜欢味道的，所以宠物狗不会因为自己屁股上带着臭味是一种不雅而自觉的去清理。或许小编可以直接说对于狗来说是真的不存在香味和臭味之分，对于它们来说只是味道不同而已。因此狗狗特有的肛门腺也是臭味的一个来源。&lt;br /&gt;\r\n狗狗的嘴巴也是异味来源之一，狗狗通常是杂食动物，而对于像如今的狗主人来说，都会喂自己爱犬肉类或含肉类狗食。通常都不会为狗狗清理嘴巴，所以狗狗嘴巴里会伴有异味也实属正常。&lt;br /&gt;\r\n综上所述，作为狗主人的你不难发现狗狗的异味臭味都是关乎它们吃的什么。一般狗粮里都会注重营养的搭配而忽略到臭味异味这一点，这里我们不得不提到维萨手工狗粮的叶师傅曾经跟小编说过，手工狗粮里一般都会加入极其少量的丝兰提取物，所以小编这里就为广大狗主人着重介绍一下丝兰。&lt;br /&gt;\r\n丝兰提取物作为一种纯天然植物提取物，主要富含天然类固醇丝兰皂苷，可以说是天然的肠道清洁剂和表面活性剂，在肠道中起到了一种极好的清洁剂作用，清除肠壁污物和排除毒素。&lt;br /&gt;\r\n从药理上来说丝兰提取物其特有的多糖成分与氨气有非常强的亲和力可以减少宠物肠道中氨气等臭气的产生，同时把它们转化为无毒的氮化物被机体利用，大大降低爱宠便臭味和身体异味，让养宠家庭更加自然清新。\r\n&lt;/p&gt;');
INSERT INTO `c9_content_news` VALUES('22','8','&lt;p&gt;\r\n	&lt;img style=&quot;width:542px;height:354px;&quot; title=&quot;狗狗出门叫不回来怎么办&quot; border=&quot;0&quot; alt=&quot;狗狗出门叫不回来怎么办&quot; src=&quot;/data/upload/image/201903/91684ff4b1428ccb0770431b830ec4f2.png&quot; width=&quot;542&quot; height=&quot;354&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	狗狗出门叫不回来怎么办？这是很多养狗人无奈，特别狗狗对外界好奇心重，完全把狗主人放在一边了。无乱狗主人怎么叫也不回。所以，狗狗叫回训练是必要的。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	1、狗狗出门叫不回来形成原因\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	狗从小被狗主人人为地把它的同伴和户外环境隔离了，造成了狗对户外自由奔跑的原始需求的急增大，所以，当遇到能有机会自由在户外奔跑与同伴玩要的机会后就不会再觉得狗主人好，也不会再听狗主人的，只有它玩累了或者同伴们不在身边了，狗才会再想起主人的存在。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	2、狗狗出门叫不回来解决方法\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	1)、使用遥控电子项圈，当狗跑得远井且跑得非常忘我开心时叫狗回来，然后按遥控，通过微电流让狗瞬间冷静，打断它原有的思路，当狗回来后给予奖助，当第一声叫不回来后，再叫第二声，并且加大电子项圈的电流，直到狗回来。回来后立即奖励。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	遥控电子项圈使用技巧：一是须先下口令再按电流：二是不能让狗看着遥控器时按：三是不能天天持续使用，使用一两次后，要隔几天使用，以免让狗对电子项圈的功能产生依赖。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	2)、使用小石头砸的方法，当带狗到户外与其它狗一起玩时，训练者双手准备两把小石子，尾随狗四五米的位置，当狗玩得非常忘我时，立即说“来”的口令，狗不来时，立即对准狗的屁股砸一把小石头如果狗逃跑的话，一直尾随狗其后再使用同样的方法，直到狗无处可逃，那时候狗会在心理臣服而自觉回。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	3)、提前安排助训员（可以安排一个陌生人来帮忙），让助训员去给狗制造疼痛，让训练者给狗制造安慰，一正一反让狗自我转换。\r\n&lt;/p&gt;');
INSERT INTO `c9_content_news` VALUES('23','8','&lt;p&gt;\r\n	&lt;img style=&quot;width:489px;height:323px;&quot; title=&quot;狗怎么训练才听懂人话&quot; border=&quot;0&quot; alt=&quot;狗怎么训练才听懂人话&quot; src=&quot;/data/upload/image/201903/4ef6b87667d01cce98e41968f5f49de9.jpg&quot; width=&quot;489&quot; height=&quot;323&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	宠物狗怎么训练才听懂人话？其实养狗的问题主要是观念问题，城市养宠物犬其实也是一种奢侈消费，是衣食住行之外的消费，可养可不养，养了之后狗狗的吃喝拉撒就变成了刚需消费，你想继续养好，还得把它训练好，否则就是花钱买罪受，很容易产生抛弃的念头。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	城市养狗本是一种心理寄托，初心是想要它听话温顺，想要它陪伴终老，想要它自由自在。可结果却往往事与愿违。改变状况的唯一方案，就在主人的一念之间，要么学习，要么放弃！你会怎么选？狗怎么训练才听懂人话？\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	在狗狗还小的时候，最容易建立规则，错过了就要花更大的精力更多的时间去学习，去教育。从小就会遇到行为问题，从小就可以训练，人跟狗相处，对它的行为干扰都是一种潜移默化的训练，说话的语气和跟它相处的行为，反正你想把狗长期养下去就要想到去训练好它。\r\n&lt;/p&gt;\r\n&lt;div&gt;\r\n	狗怎么训练才听懂人话？那些狗子不听话的主人，怎么还不下单来学习，一套教程是养狗的标配，也不贵，几百块一包狗粮钱。晚一天教育它，多忍受一天它不听话带来的各种烦恼，早一天训练它，早一天享受养狗的生活，不训练教育它，主人一只脚已经踏上了让它流浪的路上。\r\n&lt;/div&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;');
INSERT INTO `c9_content_news` VALUES('24','9','&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	养狗真的可以提高人的幸福感吗？从心理学的角度来看，如果我们在家里饲养小动物，实际过程中可能会为你增加一些小麻烦，但确实是可以增加人与人之间的幸福感指数的，特别是人类最忠诚的朋友——狗狗。那下面我们就来说说养狗会给人带来什么样的幸福感，快来看看吧。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;img style=&quot;width:500px;height:334px;&quot; title=&quot;养狗可以提高人的幸福感吗？&quot; alt=&quot;养狗可以提高人的幸福感吗？&quot; src=&quot;/data/upload/image/201903/b813ac5a8c2b9b184719b30400b4558f.jpg&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	1.狗的服从性高。通过我们正确的训练，狗狗是可以成为人类的好帮手，比如导盲犬、缉毒犬、搜救犬等，这样狗只要通过人类特别的训练，它们就能成为人类处置特殊工作中的得力帮手，甚至人类利用塔门特性来执行任务效果更佳，因为狗通人性，懂得服从，执行力堪比狼性。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	2.狗的灵性比其他小动物要高一些。事实证明，如果我们在家里养狗，狗狗宠医和它与人之间的互动会比其他宠物更贴近人性，因此从饲养宠物的角度，人们更喜欢养狗的多一些。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	3.家庭饲养狗狗，可以有效成为家庭成员。只要主人对待狗狗好，狗是会通晓人的友善和喜爱，同样狗狗会用行动证明它也爱你和家，会成为家庭中不可或缺的家庭成员，所以家里养一条狗，在某些方面会增加家庭的温暖和爱心，对提升家庭幸福指数有好处，同事也再次提醒大家，管理好狗狗才能更和谐。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;img style=&quot;width:500px;height:334px;&quot; title=&quot;养狗可以提高人的幸福感吗？&quot; alt=&quot;养狗可以提高人的幸福感吗？&quot; src=&quot;/data/upload/image/201903/b01eb39f7c686b69c2b46d8d8addeb1a.jpg&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	因为狗狗的性格相比其他动物更加的活泼外向，互动性也强，对主人的依赖感也很明显。所以如果你是一个害怕孤独的人，如果你独自生活在异乡，如果你不善于人际交往。想象一下，你忙碌了一天回到家中，一进门，就看到可爱的狗狗激动的奔向你扑个满怀，这个时候你一定会觉得连空气都是带着爱心的。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	所以，爱狗的盆友们，还迟疑什么？行动起来吧！不过最后还是要唠叨一句，如果养了，就请不离不弃，善始善终。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	&lt;br /&gt;\r\n&amp;nbsp;\r\n&lt;/p&gt;');
INSERT INTO `c9_content_news` VALUES('25','9','&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	目前社会现在大多数的家庭都是独生子女，很多家长考虑买只狗狗来陪伴孩子一起成长，要知道从小喂养狗狗的孩子要比没有喂养宠物的孩子更加优秀，喂养狗狗可以给孩子带来很多好处，现在我们具体了解下哪些狗狗适合陪伴孩子。&lt;br /&gt;\r\n&lt;img alt=&quot;狗狗和小孩&quot; src=&quot;/data/upload/image/201903/8a5d041dbb4c6afaa75c41af3101ce6c.jpg&quot; width=&quot;480&quot; height=&quot;302&quot; /&gt;&lt;br /&gt;\r\n1.首先孩子是幼小的，不懂事，要选择温顺的狗狗来陪伴孩子，这类狗狗要包容性强，同时能照顾好孩子，就像牧羊犬放羊一样。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	2.狗狗是非常适合陪伴孩子玩耍的。比格犬、伯恩山犬、比熊犬、波士顿梗、拳师犬、布列塔尼猎犬、斗牛犬、猎浣熊犬、英国塞特犬、猎狐犬、哥顿塞特犬、爱尔兰塞特犬、荷兰毛狮犬、拉不拉多寻回犬、马士提夫犬、纽芬兰犬、八哥犬、萨摩犬、激飞犬、维兹拉犬、金毛犬等等。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	3.每个品种的狗狗有自己不同的性格，比如说金毛非常忠诚、钟情、友善的品种，具有非常强的包容性，可以很好的照顾小孩子。拉不拉多聪明、有爱心、非常容易跟孩子打成一片。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	对于不同年龄段的孩子对于狗狗的选择也不同，要给孩子选择一个好的玩伴，会让孩子受益终生。\r\n&lt;/p&gt;');
INSERT INTO `c9_content_news` VALUES('26','9','&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	很多人都知道狗狗会认路也会识别谁是自己的主人，可是你知道狗狗是通过什么方式来辨认自己主人的？相信这个问题大家一定很好奇，有养狗的朋友们应该都知道，当我们每天下班回家时候或者是长时间外出没有见到主人，但狗狗都可以第一时间来迎接主人，对主人表示亲昵，而且就算是在人海中，狗狗也可以准确的找到自己的主人，那这是为什么呢？\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;img title=&quot;狗狗是通过什么方式来辨认自己主人的？&quot; alt=&quot;狗狗是通过什么方式来辨认自己主人的？&quot; src=&quot;/data/upload/image/201903/9deb937ab6cd9b700be6297cd4516ce7.jpg&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	&lt;br /&gt;\r\n&amp;nbsp;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	&lt;strong&gt;1.&lt;/strong&gt;&lt;strong&gt;视觉。&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	狗狗是色盲，而且视力只有人类的五分之一到三分之一，但是狗狗与人类的视觉成像系统还是很像的，它所看到的一切都会反映到它脑海里，狗狗通过眼睛来记忆主人长什么样子，主人会对自己做什么，行为习惯是什么，它都能很好的记清楚。有时候隔着几十米的距离呼唤自己的狗狗，狗狗听到了就会跑过来，因为这是狗狗用眼睛视力发现主人了。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	&lt;strong&gt;2.&lt;/strong&gt;&lt;strong&gt;听觉&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	狗狗的耳朵结构和人类是不一样的，能够像个小雷达一样转动收听信号。狗狗的听力是人类的16倍，听觉感应超强 ，因为每一个人说话的声音频率都是不同的，所以在狗狗这种超强的听力下，如何区分主人的声音就更加容易了。当狗狗被主人喊名字的时候它会迅速跑到主人身边，如果是陌生人的话，那狗狗可能就只会再嗅闻几下，抬头看看，和记忆中的主人不对的话，就会失去兴趣了。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	&lt;img title=&quot;狗狗是通过什么方式来辨认自己主人的？&quot; border=&quot;0&quot; alt=&quot;狗狗是通过什么方式来辨认自己主人的？&quot; src=&quot;/data/upload/image/201903/86968f96843ec7309493d558d9de8f99.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;strong&gt;3.&lt;/strong&gt;&lt;strong&gt;嗅觉&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	狗狗的嗅觉灵敏度比人类强了不知道多少倍，嗅闻可以说是狗狗最主要的辨别周遭环境的手段，从小跟着你长大的狗狗，对你身上的气味已经非常熟悉了，就算你喷了十七八种香水，它也总能在人群中一下子就找到你！所以狗狗就算不用眼睛看，也能分得清主人和陌生人。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	&lt;br /&gt;\r\n&amp;nbsp;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	&lt;img title=&quot;狗狗是通过什么方式来辨认自己主人的？&quot; border=&quot;0&quot; alt=&quot;狗狗是通过什么方式来辨认自己主人的？&quot; src=&quot;/data/upload/image/201903/ea7b69959d6e7e4b4e089fc3f557a3f0.jpg&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	相信通过文章大家都知道了狗狗是通过什么方式来辨认自己主人的吧，最重要的原因是狗狗跟主人每天为伴，建立了深厚感情。因此，狗对主人的形象记忆甚深。\r\n&lt;/p&gt;');
INSERT INTO `c9_content_news` VALUES('27','6','&lt;p&gt;\r\n	微莎狗狗工作室新进设备绝不采用骨粉成品材料研磨机\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	研磨机主要作用：研磨骨头成粉，中草药研磨成粉（主要是金银草，用于解决狗狗泪痕问题。海藻，用于美毛。）\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/data/upload/image/201903/638bae29fd849175b5fe0863d76f3255.jpg&quot; /&gt;&lt;img alt=&quot;&quot; src=&quot;/data/upload/image/201903/0c80c08d5190911c7e9a36a927dcd2ec.jpg&quot; /&gt;\r\n&lt;/p&gt;');
INSERT INTO `c9_content_news` VALUES('28','13','&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	宠物狗会得糖尿病吗?答案是肯定的，其实人和狗是动物中相当容易得糖尿病的种类，虽然一般人的观念，认为狗狗肥胖才是狗狗的糖尿病的真正元凶，要知道有时体质的差异也会造成，比如胰岛素缺乏症。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:center;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;img style=&quot;border:0px currentColor;&quot; alt=&quot;警惕狗狗也会得糖尿病&quot; src=&quot;/data/upload/image/201903/d13949c0379ab8dabcb07e4f6d4423dd.jpg&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	宠物犬胰岛素正常分泌时，动物进食所分解的葡萄糖大量进入细胞中，提供营养。相反的，胰岛素分祕不正常时，这些葡萄糖不易进入细胞，使葡萄糖在血液中一再囤积，演变成血糖毒。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	狗狗高血糖的影响相当深远，再临床症状上，有非常明显多渴、多尿的现象。原因是肾臟在过滤高血糖时，无法完全吸收，使糖份在尿液中析出，而尿中渗透压节节高升，不断带走大量水份，形成尿糖现象，尿量也不断增加，这时动物会有脱水的感觉，需要时时补充水份。当然，肾臟在长期过滤高血糖的负担下，机能容易老化，所以糖尿病除了分泌胰岛素的胰臟会坏死外，肾臟病通常也是伴随而来。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	不只如此，高血脂肪及酸中毒都是连锁反应。因為葡萄糖不易进入细胞，使细胞养份缺乏，便不断產生飢饿感，动物只得不断进食才能满足，此為多食症状，在多食后，血液中脂肪大量囤积，形成脂酸，这就是高血脂酸症。高血脂将造成血管病变，循环至肝中，分解的物质造成酸中毒。根据以上所述，正可以解释，為什麼肥胖很容易和糖尿病互相掛鉤的原因，各位读者怎可不谨慎啊！\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	当狗狗因肥胖而有多渴、多尿、尿糖、多食………的症状，那得了糖尿病，别怕，糖尿病并非绝症，和人类一样，以目前的医疗技术，糖尿病在严密的医疗、护理和饮食控制下，一样会有相当好的治疗成效，就怕主人没有观念，随意放弃，那狗狗就成為糖尿病的牺牲品了。下期将针对主人能做到的部份，即爱犬护理和饮食控制上，做一详细介绍。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	糖尿病是由于胰岛素相对或绝对缺乏，致使糖代谢发生紊乱的一种内分泌疾病，是犬最常见的内分泌疾病。以8～9岁为多见。母犬的发病率是公大的2～4倍。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;strong&gt;狗狗糖尿病病因：&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	原发性固素包括胰腺创伤、肿瘤、感染、自体抗体、炎症等引起的胰腺损伤；生长激素、甲状腺激素、糖皮质激素等诱发的β±细胞衰竭；以及靶细胞敏感性下降。继发性因素有：急性和复发性腺泡坏死性胰腺炎以及胰岛淀粉样变。镇静药、麻醉剂、噻嗪类及苯妥英钠等药物可影响胰岛素的释放。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;strong&gt;狗狗糖尿病症状：&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	常表现夜尿，多尿，烦渴，轻度脱水，食欲亢进但体重减轻。有的可触及肿大的肝脏，有的伴有膀胱炎，1／2的病犬有白内障。即便在空腹状态下，血液亦呈明显的高脂血。伴发酮酸酸中毒时，食欲减退或废绝，精神沉郁，体温可能升高，中度乃至重度脱水，呕吐，腹泻，少尿或无尿，空腹血糖含量可达200mg以上。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;strong&gt;狗狗糖尿病治疗：&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	狗狗糖尿病的治疗原则是降低血糖，纠正水、电解及酸碱平衡紊乱。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	口服降糖药：常用的药物有乙酸苯磺酰环己脲、氯磺丙脲、甲苯磺丁脲、优降糖等。一般仅限于血糖不超过每百毫升200mg，且不伴有酮血症的病犬。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	胰岛素疗法，早晨饲喂前0.5h皮下注射中效胰岛素0.5μg/kg体重，每天1次。对伴发酮酸酸中毒的病犬、可选用结晶胰岛素或半慢胰岛素锌悬液，采用小剂量连续静脉滴注或小剂量肌肉注射，静脉注射剂量为0.1μg／kg体重，肌肉往射剂量为3kg以上1μg，10kg以下2μg。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	液体疗法：可选用乳酸林格氏液、0.45%氯化钠液和5%葡萄糖液。静脉注射液体的量一般不应超过90ml／kg体重，可先注入20～30ml／kg体重，然后缓慢注射。并适时补充钾盐。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	为避免狗狗糖尿病正确选择狗粮才是关键，微莎自制手工狗粮科学的成分配比，多重口味，多重营养，让狗狗吃的香，吃的健康\r\n&lt;/p&gt;');
INSERT INTO `c9_content_news` VALUES('30','13','&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;strong&gt;一、关于“犬细小病毒”&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;strong&gt;1.犬细小病毒概念&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	犬细小病毒(CPV)属细小病毒科。细小病毒科是已发现的真病毒中个体最小﹑结构最简单的DNA病毒。犬细小病毒感染是20世纪70年代发现的一种烈性传染病，临床表现为急性出血性胃肠炎或非化脓性心肌炎。其非经治疗的成活率&amp;lt;5%。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:center;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;img style=&quot;border:0px currentColor;&quot; alt=&quot;犬细小病毒的常识，宠物主人必须知道&quot; src=&quot;/data/upload/image/201903/dd05ec6494d3fd15e9a748d7b853354c.jpg&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;strong&gt;★ 犬细小病毒病原&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	犬细小病毒(CanineParvovirus，CPV)属细小病毒科，细小病毒属。CPV对多种理化因素和常用消毒剂具有较强的抵抗力，在4-10度存活6个月，37度存活2周，56度存活24小时，80度存活15分钟，在室温下保存3个月感染性仅轻度下降，在粪便中可存活数月至数年。该病毒对乙醚，氯仿，醇类有抵抗力，对紫外线，福尔马林，次氯酸钠，氧化剂敏感。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;strong&gt;★犬细小病毒流行病学&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	CPV主要感染犬，尤其幼犬，传染性极强，死亡率也高。一年四季均可发病，以冬，春多发。饲养管理条件骤变，长途运输，寒冷，拥挤均可促使本病发生。病犬是主要传染源，呕吐物，唾液，粪便中均有大量病毒。康复犬仍可长期通过粪便向外排毒。有证据表明人，虱，苍蝇和蟑螂可成为CPV的机械携带者。健康犬与病犬或带毒犬直接接触，或经污染的饲料和饮水通过消化道感染。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	★ 发病机理健康犬经消化道感染病毒后，病毒主要攻击两种细胞，一种是肠上皮细胞，一种是心肌细胞，分别表现胃肠道症状和心肌炎症状，心肌炎以幼犬多见。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;strong&gt;2.犬细小病毒感染的流行特征&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	犬细小病毒感染的潜伏期为7—14天。犬感染细小病毒发病急，死亡率高，常呈爆发性流行。不同年龄、性别、品种的犬均可感染，但以刚断奶至免疫为未完成其间的幼犬居多，病情也较严重。纯种犬较杂交犬易感染。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;strong&gt;3.犬细小病毒的传染源和传播途径&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	病犬是主要的传染源。感染后1—2周内粪便排毒，以4—7天排毒最多。发病急性期，呕吐物和唾液中也可排毒。康复犬可长期通过粪便排毒。犬细小病毒主要的感染途径有两种。一是病犬和健康犬直接接触或经污染的饲料和饮水通过消化道感染。二是人、虱、苍蝇和蟑螂等接触犬细小病毒后成为病毒的携带者，间接感染了健康犬。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;strong&gt;4.犬细小病毒感染的多发季节&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	犬细小病毒感染一年四季均可发生，但以冬春两季多发。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	二.&lt;span&gt;&amp;nbsp;&lt;/span&gt;&lt;strong&gt;犬细小病毒感染的临床症状&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	犬细小病毒感染后在临床上表现各异，但主要表现为肠胃炎或心肌炎两型，有时一些肠胃炎型病例也伴有心肌炎病变。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;strong&gt;1.犬细小病毒-肠胃炎型&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	发病初期病犬厌食，抑郁，发热(40--41℃)或呕吐。随后出现腹泻。大便初呈黄或灰黄色随后呈酱红色，恶臭。胃肠道症状出现1—2天后表现脱水和体重减轻。多数病犬扁桃体和头颈部淋巴结肿大，有的病犬口腔内可见小泡。\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;strong&gt;2.犬细小病毒-心肌炎型&lt;/strong&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;text-indent:2em;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;\r\n	多见于4—6周龄幼犬，也见于成犬。常无先兆性症状，或仅表现为轻度腹泻，继而出现衰弱，呼吸困难，心率快而弱，心脏听诊出现杂音，心率不齐，心电图发生病理性改变。犬一般短时间内死亡。\r\n&lt;/p&gt;');
INSERT INTO `c9_content_news` VALUES('31','13','&lt;span style=&quot;color:#333333;font-family:微软雅黑;font-size:16px;font-style:normal;font-weight:400;background-color:#FFFFFF;&quot;&gt;要是你家狗狗出现牙黄、发出异味的时候就要帮它祛口臭了，建议每天帮狗狗刷下牙，还有平常给它啃下大骨头或者购买一些有助磨牙的狗零食（推荐使用微莎狗狗工作室手工自制的鸡肉干）给它吃，这样就能帮助狗狗祛口臭、预防牙结石等症状了，而且经常磨牙有助狗狗口腔健康！&lt;/span&gt;');

DROP TABLE IF EXISTS `c9_content_product`;
CREATE TABLE `c9_content_product` (
  `id` mediumint(8) NOT NULL,
  `catid` smallint(5) NOT NULL,
  `content` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `catid` (`catid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `c9_content_product` VALUES('20','11','&lt;p&gt;\r\n	&amp;nbsp;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	牛肉&amp;nbsp;提供能量，免疫力提升&lt;br /&gt;\r\n天然谷物 将多种粮食谷物混合食用或将谷物与动物性食物混合食用以便提高谷类蛋白质的生理价值&lt;br /&gt;\r\n维生素 帮助消化，促进营养吸收，保护肠道菌群&lt;br /&gt;\r\n鸡蛋 健康活力，高蛋白富含卵磷脂\r\n&lt;/p&gt;');
INSERT INTO `c9_content_product` VALUES('21','11','&lt;p&gt;\r\n	&amp;nbsp;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	鸡肉&amp;nbsp;提供能量，免疫力提升，利于消化&lt;br /&gt;\r\n天然谷物 将多种粮食谷物混合食用或将谷物与动物性食物混合食用以便提高谷类蛋白质的生理价值&lt;br /&gt;\r\n维生素 帮助消化，促进营养吸收，保护肠道菌群&lt;br /&gt;\r\n鸡蛋 健康活力，高蛋白富含卵磷脂\r\n&lt;/p&gt;');
INSERT INTO `c9_content_product` VALUES('29','12','狗狗零食牛肉块，采用新鲜牛肉切块蒸煮致熟，干果机脱水烘干！');

DROP TABLE IF EXISTS `c9_diy_hdp`;
CREATE TABLE `c9_diy_hdp` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `biaoti` varchar(255) NOT NULL,
  `tupian` varchar(255) NOT NULL,
  `lianjie` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `c9_diy_hdp` VALUES('6','手工自制狗粮湿粮','/data/upload/image/201903/080ee4ad71b52b09875de320fc22effd.png','http://www.wysha.cn');
INSERT INTO `c9_diy_hdp` VALUES('5','手工自制狗粮','/data/upload/image/201903/ac943d87c051926d1a4aede5e25b0019.png','http://www.wysha.cn');
INSERT INTO `c9_diy_hdp` VALUES('4','手工自制狗粮','/data/upload/image/201903/25cb378f6b968bb90548678949539aa3.png','http://www.wysha.cn');
INSERT INTO `c9_diy_hdp` VALUES('7','手工自制狗粮','/data/upload/image/201903/d844e3f41320490c9771218d32d1d1e4.png','http://www.wysha.cn');

DROP TABLE IF EXISTS `c9_form_comment`;
CREATE TABLE `c9_form_comment` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `cid` mediumint(8) NOT NULL,
  `userid` mediumint(8) NOT NULL,
  `username` char(20) NOT NULL,
  `listorder` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '1',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `ip` char(20) DEFAULT NULL,
  `pinglunneirong` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `listorder` (`listorder`),
  KEY `status` (`status`),
  KEY `time` (`time`),
  KEY `userid` (`userid`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `c9_form_gestbook`;
CREATE TABLE `c9_form_gestbook` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `cid` mediumint(8) NOT NULL,
  `userid` mediumint(8) NOT NULL,
  `username` char(20) NOT NULL,
  `listorder` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '1',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `ip` char(20) DEFAULT NULL,
  `nindexingming` varchar(255) DEFAULT NULL,
  `lianxiQQ` varchar(255) DEFAULT NULL,
  `liuyanneirong` varchar(255) DEFAULT NULL,
  `zhongliang` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `listorder` (`listorder`),
  KEY `status` (`status`),
  KEY `time` (`time`),
  KEY `userid` (`userid`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `c9_form_gestbook` VALUES('1','0','0','','0','1','1552281938','49.82.93.76','夜间','15052611371','汗哒哒','夜间');

DROP TABLE IF EXISTS `c9_keylink`;
CREATE TABLE `c9_keylink` (
  `id` int(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `link` varchar(100) NOT NULL,
  `weight` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `c9_keylink` VALUES('1','狗粮','http://www.wysha.cn/','0');

DROP TABLE IF EXISTS `c9_member`;
CREATE TABLE `c9_member` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `username` char(20) NOT NULL DEFAULT '',
  `password` char(32) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL,
  `avatar` varchar(100) NOT NULL DEFAULT '',
  `modelid` smallint(5) NOT NULL,
  `regdate` int(10) unsigned NOT NULL DEFAULT '0',
  `regip` varchar(50) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `c9_member_connect`;
CREATE TABLE `c9_member_connect` (
  `uid` mediumint(9) NOT NULL,
  `openid` varchar(32) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `c9_member_geren`;
CREATE TABLE `c9_member_geren` (
  `id` mediumint(8) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `c9_model`;
CREATE TABLE `c9_model` (
  `modelid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `typeid` tinyint(3) NOT NULL,
  `modelname` char(30) NOT NULL,
  `tablename` char(20) NOT NULL,
  `listtpl` varchar(30) NOT NULL,
  `showtpl` varchar(30) NOT NULL,
  `joinid` smallint(5) DEFAULT NULL,
  `setting` text,
  PRIMARY KEY (`modelid`),
  KEY `typeid` (`typeid`),
  KEY `joinid` (`joinid`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `c9_model` VALUES('1','1','文章模型','content_news','list_news.html','show_news.html','0','a:1:{s:7:\"default\";a:6:{s:5:\"title\";a:2:{s:4:\"name\";s:6:\"标题\";s:4:\"show\";s:1:\"1\";}s:8:\"keywords\";a:2:{s:4:\"name\";s:9:\"关键字\";s:4:\"show\";s:1:\"1\";}s:5:\"thumb\";a:2:{s:4:\"name\";s:9:\"缩略图\";s:4:\"show\";s:1:\"1\";}s:11:\"description\";a:2:{s:4:\"name\";s:6:\"描述\";s:4:\"show\";s:1:\"1\";}s:4:\"time\";a:2:{s:4:\"name\";s:12:\"发布时间\";s:4:\"show\";s:1:\"1\";}s:4:\"hits\";a:2:{s:4:\"name\";s:9:\"阅读数\";s:4:\"show\";s:1:\"1\";}}}');
INSERT INTO `c9_model` VALUES('2','1','产品模型','content_product','list_product.html','show_product.html','','a:1:{s:7:\"default\";a:6:{s:5:\"title\";a:2:{s:4:\"name\";s:6:\"标题\";s:4:\"show\";s:1:\"1\";}s:8:\"keywords\";a:2:{s:4:\"name\";s:9:\"关键字\";s:4:\"show\";s:1:\"1\";}s:5:\"thumb\";a:2:{s:4:\"name\";s:9:\"缩略图\";s:4:\"show\";s:1:\"1\";}s:11:\"description\";a:2:{s:4:\"name\";s:6:\"描述\";s:4:\"show\";s:1:\"1\";}s:4:\"time\";a:2:{s:4:\"name\";s:12:\"发布时间\";s:4:\"show\";s:1:\"1\";}s:4:\"hits\";a:2:{s:4:\"name\";s:9:\"阅读数\";s:4:\"show\";s:1:\"1\";}}}');
INSERT INTO `c9_model` VALUES('3','3','定制狗粮','form_gestbook','list_gestbook.html','form.html','','a:1:{s:4:\"form\";a:11:{s:4:\"post\";s:1:\"0\";s:3:\"num\";s:1:\"0\";s:4:\"time\";s:2:\"10\";s:5:\"check\";s:1:\"0\";s:4:\"code\";s:1:\"1\";s:6:\"member\";s:1:\"0\";s:5:\"email\";s:1:\"0\";s:11:\"smtpemailto\";s:0:\"\";s:11:\"mailsubject\";s:0:\"\";s:4:\"show\";a:4:{i:0;s:13:\"nindexingming\";i:1;s:8:\"lianxiQQ\";i:2;s:13:\"liuyanneirong\";i:3;s:10:\"zhongliang\";}s:10:\"membershow\";a:4:{i:0;s:13:\"nindexingming\";i:1;s:8:\"lianxiQQ\";i:2;s:13:\"liuyanneirong\";i:3;s:10:\"zhongliang\";}}}');
INSERT INTO `c9_model` VALUES('4','3','文章评论','form_comment','list_comment.html','form.html','1','a:1:{s:4:\"form\";a:8:{s:4:\"post\";s:1:\"0\";s:3:\"num\";s:1:\"0\";s:4:\"time\";s:0:\"\";s:5:\"check\";s:1:\"0\";s:4:\"code\";s:1:\"0\";s:6:\"member\";s:1:\"0\";s:4:\"show\";a:1:{i:0;s:14:\"pinglunneirong\";}s:10:\"membershow\";a:1:{i:0;s:14:\"pinglunneirong\";}}}');
INSERT INTO `c9_model` VALUES('5','2','个人','member_geren','list_geren.html','show_geren.html','','');
INSERT INTO `c9_model` VALUES('6','4','幻灯片','diy_hdp','list_hdp.html','show_hdp.html','','a:1:{s:4:\"form\";a:1:{s:4:\"show\";a:3:{i:0;s:6:\"biaoti\";i:1;s:6:\"tupian\";i:2;s:7:\"lianjie\";}}}');

DROP TABLE IF EXISTS `c9_model_field`;
CREATE TABLE `c9_model_field` (
  `fieldid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `modelid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `field` varchar(20) NOT NULL,
  `name` varchar(30) NOT NULL,
  `isshow` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `tips` text NOT NULL,
  `pattern` varchar(255) NOT NULL,
  `errortips` varchar(255) NOT NULL,
  `formtype` varchar(20) NOT NULL,
  `setting` mediumtext NOT NULL,
  `listorder` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fieldid`),
  KEY `modelid` (`modelid`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `c9_model_field` VALUES('1','1','content','内容','1','','','','editor','a:4:{s:7:\"toolbar\";s:1:\"1\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"450\";s:12:\"defaultvalue\";s:0:\"\";}','0','0');
INSERT INTO `c9_model_field` VALUES('2','2','content','内容','1','','','','editor','a:5:{s:7:\"toolbar\";s:1:\"2\";s:5:\"items\";s:256:\"\'source\',\'|\',\'forecolor\',\'bold\',\'italic\',\'underline\',\'lineheight\',\'|\',\'fontname\',\'fontsize\',\'code\',\'plainpaste\',\'wordpaste\',\'|\',\'image\',\'multiimage\',\'flash\',\'media\',\'insertfile\',\'link\',\'unlink\',\'|\',\'justifyleft\',\'justifycenter\',\'justifyright\',\'justifyfull\'\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"450\";s:12:\"defaultvalue\";s:190:\"编辑器支持自定义啦，赶快去内容模型》产品模型》字段管理》编辑器里面看看吧&lt;br&gt;如需更多字段，请大家自己在字段管理处自行添加吧。\";}','0','0');
INSERT INTO `c9_model_field` VALUES('3','3','nindexingming','您的姓名','1','','','','input','a:2:{s:4:\"size\";s:3:\"150\";s:12:\"defaultvalue\";s:0:\"\";}','0','0');
INSERT INTO `c9_model_field` VALUES('4','3','lianxiQQ','手机号码','1','','/^(1)[0-9]{10}$/','','input','a:2:{s:4:\"size\";s:3:\"150\";s:12:\"defaultvalue\";s:0:\"\";}','0','0');
INSERT INTO `c9_model_field` VALUES('5','3','liuyanneirong','留言内容','1','','1','留言内容不能为空','textarea','a:3:{s:5:\"width\";s:3:\"400\";s:6:\"height\";s:2:\"90\";s:12:\"defaultvalue\";s:0:\"\";}','0','0');
INSERT INTO `c9_model_field` VALUES('6','4','pinglunneirong','评论内容','1','','1','评论内容不能为空','textarea','a:3:{s:5:\"width\";s:3:\"400\";s:6:\"height\";s:2:\"90\";s:12:\"defaultvalue\";s:0:\"\";}','0','0');
INSERT INTO `c9_model_field` VALUES('7','6','biaoti','标题','1','','1','','input','a:2:{s:4:\"size\";s:3:\"600\";s:12:\"defaultvalue\";s:0:\"\";}','0','0');
INSERT INTO `c9_model_field` VALUES('8','6','tupian','图片','1','','1','','file','a:3:{s:4:\"type\";s:11:\"gif,png,jpg\";s:7:\"preview\";s:1:\"1\";s:4:\"size\";s:2:\"10\";}','0','0');
INSERT INTO `c9_model_field` VALUES('9','6','lianjie','连接','1','','1','','input','a:2:{s:4:\"size\";s:3:\"600\";s:12:\"defaultvalue\";s:19:\"http://www.wysha.cn\";}','0','0');
INSERT INTO `c9_model_field` VALUES('10','3','zhongliang','重量','1','','1','','input','a:2:{s:4:\"size\";s:3:\"180\";s:12:\"defaultvalue\";s:0:\"\";}','0','0');

