
CREATE TABLE IF NOT EXISTS `edu_ad` (
  `ad_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '广告id',
  `ad_name` varchar(255) NOT NULL,
  `ad_content` text,
  `status` int(2) NOT NULL DEFAULT '1' COMMENT '状态，1显示，0不显示',
  PRIMARY KEY (`ad_id`),
  KEY `ad_name` (`ad_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_application`
--

CREATE TABLE IF NOT EXISTS `edu_application` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `user_id` int(5) DEFAULT NULL,
  `t_name` varchar(20) DEFAULT NULL,
  `sex` int(2) NOT NULL,
  `nianling` int(4) NOT NULL,
  `xueli` varchar(50) NOT NULL,
  `school` varchar(150) NOT NULL,
  `tel` int(18) NOT NULL,
  `signature` longtext NOT NULL,
  `zigezheng` varchar(200) DEFAULT NULL,
  `zichengzheng` varchar(200) DEFAULT NULL,
  `addtime` datetime DEFAULT NULL,
  `state` int(2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 表的结构 `edu_asset`
--

CREATE TABLE IF NOT EXISTS `edu_asset` (
  `aid` bigint(20) NOT NULL AUTO_INCREMENT,
  `key` varchar(50) NOT NULL,
  `filename` varchar(50) DEFAULT NULL,
  `filesize` int(11) DEFAULT NULL,
  `filepath` varchar(200) NOT NULL,
  `uploadtime` int(11) NOT NULL,
  `status` int(2) NOT NULL DEFAULT '1',
  `meta` text,
  `suffix` varchar(50) DEFAULT NULL,
  `download_times` int(6) NOT NULL,
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_auth_access`
--

CREATE TABLE IF NOT EXISTS `edu_auth_access` (
  `role_id` mediumint(8) unsigned NOT NULL COMMENT '角色',
  `rule_name` varchar(255) NOT NULL COMMENT '规则唯一英文标识,全小写',
  `type` varchar(30) DEFAULT NULL COMMENT '权限规则分类，请加应用前缀,如admin_',
  KEY `role_id` (`role_id`),
  KEY `rule_name` (`rule_name`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `edu_auth_access`
--

INSERT INTO `edu_auth_access` (`role_id`, `rule_name`, `type`) VALUES
(2, 'course/adminsection/index', 'admin_url'),
(2, 'course/admincourse/index', 'admin_url'),
(2, 'course/admincoursetype/index', 'admin_url'),
(2, 'admin/course/index', 'admin_url'),
(2, 'admin/setting/clearcache', 'admin_url'),
(2, 'admin/mailer/active_post', 'admin_url'),
(2, 'admin/mailer/active', 'admin_url'),
(2, 'admin/mailer/index_post', 'admin_url'),
(2, 'admin/mailer/index', 'admin_url'),
(2, 'admin/mailer/default', 'admin_url'),
(2, 'admin/route/listorders', 'admin_url'),
(2, 'admin/route/open', 'admin_url'),
(2, 'admin/route/ban', 'admin_url'),
(2, 'admin/route/delete', 'admin_url'),
(2, 'admin/route/edit_post', 'admin_url'),
(2, 'admin/route/edit', 'admin_url'),
(2, 'admin/route/add_post', 'admin_url'),
(2, 'admin/route/add', 'admin_url'),
(2, 'admin/route/index', 'admin_url'),
(2, 'admin/setting/site_post', 'admin_url'),
(2, 'admin/setting/site', 'admin_url'),
(2, 'admin/setting/password_post', 'admin_url'),
(2, 'admin/setting/password', 'admin_url'),
(2, 'admin/user/userinfo_post', 'admin_url'),
(2, 'admin/user/userinfo', 'admin_url'),
(2, 'admin/setting/userdefault', 'admin_url'),
(2, 'admin/setting/default', 'admin_url');

-- --------------------------------------------------------

--
-- 表的结构 `edu_auth_rule`
--

CREATE TABLE IF NOT EXISTS `edu_auth_rule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '规则id,自增主键',
  `module` varchar(20) NOT NULL COMMENT '规则所属module',
  `type` varchar(30) NOT NULL DEFAULT '1' COMMENT '权限规则分类，请加应用前缀,如admin_',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '规则唯一英文标识,全小写',
  `param` varchar(255) DEFAULT NULL COMMENT '额外url参数',
  `title` varchar(20) NOT NULL DEFAULT '' COMMENT '规则中文描述',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否有效(0:无效,1:有效)',
  `condition` varchar(300) NOT NULL DEFAULT '' COMMENT '规则附加条件',
  PRIMARY KEY (`id`),
  KEY `module` (`module`,`status`,`type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=208 ;

--
-- 转存表中的数据 `edu_auth_rule`
--

INSERT INTO `edu_auth_rule` (`id`, `module`, `type`, `name`, `param`, `title`, `status`, `condition`) VALUES
(1, 'Admin', 'admin_url', 'admin/content/default', '', '文章系统', 1, ''),
(2, 'Api', 'admin_url', 'api/guestbookadmin/index', '', '所有留言', 1, ''),
(3, 'Api', 'admin_url', 'api/guestbookadmin/delete', '', '删除网站留言', 1, ''),
(4, 'Comment', 'admin_url', 'comment/commentadmin/index', '', '评论管理', 1, ''),
(5, 'Comment', 'admin_url', 'comment/commentadmin/delete', '', '删除评论', 1, ''),
(6, 'Comment', 'admin_url', 'comment/commentadmin/check', '', '评论审核', 1, ''),
(7, 'Portal', 'admin_url', 'portal/adminpost/index', '', '文章管理', 1, ''),
(8, 'Portal', 'admin_url', 'portal/adminpost/listorders', '', '文章排序', 1, ''),
(9, 'Portal', 'admin_url', 'portal/adminpost/top', '', '文章置顶', 1, ''),
(10, 'Portal', 'admin_url', 'portal/adminpost/recommend', '', '文章推荐', 1, ''),
(11, 'Portal', 'admin_url', 'portal/adminpost/move', '', '批量移动', 1, ''),
(12, 'Portal', 'admin_url', 'portal/adminpost/check', '', '文章审核', 1, ''),
(13, 'Portal', 'admin_url', 'portal/adminpost/delete', '', '删除文章', 1, ''),
(14, 'Portal', 'admin_url', 'portal/adminpost/edit', '', '编辑文章', 1, ''),
(15, 'Portal', 'admin_url', 'portal/adminpost/edit_post', '', '提交编辑', 1, ''),
(16, 'Portal', 'admin_url', 'portal/adminpost/add', '', '添加文章', 1, ''),
(17, 'Portal', 'admin_url', 'portal/adminpost/add_post', '', '提交添加', 1, ''),
(18, 'Portal', 'admin_url', 'portal/adminterm/index', '', '分类管理', 1, ''),
(19, 'Portal', 'admin_url', 'portal/adminterm/listorders', '', '文章分类排序', 1, ''),
(20, 'Portal', 'admin_url', 'portal/adminterm/delete', '', '删除分类', 1, ''),
(21, 'Portal', 'admin_url', 'portal/adminterm/edit', '', '编辑分类', 1, ''),
(22, 'Portal', 'admin_url', 'portal/adminterm/edit_post', '', '提交编辑', 1, ''),
(23, 'Portal', 'admin_url', 'portal/adminterm/add', '', '添加分类', 1, ''),
(24, 'Portal', 'admin_url', 'portal/adminterm/add_post', '', '提交添加', 1, ''),
(25, 'Portal', 'admin_url', 'portal/adminpage/index', '', '页面管理', 1, ''),
(26, 'Portal', 'admin_url', 'portal/adminpage/listorders', '', '页面排序', 1, ''),
(27, 'Portal', 'admin_url', 'portal/adminpage/delete', '', '删除页面', 1, ''),
(28, 'Portal', 'admin_url', 'portal/adminpage/edit', '', '编辑页面', 1, ''),
(29, 'Portal', 'admin_url', 'portal/adminpage/edit_post', '', '提交编辑', 1, ''),
(30, 'Portal', 'admin_url', 'portal/adminpage/add', '', '添加页面', 1, ''),
(31, 'Portal', 'admin_url', 'portal/adminpage/add_post', '', '提交添加', 1, ''),
(32, 'Admin', 'admin_url', 'admin/recycle/default', '', '回收站', 1, ''),
(33, 'Portal', 'admin_url', 'portal/adminpost/recyclebin', '', '文章回收', 1, ''),
(34, 'Portal', 'admin_url', 'portal/adminpost/restore', '', '文章还原', 1, ''),
(35, 'Portal', 'admin_url', 'portal/adminpost/clean', '', '彻底删除', 1, ''),
(36, 'Portal', 'admin_url', 'portal/adminpage/recyclebin', '', '页面回收', 1, ''),
(37, 'Portal', 'admin_url', 'portal/adminpage/clean', '', '彻底删除', 1, ''),
(38, 'Portal', 'admin_url', 'portal/adminpage/restore', '', '页面还原', 1, ''),
(39, 'Admin', 'admin_url', 'admin/extension/default', '', '扩展工具', 1, ''),
(40, 'Admin', 'admin_url', 'admin/backup/default', '', '备份管理', 1, ''),
(41, 'Admin', 'admin_url', 'admin/backup/restore', '', '数据还原', 1, ''),
(42, 'Admin', 'admin_url', 'admin/backup/index', '', '数据备份', 1, ''),
(43, 'Admin', 'admin_url', 'admin/backup/index_post', '', '提交数据备份', 1, ''),
(44, 'Admin', 'admin_url', 'admin/backup/download', '', '下载备份', 1, ''),
(45, 'Admin', 'admin_url', 'admin/backup/del_backup', '', '删除备份', 1, ''),
(46, 'Admin', 'admin_url', 'admin/backup/import', '', '数据备份导入', 1, ''),
(47, 'Admin', 'admin_url', 'admin/plugin/index', '', '插件管理', 1, ''),
(48, 'Admin', 'admin_url', 'admin/plugin/toggle', '', '插件启用切换', 1, ''),
(49, 'Admin', 'admin_url', 'admin/plugin/setting', '', '插件设置', 1, ''),
(50, 'Admin', 'admin_url', 'admin/plugin/setting_post', '', '插件设置提交', 1, ''),
(51, 'Admin', 'admin_url', 'admin/plugin/install', '', '插件安装', 1, ''),
(52, 'Admin', 'admin_url', 'admin/plugin/uninstall', '', '插件卸载', 1, ''),
(53, 'Admin', 'admin_url', 'admin/slide/default', '', '幻灯片', 1, ''),
(54, 'Admin', 'admin_url', 'admin/slide/index', '', '幻灯片管理', 1, ''),
(55, 'Admin', 'admin_url', 'admin/slide/listorders', '', '幻灯片排序', 1, ''),
(56, 'Admin', 'admin_url', 'admin/slide/toggle', '', '幻灯片显示切换', 1, ''),
(57, 'Admin', 'admin_url', 'admin/slide/delete', '', '删除幻灯片', 1, ''),
(58, 'Admin', 'admin_url', 'admin/slide/edit', '', '编辑幻灯片', 1, ''),
(59, 'Admin', 'admin_url', 'admin/slide/edit_post', '', '提交编辑', 1, ''),
(60, 'Admin', 'admin_url', 'admin/slide/add', '', '添加幻灯片', 1, ''),
(61, 'Admin', 'admin_url', 'admin/slide/add_post', '', '提交添加', 1, ''),
(62, 'Admin', 'admin_url', 'admin/slidecat/index', '', '幻灯片分类', 1, ''),
(63, 'Admin', 'admin_url', 'admin/slidecat/delete', '', '删除分类', 1, ''),
(64, 'Admin', 'admin_url', 'admin/slidecat/edit', '', '编辑分类', 1, ''),
(65, 'Admin', 'admin_url', 'admin/slidecat/edit_post', '', '提交编辑', 1, ''),
(66, 'Admin', 'admin_url', 'admin/slidecat/add', '', '添加分类', 1, ''),
(67, 'Admin', 'admin_url', 'admin/slidecat/add_post', '', '提交添加', 1, ''),
(68, 'Admin', 'admin_url', 'admin/ad/index', '', '网站广告', 1, ''),
(69, 'Admin', 'admin_url', 'admin/ad/toggle', '', '广告显示切换', 1, ''),
(70, 'Admin', 'admin_url', 'admin/ad/delete', '', '删除广告', 1, ''),
(71, 'Admin', 'admin_url', 'admin/ad/edit', '', '编辑广告', 1, ''),
(72, 'Admin', 'admin_url', 'admin/ad/edit_post', '', '提交编辑', 1, ''),
(73, 'Admin', 'admin_url', 'admin/ad/add', '', '添加广告', 1, ''),
(74, 'Admin', 'admin_url', 'admin/ad/add_post', '', '提交添加', 1, ''),
(75, 'Admin', 'admin_url', 'admin/link/index', '', '友情链接', 1, ''),
(76, 'Admin', 'admin_url', 'admin/link/listorders', '', '友情链接排序', 1, ''),
(77, 'Admin', 'admin_url', 'admin/link/toggle', '', '友链显示切换', 1, ''),
(78, 'Admin', 'admin_url', 'admin/link/delete', '', '删除友情链接', 1, ''),
(79, 'Admin', 'admin_url', 'admin/link/edit', '', '编辑友情链接', 1, ''),
(80, 'Admin', 'admin_url', 'admin/link/edit_post', '', '提交编辑', 1, ''),
(81, 'Admin', 'admin_url', 'admin/link/add', '', '添加友情链接', 1, ''),
(82, 'Admin', 'admin_url', 'admin/link/add_post', '', '提交添加', 1, ''),
(83, 'Api', 'admin_url', 'api/oauthadmin/setting', '', '第三方登陆', 1, ''),
(84, 'Api', 'admin_url', 'api/oauthadmin/setting_post', '', '提交设置', 1, ''),
(85, 'Admin', 'admin_url', 'admin/menu/default', '', '菜单管理', 1, ''),
(86, 'Admin', 'admin_url', 'admin/navcat/default1', '', '前台菜单', 1, ''),
(87, 'Admin', 'admin_url', 'admin/nav/index', '', '菜单管理', 1, ''),
(88, 'Admin', 'admin_url', 'admin/nav/listorders', '', '前台导航排序', 1, ''),
(89, 'Admin', 'admin_url', 'admin/nav/delete', '', '删除菜单', 1, ''),
(90, 'Admin', 'admin_url', 'admin/nav/edit', '', '编辑菜单', 1, ''),
(91, 'Admin', 'admin_url', 'admin/nav/edit_post', '', '提交编辑', 1, ''),
(92, 'Admin', 'admin_url', 'admin/nav/add', '', '添加菜单', 1, ''),
(93, 'Admin', 'admin_url', 'admin/nav/add_post', '', '提交添加', 1, ''),
(94, 'Admin', 'admin_url', 'admin/navcat/index', '', '菜单分类', 1, ''),
(95, 'Admin', 'admin_url', 'admin/navcat/delete', '', '删除分类', 1, ''),
(96, 'Admin', 'admin_url', 'admin/navcat/edit', '', '编辑分类', 1, ''),
(97, 'Admin', 'admin_url', 'admin/navcat/edit_post', '', '提交编辑', 1, ''),
(98, 'Admin', 'admin_url', 'admin/navcat/add', '', '添加分类', 1, ''),
(99, 'Admin', 'admin_url', 'admin/navcat/add_post', '', '提交添加', 1, ''),
(100, 'Admin', 'admin_url', 'admin/menu/index', '', '后台菜单', 1, ''),
(101, 'Admin', 'admin_url', 'admin/menu/add', '', '添加菜单', 1, ''),
(102, 'Admin', 'admin_url', 'admin/menu/add_post', '', '提交添加', 1, ''),
(103, 'Admin', 'admin_url', 'admin/menu/listorders', '', '后台菜单排序', 1, ''),
(104, 'Admin', 'admin_url', 'admin/menu/export_menu', '', '菜单备份', 1, ''),
(105, 'Admin', 'admin_url', 'admin/menu/edit', '', '编辑菜单', 1, ''),
(106, 'Admin', 'admin_url', 'admin/menu/edit_post', '', '提交编辑', 1, ''),
(107, 'Admin', 'admin_url', 'admin/menu/delete', '', '删除菜单', 1, ''),
(108, 'Admin', 'admin_url', 'admin/menu/lists', '', '所有菜单', 1, ''),
(109, 'Admin', 'admin_url', 'admin/setting/default', '', '系统设置', 1, ''),
(110, 'Admin', 'admin_url', 'admin/setting/userdefault', '', '个人信息', 1, ''),
(111, 'Admin', 'admin_url', 'admin/user/userinfo', '', '修改信息', 1, ''),
(112, 'Admin', 'admin_url', 'admin/user/userinfo_post', '', '修改信息提交', 1, ''),
(113, 'Admin', 'admin_url', 'admin/setting/password', '', '修改密码', 1, ''),
(114, 'Admin', 'admin_url', 'admin/setting/password_post', '', '提交修改', 1, ''),
(115, 'Admin', 'admin_url', 'admin/setting/site', '', '网站设置', 1, ''),
(116, 'Admin', 'admin_url', 'admin/setting/site_post', '', '提交修改', 1, ''),
(117, 'Admin', 'admin_url', 'admin/route/index', '', '路由列表', 1, ''),
(118, 'Admin', 'admin_url', 'admin/route/add', '', '路由添加', 1, ''),
(119, 'Admin', 'admin_url', 'admin/route/add_post', '', '路由添加提交', 1, ''),
(120, 'Admin', 'admin_url', 'admin/route/edit', '', '路由编辑', 1, ''),
(121, 'Admin', 'admin_url', 'admin/route/edit_post', '', '路由编辑提交', 1, ''),
(122, 'Admin', 'admin_url', 'admin/route/delete', '', '路由删除', 1, ''),
(123, 'Admin', 'admin_url', 'admin/route/ban', '', '路由禁止', 1, ''),
(124, 'Admin', 'admin_url', 'admin/route/open', '', '路由启用', 1, ''),
(125, 'Admin', 'admin_url', 'admin/route/listorders', '', '路由排序', 1, ''),
(126, 'Admin', 'admin_url', 'admin/mailer/default', '', '邮箱配置', 1, ''),
(127, 'Admin', 'admin_url', 'admin/mailer/index', '', 'SMTP配置', 1, ''),
(128, 'Admin', 'admin_url', 'admin/mailer/index_post', '', '提交配置', 1, ''),
(129, 'Admin', 'admin_url', 'admin/mailer/active', '', '邮件模板', 1, ''),
(130, 'Admin', 'admin_url', 'admin/mailer/active_post', '', '提交模板', 1, ''),
(131, 'Admin', 'admin_url', 'admin/setting/clearcache', '', '清除缓存', 1, ''),
(132, 'User', 'admin_url', 'user/indexadmin/default', '', '会员系统', 1, ''),
(133, 'User', 'admin_url', 'user/indexadmin/default1', '', '用户组', 1, ''),
(134, 'User', 'admin_url', 'user/indexadmin/index', '', '学员管理', 1, ''),
(135, 'User', 'admin_url', 'user/indexadmin/ban', '', '拉黑会员', 1, ''),
(136, 'User', 'admin_url', 'user/indexadmin/cancelban', '', '启用会员', 1, ''),
(137, 'User', 'admin_url', 'user/oauthadmin/index', '', '第三方用户', 1, ''),
(138, 'User', 'admin_url', 'user/oauthadmin/delete', '', '第三方用户解绑', 1, ''),
(139, 'User', 'admin_url', 'user/indexadmin/default3', '', '管理组', 1, ''),
(140, 'Admin', 'admin_url', 'admin/rbac/index', '', '角色管理', 1, ''),
(141, 'Admin', 'admin_url', 'admin/rbac/member', '', '成员管理', 1, ''),
(142, 'Admin', 'admin_url', 'admin/rbac/authorize', '', '权限设置', 1, ''),
(143, 'Admin', 'admin_url', 'admin/rbac/authorize_post', '', '提交设置', 1, ''),
(144, 'Admin', 'admin_url', 'admin/rbac/roleedit', '', '编辑角色', 1, ''),
(145, 'Admin', 'admin_url', 'admin/rbac/roleedit_post', '', '提交编辑', 1, ''),
(146, 'Admin', 'admin_url', 'admin/rbac/roledelete', '', '删除角色', 1, ''),
(147, 'Admin', 'admin_url', 'admin/rbac/roleadd', '', '添加角色', 1, ''),
(148, 'Admin', 'admin_url', 'admin/rbac/roleadd_post', '', '提交添加', 1, ''),
(149, 'Admin', 'admin_url', 'admin/user/index', '', '管理员', 1, ''),
(150, 'Admin', 'admin_url', 'admin/user/delete', '', '删除管理员', 1, ''),
(151, 'Admin', 'admin_url', 'admin/user/edit', '', '管理员编辑', 1, ''),
(152, 'Admin', 'admin_url', 'admin/user/edit_post', '', '编辑提交', 1, ''),
(153, 'Admin', 'admin_url', 'admin/user/add', '', '管理员添加', 1, ''),
(154, 'Admin', 'admin_url', 'admin/user/add_post', '', '添加提交', 1, ''),
(155, 'Admin', 'admin_url', 'admin/plugin/update', '', '插件更新', 1, ''),
(156, 'Course', 'admin_url', 'course/admincoursetype/label', '', '标签管理', 1, ''),
(157, 'Course', 'admin_url', 'course/adminlabel/index', '', '标签管理', 1, ''),
(158, 'Admin', 'admin_url', 'admin/setting/alipay', '', '支付宝配置', 1, ''),
(159, 'Admin', 'admin_url', 'admin/adminorder/index', '', '订单管理', 1, ''),
(160, 'Course', 'admin_url', 'course/adminorder/index', '', '订单列表', 1, ''),
(161, 'Teacher', 'admin_url', 'teacher/center/index', '', '教师管理', 1, ''),
(162, 'Teacher', 'admin_url', 'teacher/admincenter/index', '', '教师管理', 1, ''),
(163, 'Admin', 'admin_url', 'admin/course/index', '', '课程系统', 1, ''),
(164, 'Course', 'admin_url', 'course/admincoursetype/index', '', '分类管理', 1, ''),
(165, 'Course', 'admin_url', 'course/admincourse/index', '', '课程管理', 1, ''),
(166, 'Course', 'admin_url', 'course/adminsection/index', '', '课时管理', 1, ''),
(167, 'Card', 'admin_url', 'card/admincard/index', '', '点卡系统', 1, ''),
(168, 'Admin', 'admin_url', 'admin/storage/index', '', '文件存储', 1, ''),
(169, 'Admin', 'admin_url', 'admin/storage/setting_post', '', '文件存储设置提交', 1, ''),
(170, 'User', 'admin_url', 'user/center/index', '', '学员管理', 1, ''),
(171, 'User', 'admin_url', 'user/center/indexadmin', '', '学员管理', 1, ''),
(172, 'Exam', 'admin_url', 'exam/index/default', '', '考试系统', 1, ''),
(173, 'Exam', 'admin_url', 'exam/exam_shiti/index', '', '试题管理', 1, ''),
(174, 'Exam', 'admin_url', 'exam/exam_kaoshi/index', '', '考试管理', 1, ''),
(175, 'Exam', 'admin_url', 'exam/shiti/index', '', '试题管理', 1, ''),
(176, 'Exam', 'admin_url', 'exam/kaoshi/index', '', '考试管理', 1, ''),
(178, 'Exam', 'admin_url', 'exam/shiti/default', '', '考试系统', 1, ''),
(179, 'Exam', 'admin_url', 'exam/shiti/shitilist', '', '试题管理', 1, ''),
(180, 'Exam', 'admin_url', 'exam/shiti/shijuan', '', '试卷管理', 1, ''),
(181, 'Exam', 'admin_url', 'exam/adminshiti/shitilist', '', '试题管理', 1, ''),
(182, 'Exam', 'admin_url', 'exam/adminshiti/shijuan', '', '试卷管理', 1, ''),
(183, 'EduCloud', 'admin_url', 'educloud/index/index', NULL, '教育云系统', 1, ''),
(184, 'EduCloud', 'admin_url', 'educloud/educloud/getsubaccountlist', NULL, '云点播', 1, ''),
(185, 'Admin', 'admin_url', 'admin/educloud/index', NULL, '账户管理', 1, ''),
(186, 'admin', 'admin_url', 'admin/educloud/getsubaccountinfo', NULL, '账户管理', 1, ''),
(187, 'Admin', 'admin_url', 'admin/educloud/defult', NULL, '教育云系统', 1, ''),
(188, 'Educloud', 'admin_url', 'educloud/educloud/index', NULL, '账户管理', 1, ''),
(189, 'EduCloud', 'admin_url', 'educloud/educloud/buy', NULL, '套餐购买', 1, ''),
(190, 'EduCloud', 'admin_url', 'educloud/educloud/buypackage', NULL, '套餐购买', 1, ''),
(191, 'EduCloud', 'admin_url', 'educloud/educloud/resourceindex', NULL, '资源管理', 1, ''),
(192, 'Admin', 'admin_url', 'admin/educloud/getvideolist', NULL, '资源管理', 1, ''),
(193, 'Admin', 'admin_url', 'admin/educloud/default', NULL, '账户管理', 1, ''),
(194, 'admin', 'admin_url', 'admin/educloud/add', NULL, '创建账户', 1, ''),
(195, 'Admin', 'admin_url', 'admin/educloud/default2', NULL, '资源管理', 1, ''),
(196, 'Admin', 'admin_url', 'admin/educloud/getliveroomlist', NULL, '资源管理', 1, ''),
(197, 'admin', 'admin_url', 'admin/educloud/getplaybacklist', NULL, '回放管理', 1, ''),
(198, 'Admin', 'admin_url', 'admin/educloud/index2', NULL, '点播管理', 1, ''),
(199, 'Admin', 'admin_url', 'admin/educloud/index3', NULL, '直播管理', 1, ''),
(200, 'Admin', 'admin_url', 'admin/educloud/ali_video_account', NULL, '账号绑定', 1, ''),
(201, 'Admin', 'admin_url', 'admin/educloud/ali_account', NULL, '账号绑定', 1, ''),
(202, 'Admin', 'admin_url', 'admin/educloud/ali_videolist', NULL, '视频管理', 1, ''),
(203, 'admin', 'admin_url', 'admin/educloud/qn_count', NULL, '资源管理', 1, ''),
(204, 'admin', 'admin_url', 'admin/educloud/qnlist', NULL, '资料列表', 1, ''),
(205, 'admin', 'admin_url', 'admin/educloud/qncount', NULL, '资料管理', 1, ''),
(206, 'admin', 'admin_url', 'admin/educloud/qncountadd', NULL, '账号绑定', 1, ''),
(207, 'admin', 'admin_url', 'admin/setting/pay', NULL, '支付配置', 1, '');

-- --------------------------------------------------------

--
-- 表的结构 `edu_card`
--

CREATE TABLE IF NOT EXISTS `edu_card` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `card_state` int(2) NOT NULL DEFAULT '0',
  `type_id` int(2) DEFAULT NULL,
  `card_price` int(5) DEFAULT NULL,
  `card_name` varchar(20) DEFAULT NULL,
  `card_pass` varchar(10) DEFAULT NULL,
  `cs_id` int(10) DEFAULT '0',
  `user_id` int(10) DEFAULT '0',
  `use_state` int(2) NOT NULL DEFAULT '0',
  `sale_state` int(2) NOT NULL DEFAULT '0',
  `viptime` int(5) NOT NULL DEFAULT '0',
  `addtime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_cardtype`
--

CREATE TABLE IF NOT EXISTS `edu_cardtype` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `typename` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_chatmsg`
--

CREATE TABLE IF NOT EXISTS `edu_chatmsg` (
  `id` int(8) unsigned NOT NULL AUTO_INCREMENT,
  `content` text,
  `time` int(15) DEFAULT NULL,
  `sender` varchar(20) DEFAULT NULL,
  `pic` varchar(225) DEFAULT NULL,
  `timee` datetime DEFAULT NULL,
  `cs_id` int(6) DEFAULT NULL,
  `channel_id` varchar(40) DEFAULT NULL,
  `uid` int(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_comments`
--

CREATE TABLE IF NOT EXISTS `edu_comments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_table` varchar(100) NOT NULL COMMENT '评论内容所在表，不带表前缀',
  `post_id` int(11) unsigned NOT NULL DEFAULT '0',
  `url` varchar(255) DEFAULT NULL COMMENT '原文地址',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '发表评论的用户id',
  `to_uid` int(11) NOT NULL DEFAULT '0' COMMENT '被评论的用户id',
  `full_name` varchar(50) DEFAULT NULL COMMENT '评论者昵称',
  `email` varchar(255) DEFAULT NULL COMMENT '评论者邮箱',
  `createtime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `content` text NOT NULL COMMENT '评论内容',
  `type` smallint(1) NOT NULL DEFAULT '1' COMMENT '评论类型；1实名评论',
  `parentid` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '被回复的评论id',
  `path` varchar(500) DEFAULT NULL,
  `status` smallint(1) NOT NULL DEFAULT '1' COMMENT '状态，1已审核，0未审核',
  PRIMARY KEY (`id`),
  KEY `comment_post_ID` (`post_id`),
  KEY `comment_approved_date_gmt` (`status`),
  KEY `comment_parent` (`parentid`),
  KEY `table_id_status` (`post_table`,`post_id`,`status`),
  KEY `createtime` (`createtime`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


--
-- 表的结构 `edu_common_action_log`
--

CREATE TABLE IF NOT EXISTS `edu_common_action_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` bigint(20) DEFAULT '0' COMMENT '用户id',
  `object` varchar(100) DEFAULT NULL COMMENT '访问对象的id,格式：不带前缀的表名+id;如posts1表示xx_posts表里id为1的记录',
  `action` varchar(50) DEFAULT NULL COMMENT '操作名称；格式规定为：应用名+控制器+操作名；也可自己定义格式只要不发生冲突且惟一；',
  `count` int(11) DEFAULT '0' COMMENT '访问次数',
  `last_time` int(11) DEFAULT '0' COMMENT '最后访问的时间戳',
  `ip` varchar(15) DEFAULT NULL COMMENT '访问者最后访问ip',
  PRIMARY KEY (`id`),
  KEY `user_object_action` (`user`,`object`,`action`),
  KEY `user_object_action_ip` (`user`,`object`,`action`,`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_config`
--

CREATE TABLE IF NOT EXISTS `edu_config` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `type` int(2) DEFAULT NULL,
  `alipaycount` varchar(30) CHARACTER SET utf8 COLLATE utf8_estonian_ci DEFAULT NULL,
  `pid` varchar(30) CHARACTER SET utf8 COLLATE utf8_estonian_ci DEFAULT NULL,
  `key` varchar(30) CHARACTER SET utf8 COLLATE utf8_estonian_ci DEFAULT NULL,
  `AppId` varchar(30) CHARACTER SET utf8 COLLATE utf8_estonian_ci DEFAULT NULL,
  `SecretId` varchar(30) CHARACTER SET utf8 COLLATE utf8_estonian_ci DEFAULT NULL,
  `SecretKey` varchar(30) CHARACTER SET utf8 COLLATE utf8_estonian_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_coupon`
--

CREATE TABLE IF NOT EXISTS `edu_coupon` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `coupon` varchar(15) NOT NULL COMMENT '优惠券',
  `discount` int(2) NOT NULL COMMENT '优惠力度',
  `sales_state` int(2) NOT NULL COMMENT '1销售，0未销售',
  `used_state` int(2) NOT NULL COMMENT '1已用，0未用',
  `state` int(2) NOT NULL COMMENT '1正常，0禁用',
  `user_id` int(10) NOT NULL COMMENT '所有者ID',
  `addtime` datetime NOT NULL COMMENT '添加时间',
  `timelimit` datetime NOT NULL COMMENT '期限',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_course`
--

CREATE TABLE IF NOT EXISTS `edu_course` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `cs_name` varchar(50) DEFAULT NULL,
  `ty_id` int(5) DEFAULT NULL,
  `cs_teacher` int(5) DEFAULT NULL,
  `cs_addtime` datetime DEFAULT NULL,
  `cs_state` int(2) DEFAULT NULL,
  `is_tuijian` int(2) DEFAULT NULL,
  `cs_price` float(8,2) DEFAULT NULL,
  `cs_picture` varchar(200) DEFAULT NULL,
  `listorder` int(10) DEFAULT NULL,
  `sec_numbers` int(5) DEFAULT NULL,
  `cs_xuni` int(5) DEFAULT NULL,
  `cs_brief` text,
  `top_id` int(5) DEFAULT NULL,
  `mubiao` text,
  `shihe` varchar(200) DEFAULT NULL,
  `labelid` int(2) DEFAULT NULL,
  `stu_numbers` int(5) DEFAULT NULL,
  `course_type` varchar(10) DEFAULT NULL,
  `isover` int(2) DEFAULT '0',
  `youxiaoqi` int(5) DEFAULT '90',
  `ftfaddress` varchar(100) NOT NULL,
  `ftfstarttime` datetime NOT NULL,
  `markedid` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 表的结构 `edu_coursetype`
--

CREATE TABLE IF NOT EXISTS `edu_coursetype` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `name` varchar(200) DEFAULT NULL COMMENT '分类名称',
  `slug` varchar(200) DEFAULT '',
  `description` longtext COMMENT '分类描述',
  `parent` bigint(20) unsigned DEFAULT '0' COMMENT '分类父id',
  `count` bigint(20) DEFAULT '0' COMMENT '分类文章数',
  `path` varchar(500) DEFAULT NULL COMMENT '分类层级关系路径',
  `seo_title` varchar(500) DEFAULT NULL,
  `seo_keywords` varchar(500) DEFAULT NULL,
  `seo_description` varchar(500) DEFAULT NULL,
  `listorder` int(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `status` int(2) NOT NULL DEFAULT '1' COMMENT '状态，1发布，0不发布',
  PRIMARY KEY (`term_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


--
-- 表的结构 `edu_discount`
--

CREATE TABLE IF NOT EXISTS `edu_discount` (
  `int` int(2) NOT NULL AUTO_INCREMENT,
  `c_ids` varchar(1000) NOT NULL,
  `discount` float(2,1) NOT NULL,
  `starttime` datetime NOT NULL,
  `endtime` datetime NOT NULL,
  PRIMARY KEY (`int`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_exam_baoming`
--

CREATE TABLE IF NOT EXISTS `edu_exam_baoming` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `username` varchar(10) DEFAULT NULL COMMENT '用户姓名',
  `userid` int(7) DEFAULT NULL,
  `top_id` int(6) DEFAULT '0' COMMENT '一级目录',
  `type_id` int(6) DEFAULT '0' COMMENT '二级目录',
  `sex` int(2) DEFAULT '0' COMMENT '1男，2女',
  `idnumber` varchar(20) DEFAULT '0' COMMENT '身份证',
  `mobilephone` varchar(13) DEFAULT '0' COMMENT '手机号',
  `fixedphone` varchar(13) DEFAULT '0' COMMENT '固定电话',
  `qq` varchar(13) DEFAULT '0' COMMENT 'qq号',
  `patriarchal` varchar(10) DEFAULT '0' COMMENT '家长姓名',
  `patriarchalphone` varchar(13) DEFAULT '0' COMMENT '家长电话',
  `addtime` datetime DEFAULT NULL,
  `chinese` int(11) DEFAULT NULL COMMENT '语文成绩',
  `maths` int(11) DEFAULT NULL COMMENT '数学成绩',
  `english` int(11) DEFAULT NULL COMMENT '外语成绩',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_exam_kemu`
--

CREATE TABLE IF NOT EXISTS `edu_exam_kemu` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `kemu` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_exam_myerrors`
--

CREATE TABLE IF NOT EXISTS `edu_exam_myerrors` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `uid` int(8) DEFAULT NULL,
  `shitiid` longtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_exam_papers`
--

CREATE TABLE IF NOT EXISTS `edu_exam_papers` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `cs_id` int(6) DEFAULT NULL,
  `teacherid` int(2) DEFAULT NULL,
  `title` varchar(100) DEFAULT NULL,
  `limitedTime` int(4) DEFAULT '0',
  `tingli_id` text,
  `tingli_score` int(3) DEFAULT NULL,
  `single_choice_id` text,
  `single_choice_score` int(3) DEFAULT NULL,
  `fill_id` text,
  `fill_score` int(3) DEFAULT NULL,
  `determine_id` text,
  `determine_score` int(3) DEFAULT NULL,
  `essay_id` text,
  `essay_score` int(3) DEFAULT NULL,
  `material_id` text,
  `material_score` int(3) DEFAULT NULL,
  `lunshu_id` text,
  `lunshu_score` int(3) DEFAULT NULL,
  `anli_id` text,
  `anli_score` int(3) DEFAULT NULL,
  `addtime` datetime DEFAULT NULL,
  `state` int(2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_exam_shiti`
--

CREATE TABLE IF NOT EXISTS `edu_exam_shiti` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `cs_id` int(4) DEFAULT '0',
  `typeid` int(4) DEFAULT '0',
  `teacherid` int(5) DEFAULT '0',
  `uncertain` int(1) DEFAULT '0',
  `stem` text,
  `xa` varchar(800) DEFAULT '0',
  `xb` varchar(800) DEFAULT '0',
  `xc` varchar(800) DEFAULT '0',
  `xd` varchar(800) DEFAULT '0',
  `xe` varchar(800) DEFAULT '0',
  `xf` varchar(800) DEFAULT '0',
  `daan` text,
  `analysis` text,
  `xilieid` int(7) DEFAULT NULL,
  `xielie` int(7) NOT NULL DEFAULT '0',
  `audio` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
-- --------------------------------------------------------

--
-- 表的结构 `edu_exam_shitidone`
--

CREATE TABLE IF NOT EXISTS `edu_exam_shitidone` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `userid` int(8) DEFAULT NULL,
  `shitiid` longtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_exam_tixing`
--

CREATE TABLE IF NOT EXISTS `edu_exam_tixing` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `tixing` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_exam_userpapers`
--

CREATE TABLE IF NOT EXISTS `edu_exam_userpapers` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `userid` int(8) DEFAULT NULL,
  `teacherid` int(6) DEFAULT NULL,
  `papersid` int(8) DEFAULT NULL,
  `tingli` text,
  `choice` text,
  `fill` text,
  `determine` text,
  `essay` text,
  `material` text,
  `lunshu` text NOT NULL,
  `anli` text NOT NULL,
  `tingliscore` int(3) DEFAULT NULL,
  `choicescore` int(3) DEFAULT '0',
  `fillscore` text,
  `determinescore` text,
  `lunshuscore` text NOT NULL,
  `anliscore` text NOT NULL,
  `essayscore` text,
  `materialscore` text,
  `score` int(3) DEFAULT '0',
  `addtime` datetime DEFAULT NULL,
  `readover` int(2) DEFAULT '0',
  `chacktime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_forum_plate`
--

CREATE TABLE IF NOT EXISTS `edu_forum_plate` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) CHARACTER SET utf8 COLLATE utf8_estonian_ci DEFAULT NULL,
  `pic` varchar(100) CHARACTER SET utf8 COLLATE utf8_estonian_ci DEFAULT NULL,
  `brief` varchar(200) CHARACTER SET utf8 COLLATE utf8_estonian_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_forum_praisal`
--

CREATE TABLE IF NOT EXISTS `edu_forum_praisal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `replyid` int(11) DEFAULT NULL,
  `topicid` int(11) DEFAULT NULL,
  `userid` int(11) DEFAULT NULL,
  `content` varchar(1000) DEFAULT NULL,
  `addtime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_forum_reply`
--

CREATE TABLE IF NOT EXISTS `edu_forum_reply` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `topicid` int(5) DEFAULT NULL,
  `userid` int(8) DEFAULT NULL,
  `content` longtext,
  `addtime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_forum_topic`
--

CREATE TABLE IF NOT EXISTS `edu_forum_topic` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `plateid` int(3) DEFAULT NULL,
  `userid` int(8) DEFAULT NULL,
  `topictltle` varchar(50) DEFAULT NULL,
  `topiccontent` longtext,
  `addtime` datetime DEFAULT NULL,
  `replytime` datetime DEFAULT NULL,
  `hits` int(7) DEFAULT '0',
  `istop` int(2) DEFAULT '0',
  `iscream` int(2) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_guestbook`
--

CREATE TABLE IF NOT EXISTS `edu_guestbook` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `full_name` varchar(50) NOT NULL COMMENT '留言者姓名',
  `email` varchar(100) NOT NULL COMMENT '留言者邮箱',
  `title` varchar(255) DEFAULT NULL COMMENT '留言标题',
  `msg` text NOT NULL COMMENT '留言内容',
  `createtime` datetime NOT NULL,
  `status` smallint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_label`
--

CREATE TABLE IF NOT EXISTS `edu_label` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `c_id` int(2) DEFAULT NULL,
  `labelname` varchar(50) DEFAULT NULL,
  `listorder` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_links`
--

CREATE TABLE IF NOT EXISTS `edu_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL COMMENT '友情链接地址',
  `link_name` varchar(255) NOT NULL COMMENT '友情链接名称',
  `link_image` varchar(255) DEFAULT NULL COMMENT '友情链接图标',
  `link_target` varchar(25) NOT NULL DEFAULT '_blank' COMMENT '友情链接打开方式',
  `link_description` text NOT NULL COMMENT '友情链接描述',
  `link_status` int(2) NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0' COMMENT '友情链接评级',
  `link_rel` varchar(255) DEFAULT '',
  `listorder` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- 转存表中的数据 `edu_links`
--

INSERT INTO `edu_links` (`link_id`, `link_url`, `link_name`, `link_image`, `link_target`, `link_description`, `link_status`, `link_rating`, `link_rel`, `listorder`) VALUES
(1, 'http://www.yxtcmf.com', '易学堂官网', '', '_blank', '易学堂官网', 1, 0, '', 0);

-- --------------------------------------------------------

--
-- 表的结构 `edu_live`
--

CREATE TABLE IF NOT EXISTS `edu_live` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `channelname` varchar(100) DEFAULT NULL,
  `outputsourcetype` int(2) DEFAULT NULL,
  `playerpassword` varchar(20) DEFAULT NULL,
  `upstream_address` varchar(200) DEFAULT NULL,
  `channelid` varchar(25) DEFAULT NULL,
  `appid` varchar(15) DEFAULT NULL,
  `sectionid` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_livesection`
--

CREATE TABLE IF NOT EXISTS `edu_livesection` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `csid` int(6) NOT NULL,
  `teacherid` int(5) NOT NULL,
  `secname` varchar(32) NOT NULL,
  `isfree` int(1) DEFAULT '0',
  `starttime` datetime NOT NULL,
  `endtime` datetime NOT NULL,
  `duration` int(3) NOT NULL,
  `url` varchar(100) NOT NULL,
  `param` longtext NOT NULL,
  `mtgkey` varchar(64) NOT NULL,
  `password` varchar(10) NOT NULL,
  `meetingtype` int(2) NOT NULL,
  `meetingnumber` varchar(10) NOT NULL,
  `student_code` varchar(15) DEFAULT NULL,
  `admin_code` varchar(15) DEFAULT NULL,
  `teacher_code` varchar(15) DEFAULT NULL,
  `addtime` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_material`
--

CREATE TABLE IF NOT EXISTS `edu_material` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `cs_id` int(10) DEFAULT NULL,
  `name` varchar(80) DEFAULT NULL,
  `url` varchar(600) DEFAULT NULL,
  `addtime` datetime DEFAULT NULL,
  `sc_id` int(10) DEFAULT NULL,
  `downname` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_menu`
--

CREATE TABLE IF NOT EXISTS `edu_menu` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `parentid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `app` char(20) NOT NULL COMMENT '应用名称app',
  `model` char(20) NOT NULL COMMENT '控制器',
  `action` char(20) NOT NULL COMMENT '操作名称',
  `data` char(50) NOT NULL COMMENT '额外参数',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '菜单类型  1：权限认证+菜单；0：只作为菜单',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态，1显示，0不显示',
  `name` varchar(50) NOT NULL COMMENT '菜单名称',
  `icon` varchar(50) DEFAULT NULL COMMENT '菜单图标',
  `remark` varchar(255) NOT NULL COMMENT '备注',
  `listorder` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT '排序ID',
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `parentid` (`parentid`),
  KEY `model` (`model`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=305 ;

--
-- 转存表中的数据 `edu_menu`
--

INSERT INTO `edu_menu` (`id`, `parentid`, `app`, `model`, `action`, `data`, `type`, `status`, `name`, `icon`, `remark`, `listorder`) VALUES
(1, 0, 'Admin', 'Content', 'default', '', 0, 1, '文章系统', 'th', '', 20),
(7, 1, 'Portal', 'AdminPost', 'index', '', 1, 1, '文章管理', '', '', 1),
(8, 7, 'Portal', 'AdminPost', 'listorders', '', 1, 0, '文章排序', '', '', 0),
(9, 7, 'Portal', 'AdminPost', 'top', '', 1, 0, '文章置顶', '', '', 0),
(10, 7, 'Portal', 'AdminPost', 'recommend', '', 1, 0, '文章推荐', '', '', 0),
(11, 7, 'Portal', 'AdminPost', 'move', '', 1, 0, '批量移动', '', '', 1000),
(12, 7, 'Portal', 'AdminPost', 'check', '', 1, 0, '文章审核', '', '', 1000),
(13, 7, 'Portal', 'AdminPost', 'delete', '', 1, 0, '删除文章', '', '', 1000),
(14, 7, 'Portal', 'AdminPost', 'edit', '', 1, 0, '编辑文章', '', '', 1000),
(15, 14, 'Portal', 'AdminPost', 'edit_post', '', 1, 0, '提交编辑', '', '', 0),
(16, 7, 'Portal', 'AdminPost', 'add', '', 1, 0, '添加文章', '', '', 1000),
(17, 16, 'Portal', 'AdminPost', 'add_post', '', 1, 0, '提交添加', '', '', 0),
(18, 1, 'Portal', 'AdminTerm', 'index', '', 0, 1, '分类管理', '', '', 2),
(19, 18, 'Portal', 'AdminTerm', 'listorders', '', 1, 0, '文章分类排序', '', '', 0),
(20, 18, 'Portal', 'AdminTerm', 'delete', '', 1, 0, '删除分类', '', '', 1000),
(21, 18, 'Portal', 'AdminTerm', 'edit', '', 1, 0, '编辑分类', '', '', 1000),
(22, 21, 'Portal', 'AdminTerm', 'edit_post', '', 1, 0, '提交编辑', '', '', 0),
(23, 18, 'Portal', 'AdminTerm', 'add', '', 1, 0, '添加分类', '', '', 1000),
(24, 23, 'Portal', 'AdminTerm', 'add_post', '', 1, 0, '提交添加', '', '', 0),
(25, 1, 'Portal', 'AdminPage', 'index', '', 1, 1, '页面管理', '', '', 3),
(26, 25, 'Portal', 'AdminPage', 'listorders', '', 1, 0, '页面排序', '', '', 0),
(27, 25, 'Portal', 'AdminPage', 'delete', '', 1, 0, '删除页面', '', '', 1000),
(28, 25, 'Portal', 'AdminPage', 'edit', '', 1, 0, '编辑页面', '', '', 1000),
(29, 28, 'Portal', 'AdminPage', 'edit_post', '', 1, 0, '提交编辑', '', '', 0),
(30, 25, 'Portal', 'AdminPage', 'add', '', 1, 0, '添加页面', '', '', 1000),
(31, 30, 'Portal', 'AdminPage', 'add_post', '', 1, 0, '提交添加', '', '', 0),
(32, 1, 'Admin', 'Recycle', 'default', '', 1, 1, '回收站', '', '', 4),
(33, 32, 'Portal', 'AdminPost', 'recyclebin', '', 1, 1, '文章回收', '', '', 0),
(34, 33, 'Portal', 'AdminPost', 'restore', '', 1, 0, '文章还原', '', '', 1000),
(35, 33, 'Portal', 'AdminPost', 'clean', '', 1, 0, '彻底删除', '', '', 1000),
(36, 32, 'Portal', 'AdminPage', 'recyclebin', '', 1, 1, '页面回收', '', '', 1),
(37, 36, 'Portal', 'AdminPage', 'clean', '', 1, 0, '彻底删除', '', '', 1000),
(38, 36, 'Portal', 'AdminPage', 'restore', '', 1, 0, '页面还原', '', '', 1000),
(39, 0, 'Admin', 'Extension', 'default', '', 0, 1, '扩展工具', 'database', '', 40),
(40, 39, 'Admin', 'Backup', 'default', '', 1, 1, '备份管理', '', '', 0),
(41, 40, 'Admin', 'Backup', 'restore', '', 1, 1, '数据还原', '', '', 0),
(42, 40, 'Admin', 'Backup', 'index', '', 1, 1, '数据备份', '', '', 0),
(43, 42, 'Admin', 'Backup', 'index_post', '', 1, 0, '提交数据备份', '', '', 0),
(44, 40, 'Admin', 'Backup', 'download', '', 1, 0, '下载备份', '', '', 1000),
(45, 40, 'Admin', 'Backup', 'del_backup', '', 1, 0, '删除备份', '', '', 1000),
(46, 40, 'Admin', 'Backup', 'import', '', 1, 0, '数据备份导入', '', '', 1000),
(47, 39, 'Admin', 'Plugin', 'index', '', 1, 0, '插件管理', '', '', 0),
(48, 47, 'Admin', 'Plugin', 'toggle', '', 1, 0, '插件启用切换', '', '', 0),
(49, 47, 'Admin', 'Plugin', 'setting', '', 1, 0, '插件设置', '', '', 0),
(50, 49, 'Admin', 'Plugin', 'setting_post', '', 1, 0, '插件设置提交', '', '', 0),
(51, 47, 'Admin', 'Plugin', 'install', '', 1, 0, '插件安装', '', '', 0),
(52, 47, 'Admin', 'Plugin', 'uninstall', '', 1, 0, '插件卸载', '', '', 0),
(53, 39, 'Admin', 'Slide', 'default', '', 1, 1, '幻灯片', '', '', 1),
(54, 53, 'Admin', 'Slide', 'index', '', 1, 1, '幻灯片管理', '', '', 0),
(55, 54, 'Admin', 'Slide', 'listorders', '', 1, 0, '幻灯片排序', '', '', 0),
(56, 54, 'Admin', 'Slide', 'toggle', '', 1, 0, '幻灯片显示切换', '', '', 0),
(57, 54, 'Admin', 'Slide', 'delete', '', 1, 0, '删除幻灯片', '', '', 1000),
(58, 54, 'Admin', 'Slide', 'edit', '', 1, 0, '编辑幻灯片', '', '', 1000),
(59, 58, 'Admin', 'Slide', 'edit_post', '', 1, 0, '提交编辑', '', '', 0),
(60, 54, 'Admin', 'Slide', 'add', '', 1, 0, '添加幻灯片', '', '', 1000),
(61, 60, 'Admin', 'Slide', 'add_post', '', 1, 0, '提交添加', '', '', 0),
(62, 53, 'Admin', 'Slidecat', 'index', '', 1, 1, '幻灯片分类', '', '', 0),
(63, 62, 'Admin', 'Slidecat', 'delete', '', 1, 0, '删除分类', '', '', 1000),
(64, 62, 'Admin', 'Slidecat', 'edit', '', 1, 0, '编辑分类', '', '', 1000),
(65, 64, 'Admin', 'Slidecat', 'edit_post', '', 1, 0, '提交编辑', '', '', 0),
(66, 62, 'Admin', 'Slidecat', 'add', '', 1, 0, '添加分类', '', '', 1000),
(67, 66, 'Admin', 'Slidecat', 'add_post', '', 1, 0, '提交添加', '', '', 0),
(85, 0, 'Admin', 'Menu', 'default', '', 1, 1, '菜单管理', 'list', '', 30),
(86, 85, 'Admin', 'Navcat', 'default1', '', 1, 1, '前台菜单', '', '', 0),
(87, 86, 'Admin', 'Nav', 'index', '', 1, 1, '菜单管理', '', '', 0),
(88, 87, 'Admin', 'Nav', 'listorders', '', 1, 0, '前台导航排序', '', '', 0),
(89, 87, 'Admin', 'Nav', 'delete', '', 1, 0, '删除菜单', '', '', 1000),
(90, 87, 'Admin', 'Nav', 'edit', '', 1, 0, '编辑菜单', '', '', 1000),
(91, 90, 'Admin', 'Nav', 'edit_post', '', 1, 0, '提交编辑', '', '', 0),
(92, 87, 'Admin', 'Nav', 'add', '', 1, 0, '添加菜单', '', '', 1000),
(93, 92, 'Admin', 'Nav', 'add_post', '', 1, 0, '提交添加', '', '', 0),
(94, 86, 'Admin', 'Navcat', 'index', '', 1, 1, '菜单分类', '', '', 0),
(95, 94, 'Admin', 'Navcat', 'delete', '', 1, 0, '删除分类', '', '', 1000),
(96, 94, 'Admin', 'Navcat', 'edit', '', 1, 0, '编辑分类', '', '', 1000),
(97, 96, 'Admin', 'Navcat', 'edit_post', '', 1, 0, '提交编辑', '', '', 0),
(98, 94, 'Admin', 'Navcat', 'add', '', 1, 0, '添加分类', '', '', 1000),
(99, 98, 'Admin', 'Navcat', 'add_post', '', 1, 0, '提交添加', '', '', 0),
(100, 85, 'Admin', 'Menu', 'index', '', 1, 1, '后台菜单', '', '', 0),
(101, 100, 'Admin', 'Menu', 'add', '', 1, 0, '添加菜单', '', '', 0),
(102, 101, 'Admin', 'Menu', 'add_post', '', 1, 0, '提交添加', '', '', 0),
(103, 100, 'Admin', 'Menu', 'listorders', '', 1, 0, '后台菜单排序', '', '', 0),
(104, 100, 'Admin', 'Menu', 'export_menu', '', 1, 0, '菜单备份', '', '', 1000),
(105, 100, 'Admin', 'Menu', 'edit', '', 1, 0, '编辑菜单', '', '', 1000),
(106, 105, 'Admin', 'Menu', 'edit_post', '', 1, 0, '提交编辑', '', '', 0),
(107, 100, 'Admin', 'Menu', 'delete', '', 1, 0, '删除菜单', '', '', 1000),
(108, 100, 'Admin', 'Menu', 'lists', '', 1, 0, '所有菜单', '', '', 1000),
(109, 0, 'Admin', 'Setting', 'default', '', 0, 1, '系统设置', 'cogs', '', 0),
(110, 109, 'Admin', 'Setting', 'userdefault', '', 0, 1, '个人信息', '', '', 0),
(111, 110, 'Admin', 'User', 'userinfo', '', 1, 1, '修改信息', '', '', 0),
(112, 111, 'Admin', 'User', 'userinfo_post', '', 1, 0, '修改信息提交', '', '', 0),
(113, 110, 'Admin', 'Setting', 'password', '', 1, 1, '修改密码', '', '', 0),
(114, 113, 'Admin', 'Setting', 'password_post', '', 1, 0, '提交修改', '', '', 0),
(115, 109, 'Admin', 'Setting', 'site', '', 1, 1, '网站设置', '', '', 0),
(116, 115, 'Admin', 'Setting', 'site_post', '', 1, 0, '提交修改', '', '', 0),
(117, 115, 'Admin', 'Route', 'index', '', 1, 0, '路由列表', '', '', 0),
(118, 115, 'Admin', 'Route', 'add', '', 1, 0, '路由添加', '', '', 0),
(119, 118, 'Admin', 'Route', 'add_post', '', 1, 0, '路由添加提交', '', '', 0),
(120, 115, 'Admin', 'Route', 'edit', '', 1, 0, '路由编辑', '', '', 0),
(121, 120, 'Admin', 'Route', 'edit_post', '', 1, 0, '路由编辑提交', '', '', 0),
(122, 115, 'Admin', 'Route', 'delete', '', 1, 0, '路由删除', '', '', 0),
(123, 115, 'Admin', 'Route', 'ban', '', 1, 0, '路由禁止', '', '', 0),
(124, 115, 'Admin', 'Route', 'open', '', 1, 0, '路由启用', '', '', 0),
(125, 115, 'Admin', 'Route', 'listorders', '', 1, 0, '路由排序', '', '', 0),
(221, 132, 'User', 'Indexadmin', 'index', '', 1, 1, '学员管理', '', '', 0),
(131, 109, 'Admin', 'Setting', 'clearcache', '', 1, 1, '清除缓存', '', '', 1),
(132, 0, 'User', 'Indexadmin', 'default', '', 1, 1, '会员系统', 'group', '', 10),
(139, 132, 'User', 'Indexadmin', 'default3', '', 1, 1, '管理组', '', '', 1),
(140, 139, 'Admin', 'Rbac', 'index', '', 1, 1, '角色管理', '', '', 0),
(141, 140, 'Admin', 'Rbac', 'member', '', 1, 0, '成员管理', '', '', 1000),
(142, 140, 'Admin', 'Rbac', 'authorize', '', 1, 0, '权限设置', '', '', 1000),
(143, 142, 'Admin', 'Rbac', 'authorize_post', '', 1, 0, '提交设置', '', '', 0),
(144, 140, 'Admin', 'Rbac', 'roleedit', '', 1, 0, '编辑角色', '', '', 1000),
(145, 144, 'Admin', 'Rbac', 'roleedit_post', '', 1, 0, '提交编辑', '', '', 0),
(146, 140, 'Admin', 'Rbac', 'roledelete', '', 1, 1, '删除角色', '', '', 1000),
(147, 140, 'Admin', 'Rbac', 'roleadd', '', 1, 1, '添加角色', '', '', 1000),
(148, 147, 'Admin', 'Rbac', 'roleadd_post', '', 1, 0, '提交添加', '', '', 0),
(149, 139, 'Admin', 'User', 'index', '', 1, 1, '管理员', '', '', 0),
(150, 149, 'Admin', 'User', 'delete', '', 1, 0, '删除管理员', '', '', 1000),
(151, 149, 'Admin', 'User', 'edit', '', 1, 0, '管理员编辑', '', '', 1000),
(152, 151, 'Admin', 'User', 'edit_post', '', 1, 0, '编辑提交', '', '', 0),
(153, 149, 'Admin', 'User', 'add', '', 1, 0, '管理员添加', '', '', 1000),
(154, 153, 'Admin', 'User', 'add_post', '', 1, 0, '添加提交', '', '', 0),
(155, 47, 'Admin', 'Plugin', 'update', '', 1, 0, '插件更新', '', '', 0),
(158, 0, 'Admin', 'Course', 'index', '', 0, 1, '课程系统', '', '', 1),
(159, 158, 'Course', 'AdminCoursetype', 'index', '', 1, 1, '分类管理', '', '', 0),
(160, 158, 'Course', 'AdminCourse', 'index', '', 1, 1, '课程管理', '', '', 0),
(161, 158, 'Course', 'AdminSection', 'index', '', 1, 1, '课时管理', '', '', 0),
(165, 282, 'Card', 'AdminCard', 'index', '', 1, 1, '点卡管理', '', '', 0),
(166, 158, 'Course', 'AdminLabel', 'index', '', 1, 1, '标签管理', '', '', 1),
(167, 0, 'Admin', 'AdminOrder', 'index', '', 1, 1, '订单管理', 'money', '', 5),
(168, 167, 'Course', 'AdminOrder', 'index', '', 1, 1, '订单列表', '', '', 0),
(169, 132, 'Teacher', 'AdminCenter', 'index', '', 1, 1, '教师管理', '', '', 0),
(226, 0, 'Exam', 'shiti', 'default', '', 1, 1, '考试系统', 'clipboard', '', 3),
(227, 226, 'Exam', 'AdminShiti', 'shitilist', '', 1, 1, '试题管理', '', '', 0),
(228, 226, 'Exam', 'AdminShiti', 'shijuan', '', 1, 1, '试卷管理', '', '', 0),
(229, 39, 'Admin', 'Link', 'index', '', 1, 1, '友情链接', '', '', 0),
(230, 159, 'Course', 'AdminCoursetype', 'add', '', 1, 0, '添加分类', '', '', 0),
(231, 159, 'Course', 'AdminCoursetype', 'add_post', '', 1, 0, '提交分类', '', '', 0),
(232, 159, 'Course', 'AdminCoursetype', 'edit', '', 1, 0, '编辑分类', '', '', 0),
(233, 159, 'Course', 'AdminCoursetype', 'edit_post', '', 1, 0, '编辑提交', '', '', 0),
(234, 159, 'Course', 'AdminCoursetype', 'listorders', '', 1, 0, '排序', '', '', 0),
(235, 159, 'Course', 'AdminCoursetype', 'delete', '', 1, 0, '删除分类', '', '', 0),
(236, 229, 'Admin', 'Link', 'add', '', 1, 0, '添加链接', '', '', 0),
(237, 229, 'Admin', 'Link', 'add_post', '', 1, 0, '添加提交', '', '', 0),
(238, 229, 'Admin', 'Link', 'edit', '', 1, 0, '编辑链接', '', '', 0),
(239, 229, 'Admin', 'Link', 'edit_post', '', 1, 0, '编辑提交', '', '', 0),
(240, 160, 'Course', 'AdminCourse', 'add', '', 1, 0, '添加课程', '', '', 0),
(241, 160, 'Course', 'AdminCourse', 'add_post', '', 1, 0, '添加课程提交', '', '', 0),
(242, 160, 'Course', 'AdminCourse', 'edit', '', 1, 0, '编辑课程', '', '', 0),
(243, 160, 'Course', 'AdminCourse', 'edit_post', '', 1, 0, '编辑课程提交', '', '', 0),
(244, 160, 'Course', 'AdminCourse', 'listorders', '', 1, 0, '课程排序', '', '', 0),
(245, 160, 'Course', 'AdminCourse', 'delete', '', 1, 0, '删除课程', '', '', 0),
(246, 160, 'Course', 'AdminCourse', 'check', '', 1, 0, '审核课程', '', '', 0),
(247, 160, 'Course', 'AdminCourse', 'recommend', '', 1, 0, '推荐课程', '', '', 0),
(248, 160, 'Course', 'AdminCourse', 'move', '', 1, 0, '移动课程', '', '', 0),
(249, 161, 'Course', 'AdminSection', 'index_cs', '', 1, 0, '课时列表', '', '', 0),
(250, 160, 'Course', 'AdminMaterial', 'index_cs', '', 1, 0, '资料列表', '', '', 0),
(251, 160, 'Course', 'AdminCourse', 'xueyuan', '', 1, 0, '学员列表', '', '', 0),
(252, 160, 'Course', 'AdminCourse', 'pinglun', '', 1, 0, '评论列表', '', '', 0),
(253, 160, 'Course', 'AdminCourse', 'pinglundel', '', 1, 0, '删除评论', '', '', 0),
(254, 160, 'Course', 'AdminCourse', 'zhibo', '', 1, 0, '直播课程', '', '', 0),
(255, 160, 'Course', 'AdminCourse', 'doc', '', 1, 0, '文本课程', '', '', 0),
(256, 161, 'Course', 'AdminSection', 'check', '', 1, 0, '课时审核', '', '', 0),
(257, 161, 'Course', 'AdminSection', 'isfree', '', 1, 0, '设置免费', '', '', 0),
(258, 161, 'Course', 'AdminSection', 'move', '', 1, 0, '批量移动', '', '', 0),
(259, 161, 'Course', 'AdminSection', 'delete', '', 1, 0, '删除课时', '', '', 0),
(260, 161, 'Course', 'AdminSection', 'listorders', '', 1, 0, '课时排序', '', '', 0),
(261, 161, 'Course', 'AdminSection', 'edit', '', 1, 0, '编辑课时', '', '', 0),
(262, 161, 'Course', 'AdminSection', 'edit_post', '', 1, 0, ' 编辑课时提交', '', '', 0),
(263, 221, 'User', 'Indexadmin', 'detailed', '', 1, 0, '详细信息', '', '', 0),
(264, 221, 'User', 'Indexadmin', 'buycourse', '', 1, 0, '所买课程', '', '', 0),
(265, 221, 'User', 'Indexadmin', 'presentcourse', '', 1, 0, '赠送课程', '', '', 0),
(266, 221, 'User', 'Indexadmin', 'repass', '', 1, 0, '重置密码', '', '', 0),
(267, 266, 'User', 'Indexadmin', 'repass_post', '', 1, 0, '提交数据', '', '', 0),
(268, 221, 'User', 'Indexadmin', 'addmoney', '', 1, 0, '赠送金币', '', '', 0),
(269, 268, 'User', 'Indexadmin', 'addmoney_post', '', 1, 0, '提交数据', '', '', 0),
(270, 265, 'User', 'Indexadmin', 'presentcourse_post', '', 1, 0, '提交数据', '', '', 0),
(271, 221, 'User', 'Indexadmin', 'imporuser', '', 1, 0, '批量导入', '', '', 0),
(272, 221, 'User', 'Indexadmin', 'del', '', 1, 0, '删除会员', '', '', 0),
(273, 221, 'User', 'Indexadmin', 'ban', '', 1, 0, '禁用会员', '', '', 0),
(274, 221, 'User', 'Indexadmin', 'cancelban', '', 1, 0, '解除禁用', '', '', 0),
(275, 169, 'Teacher', 'AdminCenter', 'tcourse', '', 1, 0, '查看课程', '', '', 0),
(276, 169, 'Teacher', 'AdminCenter', 'requery', '', 1, 0, '资格审核', '', '', 0),
(277, 169, 'Teacher', 'AdminCenter', 'creatfolder', '', 1, 0, '创建上传目录', '', '', 0),
(278, 169, 'Teacher', 'AdminCenter', 'folder', '', 1, 0, '查看上传目录', '', '', 0),
(279, 169, 'Teacher', 'AdminCenter', 'adminforum', '', 1, 0, '设置论坛管理员', '', '', 0),
(280, 169, 'Teacher', 'AdminCenter', 'setbili', '', 1, 0, '设置分成比例', '', '', 0),
(281, 280, 'Teacher', 'AdminCenter', 'setbili_post', '', 1, 0, '提交数据', '', '', 0),
(282, 0, 'Market', 'AdminMarket', 'main', '', 0, 1, '营销系统', 'cubes', '', 4),
(283, 282, 'Card', 'AdminCard', 'discount', '', 1, 1, '限时打折', '', '', 0),
(284, 282, 'Card', 'AdminCard', 'coupon', '', 1, 1, '优惠券', '', '', 0),
(285, 282, 'User', 'Indexadmin', 'regpresent', '', 1, 1, '注册奖励', '', '', 0),
(286, 282, 'User', 'Promoters', 'index', '', 1, 1, '课程推广员', '', '', 0),
(287, 0, 'Admin', 'Educloud', 'defult', '', 1, 1, '教育云系统', 'cloud-download', '', 2),
(289, 298, 'Admin', 'Educloud', 'index', '', 1, 1, '账户管理', '', '', 2),
(291, 298, 'Admin', 'Educloud', 'getliveroomlist', '', 1, 1, '资源管理', '', '', 1),
(299, 297, 'Admin', 'Educloud', 'Ali_account', '', 1, 1, '账号绑定', '', '', 2),
(300, 297, 'Admin', 'Educloud', 'Ali_videolist', '', 1, 1, '视频管理', '', '', 1),
(301, 287, 'admin', 'educloud', 'qnCount', '', 1, 1, '资料管理', '', '', 3),
(297, 287, 'Admin', 'Educloud', 'index2', '', 1, 1, '点播管理', '', '', 1),
(298, 287, 'Admin', 'Educloud', 'index3', '', 1, 1, '直播管理', '', '', 2),
(302, 301, 'admin', 'educloud', 'qnList', '', 1, 1, '资料列表', '', '', 1),
(303, 301, 'admin', 'educloud', 'qnCountAdd', '', 1, 1, '账号绑定', '', '', 2);

-- --------------------------------------------------------

--
-- 表的结构 `edu_message`
--

CREATE TABLE IF NOT EXISTS `edu_message` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `touid` int(8) NOT NULL,
  `fromuid` int(8) NOT NULL,
  `type` int(2) NOT NULL,
  `isread` int(2) NOT NULL,
  `content` varchar(300) NOT NULL,
  `addtime` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_mycoupon`
--

CREATE TABLE IF NOT EXISTS `edu_mycoupon` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `couponid` int(10) NOT NULL,
  `userid` int(10) NOT NULL,
  `addtime` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_nav`
--

CREATE TABLE IF NOT EXISTS `edu_nav` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL,
  `parentid` int(11) NOT NULL,
  `label` varchar(255) NOT NULL,
  `target` varchar(50) DEFAULT NULL,
  `href` varchar(255) NOT NULL,
  `icon` varchar(255) NOT NULL,
  `status` int(2) NOT NULL DEFAULT '1',
  `listorder` int(6) DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=26 ;

--
-- 转存表中的数据 `edu_nav`
--

INSERT INTO `edu_nav` (`id`, `cid`, `parentid`, `label`, `target`, `href`, `icon`, `status`, `listorder`, `path`) VALUES
(5, 2, 0, '我是教师', '', 'on', '', 1, 1, '0-5'),
(4, 1, 0, '关于', '', 'a:2:{s:6:"action";s:17:"Portal/Page/index";s:5:"param";a:1:{s:2:"id";s:2:"25";}}', '', 1, 2, '0-4'),
(8, 2, 5, '成为教师', '', 'a:2:{s:6:"action";s:17:"Portal/Page/index";s:5:"param";a:1:{s:2:"id";s:2:"15";}}', '', 1, 0, '0-5-8'),
(7, 2, 5, '发布课程', '', 'a:2:{s:6:"action";s:17:"Portal/Page/index";s:5:"param";a:1:{s:2:"id";s:2:"21";}}', '', 1, 0, '0-5-7'),
(9, 2, 5, '收益提成', '', 'a:2:{s:6:"action";s:17:"Portal/Page/index";s:5:"param";a:1:{s:2:"id";s:1:"2";}}', '', 1, 0, '0-5-9'),
(10, 2, 0, '我是学生', '', 'a:2:{s:6:"action";s:17:"Portal/Page/index";s:5:"param";a:1:{s:2:"id";s:1:"2";}}', '', 1, 0, '0-10'),
(11, 2, 10, '如何注册', '', 'a:2:{s:6:"action";s:17:"Portal/Page/index";s:5:"param";a:1:{s:2:"id";s:2:"21";}}', '', 1, 0, '0-10-11'),
(12, 2, 10, '购买课程', '', 'a:2:{s:6:"action";s:17:"Portal/Page/index";s:5:"param";a:1:{s:2:"id";s:1:"2";}}', '', 1, 0, '0-10-12'),
(13, 2, 10, '如何学习', '', 'a:2:{s:6:"action";s:17:"Portal/Page/index";s:5:"param";a:1:{s:2:"id";s:1:"2";}}', '', 1, 0, '0-10-13'),
(14, 2, 0, '账户管理', '', 'a:2:{s:6:"action";s:17:"Portal/Page/index";s:5:"param";a:1:{s:2:"id";s:1:"2";}}', '', 1, 2, '0-14'),
(15, 2, 14, '系统设置', '', 'a:2:{s:6:"action";s:17:"Portal/Page/index";s:5:"param";a:1:{s:2:"id";s:1:"2";}}', '', 1, 0, '0-14-15'),
(16, 2, 14, '课程设置', '', 'a:2:{s:6:"action";s:17:"Portal/Page/index";s:5:"param";a:1:{s:2:"id";s:1:"2";}}', '', 1, 0, '0-14-16'),
(17, 2, 14, '用户管理', '', 'a:2:{s:6:"action";s:17:"Portal/Page/index";s:5:"param";a:1:{s:2:"id";s:1:"2";}}', '', 1, 0, '0-14-17'),
(18, 2, 0, '加盟网上学院', '', 'a:2:{s:6:"action";s:17:"Portal/Page/index";s:5:"param";a:1:{s:2:"id";s:1:"2";}}', '', 1, 3, '0-18'),
(19, 2, 18, '招商加盟', '', 'a:2:{s:6:"action";s:17:"Portal/Page/index";s:5:"param";a:1:{s:2:"id";s:1:"2";}}', '', 1, 0, '0-18-19'),
(20, 2, 18, '学习卡代理', '', 'a:2:{s:6:"action";s:17:"Portal/Page/index";s:5:"param";a:1:{s:2:"id";s:1:"2";}}', '', 1, 0, '0-18-20'),
(21, 2, 18, '入驻专家团队', '', 'a:2:{s:6:"action";s:17:"Portal/Page/index";s:5:"param";a:1:{s:2:"id";s:1:"2";}}', '', 1, 0, '0-18-21'),
(22, 2, 0, '关于我们', '', 'a:2:{s:6:"action";s:17:"Portal/Page/index";s:5:"param";a:1:{s:2:"id";s:1:"2";}}', '', 1, 4, '0-22'),
(23, 2, 22, '关于我们', '', 'a:2:{s:6:"action";s:17:"Portal/Page/index";s:5:"param";a:1:{s:2:"id";s:1:"2";}}', '', 1, 0, '0-22-23'),
(24, 2, 22, '官方微博', '', 'home', '', 1, 0, '0-22-24'),
(25, 2, 22, '加入我们', '', 'home', '', 1, 0, '0-22-25');

-- --------------------------------------------------------

--
-- 表的结构 `edu_nav_cat`
--

CREATE TABLE IF NOT EXISTS `edu_nav_cat` (
  `navcid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `active` int(1) NOT NULL DEFAULT '1',
  `remark` text,
  PRIMARY KEY (`navcid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- 转存表中的数据 `edu_nav_cat`
--

INSERT INTO `edu_nav_cat` (`navcid`, `name`, `active`, `remark`) VALUES
(1, '主导航', 1, '主导航'),
(2, '底部导航', 0, '底部导航');

-- --------------------------------------------------------

--
-- 表的结构 `edu_notest`
--

CREATE TABLE IF NOT EXISTS `edu_notest` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `c_id` int(6) NOT NULL,
  `s_id` int(6) NOT NULL,
  `u_id` int(8) NOT NULL,
  `content` text NOT NULL,
  `addtime` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

-- --------------------------------------------------------

--
-- 表的结构 `edu_oauth_user`
--

CREATE TABLE IF NOT EXISTS `edu_oauth_user` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `from` varchar(20) NOT NULL COMMENT '用户来源key',
  `name` varchar(30) NOT NULL COMMENT '第三方昵称',
  `head_img` varchar(200) NOT NULL COMMENT '头像',
  `uid` int(20) NOT NULL COMMENT '关联的本站用户id',
  `create_time` datetime NOT NULL COMMENT '绑定时间',
  `last_login_time` datetime NOT NULL COMMENT '最后登录时间',
  `last_login_ip` varchar(16) NOT NULL COMMENT '最后登录ip',
  `login_times` int(6) NOT NULL COMMENT '登录次数',
  `status` tinyint(2) NOT NULL,
  `access_token` varchar(60) NOT NULL,
  `expires_date` int(12) NOT NULL COMMENT 'access_token过期时间',
  `openid` varchar(40) NOT NULL COMMENT '第三方用户id',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_options`
--

CREATE TABLE IF NOT EXISTS `edu_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` int(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- 转存表中的数据 `edu_options`
--

INSERT INTO `edu_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(1, 'site_options', '{"site_name":"\\u6613\\u5b66\\u5802\\u6f14\\u793a\\u7ad9","site_host":"demo.yxtcmf.com","logo":"\\/data\\/upload\\/20190305\\/5c7e03c39f41a.png","kefu_tel":"15853789278","kefu_QQ":"378146005","site_admin_url_password":"","site_tpl":"classics","site_homestyle":"green","site_adminstyle":"flat","site_icp":"","site_admin_email":"admin@123.com","site_tongji":"","site_copyright":"","site_seo_title":"\\u6613\\u5b66\\u5802\\u6f14\\u793a\\u7ad9","site_seo_keywords":"\\u7f51\\u7edc\\u8bfe\\u5802\\uff0c\\u5fae\\u8bfe\\uff0c\\u7ffb\\u8f6c\\u8bfe\\u5802","site_seo_description":"yxtcmf\\u662f\\u6613\\u5b66\\u5802\\u53d1\\u5e03\\u7684\\u4e00\\u6b3e\\u7528\\u4e8e\\u5feb\\u901f\\u5efa\\u7acb\\u7f51\\u6821\\u7684\\u5185\\u5bb9\\u7ba1\\u7406\\u6846\\u67b6","urlmode":"2","html_suffix":"html","seller_email":"","key":"","partner":"","wx_APPID":"","wx_MCHID":"","wx_KEY":"","wx_APPSECRET":"","UCPAAS_accountsid":"","UCPAAS_token":"","UCPAAS_very_appId":"","UCPAAS_MSN_TEMPLATE_ID":"","UCPAAS_FIND_TEMPLATE_ID":"","VIPPRICE":"10","dianboIsOpen":"1","zhiboIsOpen":"1","xianxiaIsOpen":"1","forumIsOpen":"1","mingshiIsOpen":"1","cmfIsOpen":"1","comment_time_interval":0}', 1),
(2, 'cmf_settings', '{"banned_usernames":""}', 1);

-- --------------------------------------------------------

--
-- 表的结构 `edu_order`
--

CREATE TABLE IF NOT EXISTS `edu_order` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `user_id` int(8) DEFAULT NULL,
  `course_id` int(8) DEFAULT NULL,
  `orderid` varchar(20) DEFAULT NULL,
  `pay` varchar(10) NOT NULL,
  `state` int(2) DEFAULT NULL,
  `addtime` datetime DEFAULT NULL,
  `total` float(8,2) DEFAULT NULL,
  `alipayorder` varchar(40) DEFAULT NULL,
  `viptimes` int(2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 转存表中的数据 `edu_order`
--

-- --------------------------------------------------------

--
-- 表的结构 `edu_playpoint`
--

CREATE TABLE IF NOT EXISTS `edu_playpoint` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(8) NOT NULL,
  `cid` int(8) NOT NULL,
  `sid` int(8) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_plugins`
--

CREATE TABLE IF NOT EXISTS `edu_plugins` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `name` varchar(50) NOT NULL COMMENT '插件名，英文',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '插件名称',
  `description` text COMMENT '插件描述',
  `type` tinyint(2) DEFAULT '0' COMMENT '插件类型, 1:网站；8;微信',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态；1开启；',
  `config` text COMMENT '插件配置',
  `hooks` varchar(255) DEFAULT NULL COMMENT '实现的钩子;以“，”分隔',
  `has_admin` tinyint(2) DEFAULT '0' COMMENT '插件是否有后台管理界面',
  `author` varchar(50) DEFAULT '' COMMENT '插件作者',
  `version` varchar(20) DEFAULT '' COMMENT '插件版本号',
  `createtime` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '插件安装时间',
  `listorder` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_posts`
--

CREATE TABLE IF NOT EXISTS `edu_posts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned DEFAULT '0' COMMENT '发表者id',
  `post_keywords` varchar(150) NOT NULL COMMENT 'seo keywords',
  `post_date` datetime DEFAULT '0000-00-00 00:00:00' COMMENT 'post创建日期，永久不变，一般不显示给用户',
  `post_content` longtext COMMENT 'post内容',
  `post_title` text COMMENT 'post标题',
  `post_excerpt` text COMMENT 'post摘要',
  `post_status` int(2) DEFAULT '1' COMMENT 'post状态，1已审核，0未审核',
  `comment_status` int(2) DEFAULT '1' COMMENT '评论状态，1允许，0不允许',
  `post_modified` datetime DEFAULT '0000-00-00 00:00:00' COMMENT 'post更新时间，可在前台修改，显示给用户',
  `post_content_filtered` longtext,
  `post_parent` bigint(20) DEFAULT '0' COMMENT 'post的父级post id,表示post层级关系',
  `post_type` int(2) DEFAULT NULL,
  `post_mime_type` varchar(100) DEFAULT '',
  `comment_count` bigint(20) DEFAULT '0',
  `smeta` text COMMENT 'post的扩展字段，保存相关扩展属性，如缩略图；格式为json',
  `post_hits` int(11) DEFAULT '0' COMMENT 'post点击数，查看数',
  `post_like` int(11) DEFAULT '0' COMMENT 'post赞数',
  `istop` tinyint(1) NOT NULL DEFAULT '0' COMMENT '置顶 1置顶； 0不置顶',
  `recommended` tinyint(1) NOT NULL DEFAULT '0' COMMENT '推荐 1推荐 0不推荐',
  PRIMARY KEY (`id`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`id`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `post_date` (`post_date`) USING BTREE
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=26 ;

--
-- 转存表中的数据 `edu_posts`
--

INSERT INTO `edu_posts` (`id`, `post_author`, `post_keywords`, `post_date`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `post_modified`, `post_content_filtered`, `post_parent`, `post_type`, `post_mime_type`, `comment_count`, `smeta`, `post_hits`, `post_like`, `istop`, `recommended`) VALUES
(25, 1, '关于我们', '2017-03-27 10:20:52', '<p><img src="/ueditor/php/upload/image/20160915/1473949785109042.jpg" alt="1473949785109042.jpg"/>这里是关于我们的内容</p>', '关于', '关于我们', 1, 1, '2017-03-27 10:19:20', NULL, 0, 2, '', 0, '{"template":"pagecontent","thumb":""}', 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- 表的结构 `edu_promoters`
--

CREATE TABLE IF NOT EXISTS `edu_promoters` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(15) NOT NULL,
  `tel` varchar(18) NOT NULL,
  `code` varchar(10) NOT NULL,
  `addtime` datetime NOT NULL,
  `state` int(2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_regpresent`
--

CREATE TABLE IF NOT EXISTS `edu_regpresent` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `key` varchar(20) NOT NULL,
  `value` varchar(20) NOT NULL,
  `parameter` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_role`
--

CREATE TABLE IF NOT EXISTS `edu_role` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL DEFAULT '角色名称',
  `pid` smallint(6) DEFAULT NULL COMMENT '父角色ID',
  `status` tinyint(1) unsigned DEFAULT NULL COMMENT '状态',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `listorder` int(3) NOT NULL DEFAULT '0' COMMENT '排序字段',
  PRIMARY KEY (`id`),
  KEY `parentId` (`pid`),
  KEY `status` (`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- 转存表中的数据 `edu_role`
--

INSERT INTO `edu_role` (`id`, `name`, `pid`, `status`, `remark`, `create_time`, `update_time`, `listorder`) VALUES
(1, '超级管理员', 0, 1, '拥有网站最高管理员权限！', 1329633709, 1329633709, 0),
(2, '课程管理员', 0, 1, '', 1425135402, 1456298242, 0);

-- --------------------------------------------------------

--
-- 表的结构 `edu_role_user`
--

CREATE TABLE IF NOT EXISTS `edu_role_user` (
  `role_id` mediumint(9) unsigned DEFAULT NULL,
  `user_id` char(32) DEFAULT NULL,
  KEY `group_id` (`role_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `edu_route`
--

CREATE TABLE IF NOT EXISTS `edu_route` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '路由id',
  `full_url` varchar(255) DEFAULT NULL COMMENT '完整url， 如：portal/list/index?id=1',
  `url` varchar(255) DEFAULT NULL COMMENT '实际显示的url',
  `listorder` int(5) DEFAULT '0' COMMENT '排序，优先级，越小优先级越高',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态，1：启用 ;0：不启用',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=58 ;

--
-- 转存表中的数据 `edu_route`
--

INSERT INTO `edu_route` (`id`, `full_url`, `url`, `listorder`, `status`) VALUES
(1, 'user/login/index', 'login$', 0, 1),
(2, 'user/register/index', 'register$', 0, 1),
(4, 'page/index/id/25', 'about$', 0, 1),
(5, 'forum/plate/index', 'forum$', 0, 1),
(21, 'portal/index/article', 'article$', 0, 1),
(24, 'course/course/courseinfo', 'courseinfo/:id\\d', 3, 1),
(55, 'course/course/livecourseinfo', 'livecourseinfo/:id\\d', 0, 1),
(28, 'teacher/teacher/about', 'teacherinfo/:id\\d', 2, 1),
(29, 'teacher/teacher/index', 'teacher$', 1, 1),
(31, 'teacher/center/index', 'tcenter$', 0, 1),
(34, 'portal/index/article', 'article/termid/:termid', 1, 1),
(40, 'portal/index/content', 'pcontent/:id', 0, 1),
(41, 'forum/plate/topic', 'topic/:id', 0, 1),
(42, 'forum/plate/thread', 'thread/:id', 0, 1),
(43, 'forum/plate/edittopic', 'edittopic/:id', 0, 1),
(44, 'forum/plate/edit', 'editplate/:id', 0, 1),
(46, 'course/course/coursecenter', 'coursecenter/:topid\\d/:childid\\d/:thirdid\\d/:labelid', 0, 1),
(54, 'course/course/livecourse', 'livecourse$', 0, 1),
(51, 'course/course/livecoursecenter', 'livecenter/:topid\\d/:childid\\d/:thirdid\\d/:labelid', 0, 1),
(52, 'course/course/livecoursecenter', 'livecenter$', 0, 1),
(50, 'course/course/coursecenter', 'coursecenter$', 0, 1),
(56, 'course/course/ftfcourse', 'ftfcourse/:topid\\d/:childid\\d/:thirdid\\d/:labelid', 0, 1),
(57, 'course/course/ftfcourse', 'ftfcourse$', 0, 1);

-- --------------------------------------------------------

--
-- 表的结构 `edu_section`
--

CREATE TABLE IF NOT EXISTS `edu_section` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `cs_id` int(6) DEFAULT NULL,
  `sc_name` varchar(50) DEFAULT NULL,
  `is_free` int(2) NOT NULL DEFAULT '0',
  `sc_time` varchar(16) DEFAULT NULL,
  `playtimes` int(2) DEFAULT NULL,
  `yun_url` varchar(600) DEFAULT NULL,
  `videoid` int(15) NOT NULL,
  `doccontent` longtext,
  `addtime` datetime DEFAULT NULL,
  `state` int(2) DEFAULT NULL,
  `listorder` int(10) DEFAULT NULL,
  `type_id` int(2) NOT NULL COMMENT '"1"为章，"0"为节',
  `zhang_id` int(2) NOT NULL DEFAULT '0',
  `video_type` int(2) DEFAULT NULL COMMENT '"1"为云存储，"2"为优酷视频地址',
  `section_type` int(2) DEFAULT NULL COMMENT '"1"为视频课程，"2"为doc课程',
  `playpass` varchar(10) DEFAULT NULL COMMENT '优酷的播放密码',
  `live_starttime` datetime DEFAULT NULL COMMENT '直播开始时间',
  `videolocation` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_slide`
--

CREATE TABLE IF NOT EXISTS `edu_slide` (
  `slide_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slide_cid` bigint(20) NOT NULL,
  `slide_name` varchar(255) NOT NULL,
  `slide_pic` varchar(255) DEFAULT NULL,
  `slide_url` varchar(255) DEFAULT NULL,
  `slide_des` varchar(255) DEFAULT NULL,
  `slide_content` text,
  `slide_status` int(2) NOT NULL DEFAULT '1',
  `listorder` int(10) DEFAULT '0',
  PRIMARY KEY (`slide_id`),
  KEY `slide_cid` (`slide_cid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- 转存表中的数据 `edu_slide`
--

INSERT INTO `edu_slide` (`slide_id`, `slide_cid`, `slide_name`, `slide_pic`, `slide_url`, `slide_des`, `slide_content`, `slide_status`, `listorder`) VALUES
(2, 1, '在线教育', '/data/upload/20161109/5822d235eeba2.jpg', 'http://www.educmf.com', '在线教育', '在线教育', 1, 0),
(3, 1, '首页', '/data/upload/20161109/5822d2504109d.jpg', 'http://www.educmf.com', '首页', '', 1, 0),
(4, 2, '直播首页', '/data/upload/20190302/5c7a8a19ec1cc.jpg', 'http://www.yxtcmf.com', '', '', 1, 0);

-- --------------------------------------------------------

--
-- 表的结构 `edu_slide_cat`
--

CREATE TABLE IF NOT EXISTS `edu_slide_cat` (
  `cid` bigint(20) NOT NULL AUTO_INCREMENT,
  `cat_name` varchar(255) NOT NULL,
  `cat_idname` varchar(255) NOT NULL,
  `cat_remark` text,
  `cat_status` int(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`cid`),
  KEY `cat_idname` (`cat_idname`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- 转存表中的数据 `edu_slide_cat`
--

INSERT INTO `edu_slide_cat` (`cid`, `cat_name`, `cat_idname`, `cat_remark`, `cat_status`) VALUES
(1, '首页nav幻灯片', 'nav1_', '首页nav幻灯片', 1),
(2, '直播首页幻灯片', 'nav2_', '直播首页幻灯片', 1);

-- --------------------------------------------------------

--
-- 表的结构 `edu_teacher_order`
--

CREATE TABLE IF NOT EXISTS `edu_teacher_order` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `u_id` int(4) DEFAULT NULL,
  `c_id` int(4) DEFAULT NULL,
  `money` float DEFAULT NULL,
  `addtime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_terms`
--

CREATE TABLE IF NOT EXISTS `edu_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `name` varchar(200) DEFAULT NULL COMMENT '分类名称',
  `slug` varchar(200) DEFAULT '',
  `taxonomy` varchar(32) DEFAULT NULL COMMENT '分类类型',
  `description` longtext COMMENT '分类描述',
  `parent` bigint(20) unsigned DEFAULT '0' COMMENT '分类父id',
  `count` bigint(20) DEFAULT '0' COMMENT '分类文章数',
  `path` varchar(500) DEFAULT NULL COMMENT '分类层级关系路径',
  `seo_title` varchar(500) DEFAULT NULL,
  `seo_keywords` varchar(500) DEFAULT NULL,
  `seo_description` varchar(500) DEFAULT NULL,
  `list_tpl` varchar(50) DEFAULT NULL COMMENT '分类列表模板',
  `one_tpl` varchar(50) DEFAULT NULL COMMENT '分类文章页模板',
  `listorder` int(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `status` int(2) NOT NULL DEFAULT '1' COMMENT '状态，1发布，0不发布',
  PRIMARY KEY (`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_term_relationships`
--

CREATE TABLE IF NOT EXISTS `edu_term_relationships` (
  `tid` bigint(20) NOT NULL AUTO_INCREMENT,
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT 'posts表里文章id',
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '分类id',
  `listorder` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `status` int(2) NOT NULL DEFAULT '1' COMMENT '状态，1发布，0不发布',
  PRIMARY KEY (`tid`),
  KEY `term_taxonomy_id` (`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_tixian`
--

CREATE TABLE IF NOT EXISTS `edu_tixian` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `u_id` int(4) DEFAULT NULL,
  `money` int(6) DEFAULT NULL,
  `state` int(2) DEFAULT NULL,
  `addtime` datetime DEFAULT NULL,
  `turename` varchar(10) DEFAULT NULL,
  `count` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_usercourse`
--

CREATE TABLE IF NOT EXISTS `edu_usercourse` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `user_id` int(8) DEFAULT NULL,
  `course_id` int(8) DEFAULT NULL,
  `teacher_id` int(6) DEFAULT NULL,
  `course_price` float(8,2) DEFAULT NULL,
  `state` int(2) DEFAULT NULL,
  `studied` varchar(1000) DEFAULT NULL,
  `pinglun` text,
  `pingluntime` datetime DEFAULT NULL,
  `addtime` datetime DEFAULT NULL,
  `youxiaoqi` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

-- --------------------------------------------------------

--
-- 表的结构 `edu_users`
--

CREATE TABLE IF NOT EXISTS `edu_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '' COMMENT '用户名',
  `user_pass` varchar(64) NOT NULL DEFAULT '' COMMENT '登录密码；sp_password加密',
  `user_nicename` varchar(50) NOT NULL DEFAULT '' COMMENT '用户美名',
  `user_email` varchar(100) NOT NULL DEFAULT '' COMMENT '登录邮箱',
  `user_url` varchar(100) NOT NULL DEFAULT '' COMMENT '用户个人网站',
  `avatar` varchar(255) DEFAULT NULL COMMENT '用户头像，相对于upload/avatar目录',
  `sex` varchar(7) DEFAULT '0' COMMENT '性别；0：保密，1：男；2：女',
  `birthday` date DEFAULT NULL COMMENT '生日',
  `signature` varchar(255) DEFAULT NULL COMMENT '个性签名',
  `last_login_ip` varchar(16) DEFAULT NULL COMMENT '最后登录ip',
  `last_login_time` datetime NOT NULL DEFAULT '2000-01-01 00:00:00' COMMENT '最后登录时间',
  `create_time` datetime NOT NULL DEFAULT '2000-01-01 00:00:00' COMMENT '注册时间',
  `user_activation_key` varchar(60) NOT NULL DEFAULT '' COMMENT '激活码',
  `user_status` int(11) NOT NULL DEFAULT '1' COMMENT '用户状态 0：禁用； 1：正常 ；2：未验证',
  `score` int(11) NOT NULL DEFAULT '0' COMMENT '用户积分',
  `user_type` smallint(1) DEFAULT '1' COMMENT '用户类型，1:admin ;2:会员;3教师',
  `coin` float(8,2) NOT NULL DEFAULT '0.00' COMMENT '金币',
  `mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '手机号',
  `prov` varchar(20) DEFAULT '' COMMENT '省',
  `city` varchar(20) DEFAULT '' COMMENT '市',
  `dist` varchar(20) DEFAULT '' COMMENT '县',
  `weiixn` varchar(40) DEFAULT '' COMMENT '微信',
  `qq` int(15) DEFAULT NULL COMMENT 'QQ',
  `teacstate` int(2) DEFAULT '0' COMMENT '申请教师的状态',
  `chatstate` int(2) DEFAULT '0' COMMENT '直播聊天室的状态0不在线，1在线',
  `zhicheng` varchar(60) DEFAULT NULL COMMENT '教师职称',
  `tcProfile` varchar(600) DEFAULT NULL COMMENT '教师简介',
  `adminplate` int(2) DEFAULT NULL,
  `folderid` int(10) DEFAULT NULL,
  `coins` int(11) NOT NULL DEFAULT '0' COMMENT '金币',
  `errors` int(2) DEFAULT NULL,
  `baijiayuncategory` varchar(20) DEFAULT NULL,
  `aliyuncategory` varchar(20) NOT NULL,
  `PromoterCode` varchar(10) NOT NULL,
  `marketcount` varchar(30) NOT NULL,
  `marketpass` varchar(30) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

-- --------------------------------------------------------

--
-- 表的结构 `edu_user_favorites`
--

CREATE TABLE IF NOT EXISTS `edu_user_favorites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL COMMENT '收藏内容的标题',
  `url` varchar(255) DEFAULT NULL COMMENT '收藏内容的原文地址，不带域名',
  `description` varchar(500) DEFAULT NULL COMMENT '收藏内容的描述',
  `table` varchar(50) DEFAULT NULL COMMENT '收藏实体以前所在表，不带前缀',
  `object_id` int(11) DEFAULT NULL COMMENT '收藏内容原来的主键id',
  `createtime` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `edu_vipuser`
--

CREATE TABLE IF NOT EXISTS `edu_vipuser` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `uid` int(8) NOT NULL,
  `vipcard` varchar(20) NOT NULL,
  `state` int(2) NOT NULL,
  `startime` datetime NOT NULL,
  `endtime` datetime NOT NULL,
  `vipprice` int(5) NOT NULL,
  `duration` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

