<?php
namespace Teacher\Controller;
use Common\Controller\HomebaseController;
require('./Expand/Qiniu/autoload.php');
use Qiniu\Auth;
use Qiniu\Storage\BucketManager;
use vod\Request\V20170321 as vod;
class CenterController extends HomebaseController {
    function _initialize() {
		parent::_initialize();
		$this->check_teacher();
		$this->course_obj = D("Common/Course");
		$this->coursetype_obj = D("Common/Coursetype");
		$this->courseview_obj = D("Common/CourseView");
		$this->user_obj = D("Common/Users");
		$this->label_obj = D("Common/Label");
		$this->section_obj = D("Common/Section");
		$this->livesection_obj = D("Common/Livesection");
		$this->usercourse_obj = D("Common/Usercourse");
		$this->material_obj = D("Common/Material");
		$this->comments_obj = D("Common/Comments");
		$this->teacher_order = D("Common/Teacher_order");
		$this->tixian_obj = D("Common/Tixian");
		$this->application_obj = D("Common/Application");
		$this->shiti_obj = D("Common/Exam_shiti");
		$this->live_obj = D("Common/Live");
		$this->userpapers_obj = D("Common/Exam_userpapers");
		$this->papers_obj = D("Common/Exam_papers");
		$userid=sp_get_current_userid();
		$user=$this->user_obj->where(array('id'=>$userid))->find();
		$avatar=$user['avatar'];
		$this->assign('avatar',$avatar);
		$this->assign('user',$user);
		
	}
	public function index(){
		session('pic',null);
		$where['cs_state']=1;
		$where['cs_teacher']=sp_get_current_userid();
		$where['course_type']='normal';
		$count=$this->course_obj->where($where)->count();
		$page = $this->page($count, 10);
		$courselist=$this->courseview_obj->where($where)->order(array('listorder','id'=>'desc'))->limit($page->firstRow . ',' . $page->listRows)->select();
	     foreach($courselist as $n=> $val){
			$courselist[$n]['xueyuaunshu']=$this->usercourse_obj->where('course_id=\''.$val['id'].'\'')->count();
		}
		$this->assign("Page", $page->show('Admin'));
		$this->assign("current_page",$page->GetCurrentPage());
		$this->assign("courselist",$courselist);
		$this->display();
	}
	public function live(){
		$where['cs_state']=1;
		$where['cs_teacher']=sp_get_current_userid();
		$where['course_type']='live';
		$count=$this->course_obj->where($where)->count();
		$page = $this->page($count, 10);
		$courselist=$this->courseview_obj->where($where)->order(array('listorder','id'=>'desc'))->limit($page->firstRow . ',' . $page->listRows)->select();
	     foreach($courselist as $n=> $val){
			$courselist[$n]['xueyuaunshu']=$this->usercourse_obj->where('course_id=\''.$val['id'].'\'')->count();
		}
		$this->assign("Page", $page->show('Admin'));
		$this->assign("current_page",$page->GetCurrentPage());
		$this->assign("courselist",$courselist);
		$this->display();
	}
	public function doc(){
		$where['cs_state']=1;
		$where['cs_teacher']=sp_get_current_userid();
		$where['course_type']='doc';
		$count=$this->course_obj->where($where)->count();
		$page = $this->page($count, 10);
		$courselist=$this->courseview_obj->where($where)->order(array('listorder','id'=>'desc'))->limit($page->firstRow . ',' . $page->listRows)->select();
	     foreach($courselist as $n=> $val){
			$courselist[$n]['xueyuaunshu']=$this->usercourse_obj->where('course_id=\''.$val['id'].'\'')->count();
		}
		$this->assign("Page", $page->show('Admin'));
		$this->assign("current_page",$page->GetCurrentPage());
		$this->assign("courselist",$courselist);
		$this->display();
	}
	function ftf(){
		$where['cs_state']=1;
		$where['cs_teacher']=sp_get_current_userid();
		$where['course_type']='ftf';
		$count=$this->course_obj->where($where)->count();
		$page = $this->page($count, 10);
		$courselist=$this->courseview_obj->where($where)->order(array('listorder','id'=>'desc'))->limit($page->firstRow . ',' . $page->listRows)->select();
	     foreach($courselist as $n=> $val){
			$courselist[$n]['xueyuaunshu']=$this->usercourse_obj->where('course_id=\''.$val['id'].'\'')->count();
		}
		$this->assign("Page", $page->show('Admin'));
		$this->assign("current_page",$page->GetCurrentPage());
		$this->assign("courselist",$courselist);
		$this->display();
		
	}
	function createcourse(){
		$this->display();
	}
	function coursetype(){
		if(POST){
			$type=I('post.type');
			$title=I('post.title');
			$this->_getTree();
			$term_id = intval(I("get.term"));
			$term=$this->course_obj->where("ty_id=$term_id")->find();
			$domain=sp_get_domain();
			$this->assign("term",$term);
			$this->assign("domain",$domain);
			$this->assign('title',$title);
			$this->assign('type',$type);
			if($type=='normal'){
				if(C('dianboIsOpen')==0){
			        $this->error('录播模块未开启');
				}else{
					$this->display('add');
				}
				
			}
			if($type=='live'){
				if(C('zhiboIsOpen')==0){
			        $this->error('直播模块未开启');
				}else{
					$this->display('addzhibocourse');
				}
			}
			if($type=='doc'){
				
				$this->display('adddoccourse');
			}
			if($type=='ftf'){
				if(C('xianxiaIsOpen')==0){
			        $this->error('线下模块未开启');
				}else{
					$this->display('addftfcourse');
				}
			}
		}
	}
	
	function add_post(){
	if (IS_POST) {
		    $data =I("post.");
			$count=$this->course_obj->count();
			$term_id=intval(I($_POST['ty_id']));
			$typedata=$this->coursetype_obj->where("term_id=$term_id")->find();
			$teacherdata=M('application')->where(array('user_id'=>sp_get_current_userid()))->find();
			$data['cs_teacher']=sp_get_current_userid();
			$data['top_id']=$typedata['parent'];
			$data['cs_addtime']=date('Y-m-d H:i:s');
			$data['cs_state']=1;
			$data['youxiaoqi']=360;
			$data['cs_brief']=htmlspecialchars_decode($data['cs_brief']);
			$data['course_type']=$_POST['type'];
			if ($this->course_obj->add($data)) {
				session('pic',null);
				$this->success("添加成功！",U("Teacher/Center/index"));
			}else{
				$this->error("添加失败！");
			}			
		}
	
	}
    private function _getTree($term_id){
		$result = $this->coursetype_obj->order(array("listorder"=>"asc"))->select();
		
		$tree = new \Tree();
		$tree->icon = array('&nbsp;&nbsp;&nbsp;│ ', '&nbsp;&nbsp;&nbsp;├─ ', '&nbsp;&nbsp;&nbsp;└─ ');
		$tree->nbsp = '&nbsp;&nbsp;&nbsp;';
		foreach ($result as $r) {
			$r['str_manage'] = '<a href="' . U("AdminCoursetype/add", array("parent" => $r['term_id'])) . '">添加子类</a> | <a href="' . U("AdminTerm/edit", array("id" => $r['term_id'])) . '">修改</a> | <a class="J_ajax_del" href="' . U("AdminTerm/delete", array("id" => $r['term_id'])) . '">删除</a> ';
			$r['visit'] = "<a href='#'>访问</a>";
			$r['taxonomys'] = $this->taxonomys[$r['taxonomy']];
			$r['id']=$r['term_id'];
			$r['parentid']=$r['parent'];
			$r['selected']=$term_id==$r['term_id']?"selected":"";
			$array[] = $r;
		}
		$tree->init($array);
		$str="<option value='\$id' \$selected>\$spacer\$name</option>";
		$taxonomys = $tree->get_tree(0, $str);
		$this->assign("taxonomys", $taxonomys);
	}
	
    function Labelselect(){
       $c_id=intval(I("get.id"));
       $label = $this->label_obj->order(array("id"=>"asc"))->where(array('c_id'=>$c_id))->select();
       $json_string = json_encode($label);
       echo $json_string;
    }
    function addsection(){
        $cs_id=  intval(I("get.cs_id"));
		$cs_data=$this->course_obj->where("id=$cs_id")->find();
		$cs_name=$this->course_obj->where("id=$cs_id")->getField('cs_name');
		$cs_pic=$this->course_obj->where("id=$cs_id")->getField('cs_picture');
		$where['cs_id']=$cs_id;
		$where['type_id']=1;
		$videolocation=C('yuntype');
		$zhang_list=$this->section_obj->where($where)->order("id DESC")->select();
		$this->assign("cs_data",$cs_data);
		$this->assign("cs_type",$cs_data['course_type']);
		$this->assign("cs_id",$cs_id);
		$this->assign("zhang_list",$zhang_list);
		$this->assign("cs_data",$cs_name);
		$this->assign("cs_pic",$cs_pic);
		$this->assign("videolocation",$videolocation);
		$this->display();
    }
	
    function addsection_post(){
		if (IS_POST) {
			if ($data=$this->section_obj->create()) {
				$data['state']=1;
			     if($data['video_type']==1){
					$data['yun_url']=I('post.yun_url');
				 }
				 if($data['video_type']==2){
				    $data['yun_url']=I('post.youku_url');
				    $data['playpass']=I('post.playpass');
				 }
				 if($data['video_type']==3){
					 $data['yun_url']=I('post.audio_yun_url');
				 }
				if ($this->section_obj->add($data)!==false) {
					$this->success("添加成功！",U("Teacher/Center/sectionlist",array('cs_id'=>$data['cs_id'])));
				} else {
					$this->error("添加失败！");
				}
			} else {
				$this->error($this->section_obj->getError());
			}
		}
    }
	
	function coursedelete(){
		if(isset($_GET['id'])){
			$id = intval(I("get.id"));
			if ($this->course_obj->delete($id)!==false) {
				$this->success("删除成功！");
			} else {
				$this->error("删除失败！");
			}
		}
	}
	function addlivesection(){
        $cs_id=  intval(I("get.cs_id"));
		$cs_data=$this->course_obj->where("id=$cs_id")->find();
		$this->assign("cs_data",$cs_data);
		$this->assign("cs_id",$cs_id);
		$this->display();
    }
	function addlivesection_post(){
        $data=$this->livesection_obj->create();
        if(!$data['isfree']){
            $data['isfree']=0;
        }
        if(!$data['secname']){
            $this->error('请填写标题！');
        }
        $info = $this->get_site_info();
        $endtime=date('Y-m-d H:i:s',strtotime($data['starttime'])+$data['duration']*60);
        $postdata=$info;
        $postdata['live_starttime'] = $data['starttime'];
        $postdata['duration'] =$data['duration'];
        $postdata['title'] = $data['secname'];
        $postdata['live_type'] = $data['meetingtype'];
        $postdata['max_users'] = I("post.max_users");
        $url=$url=$info['server']."/api/educloud/createlive";
        $res = json_decode($res = post_curl($url, $postdata), true);
        $roominfo=$res['data'];
        if($res['code']==0){
            $adddate['csid']=$data['csid'];
            $adddate['teacherid']=sp_get_current_userid();
            $adddate['secname']=$data['secname'];
            $adddate['isfree']=$data['isfree'];
            $adddate['starttime']=$data['starttime'];
            $adddate['endtime']=$endtime;
            $adddate['duration']=$data['duration'];
            $adddate['url']=$roominfo['room_id'];
            $adddate['addtime']=date('Y-m-d H:i:s',time());
            $adddate['student_code']=$roominfo['student_code'];
            $adddate['admin_code']=$roominfo['admin_code'];
            $adddate['teacher_code']=$roominfo['teacher_code'];
            if($this->livesection_obj->add($adddate)){
                $this->success("添加成功！",U("Teacher/Center/sectionlist",array('cs_id'=>$data['csid'])));
            } else{
                $this->error('创建房间成功，但写入数据失败');
            }
        }else{
            $this->error($res['msg']);
        }
        dump($res);
    }
	function adddocsection(){
        $cs_id=  intval(I("get.cs_id"));
		$cs_data=$this->course_obj->where("id=$cs_id")->find();
		$where['cs_id']=$cs_id;
		$where['type_id']=1;
		$zhang_list=$this->section_obj->where($where)->order("id DESC")->select();
		$this->assign("cs_data",$cs_data);
		$this->assign("cs_id",$cs_id);
		$this->assign("zhang_list",$zhang_list);
		$this->display();
    }
	function adddocsection_post(){
		if (IS_POST) {
			if ($data=$this->section_obj->create()) {
			     $data['doccontent']=htmlspecialchars_decode($data['doccontent']);
				if ($this->section_obj->add($data)!==false) {
					
					$this->success("添加成功！",U("Teacher/Center/sectionlist",array('cs_id'=>$data['cs_id'])));
					
				} else {
					$this->error("添加失败！");
				}
			} else {
				$this->error($this->section_obj->getError());
			}
		}
    }
    function addzhang(){
        $cs_id=  intval(I("get.cs_id"));
		$this->assign("cs_id",$cs_id);
		$this->display();   
    }
    function addzhang_post(){
        if (IS_POST) {
        	
		    $data['cs_id']=intval(I("post.cs_id"));
		    $data['type_id']=intval(I("post.type_id"));
		    $data['sc_name']=I("post.sc_name");
		    $data['addtime']=I("post.addtime");
		    $data['state']=1;
		    if($data['sc_name']==null){
		       $this->error("请填写章节名称！");
		    }
			$result=$this->section_obj->add($data);
			if ($result) {
				
					$this->success("添加成功！" );
				}else{
					$this->error("添加失败！");
				}			
		}
	}
	function addvideo(){
	  	$this->display();
	}
    
   function sectionlist(){
        $id=intval(I("get.cs_id"));
		$cs_name=$this->course_obj->where("id=$id")->getField('cs_name');
		$cs_pic=$this->course_obj->where("id=$id")->getField('cs_picture');
		$cs_type=$this->course_obj->where("id=$id")->getField('course_type');
		
		if($cs_type=='live'){
			$count=$this->livesection_obj->where(array('csid'=>$id))->count();
		    $page = $this->page($count, 10);
			$sc_data=$this->livesection_obj->where(array('csid'=>$id))->limit($page->firstRow . ',' . $page->listRows)->order("id desc")->select();
			foreach($sc_data as $n=> $val){
				if(strtotime(date('Y-m-d H:i:s', time()))<strtotime($sc_data[$n]['starttime'])){
					$sc_data[$n]['livestate']=0;
				};
				if(strtotime($sc_data[$n]['starttime'])<strtotime(date('Y-m-d H:i:s',time())) and strtotime(date('Y-m-d H:i:s',time()))<strtotime($sc_data[$n]['endtime'])){
					$sc_data[$n]['livestate']=1;
				}; 
				if(strtotime(date('Y-m-d H:i:s', time()))>strtotime($sc_data[$n]['endtime'])){
					$sc_data[$n]['livestate']=2;
			   };
	    	}
		}else{
			$count=$this->section_obj->where(array('cs_id'=>$id,'type_id'=>0))->count();
		    $page = $this->page($count, 10);
			$sc_data=$this->section_obj->where(array('cs_id'=>$id,'type_id'=>0))->limit($page->firstRow . ',' . $page->listRows)->order("id desc")->select();
		   
		}
		$this->assign("sc_data",$sc_data);
	    $this->assign("cs_id",$id);
		$this->assign("cs_type",$cs_type);
	    $this->assign("cs_name",$cs_name);
		$this->assign("cs_pic",$cs_pic);
	    $this->assign("Page", $page->show('Admin'));
		$this->assign("current_page",$page->GetCurrentPage());
		$this->display();
   }
   function courseedit(){
   	    $id=  intval(I("get.id"));
   	    $cs_date=$this->course_obj->where("id=$id")->find();
   	    $this->_getTree($cs_date['ty_id']);
   	    $labelname=$this->label_obj->where(array('id'=>$cs_date['labelid']))->getField('labelname');
   	    $this->assign("cs_date",$cs_date);
   	    $this->assign("labelname",$labelname);
		if($cs_date['course_type']=='ftf'){
			 $this->display('ftfcourseedit');
		}else{
			 $this->display();
		}
   }
    function courseedit_post(){
		if (IS_POST) {
			$id=intval(I("post.id"));
			$data = $this->course_obj->create(); 
			$data['cs_brief']=htmlspecialchars_decode($data['cs_brief']);
			$result=$this->course_obj->where("id=$id")->save($data);
			if ($result) {
				
					$this->success("编辑成功！",U("Teacher/Center/index"));
				}else{
					$this->error("编辑失败！");
				}			
		}
    }
    function coursedel(){
       if(isset($_GET['id'])){
			$id = intval(I("get.id"));
			if ($this->course_obj->delete($id)!==false) {
				$this->success("删除成功！",U("Teacher/Center/index"));
			} else {
				$this->error("删除失败！");
			}
		}
		if(isset($_POST['ids'])){
			$tids=htmldecode(join(",",$_POST['ids']));
			if ($this->course_obj->where("id in ($tids)")->delete()) {
				$this->success("删除成功！");
			} else {
				$this->error("删除失败！");
			}
		}
    }
	function addnotice(){
		$id=intval(I($_POST['id']));
		$cid=$this->livesection_obj->where("id=$id")->getField('csid');
		$startTime=$this->livesection_obj->where("id=$id")->getField('starttime');
		$cname=$this->course_obj->where(array('id'=>$cid))->getField('cs_name');
		$user=$this->usercourse_obj->where(array('course_id'=>$cid))->select();
		foreach($user as $n=> $val){
			$RecNum=$this->user_obj->where(array('id'=>$user[$n]['user_id']))->getField('mobile');
			$userName=$this->user_obj->where(array('id'=>$user[$n]['user_id']))->getField('user_nicename');
			$coursename=$cname;
			$smsTemplateCode=C('RONGLIAN_NOTE_TEMPLATE_ID');
			if(send_note_code($RecNum,$userName,$coursename,$startTime,$smsTemplateCode)){
					$result['success']=true;
					$result['message']="发送成功！";
				 }else{
					$result['success']=false;
					$result['message']="发送失败！";
				 }
				 
		}
		 $json_string = json_encode($result);
		 echo $json_string; 
	}
    function secedit(){
        $id=  intval(I("get.id"));
		$section=$this->section_obj->where("id=$id")->find();
		$cs_name=$this->course_obj->where(array('id'=>$section['cs_id']))->getField('cs_name');
		$cs_type=$this->course_obj->where(array('id'=>$section['cs_id']))->getField('course_type');
		$cs_id=$this->course_obj->where(array('id'=>$section['cs_id']))->getField('id');
		$course = $this->course_obj->order(array("listorder"=>"asc"))->select();
		$this->assign("course",$course);
		$this->assign("cs_id",$cs_id);
		$this->assign("cs_type",$cs_type);
		$this->assign("cs_name",$cs_name);
		$this->assign("section",$section);
		$this->display();
    }
	function livsecedit(){
        $id=  intval(I("get.id"));
		$section=$this->livesection_obj->where("id=$id")->find();
		$cs_name=$this->course_obj->where(array('id'=>$section['csid']))->getField('cs_name');
		$cs_type=$this->course_obj->where(array('id'=>$section['csid']))->getField('course_type');
		$cs_id=$this->course_obj->where(array('id'=>$section['csid']))->getField('id');
		$course = $this->course_obj->order(array("listorder"=>"asc"))->select();
		$this->assign("course",$course);
		$this->assign("cs_id",$cs_id);
		$this->assign("cs_type",$cs_type);
		$this->assign("cs_name",$cs_name);
		$this->assign("section",$section);
		$this->display();
    }
	function docedit(){
        $id=  intval(I("get.id"));
		$section=$this->section_obj->where("id=$id")->find();
		$section['doccontent']=htmlspecialchars_decode($section['doccontent']);
		$cs_name=$this->course_obj->where(array('id'=>$section['cs_id']))->getField('cs_name');
		$cs_type=$this->course_obj->where(array('id'=>$section['cs_id']))->getField('course_type');
		$cs_id=$this->course_obj->where(array('id'=>$section['cs_id']))->getField('id');
		$course = $this->course_obj->order(array("listorder"=>"asc"))->select();
		$this->assign("course",$course);
		$this->assign("cs_id",$cs_id);
		$this->assign("cs_type",$cs_type);
		$this->assign("cs_name",$cs_name);
		$this->assign("section",$section);
		$this->display();
    }
    function secdelete(){
        if(isset($_GET['id'])){
			$id = intval(I("get.id"));
			if ($this->section_obj->delete($id)!==false) {
				$this->success("删除成功！");
			} else {
				$this->error("删除失败！");
			}
		}
		if(isset($_POST['ids'])){
			$tids=htmldecode(join(",",$_POST['ids']));
			if ($this->section_obj->where("id in ($tids)")->delete()) {
				$this->success("删除成功！");
			} else {
				$this->error("删除失败！");
			}
		}
    
    }
	function livesecdelete(){
        if(isset($_GET['id'])){
			$id = intval(I("get.id"));
			if ($this->livesection_obj->delete($id)!==false) {
				$this->success("删除成功！");
			} else {
				$this->error("删除失败！");
			}
		}
		if(isset($_POST['ids'])){
			$tids=htmldecode(join(",",$_POST['ids']));
			if ($this->livesection_obj->where("id in ($tids)")->delete()) {
				$this->success("删除成功！");
			} else {
				$this->error("删除失败！");
			}
		}
    
    }
    function secedit_post(){
       if (IS_POST) {
     		$id=  intval(I("post.id"));
			if ($data=$this->section_obj->create()) {
				if($data['video_type']==1){
					$data['yun_url']=I('post.yun_url');
					$data['videolocation']=C('yuntype');
				}else{
				    $data['yun_url']=I('post.youku_url');
				    $data['playpass']=I('post.playpass');
				}
				if ($this->section_obj->where("id=$id")->save($data)!==false) {
					$this->success("编辑成功！");
				} else {
					$this->error("编辑失败！");
				}
			} else {
				$this->error($this->section_obj->getError());
			}
		}
    }
	function livsecedit_post(){
       if (IS_POST) {
     		$id=  intval(I("post.id"));
			$data['secname']=I("post.secname");
			$data['duration']=I("post.duration");
			$data['starttime']=date('Y-m-d H:i:s',strtotime(I("post.starttime")));
		    $data['endtime']=date('Y-m-d H:i:s',strtotime(I("post.starttime"))+$data['duration']*60);
			$data['meetingtype']=I("post.meetingtype");
			if ($this->livesection_obj->where("id=$id")->save($data)!==false) {
				$this->success("编辑成功！" );
			} else {
				$this->error("编辑失败！");
			}
			
		}
    }
	function docedit_post(){
       if (IS_POST) {
     		$id=  intval(I("post.id"));
			if ($data=$this->section_obj->create()) {
				$data['doccontent']=htmlspecialchars_decode($data['doccontent']);
				if ($this->section_obj->where("id=$id")->save($data)!==false) {
					$this->success("编辑成功！");
				} else {
					$this->error("编辑失败！");
				}
			} else {
				$this->error($this->section_obj->getError());
			}
		}
    }
    function xueyuanlist(){
    	$id= empty((I("get.cs_id")))? (I("post.cs_id")):(I("get.cs_id"));
		$cs_name=$this->course_obj->where("id=$id")->getField('cs_name');
		$cs_type=$this->course_obj->where("id=$id")->getField('course_type');
		$cs_pic=$this->course_obj->where("id=$id")->getField('cs_picture');
		if($cs_type=='ftf'){
			$ispay=I("post.ispay");
			$tel=I("post.telphone");
			$option=I("post.option");
			$u_id=$this->user_obj->where(array('mobile'=>$tel))->getField('id');
			$uid=empty($u_id)?"-1":$u_id;
			if(!empty($tel)){
				$where_ands=empty($ispay)?array("course_id=$id and user_id=$uid" ):array("state=$ispay and course_id=$id and user_id=$uid");
			}else{
				$where_ands=empty($ispay)?array("course_id=$id" ):array("state=$ispay and course_id=$id");
			}
			$fields=array(
				'start_time'=> array("field"=>"addtime","operator"=>">"),
				'end_time'  => array("field"=>"addtime","operator"=>"<"),
			);
			if(IS_POST){
				
				foreach ($fields as $param =>$val){
					if (isset($_POST[$param]) && !empty($_POST[$param])) {
						$operator=$val['operator'];
						$field   =$val['field'];
						$get=$_POST[$param];
						$_GET[$param]=$get;
						if($operator=="like"){
							$get="%$get%";
						}
						array_push($where_ands, "$field $operator '$get'");
					}
				}
			}else{
				foreach ($fields as $param =>$val){
					if (isset($_GET[$param]) && !empty($_GET[$param])) {
						$operator=$val['operator'];
						$field   =$val['field'];
						$get=$_GET[$param];
						if($operator=="like"){
							$get="%$get%";
						}
						array_push($where_ands, "$field $operator '$get'");
					}
				}
			}
			
		    $where= join(" and ", $where_ands);
			$count=$this->usercourse_obj->where($where)->count();
			$page = $this->page($count, 20);
			$xueyuan=$this->usercourse_obj->where($where)->limit($page->firstRow . ',' . $page->listRows)->select();
			foreach($xueyuan as $n=> $val){  
				$xueyuanexport[$n]['id']=$xueyuan[$n]['id'];
				$xueyuanexport[$n]['nicename']=$this->user_obj->where(array('id'=>$xueyuan[$n]['user_id']))->getField('user_nicename');
				$xueyuanexport[$n]['tel']=$this->user_obj->where(array('id'=>$xueyuan[$n]['user_id']))->getField('mobile');
				$xueyuanexport[$n]['addtime']=$xueyuan[$n]['addtime'];	
				$xueyuan[$n]['tel']=$this->user_obj->where(array('id'=>$xueyuan[$n]['user_id']))->getField('mobile');				
	        } 
			if($option=="import"){
				 $xlsName=$cs_name."报名信息";
				 $xlsCell  = array(
					array('id','题型ID'),
					array('nicename','用户名'),
					array('tel','手机号'),
					array('addtime','报名时间'),
				);
				$this->exportExcel($xlsName,$xlsCell,$xueyuanexport);
			}
			
		}else{
			$count=$this->usercourse_obj->where(array('course_id'=>$id))->count();
		    $page = $this->page($count, 20);
			$xueyuan=$this->usercourse_obj->where(array('course_id'=>$id))->limit($page->firstRow . ',' . $page->listRows)->select();
			foreach($xueyuan as $n=> $val){           
				 $urlArr = explode("|",$xueyuan[$n]['studied']);  
				 $jnum=count( $urlArr)-1;
				 $cs_id=$xueyuan[$n][course_id];
				 $znum=$this->section_obj->where(array("cs_id"=>$cs_id))->count();
				 $xueyuan[$n]['bili'] = round (($jnum/$znum)*100);
				 $xueyuan[$n]['jnum']=$jnum;
				 $xueyuan[$n]['znum']=$znum;
				 $xueyuan[$n]['tel']=$this->user_obj->where(array('id'=>$xueyuan[$n]['user_id']))->getField('mobile');
	        } 
		}
	    $this->assign("Page", $page->show('Admin'));
		$this->assign("cs_type",$cs_type);
		$this->assign("current_page",$page->GetCurrentPage()); 
		$this->assign("xueyuan",$xueyuan);
	    $this->assign("cs_name",$cs_name);
		$this->assign("cs_pic",$cs_pic);
	    $this->assign("cs_id",$id);
		if($cs_type=='ftf'){
			$this->display('ftfxueyuanlist');
		}else{
			$this->display();
		}
		
    }
	public function exportExcel($expTitle,$expCellName,$expTableData){
        $xlsTitle = iconv('utf-8', 'gb2312', $expTitle);
        $fileName = $xlsTitle;
        $cellNum = count($expCellName);
        $dataNum = count($expTableData);
        vendor('Classes.PHPExcel');
        $objPHPExcel = new \ PHPExcel();
        $cellName = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','AA','AB','AC','AD','AE','AF','AG','AH','AI','AJ','AK','AL','AM','AN','AO','AP','AQ','AR','AS','AT','AU','AV','AW','AX','AY','AZ');
        $objPHPExcel->getActiveSheet()->setTitle($expTitle);
        $objPHPExcel->getActiveSheet(0)->mergeCells('A1:'.$cellName[$cellNum-1].'1');
        for($i=0;$i<$cellNum;$i++){
            $objPHPExcel->setActiveSheetIndex(0)->setCellValue($cellName[$i].'2', $expCellName[$i][1]);
        }
        for($i=0;$i<$dataNum;$i++){
          for($j=0;$j<$cellNum;$j++){
            $objPHPExcel->getActiveSheet(0)->setCellValue($cellName[$j].($i+3),' ' . $expTableData[$i][$expCellName[$j][0]]);
          }
        }
        header('pragma:public');
        header('Content-type:application/vnd.ms-excel;charset=utf-8;name="'.$xlsTitle.'.xls"');
        header("Content-Disposition:attachment;filename=$fileName.xls");
        $objWriter = \ PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }
    function material(){
    	$id=  intval(I("get.cs_id"));
		$cs_name=$this->course_obj->where("id=$id")->getField('cs_name');
		$cs_type=$this->course_obj->where("id=$id")->getField('course_type');
		$cs_pic=$this->course_obj->where("id=$id")->getField('cs_picture');
		$cs_id=$this->course_obj->where(array('id'=>$section['cs_id']))->getField('id');
		$count=$this->material_obj->where("cs_id=$id")->count();
		$page = $this->page($count, 10);
		$ma_data=$this->material_obj->where("cs_id=$id")->order("id ASC")->limit($page->firstRow . ',' . $page->listRows)->order("id ASC")->select();
        foreach($ma_data as $n=> $val){
			$ma_data[$n]['scname']=$this->section_obj->where('id=\''.$val['sc_id'].'\'')->getField('sc_name');
		}
	    $this->assign("ma_data",$ma_data);
		$this->assign("cs_type",$cs_type);
        $this->assign("cs_id",$id);
		$this->assign("cs_name",$cs_name);
		$this->assign("cs_pic",$cs_pic);
		$this->assign("Page", $page->show('Admin'));
		$this->assign("current_page",$page->GetCurrentPage());
		if($cs_type=='ftf'){
			$this->display('ftfmaterial');
		}else{
			$this->display();
		}
    }
    function materialadd(){
    	$id=  intval(I("get.cs_id"));
    	$sc_id=  intval(I("get.sc_id"));
		$cs_name=$this->course_obj->where("id=$id")->getField('cs_name');
		$cs_type=$this->course_obj->where("id=$id")->getField('course_type');
		$cs_id=$this->course_obj->where(array('id'=>$section['cs_id']))->getField('id');
		$this->assign("cs_id",$id);
		$this->assign("sc_id",$sc_id);
		$this->assign("cs_name",$cs_name);
        if($cs_type=='ftf'){
			$this->display('ftfmaterialadd');
		}else{
			$this->display();
		}
		
    }
    function materialadd_post(){
       if (IS_POST) {
			$data = $this->material_obj->create();
			if($data['name']==null) {
				$this->error("资料标题不能为空！");
			}
		    if($data['url']==null) {
				$this->error("下载地址不能为空！");
			}
			$result=$this->material_obj->add($data);
			if ($result) {
					$this->success("添加成功！",U("Teacher/Center/material",array('cs_id'=>$data['cs_id'])));
				}else{
					$this->error("添加失败！");
				}			
			 
		}
    	
    }
	function materialedit(){
		$id=  intval(I("get.id"));
		$data = $this->material_obj->where(array('id'=>$id))->find();
		$cs_type=$this->course_obj->where(array('id'=>$data['cs_id']))->getField('course_type');
		$this->assign("cs_type",$cs_type);
		$this->assign("cs_id",$data['cs_id']);
		$this->assign("data",$data);
		 if($cs_type=='ftf'){
			$this->display('ftfmaterialedit');
		}else{
			$this->display();
		}
	}
	function materialedit_post(){
		 if (IS_POST) {
			$id = intval(I("POST.id"));
			$material = $this->material_obj->where(array('id'=>$id))->find();
			$data['downname']=$_SESSION["access_name"];
			$data['name']=I("POST.name");
			$data['url']=I("POST.url");
			$result=$this->material_obj->where(array('id'=>$id))->save($data);
			if ($result) {
				    session("access_url",null);
				    session("access_name",null);
					$this->success("修改成功！",U("Teacher/Center/material",array('cs_id'=>$material['cs_id'])));
				}else{
					$this->error("修改失败！");
				}			
			 
		}
	}
    function materialdel(){
		if(isset($_GET['id'])){
			$id = intval(I("get.id"));
			if ($this->material_obj->delete($id)!==false) {
				$this->success("删除成功！");
			} else {
				$this->error("删除失败！");
			}
		}
		if(isset($_POST['ids'])){
			$tids=htmldecode(join(",",$_POST['ids']));
			if ($this->material_obj->where("id in ($tids)")->delete()) {
				$this->success("删除成功！");
			} else {
				$this->error("删除失败！");
			}
		}
    
    }
     function pinglun(){
		$cs_id = intval(I("get.cs_id"));
		$cs_name=$this->course_obj->where("id=$cs_id")->getField('cs_name');
		$cs_pic=$this->course_obj->where("id=$cs_id")->getField('cs_picture');
		$cs_type=$this->course_obj->where("id=$cs_id")->getField('course_type');
		$count=$this->comments_obj->where(array('post_id'=>$cs_id))->count();
		$page = $this->page($count, 10);
		$pinglun=$this->comments_obj->where(array('post_id'=>$cs_id))->limit($page->firstRow . ',' . $page->listRows)->select();
		$this->assign("pinglun",$pinglun);
		$this->assign("cs_name",$cs_name);
		$this->assign("cs_pic",$cs_pic);
		$this->assign("cs_type",$cs_type);
		$this->assign("cs_id",$cs_id);
		$this->assign("Page", $page->show('Admin'));
		$this->assign("current_page",$page->GetCurrentPage());
		$this->display();
	}
	function isfree(){
	 if(IS_POST){ 
	    $id = (int)$_POST['id']; 
		$data=$this->section_obj->where(array('id'=>$id))->find();
		if($data['is_free']==0){
			$data['is_free']=1;
		}else{
		    $data['is_free']=0;
		}
		$this->section_obj->save($data);
		
		return json_encode($data);
		
	 }
	}
	function liveisfree(){
	 if(IS_POST){ 
	    $id = (int)$_POST['id']; 
		$data=$this->livesection_obj->where(array('id'=>$id))->find();
		if($data['isfree']==0){
			$data['isfree']=1;
		}else{
		    $data['isfree']=0;
		}
		$this->livesection_obj->save($data);
		
		return json_encode($data);
		
	 }
	}
	function isover(){
	 if(IS_POST){ 
	    $id = (int)$_POST['id']; 
		$data=$this->course_obj->where(array('id'=>$id))->find();
		if($data['isover']==0){
			$data['isover']=1;
		}else{
		    $data['isover']=0;
		}
		if($this->course_obj->save($data)){
			return json_encode($data['isover']);
		}
		 
	 }
	}
	function  sales(){
	  $userid=sp_get_current_userid();
	  $count1=$this->teacher_order->where(array('u_id'=>$userid))->count();
	  $count2=$this->tixian_obj->where(array('u_id'=>$userid))->count();
      $page1 = $this->page($count1, 10);
      $page2 = $this->page($count2, 10);
	  $sales=$this->teacher_order->where(array('u_id'=>$userid))->limit($page1->firstRow . ',' . $page->listRows)->order("id desc")->select();
      $tixian=$this->tixian_obj->where(array('u_id'=>$userid))->limit($page2->firstRow . ',' . $page->listRows)->order("id desc")->select();
	  foreach($sales as $n=> $val){
	  	     $inflownum=$inflownum+$val['money'];
			 $sales[$n]['scname']=$this->course_obj->where('id=\''.$val['c_id'].'\'')->getField('cs_name');
		}
	  foreach($tixian as $n=> $val){
	  	     $tixiannum=$tixiannum+$val['money'];
		}
		$keti=$inflownum-$tixiannum;
	  $this->assign('inflownum',$inflownum); 
	  $this->assign('keti',$keti); 
	  $this->assign('tixian',$tixian); 
	  $this->assign('tixiannum',$tixiannum); 
	  $this->assign('sales',$sales); 
	  $this->assign("Page1", $page1->show('Admin'));
	  $this->assign("current_page",$page1->GetCurrentPage());
	  $this->assign("Page2", $page2->show('Admin'));
	  $this->assign("current_page",$page2->GetCurrentPage());    
	  $this->display();
	}
	function tixian(){
	   
	   $this->display();
	}
	function tixian_post(){
	   if(IS_POST){ 
	   	$userid=sp_get_current_userid();
	    $sales=$this->teacher_order->where(array('u_id'=>$userid))->select();
        $tixian=$this->tixian_obj->where(array('u_id'=>$userid))->select();
        foreach($sales as $n=> $val){
	  	     $inflownum=$inflownum+$val['money'];
		}
	    foreach($tixian as $n=> $val){
	  	     $tixiannum=$tixiannum+$val['money'];
		}
		$keti=$inflownum-$tixiannum;
	      $data= $this->tixian_obj->create();
	      if(empty($data['money'])){
	         $this->error('提现金额不能为空');
	      }
	      if($data['money']<100){
	         $this->error('提现金额必须大于100元');
	      }
	     if($data['money']>$keti){
	         $this->error('账户余额小于你的提款额');
	      }
	      if(empty($data['turename'])){
	         $this->error('真实姓名不能为空');
	      }
	      if(empty($data['count'])){
	         $this->error('提款账户不能为空');
	      }
	      $data['u_id']=sp_get_current_userid();
	      $data['addtime']=date('Y-m-d H:i:s');
	      $data['state']=0;
	      if($this->tixian_obj->add($data)){
	      	$this->success('提交成功');
	      }else{
	        $this->error('提交失败');
	      }
		}
	}

	function getuptoken($bucket){
		$auth=$this->getauth();
		$token = $auth->uploadToken($bucket);
		return  $token;
	}
    function getauth(){
        $accessKey = C('QN_AccessKey');
        $secretKey = C('QN_SecretKey');
        return $auth = new Auth($accessKey, $secretKey);
    }
	function upvideo(){
        //$this->display(upbaijiayunvideo);
        $Ali_info=$this->Ali_info();
        $this->assign('ali_info',$Ali_info);
        $this->display('upaliyunvideo');
	}
	function updoc(){
        $userid=sp_get_current_userid();
		$mobile=$this->user_obj->where(array('id'=>$userid))->getField('mobile');
		$prefix = $mobile.'doc';
		$bucket=C('QN_Bucket');
		$uptoken=$this->getuptoken($bucket);
		$qiniudomain=C('QN_Domain');
		$this->assign("uptoken",$uptoken);
		$this->assign("prefix",$prefix);
		$this->assign("qiniudomain",$qiniudomain);
		$this->display();
	}
	function upaudio(){
        $userid=sp_get_current_userid();
		$mobile=$this->user_obj->where(array('id'=>$userid))->getField('mobile');
		$prefix = $mobile.'audio';
		$bucket=C('QN_Bucket');
		$uptoken=$this->getuptoken($bucket);
		$qiniudomain=C('QN_Domain');
		$this->assign("uptoken",$uptoken);
		$this->assign("prefix",$prefix);
		$this->assign("qiniudomain",$qiniudomain);
		$this->display();
	}
	function ziyuanku(){
        $user=$this->user_obj->where(array('id'=>sp_get_current_userid()))->find();
        $postdata=$this->Ali_info();
        $postdata['CateId']=empty($user['aliyuncategory'])? '1': $user['aliyuncategory'];
        $postdata['PageSize']='19';
        $url = $postdata['server'] . "/api/educloud/getvideolist";
        $videorestemp=json_decode(post_curl($url,$postdata),true);
        $video=$videorestemp['VideoList']['Video'];
        $this->assign('result', $video);
		$this->display();
	}
	function ziyuanku2(){
        $user=$this->user_obj->where(array('id'=>sp_get_current_userid()))->find();
        $postdata=$this->Ali_info();
        $postdata['CateId']=$user['aliyuncategory'];
        $postdata['PageSize']='27';
        $url = $postdata['server'] . "/api/educloud/getvideolist";
        $videorestemp=json_decode(post_curl($url,$postdata),true);
        $video=$videorestemp['VideoList']['Video'];
        foreach($video  as $n=> $val){
            $video[$n]['size']=round($video[$n]['Size']/1024/1024,1);
            $video[$n]['ctime']=round($video[$n]['Duration']/60,1).'分钟';
        }
        $this->assign('result',$video);
		$this->display();
	}
	function document(){
		$auth=$this->getauth();
		$bucketMgr = new BucketManager($auth);
		$bucket =C('QN_Bucket');
		$userid=sp_get_current_userid();
		$user=$this->user_obj->where(array('id'=>$userid))->find();
		$prefix = $user['mobile'].'doc';
		$limit = '10000';
		list($iterms, $marker, $err) = $bucketMgr->listFiles($bucket, $prefix, $marker, $limit);
		foreach($iterms as $n=> $val){
			list($prefix, $filename) = split ('[/]', $iterms[$n]['key']); 
			$iterms[$n]['filename']= $filename;
		}
		$iterms=$this->arr_sort($iterms,'putTime');
		$iterms=array_slice($iterms, 0, 27);
		$this->assign("result",$iterms);
		$this->display();
		
	}
	function document2(){
		$auth=$this->getauth();
		$bucketMgr = new BucketManager($auth);
		$bucket = C('QN_Bucket');
		$userid=sp_get_current_userid();
		$user=$this->user_obj->where(array('id'=>$userid))->find();
		$prefix = $user['mobile'].'doc';
		$qiniudomain=C('QN_Domain');
		$limit = '10000';
		list($iterms, $marker, $err) = $bucketMgr->listFiles($bucket, $prefix, $marker, $limit);
		foreach($iterms as $n=> $val){
			 list($prefix, $filename) = split ('[/]', $iterms[$n]['key']); 
			 $iterms[$n]['filename']= $filename;
			 $iterms[$n]['authUrl']='http://'.$qiniudomain.'/'.rawurlencode($iterms[$n]['key']);
			 $iterms[$n]['size']  =round($iterms[$n]['fsize']/1024/1024,1);
		}
		$iterms=$this->arr_sort($iterms,'putTime');
		$iterms=array_slice($iterms, 0, 30);
		$this->assign("result",$iterms);
		$this->display();
		
	}
	function audio(){
		$auth=$this->getauth();
        $bucketMgr = new BucketManager($auth);
        $bucket =C('QN_Bucket');
        $userid=sp_get_current_userid();
        $user=$this->user_obj->where(array('id'=>$userid))->find();
        $prefix = $user['mobile'].'audio';
        $limit = '10000';
        list($iterms, $marker, $err) = $bucketMgr->listFiles($bucket, $prefix, $marker, $limit);
        foreach($iterms as $n=> $val){
            list($prefix, $filename) = split ('[/]', $iterms[$n]['key']);
            $iterms[$n]['filename']= $filename;
        }
        $iterms=$this->arr_sort($iterms,'putTime');
        $iterms=array_slice($iterms, 0, 27);
        $this->assign("result",$iterms);
		$this->display();
	}
	function audio2(){
		$auth=$this->getauth();
		$bucketMgr = new BucketManager($auth);
		$bucket = C('QN_Bucket');
		$userid=sp_get_current_userid();
		$user=$this->user_obj->where(array('id'=>$userid))->find();
		$prefix = $user['mobile'].'audio';
		$qiniudomain=C('QN_Domain');
		$limit = '10000';
		list($iterms, $marker, $err) = $bucketMgr->listFiles($bucket, $prefix, $marker, $limit);
		foreach($iterms as $n=> $val){
			 list($prefix, $filename) = split ('[/]', $iterms[$n]['key']); 
			 $iterms[$n]['filename']= $filename;
			 $iterms[$n]['authUrl']='http://'.$qiniudomain.'/'.rawurlencode($iterms[$n]['key']);
			 $iterms[$n]['size']  =round($iterms[$n]['fsize']/1024/1024,1);
		}
		$iterms=$this->arr_sort($iterms,'putTime');
		$iterms=array_slice($iterms, 0, 30);
		$this->assign("result",$iterms);
		$this->display();
		
	}
	function zydel(){
		$auth=$this->getauth();
		$bucketMgr = new BucketManager($auth);
		$bucket = C('QN_Bucket');
		if(isset($_POST['ids'])){
			$tids=join(",",$_POST['ids']);
			$urlArr = explode(",",$tids); 
			$num = count($urlArr);
			for($i=0;$i<$num;++$i){
			    $key = $urlArr[$i];
			    $err = $bucketMgr->delete($bucket, $key);
				if ($err !== null) {
					  $res=false;
				} else {
					 $res=true;
				}
			}
			 if($res){
				$this->success('删除成功',U("Teacher/Center/ziyuanku"));
			}else{
				$this->error('删除失败',U("Teacher/Center/ziyuanku"));
			} 
		}
	}
	function doczydel(){
		$auth=$this->getauth();
		$bucketMgr = new BucketManager($auth);
		$bucket = C('QN_Bucket');
		if(isset($_POST['ids'])){
			$tids=join(",",$_POST['ids']);
			$urlArr = explode(",",$tids); 
			$num = count($urlArr);
			for($i=0;$i<$num;++$i){
			    $key = $urlArr[$i];
			    $err = $bucketMgr->delete($bucket, $key);
				if ($err !== null) {
					  $res=false;
				} else {
					 $res=true;
				}
			}
			 if($res){
				$this->success('删除成功',U("Teacher/Center/document"));
			}else{
				$this->error('删除失败',U("Teacher/Center/document"));
			} 
		}
	}
    function audiozydel(){
        $auth=$this->getauth();
        $bucketMgr = new BucketManager($auth);
        $bucket = C('QN_Bucket');
        if(isset($_POST['ids'])){
            $tids=join(",",$_POST['ids']);
            $urlArr = explode(",",$tids);
            $num = count($urlArr);
            for($i=0;$i<$num;++$i){
                $key = $urlArr[$i];
                $err = $bucketMgr->delete($bucket, $key);
                if ($err !== null) {
                    $res=false;
                } else {
                    $res=true;
                }
            }
            if($res){
                $this->success('删除成功',U("Teacher/Center/audio"));
            }else{
                $this->error('删除失败',U("Teacher/Center/audio"));
            }
        }
    }
    function alivideodel(){
        $postdata=$this->Ali_info();
        $idlist=$_POST['ids'];
        foreach($idlist as $value){
            $postdata['id']=$value;
            $url = $postdata['server'] . "/api/educloud/delvideo";
            $res=json_decode(post_curl($url,$postdata),true);
        }
        if($res['RequestId']){
            $this->success('删除成功',U('Teacher/Center/ziyuanku'));
        }else{
            $this->error($res['msg'],U('Teacher/Center/ziyuanku'));
        }
    }
	function baijiayundel(){
			$tids=join(",",$_POST['ids']);
			$urlArr = explode(",",$tids); 
			$num = count($urlArr);
			$res=true;
			for($i=0;$i<$num;++$i){
			    $video_id =$urlArr[$i];
				$partner_key=C('BJ_Partner_Key');
				$partner_id=C('BJ_Partner_ID');
				$timestamp=time();
				$params = array(
					"video_id"=>$video_id,
					"partner_id" => $partner_id,
					"timestamp"=>$timestamp
				);
				$sign=$this->getSign($params,$partner_key);
				$url='https://api.baijiacloud.com/openapi/video/delete';
				$postdata="video_id=".$video_id."&partner_id=".$partner_id."&timestamp=".$timestamp."&sign=".$sign;
				$data=json_decode(post_curl($url,$postdata),true);
				if($data.code==0){
				   $res=true;
			   }else{
				   $this->error($data['msg']);
				   $res=false;
			   }
			}
			if($res){
				$this->success('删除成功',U("Teacher/Center/ziyuanku"));
			}else{
				$this->error('删除失败',U("Teacher/Center/ziyuanku"));
			} 
		
	}
	function checkpaper(){
		$teacherid=sp_get_current_userid();
		$count=$this->userpapers_obj->where(array('teacherid'=>$teacherid,'readover'=>0))->count();
		$page = $this->page($count, 10);
		$papers=$this->userpapers_obj->limit($page->firstRow . ',' . $page->listRows)->order(array("id"=>"desc"))->where(array('teacherid'=>$teacherid,'readover'=>0))->select();
		foreach($papers  as $n=> $val){
			$papers[$n]['title']= $this->papers_obj->where(array('id'=>$papers[$n]['papersid']))->getField('title');
		}
		$this->assign('papers',$papers);
		$this->assign("Page", $page->show('Admin'));
		$this->display();
	}
	function checkpaperfinished(){
		$teacherid=sp_get_current_userid();
		$count=$this->userpapers_obj->where(array('teacherid'=>$teacherid,'readover'=>0))->count();
		$page = $this->page($count, 10);
		$papers=$this->userpapers_obj->limit($page->firstRow . ',' . $page->listRows)->order(array("id"=>"desc"))->where(array('teacherid'=>$teacherid,'readover'=>1))->select();
		foreach($papers  as $n=> $val){
			$papers[$n]['title']= $this->papers_obj->where(array('id'=>$papers[$n]['papersid']))->getField('title');
		}
		$this->assign('papers',$papers);
		$this->assign("Page", $page->show('Admin'));
		$this->display();
	}

	function getUploadUrl(){
        $info=$this->get_site_info();
        $postdata['domain']=$this->get_domain();
        $postdata['authorcode']=$info['author_code'];
        $postdata['file_name']=$_POST['file_name'];
        $postdata['definition']='4';
        $url=$info['server']."/api/educloud/getUploadUrl";
        $Urltemp=post_curl($url,$postdata);
        echo $Urltemp;
	}
	function getResumeUploadUrl(){
        $info=$this->get_site_info();
        $postdata['domain']=$this->get_domain();
        $postdata['authorcode']=$info['author_code'];
        $postdata['video_id']=$_POST['video_id'];
        $url=$info['server']."/api/educloud/getResumeUploadUrl";
        $ResumeUrltemp=post_curl($url,$postdata);
        echo $ResumeUrltemp;
	}
	function setVideoCategory(){
        $userid=sp_get_current_userid();
        $info=$this->get_site_info();
        $postdata['domain']=$this->get_domain();
        $postdata['authorcode']=$info['author_code'];
        $postdata['video_id']=$_POST['video_id'];
        $postdata['category_id']=$this->user_obj->where(array('id'=>$userid))->getField('baijiayuncategory');
        $url=$info['server']."/api/educloud/setVideoCategory";
        $res=post_curl($url,$postdata);
	}
	function check_teacher(){
		if(!checkisteacher()){
			$this->redirect('User/center/application');
		}
	}
	function savepic(){
    	if(!empty($_SESSION['avatar'])){
    		$targ_w = intval($_POST['w']);
    		$targ_h = intval($_POST['h']);
    		$x = $_POST['x'];
    		$y = $_POST['y'];
    		$jpeg_quality = 90;
    		$avatar=$_SESSION['avatar'];
    		$avatar_dir=C("UPLOADPATH")."avatar/";
    		$src = $avatar_dir.$avatar;
    		$avatar_path=$avatar_dir.$avatar;
			$image = new \Think\Image();
			$image->open($src);
			$image->crop($targ_w, $targ_h,$x,$y);
			$image->save($src);
			$res['pic']=$avatar;
			$res['status']=1;
			$_SESSION['pic']=$avatar;
            $this->ajaxReturn($res);
    	}
    }
    function setting(){
    	
    	$this->display();
    	}
   function setting_post(){
    		 if(IS_POST){
    		 $this->users_model=D("Common/Users");
         $userid=sp_get_current_userid();
		     $data['zhicheng']=$_POST['zhicheng'];
		     $data['tcProfile']=$_POST['tcProfile'];
         $result=$this->users_model->where(array("id"=>$userid))->save($data);
			if ($result) {
				
					$this->success("修改成功！");
				}else{
					$this->error("修改失败！");
				}			
        }
   }
    function arr_sort($array,$key,$order="desc"){
        $arr_nums=$arr=array();
        foreach($array as $k=>$v){
            $arr_nums[$k]=$v[$key];
        }
        if($order=='asc'){
            asort($arr_nums);
        }else{
            arsort($arr_nums);
        }
        foreach($arr_nums as $k=>$v){
            $arr[$k]=$array[$k];
        }
        return $arr;
    }
    function get_site_info(){
        $info['authorcode']=C('authoCode');
        $info['Partner_ID']=C('BJ_Partner_ID');
        $info['Partner_Key']=C('BJ_Partner_Key');
        $info['Secret_Key']=C('BJ_Secret_Key');
        $info['private_domain']=C('BJ_private_domain');
        $info['server']=C('server');
        $info['domain']=$this->get_domain();
        return $info;
    }
    function get_domain(){
        return sp_get_domain();
    }
    public function getaliuptoken()
    {
        $user=$this->user_obj->where(array('id'=>sp_get_current_userid()))->find();
        $postdata=$this->Ali_info();
        $postdata['filename']=$_POST['title'];
        $postdata['CateId']=$user['aliyuncategory'];
        $url = $postdata['server'] . "/api/educloud/getaliuptoken";
        echo post_curl($url,$postdata);
    }
    function Ali_info(){
        $info['KeyID']=C('Ali_KeyID');
        $info['keySecret']=C('Ali_KeySecret');
        $info['Bucket']=C('Ali_Bucket');
        $info['EndPoint']=C('Ali_EndPoint');
        $info['UserId']=C('Ali_UserId');
        $info['server']=C('server');
        $info['domain']=$this->get_domain();
        $info['authorcode']=C('authoCode');
        return $info;
    }

}