DROP TABLE IF EXISTS `hong_pcat`;

CREATE TABLE `hong_pcat` (
  `cat_id` int(11) NOT NULL AUTO_INCREMENT,
  `p_id` int(11) NOT NULL DEFAULT '0',
  `sort` int(11) NOT NULL DEFAULT '0',
  `is_show` tinyint(1) NOT NULL DEFAULT '1',
  `show_sub` tinyint(1) NOT NULL DEFAULT '1',
  `name` varchar(255) NOT NULL DEFAULT '',
  `name_en` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `keywords_en` varchar(255) NOT NULL DEFAULT '',
  `desc_cn` text,
  `desc_en` text,
  `counts` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cat_id`),
  KEY `p_id` (`p_id`),
  KEY `sort` (`sort`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `hong_product`;

CREATE TABLE `hong_product` (
  `pro_id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` int(11) NOT NULL DEFAULT '0',
  `sort` int(11) NOT NULL DEFAULT '0',
  `is_show` tinyint(1) NOT NULL DEFAULT '1',
  `is_best` tinyint(1) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL DEFAULT '0',
  `username` varchar(64) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL default '',
  `filename` varchar(255) NOT NULL default '',
  `price` VARCHAR(36) NOT NULL default '',
  `price_en` VARCHAR(36) NOT NULL default '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `title_en` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `keywords_en` varchar(255) NOT NULL DEFAULT '',
  `content` mediumtext,
  `content_en` mediumtext,
  `clicks` int(11) NOT NULL DEFAULT '0',
  `created` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pro_id`),
  KEY `sort` (`sort`),
  KEY `created` (`created`),
  KEY `cat_id` (`cat_id`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `hong_enquiry`;

CREATE TABLE `hong_enquiry` (
  `e_id` int(11) NOT NULL auto_increment,
  `refer_id` int(11) NOT NULL default '0',
  `status` tinyint(1) NOT NULL default '0',
  `email` varchar(128) NOT NULL default '',
  `pro_id` int(30) NOT NULL default '0',
  `userid` int(11) NOT NULL DEFAULT '0',
  `username` varchar(64) NOT NULL DEFAULT '',
  `lang` tinyint(1) NOT NULL default '0',
  `title` VARCHAR(255) NOT NULL default '',
  `content` text,
  `created` int(11) NOT NULL default '0',
  PRIMARY KEY  (`e_id`),
  KEY `userid` (`userid`),
  KEY `created` (`created`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `hong_gimage`;

CREATE TABLE `hong_gimage` (
  `g_id` int(11) NOT NULL auto_increment,
  `pro_id` int(30) NOT NULL default '0',
  `is_show` TINYINT(1) NOT NULL default '1',
  `path` varchar(255) NOT NULL default '',
  `filename` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`g_id`),
  KEY `pro_id` (`pro_id`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `hong_acat`;

CREATE TABLE `hong_acat` (
  `cat_id` int(11) NOT NULL AUTO_INCREMENT,
  `p_id` int(11) NOT NULL DEFAULT '0',
  `sort` int(11) NOT NULL DEFAULT '0',
  `is_show` tinyint(1) NOT NULL DEFAULT '1',
  `show_sub` tinyint(1) NOT NULL DEFAULT '1',
  `name` varchar(255) NOT NULL DEFAULT '',
  `name_en` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `keywords_en` varchar(255) NOT NULL DEFAULT '',
  `desc_cn` text,
  `desc_en` text,
  `counts` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cat_id`),
  KEY `p_id` (`p_id`),
  KEY `sort` (`sort`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `hong_article`;

CREATE TABLE `hong_article` (
  `a_id` int(30) NOT NULL auto_increment,
  `sort` int(30) NOT NULL default '0',
  `cat_id` int(11) NOT NULL default '0',
  `is_show` tinyint(1) NOT NULL default '0',
  `is_best` tinyint(1) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL default '0',
  `username` varchar(64) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `title_en` varchar(255) NOT NULL default '',
  `linkurl` varchar(255) NOT NULL default '',
  `linkurl_en` varchar(255) NOT NULL default '',
  `content` mediumtext,
  `content_en` mediumtext,
  `keywords` varchar(255) NOT NULL default '',
  `keywords_en` varchar(255) NOT NULL default '',
  `clicks` int(11) NOT NULL default '0',
  `created` int(11) NOT NULL default '0',
  PRIMARY KEY  (`a_id`),
  KEY `sort` (`sort`),
  KEY `created` (`created`),
  KEY `cat_id` (`cat_id`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `hong_comment`;

CREATE TABLE `hong_comment` (
  `c_id` int(30) NOT NULL auto_increment,
  `for_id` int(30) NOT NULL default '0',
  `userid` int(11) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `lang` tinyint(1) NOT NULL default '0',
  `username`  VARCHAR(64)  NOT NULL default '',
  `actived` TINYINT(1) NOT NULL default '0',
  `content` text,
  `created` int(11) NOT NULL default '0',
  PRIMARY KEY  (`c_id`),
  KEY `for_id` (`for_id`),
  KEY `userid` (`userid`),
  KEY `created` (`created`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `hong_session`;

CREATE TABLE `hong_session` (
  `sessionid` char(32) NOT NULL default '',
  `userid` int(11) NOT NULL default '0',
  `ipaddress` varchar(32) NOT NULL default '',
  `useragent` char(32) NOT NULL default '',
  `created` int(11) NOT NULL default '0',
  `admin` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`sessionid`),
  KEY `userid` (`userid`),
  KEY `created` (`created`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `hong_usergroup`;

CREATE TABLE `hong_usergroup` (
  `groupid` int(11) NOT NULL auto_increment,
  `grouptype` tinyint(1) NOT NULL default '0',
  `groupname` varchar(64) NOT NULL default '',
  `groupname_en` varchar(64) NOT NULL default '',
  `description` varchar(255) NOT NULL default '',
  `actions` text,
  PRIMARY KEY  (`groupid`)
) ENGINE=MyISAM;


INSERT INTO `hong_usergroup` (`groupid`, `grouptype`, `groupname`, `groupname_en`, `description`, `actions`) VALUES
(1, 1, '超级管理员', 'Administrator', '超级管理员, 具有前后台所有权限, 且权限无法更改', 'all'),
(2, 0, '注册会员', 'Member', '用户在前台注册后的默认用户组', '*login*comment*enquiry*pmdays:30*'),
(3, 0, '游客', 'Guest', '前台未注册的浏览者', '*enquiry*');


DROP TABLE IF EXISTS `hong_user`;

CREATE TABLE `hong_user` (
  `userid` int(11) NOT NULL auto_increment,
  `groupid` int(11) NOT NULL,
  `activated` tinyint(1) NOT NULL default '0',
  `username` varchar(64) NOT NULL default '',
  `password` varchar(64) NOT NULL default '',
  `verifycode` varchar(8) NOT NULL default '',
  `joindate` int(11) NOT NULL default '0',
  `lastdate` int(11) NOT NULL default '0',
  `joinip` varchar(64) NOT NULL default '',
  `lastip` varchar(64) NOT NULL default '',
  `lang` tinyint(1) NOT NULL default '0',
  `loginnum` int(11) NOT NULL default '0',
  `p_num` int(11) NOT NULL default '0',
  `a_num` int(11) NOT NULL default '0',
  `q_num` int(11) NOT NULL default '0',
  `pc_num` int(11) NOT NULL default '0',
  `ac_num` int(11) NOT NULL default '0',
  `nickname` varchar(64) NOT NULL default '',
  `email` varchar(128) NOT NULL default '',
  `profile` text,
  `company` varchar(225) NOT NULL default '',
  `address` varchar(255) NOT NULL default '',
  `postcode` varchar(32) NOT NULL default '',
  `tel` varchar(255) NOT NULL default '',
  `fax` varchar(255) NOT NULL default '',
  `online` varchar(255) NOT NULL default '',
  `website` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`userid`),
  KEY `joindate` (`joindate`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `hong_pm`;

CREATE TABLE `hong_pm` (
  `pmid` int(30) NOT NULL auto_increment,
  `refer_id` int(30) NOT NULL default '0',
  `toid` int(11) NOT NULL default '0',
  `toname` varchar(64) NOT NULL default '',
  `fromid` int(11) NOT NULL default '0',
  `fromname` varchar(64) NOT NULL default '',
  `readed` tinyint(1) NOT NULL default '0',
  `newreply` tinyint(1) NOT NULL default '0',
  `subject` varchar(255) NOT NULL default '',
  `message` text,
  `created` int(11) NOT NULL default '0',
  PRIMARY KEY  (`pmid`),
  KEY `refer_id` (`refer_id`),
  KEY `toid` (`toid`),
  KEY `fromid` (`fromid`),
  KEY `created` (`created`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `hong_content`;

CREATE TABLE `hong_content` (
  `c_id` int(11) NOT NULL auto_increment,
  `title` VARCHAR(255) NOT NULL default '',
  `title_en` VARCHAR(255) NOT NULL default '',
  `content` text,
  `content_en` text,
  `keywords` varchar(255) NOT NULL default '',
  `keywords_en` varchar(255) NOT NULL default '',
  `created` int(11) NOT NULL default '0',
  `r_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`c_id`),
  KEY `r_id` (`r_id`),
  KEY `created` (`created`)
) ENGINE=MyISAM;


INSERT INTO `hong_content`  (`c_id`, `title`, `title_en`, `content`, `content_en`, `keywords`, `keywords_en`, `created`, `r_id`) VALUES 
(1,'关于我们','About Us','请在后台管理中自定义关于我们的详细内容.','please edit your content.','关于,我们','about us','1381928888', 1),
(2,'联系我们','Contact Us','请在后台管理中自定义联系我们的详细内容.','please edit your content.','联系,我们','contact us','1381928888', 2),
(3,'首页常态内容','Homepage content','请在后台管理中自定义首页常态内容.','please edit your homepage content.','hongcms中英文企业网站系统','hongcms,website system','1381928888', 3),
(4,'第一个公司','The first Company','请在后台管理常态内容中自定义第一个公司详细介绍.','please edit The first Company content on back-end.','hongcms,website system','hongcms,website system','1381928888', 11),
(5,'第二个公司','The second Company','请在后台管理常态内容中自定义第二个公司详细介绍.','please edit The second Company content on back-end.','hongcms,website system','hongcms,website system','1381928888', 12),
(6,'第三个公司','The third Company','请在后台管理常态内容中自定义第三个公司详细介绍.','please edit The third Company content on back-end.','hongcms,website system','hongcms,website system','1381928888', 13),
(7,'企业文化','Our Culture','请在后台管理常态内容中自定义企业文化详细内容.','please edit Our Culture content on back-end.','hongcms,website system','hongcms,website system','1381928888', 14),
(8,'组织结构','Organization','请在后台管理常态内容中自定义组织结构详细内容.','please edit Organization content on back-end.','hongcms,website system','hongcms,website system','1381928888', 15);


DROP TABLE IF EXISTS `hong_news`;

CREATE TABLE `hong_news` (
  `n_id` int(11) NOT NULL auto_increment,
  `sort` int(11) NOT NULL default '0',
  `is_show` TINYINT(1) NOT NULL default '1',
  `title` varchar(255) NOT NULL default '',
  `title_en` varchar(255) NOT NULL default '',
  `linkurl` varchar(255) NOT NULL default '',
  `linkurl_en` varchar(255) NOT NULL default '',
  `keywords` varchar(255) NOT NULL default '',
  `keywords_en` varchar(255) NOT NULL default '',
  `content` mediumtext,
  `content_en` mediumtext,
  `clicks` int(30) NOT NULL default '0',
  `created` int(11) NOT NULL default '0',
  PRIMARY KEY  (`n_id`),
  KEY `sort` (`sort`),
  KEY `created` (`created`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `hong_vvc`;

CREATE TABLE `hong_vvc` (
  `vvcid` int(30) NOT NULL auto_increment,
  `code` varchar(9) NOT NULL default '',
  `created` int(11) NOT NULL default '0',
  PRIMARY KEY  (`vvcid`),
  KEY `created` (`created`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `hong_adposition`;

CREATE TABLE `hong_adposition` (
  `adpoid` int(11) NOT NULL auto_increment,
  `actived` TINYINT(1) NOT NULL default '1',
  `title` varchar(255) NOT NULL default '',
  `description` varchar(255) NOT NULL default '',
  `width` varchar(16) NOT NULL default '',
  `height` varchar(16) NOT NULL default '',
  PRIMARY KEY  (`adpoid`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `hong_advertise`;

CREATE TABLE `hong_advertise` (
  `adid` int(11) NOT NULL auto_increment,
  `adpoid` int(11) NOT NULL default '0',
  `actived` TINYINT(1) NOT NULL default '1',
  `overdate` int(11) NOT NULL default '0',
  `title` varchar(255) NOT NULL default '',
  `content` text,
  `content_en` text,
  `created` int(11) NOT NULL default '0',
  PRIMARY KEY  (`adid`),
  KEY `adpoid` (`adpoid`),
  KEY `created` (`created`)
) ENGINE=MyISAM;