<?php
/**
 * +------------------------------------------------------------
 * | 区块数据模型 app\block\model\Data.php
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-04-17 10:59:25
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-04-17 10:59:25
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */


namespace app\Block\model;

use app\common\model\Init;

class Data extends Init
{
    protected $name = 'block_data';

    // 设置json类型字段
    protected $json = ['fields'];

    // 设置JSON数据返回数组
    protected $jsonAssoc = true;

    public function block()
    {
        return $this->hasOne('Block');
    }

    public function setEndTimeAttr($value)
    {
        return $value ? strtotime($value) : 0;
    }

    public function getEndTimeAttr($value)
    {
        return $value ? \time_format($value) : '';
    }

    public function getThumbAttr($value)
    {
        $rs = ['value' => $value];
        $rs['url'] = action('files/api/_init_thumb', [$value, 1]);
        return $rs;
    }

    function setThumbAttr($value)
    {
        return action('files/api/original_thumb', [$value]);
    }

}