<?php
/**
 * +------------------------------------------------------------
 * | 插件基类
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018年10月13日15:52:10
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018年10月13日15:52:04
 * +------------------------------------------------------------
 * |
 * +------------------------------------------------------------
 */

namespace app\common\controller;

use think\View;

define('ADDONS_PATH', \think\facade\Env::get('root_path') . 'addons' . DIRECTORY_SEPARATOR);

class Addons extends Init
{

    protected static $addons_path;
    protected static $addons_config;
    protected static $addons;
    protected static $_view;

    function initialize()
    {
        $var = explode('\\', get_class($this));
        self::$addons = strtolower(count($var) == 4 ? $var[1] : array_pop($var));
        self::$addons_path = ADDONS_PATH . self::$addons . DIRECTORY_SEPARATOR;
        if (is_file(self::$addons_path . 'config.php')) {
            self::$addons_config = self::$addons_path . 'config.php';
        }
        if (file_exists(self::$addons_path . 'common.php')) {
            include_once(self::$addons_path . 'common.php');
        }
        $view = new View();
        $config = config('')['template'];
        $config['view_base'] = ADDONS_PATH . self::$addons . DIRECTORY_SEPARATOR . 'view' . DIRECTORY_SEPARATOR;
        unset($config['view_path']);
        $this->view->config('view_base', ADDONS_PATH . self::$addons . DIRECTORY_SEPARATOR . 'view' . DIRECTORY_SEPARATOR);
        self::$_view = $view->engine($config);
        parent::initialize();
    }

    /**
     * 模板变量赋值
     */
    final protected function assign($name, $value = '')
    {
        self::$_view->assign($name, $value);
    }

    /**
     * 加载模板和页面输出 可以返回输出内容
     */
    public function fetch($template = '', $vars = [], $replace = [], $config = [])
    {
        echo self::$_view->fetch($template, $vars, $replace, $config);
    }

    /**
     * 渲染内容输出
     */
    public function display($content = '', $vars = [], $replace = [], $config = [])
    {
        echo self::$_view->display($content, $vars, $replace, $config);
    }

    /**
     * 渲染内容输出
     */
    public function show($content, $vars = [])
    {
        echo self::$_view->fetch($content, $vars, [], [], true);
    }


}