<?php
/**
 * +------------------------------------------------------------
 * | 扩展字段
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018年9月29日12:20:45
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018年9月29日12:20:53
 * +------------------------------------------------------------
 * |
 * +------------------------------------------------------------
 */

namespace app\common\controller;

class Fields extends Init
{

    private $id;
    private $model;
    private $relation_id;
    private $refresh;
    private $list_order;
    private $use;
    private $fields_id;
    private $status;
    private $vals;
    private $fields;
    private $form;
    private $data_id;
    //是否获取付费字段
    private static $fee_fields;

    /**
     * 新建/编辑
     */
    public function form($id = 0, $model = '')
    {
        if (request()->isPost()) {
            $data = input('post.');
            $data['model'] = $model;
            $validate = validate('Fields');
            if (!$validate->check($data)) return json(['code' => 0, 'msg' => $validate->getError()]);
            unset($data['column_id']);
            if (in_array($data['type'], [1, 2, 3])) {
                if (empty($data['value'])) return json(['code' => 0, 'msg' => '扩展字段值不能为空']);
                $max_key = max(array_column($data['value'], 'key'));
                foreach ($data['value'] as $k => $v) {
                    if ((!empty($v['key']) && !is_numeric($v['key'])) || empty($v['value'])) return json(['code' => 0, 'msg' => '扩展字段值格式错误']);
                    if ($v['key'] === '') $data['value'][$k]['key'] = ++$max_key;
                }
                $data['value'] = json_encode($data['value']);
            } else {
                $data['value'] = '';
            }
            $data['default'] = isset($data['default']) ? (is_array($data['default']) ? implode(',', $data['default']) : $data['default']) : '';
            $key = db('fields')->where('key', '=', $data['key'])->where('relation_id', '=', $data['relation_id'])->where('model', '=', $model)->find();
            if (!empty($data['search_item'])) {
                if (!is_array($data['search_item']) || ($data['search'] == 1 && count($data['search_item']) != count($data['search_item'], 1)) || ($data['search'] == 2 && count($data['search_item'], 1) / count($data['search_item']) != 3)) return json(['code' => 0, 'msg' => '搜索预设值格式错误']);
                $data['search_item'] = json_encode($data['search_item']);
            } else {
                $data['search_item'] = '';
            }
            if ($id) {
                if (!empty($key) && $key['id'] != $id) return json(['code' => 0, 'msg' => '字段标识不能重复,请修正后重新提交...']);
                $fields = db('fields')->where('id', '=', $id)->find();
                if (!empty($fields)) {
                    //改变扩展字段key
                    if ($model == 'column' && $fields['key'] != $data['key']) {
                        $column = load_column($fields['relation_id'], 0, 1, self::$user['group_id']);
                        if (!empty($column['parent_id'])) {
                            db('data')->where('column_id', '=', $fields['relation_id'])->exp('fields', 'replace(fields,\'' . $fields['key'] . '\',\'' . $data['key'] . '\')')->update();
                        }
                    }
                    //改变扩展字段类型
                    if ($fields['type'] != $data['type']) {
                        if (in_array($data['type'], [0, 4])) $data['value'] = '';
                    }
                }
                db('fields')->where('id', '=', $id)->update($data);
                $result = ['code' => 1, 'msg' => '字段《' . $data['name'] . '》已更新。'];
            } else {
                if (!empty($key)) return json(['code' => 0, 'msg' => '字段标识不能重复,请修正后重新提交...']);
                $rs = db('fields')->insert($data);
                if ($rs) {
                    $result = ['code' => 1, 'msg' => '字段《' . $data['name'] . '》已新增。'];
                } else {
                    $result = ['code' => 0, 'msg' => '出了点问题，返回重新提交试试..'];
                }
            }
            if ($result['code'] == 1) {
                $this->read([
                    'relation_id' => $data['relation_id'],
                    'refresh' => 1,
                    'model' => $data['model']
                ]);
                if ($data['model'] == 'column') {
                    $child = db('column')->where('parent_id', '=', $data['relation_id'])->column('id');
                    if (!empty($child)) {
                        foreach ($child as $k => $v) $this->read([
                            'relation_id' => $v,
                            'refresh' => 1,
                            'model' => $data['model']
                        ]);
                    }
                }
            }
            return json($result);
        } else {
            if ($id) {
                $rs = model('app\common\model\Fields')->get($id);
                return json(['code' => 1, 'data' => $rs]);
            }
        }
    }

    /**
     * 控制台扩展字段列表
     * @param string $relation_id
     * @param string $model
     * @return \think\response\Json
     */
    public function fields($relation_id = '', $model = 'column')
    {
        $relation_id = [$relation_id];
        if ($model == 'column') {
            $columns = load_columns(0, 0, '', '', '');
            if (!empty($columns[$relation_id[0]]['parent_id']) && !empty($columns[$relation_id[0]]['setting']['fields']['extends'])) {
                array_push($relation_id, $columns[$relation_id[0]]['parent_id']);
            }
        }
        if ($model == 'user') array_push($relation_id, -1);
        $where[] = ['relation_id', 'in', $relation_id];
        $where[] = ['model', '=', $model];
        $rs = model('app\common\model\Fields')->where($where)->select();
        if (!empty($rs)) {
            $rs = $rs->toArray();
            if (in_array($model, ['column', 'user', 'block'])) {
                foreach ($rs as $k => $v) {
                    $rs[$k]['parent_id'] = $model == 'user' ? -1 : ($model == 'column' ? $columns[$v['relation_id']]['parent_id'] : 0);
                    if ($v['relation_id'] == $relation_id[0]) {
                        $self[$v['key']] = $rs[$k];
                        $rs[$k]['self'] = 1;
                    } else {
                        $parent[$v['key']] = $rs[$k];
                        $rs[$k]['self'] = 0;
                    }
                }
                if (!empty($parent) && !empty($self)) {
                    $intersect = array_intersect(array_keys($parent), array_keys($self));
                    if (!empty($intersect)) {
                        foreach ($rs as $k => $v) {
                            if (in_array($v['key'], $intersect) && $v['self'] != 1) unset($rs[$k]);
                        }
                        $rs = array_values($rs);
                    }
                }
                array_multisort(array_column($rs, 'self'), SORT_ASC, $rs);
            }
        }
        $data = [
            'fields' => $rs,
            'fields_types' => self::fields_type()
        ];
        if ($model == 'column') {
            $data['name'] = $columns[$relation_id[0]]['name'];
            $data['setting'] = $columns[$relation_id[0]]['setting'];
            $data['column'] = load_column($relation_id[0], 0, 1, self::$user['group_id']);
        }
        if ($model == 'user') {
            $group = action('user/api/group', [0, $relation_id[0]]);
            $data['name'] = isset($group[0]['name']) ? $group[0]['name'] : '';
        }
        if ($model == 'block') {
            $data['name'] = db('block')->where('id', '=', $relation_id[0])->value('name');
        }
        return json(['code' => 1, 'data' => $data]);
    }

    /**
     * 删除
     */
    public function delete($id = [], $model = 'column')
    {
        $fields = db('fields')->where('id', 'in', (array)$id)->select();
        if (!empty($fields)) {
            db('fields')->where('id', 'in', (array)$id)->delete();
            action('user/Api/log', ['删除扩展字段', '名称:【' . join(',', array_column($fields, 'name')) . '】,ID:' . join(',', $id)]);
            foreach ($fields as $k => $v) $this->read([
                'relation_id' => $v['relation_id'],
                'refresh' => 1,
                'model' => $model
            ]);
            if ($model == 'column') {
                $column = db('column')->where('id', '=', $fields[0]['relation_id'])->find();
                //清除子栏目的扩展字段缓存
                if ($column['parent_id'] == 0) {
                    $child = db('column')->where('parent_id', '=', $column['id'])->column('id');
                    if (!empty($child)) {
                        foreach ($child as $k => $v) $this->read([
                            'relation_id' => $v,
                            'refresh' => 1,
                            'model' => $model
                        ]);
                    }
                }
            }
        }
        return json(['code' => 1, 'msg' => '扩展字段删除成功']);
    }

    /**
     * 获取
     */
    public function read($relation_id = 0, $refresh = 0, $list_show = '', $use = '', $model = 'column')
    {
        if (is_array($relation_id)) {
            $refresh = isset($relation_id['refresh']) ? $relation_id['refresh'] : 0;
            $list_show = isset($relation_id['list_show']) ? $relation_id['list_show'] : '';
            $use = isset($relation_id['use']) ? $relation_id['use'] : '';
            $model = isset($relation_id['model']) ? $relation_id['model'] : 'column';
            $relation_id = isset($relation_id['relation_id']) ? $relation_id['relation_id'] : '';
        }
        $cache_id = $model . '_fields_' . $relation_id;
        if ($refresh) cache($cache_id, null);
        $rs = cache($cache_id);
        if (!is_array($rs)) {
            $where = [];
            if (!empty($relation_id)) $where[] = ['relation_id', '=', $relation_id];
            if (!empty($model)) $where[] = ['model', '=', $model];
            $rs = model('app\common\model\Fields')->where($where)->order('list_order asc')->column('*', 'key');
            if ($model == 'column') {
                $column = load_column($relation_id, 0, '', self::$user['group_id']);
                if ($column['parent_id'] != 0 && !empty($column['setting']['fields']['extends'])) {
                    $parent = model('app\common\model\Fields')->where('relation_id', '=', $column['parent_id'])->where('model', '=', $model)->order('list_order asc')->column('*', 'key');
                    $rs = array_merge($parent, $rs);
                }
            }
            if ($model == 'user') {
                $parent = model('app\common\model\Fields')->where('relation_id', '=', -1)->where('model', '=', $model)->order('list_order asc')->column('*', 'key');
                $rs = array_merge($parent, $rs);
            }
            if (!empty($rs)) {
                foreach ($rs as $k => $v) {
                    if (empty($v['status'])) {
                        unset($rs[$k]);
                        continue;
                    }
                    if (in_array($v['type'], [1, 2, 3])) {
                        $rs[$k]['options'] = empty($v['value']) ? '' : json_decode($v['value'], 1);
                        unset($rs[$k]['value']);
                    }
                    $rs[$k]['search_item'] = empty($v['search_item']) ? '' : (is_array($v['search_item']) ? $v['search_item'] : json_decode($v['search_item'], 1));
                }
            } else {
                $rs = [];
            }
            cache($cache_id, $rs, 0, $model);
        }
        if (!empty($rs)) {
            if ($list_show !== '') {
                foreach ($rs as $k => $v) {
                    if ($v['list_show'] != $list_show) {
                        unset($rs[$k]);
                    }
                }
            }
            if ($use != '' && !empty($rs)) {
                foreach ($rs as $k => $v) {
                    if (isset($v['use']) && $v['use'] != $use) {
                        unset($rs[$k]);
                    }
                }
            }
        }
        return $rs;
    }

    /**
     * 禁用,主要是子类继承父类的禁用
     */
    public function forbid($fields_id = 0, $relation_id = 0, $model = 'column')
    {
        if ($fields_id && $relation_id && $model) {
            $fields = model('app\common\model\Fields')->where('id', '=', $fields_id)->find();
            if (empty($fields)) return json(['code' => 0, 'msg' => '扩展字段不存在']);
            $fields = $fields->toArray();
            if (db('fields')->where('relation_id', '=', $relation_id)->where('key', '=', $fields['key'])->where('model', '=', $model)->find()) return json(['code' => 0, 'msg' => '您已禁用']);
            if ($model == 'column') {
                $column = load_column($relation_id, 0, '', self::$user['group_id']);
                if (empty($column)) return json(['code' => 0, 'msg' => '栏目不存在']);
                if ($fields['relation_id'] != $column['parent_id']) return json(['code' => 0, 'msg' => '数据非法']);
            }
            unset($fields['id']);
            $fields['relation_id'] = $relation_id;
            $fields['status'] = 0;
            model('app\common\model\Fields')->allowField(true)->data($fields)->save();
            $this->read([
                'relation_id' => $relation_id,
                'refresh' => 1,
                'model' => $model
            ]);
            return json(['code' => 1, 'msg' => '禁用成功']);
        }
        return json(['code' => 0, 'msg' => '操作失败']);
    }

    /**
     * 修改状态
     */
    public function status($id = [], $status = '', $relation_id = 0, $model = 'column')
    {
        if (!empty($id) && in_array($status, [0, 1]) && $relation_id && $model) {
            db('fields')->where('id', 'in', $id)->where('relation_id', '=', $relation_id)->where('model', '=', $model)->setField('status', $status);
            cache($model . '_fields_' . $relation_id, null);
            if ($model == 'column') {
                $column = load_column($relation_id, 0, '', self::$user['group_id']);
                if ($column['parent_id'] == 0) {
                    //刷新子栏目自定义字段缓存
                    $child = db('column')->where('parent_id', '=', $relation_id)->column('id');
                    if (!empty($child)) foreach ($child as $k => $v) $this->read([
                        'relation_id' => $v,
                        'refresh' => 1,
                        'model' => $model
                    ]);
                }
            }
            return json(['code' => 1, 'msg' => '操作成功']);
        }
    }

    /**
     * 处理数据返回值
     */
    public function _init($vals, $fields = [], $form = 0)
    {
        is_string($vals) && $vals = json_decode($vals, true);
        if (!empty($fields) && is_array($vals)) {
            foreach ($fields as $k => $v) {
                if (isset($vals[$k])) {
                    if ($form) {
                        if ($v['type'] == 2) {
                            if (is_string($vals[$k])) {
                                $fields[$k] = explode(',', $vals[$k]);
                            }
                        } else {
                            $fields[$k] = $vals[$k];
                        }
                    } else {
                        $options = empty($v['options']) ? '' : array_column($v['options'], null, 'key');
                        $fields[$k] = [
                            'name' => $v['name'],
                            'value' => $vals[$k],
                            'unit' => $v['unit'],
                            'fee' => $v['fee'] ?? 0,
                            'key' => $vals[$k]
                        ];
                        if (!empty($v['fee']) && empty(self::$fee_fields)) {
                            $fields[$k]['value'] = ($v['type'] == 2 ? [] : '');
                        } else {
                            if (in_array($v['type'], [1, 3])) $fields[$k]['value'] = is_string($vals[$k]) ? (isset($options[$vals[$k]]) ? $options[$vals[$k]]['value'] : '') : '';
                            if ($v['type'] == 2) {
                                if (is_string($vals[$k])) {
                                    $vals[$k] = explode(',', $vals[$k]);
                                }
                                if (is_array($vals[$k])) {
                                    if (count($vals[$k]) >= 1) {
                                        $v['value'] = [];
                                        foreach ($vals[$k] as $kk => $vv) {
                                            if (!isset($options[$vv])) continue;
                                            $v['value'][$vv] = $options[$vv]['value'];
                                        }
                                        $fields[$k]['value'] = array_values($v['value']);
                                    }
                                } else {
                                    unset($fields[$k]);
                                }
                            }
                            if (in_array($v['type'], [0, 4])) $fields[$k]['value'] = is_string($vals[$k]) ? nl2br($vals[$k]) : '';
                        }
                    }
                } else {
                    if ($form) {
                        $fields[$k] = [];
                    } else {
                        $fields[$k] = [
                            'name' => $v['name'],
                            'value' => $v['type'] == 2 ? [] : '',
                            'unit' => $v['unit'],
                            'fee' => 0,
                            'key' => ''
                        ];
                    }
                }
            }
            return $fields;
        }
    }

    /**
     * 返回字段类型
     * @return array
     */
    private function fields_type()
    {
        return [
            0 => '文本框 [input]',
            1 => '列表框 [select]',
            2 => '复选 [checkbox]',
            3 => '单选 [radio]',
            4 => '文本域 [textarea]'
        ];
    }

    function __set($_name, $_val)
    {
        self::$$_name = $_val;
    }

}
