<?php
/**
 * +------------------------------------------------------------
 * | CIM 模版标签
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-01-12 16:59
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018年5月13日 21:42:41
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\common\taglib;

use think\template\TagLib;

class Cim extends TagLib
{

    /**
     * 可用标签
     */
    protected $tags = [
        'html' => ['attr' => 'id', 'close' => 0],
        'block' => ['attr' => 'id, cid, item', 'close' => 1],
        'data' => ['attr' => 'cid, type, top, pager, limit, item', 'close' => 1],
    ];

    /**
     * 区块 html
     */
    public function tagHtml($attr)
    {
        if (!isset($attr['id'])) return;
        $id = $attr['id'];
        $parse = <<<EOF
		<?php
        \$_rs = action('block/api/read', ['id'=>'$id']);
        if (!empty(\$_rs['setting'])) echo html_entity_decode(htmlspecialchars_decode(\$_rs['setting']));
		?>
EOF;
        return $parse;
    }

    /**
     * 区块 数据
     * @todo
     */
    public function tagBlock($attr, $content)
    {
        if (!isset($attr['id'])) return;
        $id = $attr['id'];
        $cid = isset($attr['cid']) ? $attr['cid'] : '';
        $item = (isset($attr['item']) ? $attr['item'] : 'v');
        $parse = <<<EOF
        <?php
        \$_rs = action('block/api/read', ['id'=>'$id','cid'=>'$cid']);
        \$__LIST__ = empty(\$_rs)||isset(\$_rs['setting'])?[]:\$_rs;
        ?>
        {foreach \$__LIST__ as \$k=>\$$item}
        $content
        {/foreach}
EOF;
        return $parse;
    }

    /**
     * 数据
     */
    public function tagData($attr, $content)
    {
        $attr['tag'] = 1;
        $_attr = var_export($attr, true);
        $item = (isset($attr['item']) ? $attr['item'] : 'v');
        $parse = <<<EOF
        <?php
        \$__ATTR__ = $_attr;
        \$_rs = action('taglib/data', [$_attr], 'widget');
        \$__LIST__ = empty(\$_rs)?[]:(isset(\$_rs['total'])?\$_rs['data']:\$_rs);
        if (isset(\$_rs['total'])) \$pager = \$_rs['pager'];
        ?>
        {foreach \$__LIST__ as \$k=>\$$item}
        $content
        {/foreach}
EOF;
        return $parse;
    }

}
