<?php
/**
 * +------------------------------------------------------------
 * | 附件基类
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-03-09 22:58:06
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-03-09 22:58:06
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\files\controller;

use app\common\controller\Init;

class Module extends Init
{

    protected static $columns = [];

    protected static $config = [];

    protected function initialize()
    {
        self::$config = config('')['files']['upload'];
        parent::initialize();
        $this->_module = [
            'fav_type' => [
                'block' => '区块',
                'index' => '数据',
                'user' => '用户'
            ]
        ];
    }

    /**
     * 上传前检测文件md5
     */
    function check_md5($md5 = [])
    {
        if (empty($md5)) return json(['code' => 2, 'msg' => '参数错误']);
        $where[] = ['md5', 'in', $md5];
        $result = db('files')->where($where)->select();
        if (empty($result)) return json(['code' => 2, 'msg' => '无数据']);
        $res = [
            'success_count' => count($result),
            'fail_count' => count((array)$md5) - count($result),
            'success' => [],
            'fail' => [],
        ];
        foreach ($result as $k => $v) {
            $res['success'][] = [
                'type' => $v['type'],
                'size' => $v['size'],
                'url' => $this->request->domain() . '/' . basename(config('')['files']['path']) . '/' . $v['path'],
                'path' => $v['path'],
                'ext' => $v['ext'],
                'md5' => $v['md5']
            ];
        }
        $res['fail'] = array_diff((array)$md5, array_column($result, 'md5'));
        return json(['code' => 1, 'msg' => '加载成功', 'data' => $res]);
    }

}