<?php
/**
 * +------------------------------------------------------------
 * |
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-04-18 00:07:36
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-04-18 00:07:36
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\files\model;

use app\common\model\Init;

class Files extends Init
{
    protected $updateTime = false;

    protected $pk = 'path';

    protected $json = ['extend'];

    protected $append = ['data_count', 'original_url'];

    protected function getFileUrlAttr($value, $data)
    {
        return str_replace('\\', DIRECTORY_SEPARATOR, env('root_path') . DIRECTORY_SEPARATOR . 'public/uploads/' . '/' . $data['path']);
    }

    protected function getThumbUrlAttr($value, $data)
    {
        return str_replace('\\', DIRECTORY_SEPARATOR, env('root_path') . DIRECTORY_SEPARATOR . 'public/uploads/thumb/' . '/' . $data['path']);
    }

    function getOriginalUrlAttr($value, $data)
    {
        return action('files/api/_init_thumb', [$data['path'], 1]);
    }

    function getExtendAttr($value)
    {
        if (is_null($value)) return '';
        return object_to_array($value);
    }

    //todo 计算数量需优化
    function getDataCountAttr()
    {
        if (empty($this->extend) || !is_array($this->extend)) return 0;
        $count = 0;
        foreach ($this->extend as $k => $v) {
            if (is_array($v)) {
                foreach ($v as $kk => $vv) {
                    $count += count($vv);
                }
            }
        }
        return $count;
    }

}