<?php
/**
 * +------------------------------------------------------------
 * | 财务 finance/controller/User.php
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\finance\controller;

use Yansongda\Pay\Log;

class User extends Module
{

    public function credit()
    {
        return view();
    }

    /**
     * 金币
     */
    public function account()
    {
        $rs = model('\app\user\model\User')->find(session('user.id'));
        $finance_setting = empty($this->finance_setting) ? [] : $this->finance_setting;
        $finance_setting['money_credit'] = empty($finance_setting['money_credit_' . session('user.group_id')]) ? 0 : $finance_setting['money_credit_' . session('user.group_id')];
        return view('', [
            'rs' => $rs,
            'finance_setting' => $finance_setting
        ]);
    }

    function convert()
    {
        $attr = input('post.');
        $attr['type'] = 1;
        $result = action('finance/api/convert', [$attr, 0]);
        if ($result['code'] == 1) {
            $this->success('兑换成功');
        } else {
            $this->error([
                'msg' => $result['msg'],
                'code' => 63001
            ]);
        }
    }

    /**
     * 交易
     */
    public function exchange()
    {
        $attr = input('param.');
        $attr['page'] = max(1, input('param.page', 0));
        $attr['with'] = 'user';
        $attr['limit'] = 15;
        $attr['user_id'] = session('user.id');
        $rs = $this->query($attr);
        $this->init_pager($rs['total']);
        return view('', ['data' => $rs['data'], 'option' => config('app.option')]);
    }

    /**
     * 充值
     */
    public function recharge()
    {
        if (request()->isPost()) {
            $attr = input('post.');
            $result = action('finance/api/recharge', [$attr, 0]);
            if ($result['code'] == 1) {
                return $result['data'];
            } else {
                $this->error([
                    'msg' => $result['msg'],
                    'code' => 63002
                ]);
            }
        }
        return view('', [
            'finance_setting' => $this->finance_setting,
            'finance_payment' => $this->finance_payment
        ]);
    }

}
