<?php
/**
 * +------------------------------------------------------------
 * | 财务 订单模型
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\finance\model;

use think\Model;

class Order extends Model
{
    protected $name = 'order';

    protected $autoWriteTimestamp = true;

    protected $append = ['balance_name', 'type_name'];

    function getBalanceNameAttr($value, $data)
    {
        return $data['balance'] ? '+' : '-';
    }

    function getTypeNameAttr($value, $data)
    {
        return $data['type'] == 0 ? '积分' : '余额';
    }

    function user()
    {
        return $this->hasOne('app\user\model\User', 'id', 'user_id')->field('pwd,money,credit,phone.email,fields', true);
    }

    function getCreateTimeAttr($value)
    {
        return date('Y-m-d H:i', $value);
    }

}