<?php
/**
 * +------------------------------------------------------------
 * | 财务 订单验证
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\finance\validate;

use think\Validate;

class Order extends Validate
{
    protected $rule = [
        'balance' => 'require|in:0,1',
        'money' => 'require|gt:0',
        'user_id' => 'require',
        'order' => 'require'
    ];
    protected $message = [
        'balance.require' => '交易类型需明确',
        'balance.in' => '交易类型为0或1',
        'money.require' => '交易金额不能为空',
        'money.gt' => '输入金额必须大于0',
        'user_id.require' => '请明确交易对象',
        'order' => '订单号不能为空'
    ];

}