<?php
/**
 * +------------------------------------------------------------
 * | 财务 信息红包验证
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\finance\validate;

use think\Validate;

class Redpack extends Validate
{
    protected $rule = [
        'data_id' => 'require|number|gt:0',
        'num' => 'require|number|gt:0',
        'type' => 'require|number|in:0,1',
        'money' => 'require'
    ];

    protected $message = [
        'data_id.require' => '数据ID不能为空',
        'data_id.number' => '数据ID必须为数字',
        'data_id.gt' => '数据ID必须大于0',
        'num.require' => '红包数量不能为空',
        'num.number' => '红包数量必须为数字',
        'num.gt' => '红包数量必须大于0',
        'type.require' => '红包类型不能为空',
        'type.number' => '红包类型必须是数字 ',
        'type.in' => '红包种类只能是等额或随机',
        'money.require' => '红包金额不能为空'
    ];
}