<?php
/**
 * +------------------------------------------------------------
 * | 财务 信息置顶
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\finance\validate;

use think\Validate;

class Top extends Validate
{
    protected $rule = [
        'data_id' => 'require|number|gt:0',
        'days' => 'require|number|gt:0'
    ];

    protected $message = [
        'data_id.require' => '数据ID不能为空',
        'data_id.number' => '数据ID必须是数字',
        'data_id.gt' => '数据ID必须大于0',
        'days.require' => '置顶天数不能为空',
        'days.number' => '置顶天数必须为数字',
        'days.gt' => '置顶天数必须大于0'
    ];
}