<?php

/**
 * +------------------------------------------------------------
 * | 数据-会员 (index/controller/User.php)
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-03-12 22:51:41
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-03-12 22:51:41
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\index\controller;

use think\Db;
use app\index\model\Data;

class User extends Module
{

    public function initialize()
    {
        parent::initialize();
        $this->_where = ['user_id' => session('user.id')];
    }

    /**
     * 信息
     */
    public function index()
    {
        $rs = action('index/api/user_data', [0, 0]);
        $this->init_pager($rs['total'], 20);
        return view('', [
            'data' => $rs['data']
        ]);
    }

    /**
     * 编辑
     */
    public function edit($key, $id)
    {
        if (request()->isPost()) {
            $data = input('post.');
            self::$column = load_column($data['column_id']);
            //更新数据
            $result = $this->_add($data);
            if ($result['code'] == 1) {
                return $this->success('信息《' . $data['name'] . '》已更新。');
            } else {
                return $this->error([
                    'msg' => $result['msg'],
                    'code' => 13001
                ]);
            }
        }
        $rs = $this->query(['key' => $key, 'id' => $id, 'where' => [['user_id', '=', self::$user['id']]]]);
        if (empty($rs)) $this->redirect('index');
        if (isset(self::$column['setting']['group'][self::$user['group_id']]['upload_limit'])) {
            $this->assign('upload_limit', self::$column['setting']['group'][self::$user['group_id']]['upload_limit']);
        } else {
            $this->assign('upload_limit', 3);
        }
        $this->assign('fields', load_fields(self::$column['id'], 0, '', 1));
        if (!empty($rs['value'])) $rs['value'] = array_column($rs['value']->toArray(), null, 'fields_id');
        if (!empty($rs['fields'])) $rs['fields'] = (array)$rs['fields'];
        return view('edit', [
            'rs' => $rs,
            'column' => self::$column,
            'area_tree' => \load_areas(),
        ]);
    }

    /**
     * 关闭
     */
    public function close($id)
    {
        action('index/api/close', [$id]);
        return $this->redirect('index');
    }

    /*
     * 评论
     */
    function comment($type = 0)
    {
        switch ($type) {
            case 0:
                //我评论的
                $data = model('app\index\model\Comment')->with('user,item')->where('user_id', '=', self::$user['id'])->order('create_time desc')->paginate(5)->toArray();
                break;
            case 1:
                //评论我的
                $data_id = db('data')->where('user_id', '=', self::$user['id'])->column('id');
                $data = model('app\index\model\Comment')->with('user,item')->where('data_id', 'in', $data_id)->where('user_id', 'neq', self::$user['id'])->order('create_time desc')->paginate(5)->toArray();
                break;
        }
        $this->init_pager($data['total'], 5);
        return view('', ['data' => $data['data']]);
    }

    /*
     * 评论删除
     */
    function comment_delete($id = [])
    {
        if (!empty($id)) {
            $data = db('comment')->where('id', 'in', $id)->select();
            if (!empty($data)) {
                $comment = [];
                foreach ($data as $k => $v) {
                    $floor = db('comment')->where('id', '=', $v['id'])->value('floor');
                    $where = [
                        ['floor', '>', $floor]
                    ];
                    if ($v['comment_id'] != 0) {
                        $comment[] = $v['data_id'];
                        $reply[] = $v['comment_id'];
                        $where[] = ['comment_id', '=', $v['comment_id']];
                        //改变回复的楼层
                        db('comment')->where($where)->setDec('floor');
                    } else {
                        $comment[] = $v['data_id'];
                        $where[] = ['data_id', '=', $v['data_id']];
                        //改变评论的楼层
                        db('comment')->where($where)->setDec('floor');
                    }
                }
                if (!empty($reply)) {
                    //更改评论的回复数量
                    $reply = array_count_values($reply);
                    foreach ($reply as $k => $v) {
                        db('comment')->where('id', '=', $k)->setDec('reply_count', $v);
                    }
                }
                if (!empty($comment)) {
                    $comment = array_count_values($comment);
                    foreach ($comment as $k => $v) {
                        db('data')->where('id', '=', $k)->setDec('comment_count', $v);
                    }
                }
                db('comment')->where('id', 'in', $id)->delete();
            }
        }
        return json(['code' => 1, 'msg' => '评论删除成功']);
    }

    /**
     * 置顶
     */
    function top($id = 0, $days = 0, $payment = '', $currency = '2')
    {
        $result = action('index/api/top', [$id, $days, $payment, 0, $currency]);
        if ($result['code'] == 1) {
            $this->success('置顶成功');
        } else {
            $this->error([
                'msg' => $result['msg'],
                'code' => 13002
            ]);
        }
    }

    /**
     * 刷新
     */
    function refresh($id = 0, $payment = '', $currency = '2')
    {
        $result = action('index/api/refresh', [$id, $payment, 0, $currency]);
        if ($result['code'] == 1) {
            $this->success('刷新成功');
        } else {
            $this->error([
                'msg' => $result['msg'],
                'code' => 13003
            ]);
        }
    }

    /**
     * 空方法解析
     */
    public function _empty($name)
    {
        //检测模板
        $name = 'index/user/' . $name;
        if (template_exists($name)) return view(template_exists($name));
        return $this->_404();
    }

}
