<?php
/**
 * +------------------------------------------------------------
 * |
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-04-17 15:10:56
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-04-17 15:10:56
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\index\model;

use app\common\model\Init;

class Column extends Init
{

    protected $name = 'column';

    public function pages()
    {
        return $this->hasOne('Pages');
    }

    public function fields()
    {
        return $this->hasMany('Fields', 'relation_id', 'id')->where('model', '=', 'column');
    }

    public function setKeywordsAttr($value)
    {
        return \is_array($value) ? join(',', $value) : $value;
    }

    public function setSettingAttr($value)
    {
        return \json_encode($value);
    }

    public function getSettingAttr($value)
    {
        return empty($value) ? '' : \json_decode($value, true);
    }

}
