<?php

/**
 * +------------------------------------------------------------
 * |
 * +------------------------------------------------------------
 * | @author zhx <10630650@qq.com>
 * +------------------------------------------------------------
 * | @time 2017-03-16 15:49
 * +------------------------------------------------------------
 * | TODO
 * +------------------------------------------------------------
 */

namespace app\index\model;

use app\common\model\Init;

class Comment extends Init
{

    protected $append = ['column', 'url', 'time'];

    protected static $columns;

    protected static function init()
    {
        self::$columns = load_columns(0);
    }

    public function user()
    {
        return $this->hasOne('\app\user\model\User', 'id', 'user_id')->field('id,group_id,name');
    }

    public function item()
    {
        return $this->hasOne('app\index\model\Data', 'id', 'data_id')->field('id, name,column_id,area_id');
    }


    function getColumnAttr($value, $data)
    {
        $rs = [];
        if (isset(self::$columns[$data['column_id']])) {
            $rs = [
                'name' => self::$columns[$data['column_id']]['name'],
                'key' => self::$columns[$data['column_id']]['key']
            ];
        }
        return $rs;
    }

    function getUrlAttr($value, $data)
    {
        if (!empty(self::$columns[$data['column_id']]['key'])) {
            return url('index/index/view', ['key' => self::$columns[$data['column_id']]['key'], 'id' => $data['data_id']]);
        }
        return '';
    }

    function reply()
    {
        return $this->hasMany('app\index\model\Comment', 'comment_id', 'id')->where('floor', '<=', '10');
    }

    function getTimeAttr($value, $data)
    {
        return time_format($data['create_time']);
    }
}
