<?php
/**
 * +------------------------------------------------------------
 * | 数据 data/controller/Module.php
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018/5/31
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018/5/31
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\index\model;

use think\facade\Env;
use think\Model;

class Feedback extends Model
{
    protected static $category;

    protected static $status;

    protected $insert = ['tags'];

    protected $name = 'feedback';

    protected $autoWriteTimestamp = true;

    protected $append = ['status_name'];

    function setTagsAttr($value)
    {
        return empty($value) ? '' : join(',', (array)$value);
    }

    function getTagsAttr($value)
    {
        return empty($value) ? [] : explode(',', $value);
    }

    protected static function init()
    {
        $config = include(Env::get('app_path') . 'index' . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . 'app.php');
        self::$status = $config['feedback_status'];
    }

    function user()
    {
        return $this->hasOne('app\user\model\User', 'id', 'user_id')->field('pwd,money,credit,phone.email,fields', true);
    }

    function getStatusNameAttr($value, $data)
    {
        return self::$status[$data['status']]['name'];
    }
}