<?php
/**
 * +------------------------------------------------------------
 * | 信息模型 data/model/Info.php
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-03-09 15:48:38
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-03-09 15:48:38
 * +------------------------------------------------------------
 * | @todo:
 * |
 * +------------------------------------------------------------
 */

namespace app\index\model;

use app\common\model\Init;

class Info extends Init
{
    protected function getPhoneAttr($value, $data)
    {
        return [
            'value' => $value,
            'hidden' => $value ? substr($value, 0, -4) . '****' : '',
            'image' => $value ? url('index/api/phone_image', ['id' => $data['data_id']]) : ''
        ];
    }

    public function getTopEndTimeAttr($value, $data)
    {
        return $value ? date('Y-m-d H:i:s', $data['top_end_time']) : '';
    }

    public function datas()
    {
        return $this->hasOne('Data', 'id', 'data_id');
    }

}
