<?php
/**
 * +------------------------------------------------------------
 * | 举报 模型
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-04-17 21:38:55
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-04-17 21:38:55
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\index\model;

use think\Model;

class Report extends Model
{

    protected $updateTime = false;

    protected $append = ['type'];

    protected $insert = ['create_time'];

    private static $cfg = [];

    protected static function init()
    {
        self::$cfg = include(realpath(dirname(__DIR__) . '/config/app.php'));
    }

    function setCreateTimeAttr()
    {
        return time();
    }

    public function getTypeAttr($value, $data)
    {
        if (isset(self::$cfg['report'][$value])) {
            return ['value' => $value, 'name' => self::$cfg['report'][$value]];
        }
        return ['value' => $value, 'name' => '-'];
    }

    public function datas()
    {
        return $this->hasOne('Data', 'id', 'data_id');
    }

    public function getTimeAttr($value, $data)
    {
        return \time_format($data['create_time']);
    }

}
