<?php
/**
 * +------------------------------------------------------------
 * | 敏感词模型
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-05-12 11:46:57
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-05-12 11:46:57
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\index\model;

use app\common\model\Init;

class Words extends Init
{

    private static $columns;

    protected $append = ['fields_name', 'column'];

    protected $auto = ['fields'];

    protected static function init()
    {
        self::$columns = load_columns(0);
    }

    function setFieldsAttr($value)
    {
        return join(',', (array)$value);
    }

    function getFieldsAttr($value)
    {
        return empty($value) ? [] : explode(',', $value);
    }

    function getFieldsNameAttr($value, $data)
    {
        if (!empty($data['fields'])) {
            $config = array_column(config('app.words'), null, 'behavior');
            $res = [];
            foreach (explode(',', $data['fields']) as $k => $v) {
                $res[] = $config[$v]['name'];
            }
            return $res;
        }
        return [];
    }

    function getColumnAttr($value, $data)
    {
        if (!empty($data['column_id']) && isset(self::$columns[$data['column_id']])) {
            return get_array_keys(self::$columns[$data['column_id']], 'name,id,url,key');
        }
        return [];
    }

}