<?php
/**
 * +------------------------------------------------------------
 * | 栏目数据验证器
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-05-23 16:32:38
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-05-23 16:32:38
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\index\validate;

use think\Validate;

class Column extends Validate
{
    protected $rule = [
        'name' => 'require',
        'key' => 'require|notIn:admin,block,cim,common,files,finance,index,message,user,wechat',
        'model' => 'require|in:common,article,info,phone,links,pages',
        'setting' => 'require'
    ];

    protected $mesage = [
        'name.require' => '栏目名称不能为空',
        'key.require' => '栏目标识不能为空',
        'key.notIn' => '系统内置的栏目标识,请更换',
        'model.require' => '请选择栏目所属模型',
        'model.in' => '栏目模型数据非法',
        'setting.require' => '请设置栏目配置'
    ];
}