<?php
/**
 * +------------------------------------------------------------
 * | 修改数据验证器
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018/7/3
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018/7/3
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\index\validate;

use think\Validate;

class DataUpdate extends Validate
{
    protected $rule = [
        'column_id' => 'require',
        'name' => 'require|max:100',
        'area_id' => 'number',
        'create_time' => 'number',
        'update_time' => 'number'
    ];

    protected $message = [
        'column.require' => '请选择要发布的栏目',
        'name.require' => '标题不能为空',
        'area_id.number' => '请选择要发布的地区',
        'create_time.number' => '日期格式错误',
        'update_time.number' => '日期格式错误',
        'name.max' => '标题长度不能超过100个字符'
    ];
}