<?php
/**
 * +------------------------------------------------------------
 * | 扩展字段验证器
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018/7/5
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018/7/5
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\index\validate;

use think\Validate;

class Fields extends Validate
{
    protected $rule = [
        'name' => 'require|max:60',
        'key' => 'require|max:20',
        'relation_id' => 'require',
        'value' => 'max:255',
        'unit' => 'max:32'
    ];

    protected $message = [
        'name.require' => '字段名称不能为空',
        'key.require' => '字段标识不能为空',
        'relation_id.require' => '请选择字段所属栏目或用户组',
        'key.max' => '标识过长',
        'name.max' => '字段名称过长',
        'unit.max' => '字段单位过长',
        'value.max' => '字段值过长'
    ];
}