<?php
/**
 * +------------------------------------------------------------
 * | 短信类 (common/controller/Sms.php)
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-04-07 15:55:08
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-04-07 15:55:08
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\message\controller;

use app\common\controller\Init;
use Overtrue\EasySms\EasySms;

class Sms extends Init
{
    private $sms;
    private $template;
    private $data;
    private $phone;
    private $content;
    private $gateways;

    function initialize()
    {
        parent::initialize();
        $this->config = config('')['sms'];
        $this->sms = new EasySms($this->config);
    }

    /**
     * 设置短信类型
     * 根据类型获得模板id
     * SMS_1，短信
     */
    function type($type, $data = [])
    {
        $types = explode('_', $type);
        $temp = $this->config[$types[0]][$this->config['default']['gateways'][0]];
        $this->$type($data);
        if (strpos($temp, '#') === false) {
            $this->template = $this->config[$types[0]][$this->config['default']['gateways'][0]];
        } else {
            $this->content($temp);
        }
        return $this;
    }

    /**
     * 设置短信内容
     * @param $content
     * @return $this
     */
    function content($content)
    {
        if (!empty($content) && !empty($this->data)) {
            foreach ($this->data as $k => $v) {
                $content = str_ireplace('#' . $k . '#', $v, $content);
            }
            $this->content = $content;
        }
    }

    /**
     * 设置接受短信手机号
     * @param $data
     * @return $this
     */
    function phone($data)
    {
        $this->phone = $data;
        return $this;
    }

    /**
     * 设置网关
     * @param $data
     */
    function gateways($data)
    {
        if (is_array($data)) {
            $this->gateways = $data;
        }
        return $this;
    }

    /**
     * 设置验证码
     */
    function verify($verify)
    {
        $this->verify = $verify;
        return $this;
    }

    /**
     * 发送短信
     * @return mixed
     */
    function send()
    {
        if (self::$sys['controller'] == 'admin' || (!empty($this->verify) && captcha_check($this->verify))) {
            $ip_key = self::$sys['ip'] . '_phone_verify';
            $cache = cache($ip_key);
            if (empty($cache) || in_array($this->phone, $cache['phone']) || count($cache['phone']) < 3 || time() > $cache['time'] + 86400) {
                $phone_key = $this->phone . '_phone_verify';
                if (empty(cache($phone_key)) || cache($phone_key)['time'] + 180 < time()) {
                    if ((!empty($this->data) && !empty($this->template)) || !empty($this->content)) {
                        if (!empty($this->phone) && $this->validate(['phone' => $this->phone], ['phone' => 'mobile']) == true) {
                            $this->result = $this->sms->send($this->phone, [
                                'content' => $this->content,
                                'template' => $this->template,
                                'data' => $this->data
                            ], $this->gateways);
                            if (empty($cache) || time() > $cache['time'] + 86400) {
                                $cache = [
                                    'phone' => [
                                        $this->phone
                                    ],
                                    'time' => time()
                                ];
                            } else {
                                if (!in_array($this->phone, $cache['phone'])) {
                                    $cache['phone'][] = $this->phone;
                                }
                            }
                            cache($phone_key, ['time' => time()]);
                            cache($ip_key, $cache);
                            $r = array('code' => '1', 'msg' => '验证码发送成功');
                        } else {
                            $r = array('code' => '0', 'msg' => '不存在的手机号');
                        }
                    } else {
                        $r = array('code' => -1, 'msg' => '参数错误，根据您的短信平台请设置模板id和模板数据或模板内容!');
                    }
                } else {
                    $r = array('code' => 0, 'msg' => '短信已发送，请注意查收....');
                }
            } else {
                $r = array('code' => 0, 'msg' => '操作过于频繁，请稍后重试....');
            }
        } else {
            $r = array('code' => 0, 'msg' => '验证码错误');
        }
        return $r;
    }

    /**
     * 验证码类短信
     */
    function SMS_1()
    {
        $code = rand(1000, 9999);
        $data = [
            'code' => $code
        ];
        $this->data = $data;
        $data['time'] = time();
        cache($this->phone, $data, 180);
    }

    /**
     * 忘记密码
     */
    function SMS_2()
    {
        $code = rand(1000, 9999);
        $data = [
            'code' => $code
        ];
        $this->data = $data;
        session('forget', ['code' => $code, 'time' => time(), 'phone' => $this->phone]);
    }

    /**
     * 重置用户密码
     */
    function PWD_1($data)
    {
        $this->data = $data;
    }

}
