<?php
/**
 * +------------------------------------------------------------
 * | 会员 user/config/app.php
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-03-10 11:38:17
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-03-10 11:38:17
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */


return [
    'name' => '用户',
    'icon' => 'fa fa-user',
    'nav' => [
        'admin' => [
            'overview' => '数据概览',
            'index' => '用户管理',
            'view' => '用户详情',
            'blacklist' => '黑名单',
            'login' => ['登录用户'],
            'move' => '移动用户',
            'group' => '用户组',
            'group_add' => '添加用户组',
            'group_edit' => '编辑用户组',
            'group_delete' => '删除用户组',
            'setting' => '模块设置',
            'delete' => '删除用户',
            'fields' => ['扩展字段'],
            'fields_add' => ['新增字段'],
            'fields_edit' => ['修改字段'],
            'fields_delete' => ['删除字段'],
            'fields_forbid' => '字段禁用',
            'reset' => '编辑用户资料',
            'add' => '添加管理员',
            'edit' => '编辑管理员',
            'admin_delete' => '删除管理员',
            'pwd' => '修改密码',
            'role' => '角色管理',
            'role_add' => '添加角色',
            'role_edit' => '编辑角色',
            'role_delete' => '删除角色',
            'admin' => '管理员管理',
            'log' => '日志管理',
            'info' => '获取用户信息'
        ],
        'user' => [
            'info' => '个人信息',
            'auth' => '身份认证',
            'favorite' => ['收藏夹'],
            'follow' => ['我关注的'],
            'inquiry' => ['我的询盘'],
            'safe' => ['安全中心'],
            'recharge' => '充值',
            'cashed' => '提现',
            'finance' => '财务明细',
            'pwd' => '修改密码',
            'log' => '帐号日志',
        ],
    ],
    'upload' => [
        'avatar' => [
            'path' => 'avatar' . DIRECTORY_SEPARATOR . ceil(session('user.id') / 10000) . DIRECTORY_SEPARATOR,
            'size' => 1024 * 2,
            'file_name' => session('user.id'),
            'ext' => 'png',
            'mark' => 0
        ]
    ],
    'group' => [
        ['id' => 0, 'name' => '游客', 'memo' => '内置用户组', 'type' => 0, 'status' => 1, 'setting' => '{"base":{"allow_login":""},"credit":{"login":""}}'],
        ['id' => 1, 'name' => '注册用户', 'memo' => '内置用户组', 'type' => 0, 'status' => 1, 'setting' => '{"base":{"allow_login":"1"},"credit":{"login":""}}']
    ],
    'like_type' => [
        'like' => '点赞',
        'fav' => '收藏'
    ],
    //自定义
    'fields' => [
        'types' => [
            0 => '单行文本 [input]',
            1 => '列表框   [select]',
            2 => '复选框   [checkbox]',
            3 => '单选     [radio]',
            4 => '文本域   [textarea]'
        ],
    ],
    'role' => [
        [
            'id' => 0,
            'type' => 0,
            'name' => '超级管理员',
            'power' => [],
            'memo' => '',
            'status' => 1
        ]
    ]
];