<?php
/**
 * +------------------------------------------------------------
 * | 用户 user/controller/Index.php
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\user\controller;

class Index extends Module
{

    /**
     * 登录
     */
    public function login()
    {
        if (request()->isPost()) {
            $result = action('user/api/login', [1, input('post.'), 0]);
            if (empty($result['code'])) {
                $this->log_user_login_error(1);
                return $this->error([
                    'msg' => $result['msg'],
                    'code' => 31001
                ]);
            }
            $this->redirect(url('user/user/index'));
        } else {
            if (!empty(session('user'))) $this->redirect('user/user/index');
            $this->assign('login_check', empty($this->user_setting['login_check']) ? 0 : 1);
            return view('../user/login');
        }
    }

    /**
     * 记录登录失败次数
     */
    public function log_user_login_error($count = '0')
    {
        $key = 'user_login_error_count';
        $result = !empty(session($key)) ? session($key) : 0;
        if ($count) {
            $result += 1;
            session($key, $result);
        }
        return $result;
    }

    /**
     * 退出登录
     */
    public function logout()
    {
        if (empty(session('user')))
            $this->redirect((self::$sys['referer'] ? self::$sys['referer'] : '/'));
        session('user', null);
        cookie(config('cookie_key') . md5(config('cookie_val')), null);
        $this->redirect((self::$sys['referer'] ? self::$sys['referer'] : '/'));
    }

    /**
     * 注册表单
     */
    public function register()
    {
        if (request()->isPost()) {
            $data = input('post.');
            $result = action('user/api/register', [1, $data, 0]);
            if ($result['code'] == 1) {
                $url = url('user/user/index');
                $this->success('注册成功，正在为您跳转...', $url);
            } else {
                $this->error([
                    'msg' => $result['msg'],
                    'code' => 31002
                ]);
            }
        } else {
            if (empty($this->user_setting['close_register'])) {
                $this->error([
                    'msg' => '系统关闭注册,请稍后重试...',
                    'code' => 31003
                ]);
            }
            if (!empty($this->user)) $this->redirect('/');
            $reg_phone_pc = empty($this->user_setting['reg_phone_pc']) ? 0 : 1;
            $reg_check = $reg_phone_pc ? 0 : (empty($this->user_setting['reg_check']) ? 0 : 1);
            $this->assign('reg_check', $reg_check);
            $this->assign('reg_phone_pc', $reg_phone_pc);
            return view('../user/register');
        }
    }

    /*
     * 忘记密码
     */
    function forget()
    {
        if ((time() - session('forget.time')) > 120)
            session('forget', null);
        $step = session('forget.step');
        $steps = input("?param.step") ? intval(input('param.step')) : 1;
        if (empty($step)) {
            $step = 1;
            if ($steps != 1) {
                $this->redirect(url('forget', ['step' => 1]));
            }
        } else {
            if ($step != $steps) {
                $this->redirect(url('forget', ['step' => $step]));
            }
        }
        if (request()->isPost()) {
            if (!input('?post.step') || !in_array(input('post.step'), [1, 2]))
                $this->error([
                    'msg' => '数据非法',
                    'code' => 31004
                ]);
            if (input('post.step') != $step) {
                $this->redirect(url('forget', ['step' => $step]));
            }
            $data = input('post.');
            if ($step == 1) {
                $phone = session('forget.phone');
                if (empty($data['phone']) || $data['phone'] != $phone)
                    $this->error([
                        'msg' => '手机号码错误',
                        'code' => 31005
                    ]);
                $rs = db('user')->where('phone', $phone)->find();
                if (empty($rs))
                    $this->error([
                        'msg' => '抱歉，此用户不存在，您可以重新注册。',
                        'code' => 31006
                    ]);
                session('forget.id', $rs['id']);
                session('forget.time', time());
                if (empty($data['code']))
                    $this->error([
                        'msg' => '验证码错误',
                        'code' => 31007
                    ]);
                $code = $data['code'];
                if ($code != session('forget.code'))
                    $this->error([
                        'msg' => '验证码错误',
                        'code' => 31007
                    ]);
                session('forget.step', 2);
                $this->redirect(url('forget', ['step' => 2]));
            }
            if ($step == 2) {
                if (empty($data['pwd']) || empty($data['repwd']))
                    $this->error([
                        'msg' => '参数错误',
                        'code' => 31009
                    ]);
                if ($data['pwd'] != $data['repwd']) {
                    $this->error([
                        'msg' => '您两次输入的密码不一致。',
                        'code' => 31010
                    ]);
                } else {
                    db('user')->where(['id' => session('forget.id')])->update(['pwd' => pwd_md5($data['pwd'])]);
                    session('forget', null);
                    $this->success('您新密码已设置成功，3秒后自动跳入登录页面。', url('login'));
                }
            }
        }
        $this->assign('phone', session('forget.phone'));
        $this->assign('step', $step);
        return view('../user/forget');
    }

    /*
     * 验证邮箱
     */
    public function verify_email($token = '')
    {
        if ($token) {
            $verify = explode("-", $token);
            $uid = decrypt($verify[0]);
            $email = decrypt($verify[1]);
            $time = $verify[2];
            if ($time + 3600 * 24 >= time()) {
                $email_info = db('user')->where('email', $email)->find();
                $user_info = db('user')->where('id', $uid)->find();
                if (!empty($email_info)) {
                    $this->error([
                        'msg' => '邮箱已被注册',
                        'code' => 31011
                    ]);
                }
                if (empty($user_info))
                    $this->error([
                        'msg' => '邮箱验证失败!',
                        'url' => url('user/user/index'),
                        'code' => 31012
                    ]);
                if (false === $reg = db('user')->where('id', $uid)->update(['email' => $email]))
                    $this->error([
                        'msg' => '邮箱验证失败!',
                        'url' => url('user/user/index'),
                        'code' => 31012
                    ]);
                $log = db('user_log')->where('user_id', '=', $user_info['id'])->where('action', '=', 'verify_email')->count();
                if (empty($log)) {
                    if (!empty($this->user_setting['bind_email_credit'])) {
                        $credit = intval($this->user_setting['bind_email_credit']);
                        $attr = [
                            'balance' => 1,
                            'money' => $credit,
                            'user_id' => $user_info['id'],
                            'payment' => 4,
                            'type' => 0,
                            'memo' => '绑定邮箱赠送【' . $credit . '】积分'
                        ];
                        //创建赠送积分订单
                        $order = action('finance/api/order', [$attr, 0]);
                        if ($order['code'] == 1) {
                            //进行支付
                            action('finance/api/credit', [['order' => $order['order']]]);
                        }
                    }
                }
                action('user/api/log', ['绑定邮箱', '', $user_info['id']]);
                $this->success('邮箱验证通过!', url('user/user/index'));
            } else {
                $this->error([
                    'msg' => '该链接已过期',
                    'url' => url('user/user/index'),
                    'code' => 31013
                ]);
            }
        } else {
            $this->error([
                'msg' => '链接无效',
                'url' => url('user/user/index'),
                'code' => 31014
            ]);
        }
    }

    /*
     * 微信login
     */
    function weixin_login($way = 'login')
    {
        $redirect_url = 'http://' . $_SERVER['HTTP_HOST'] . '/user/index/weixin_callback/way/' . $way;
        $url = "https://open.weixin.qq.com/connect/qrconnect?appid=" . config("user.open_weixin.appid") . "&redirect_uri=" . $redirect_url . "&response_type=code&scope=snsapi_login&state=STATE#wechat_redirect";
        $this->redirect($url);
    }

    /*
     * 微信callback
     */
    function weixin_callback($way = 'login')
    {
        $code = input('?request.code') ? input('request.code') : 0;
        if (!$code)
            $this->error([
                'msg' => '微信登录失败',
                'url' => url('user/user/safe_center'),
                'wait' => 3,
                'code' => 31015
            ]);
        $url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" . config("user.open_weixin.appid") . "&secret=" . config("user.open_weixin.secret") . "&code=$code&grant_type=authorization_code";
        $result = http($url, 'POST');
        $params = array();
        parse_str($result, $params);
        $result = json_decode($result, 1);
        $openid = empty($result['openid']) ? '' : $result['openid'];
        if (!empty($openid)) {
            if (self::$user['id']) {
                $bind = db('user_oauth')->where('type', '=', 3)->where('openid', '=', $openid)->find();
                if (empty($bind)) {
                    db('user_oauth')->insert([
                        'type' => 3,
                        'user_id' => self::$user['id'],
                        'openid' => $openid
                    ]);
                } else {
                    if ($bind['user_id'] != self::$user['id']) $this->error([
                        'msg' => '该微信号已绑定其他账号',
                        'code' => 31016
                    ]);
                }
                $this->success('微信号绑定成功', url('user/user/index'));
            } else {
                $result = action('user/api/register', [2, ['openid' => $openid, 'type' => 3], 0]);
                if ($result['code'] == 0) {
                    $result = action('user/api/login', [2, ['openid' => $openid, 'oauth_type' => 3], 0]);
                    if ($result['code'] == 0) $this->error($result['msg'], url('user/index/login'));
                }
                $this->redirect(url('user/user/index'));
            }
        } else {
            $this->error([
                'msg' => '微信登录失败',
                'url' => url('user/user/login'),
                'wait' => 3,
                'code' => 31015
            ]);
        }
    }

    /*
     * qq login
     */
    public function qq_login($way = 'login')
    {
        $url = 'https://graph.qq.com/oauth2.0/authorize?' . http_build_query(array(
                "response_type" => "code",
                "client_id" => config('user.qq.appid'),
                "redirect_uri" => $this->request->domain() . "/user/index/qq_callback",
                "state" => create_str(),
                "scope" => 'code'
            ));
        $this->redirect($url);
    }

    /*
     * qq callback
     */
    public function qq_callback($way = 'login')
    {
        $code = input('?request.code') ? input('request.code') : 0;
        if (!$code)
            $this->error([
                'msg' => 'QQ登录失败',
                'url' => url('user/user/safe_center'),
                'wait' => 3,
                'code' => 31018
            ]);
        $url = "https://graph.qq.com/oauth2.0/token?grant_type=authorization_code&"
            . "client_id=" . config("user.qq.appid") . "&redirect_uri=" . urlencode("http://" . $_SERVER['HTTP_HOST'] . "/user/index/qq_callback")
            . "&client_secret=" . config("user.qq.secret") . "&code=" . $code;
        $result = http($url, 'POST');
        $params = array();
        parse_str($result, $params);
        if (empty($params['access_token']))
            $this->error([
                'msg' => 'QQ登录失败',
                'url' => url('user/user/safe_center'),
                'wait' => 3,
                'code' => 31018
            ]);
        $access_token = $params['access_token'];
        $url = "https://graph.qq.com/oauth2.0/me?access_token=" . $access_token;
        $result = file_get_contents($url);
        if (strpos($result, "callback") !== false) {
            $lpos = strpos($result, "(");
            $rpos = strrpos($result, ")");
            $result = substr($result, $lpos + 1, $rpos - $lpos - 1);
        }
        $result = json_decode($result, 1);
        if (isset($result['error'])) {
            $this->error($result['error']);
        } else {
            $openid = $result['openid'];
        }
        if (!empty($openid)) {
            $oauth_info = json_decode(file_get_contents("https://graph.qq.com/user/get_user_info?access_token={$access_token}&oauth_consumer_key={$result['client_id']}&openid={$openid}"), 1);
            if (self::$user['id']) {
                $bind = db('user_oauth')->where('type', '=', 4)->where('openid', '=', $openid)->find();
                if (empty($bind)) {
                    db('user_oauth')->insert([
                        'type' => 4,
                        'user_id' => self::$user['id'],
                        'openid' => $openid,
                        'nickname' => $oauth_info['nickname']
                    ]);
                } else {
                    if ($bind['user_id'] != self::$user['id']) $this->error([
                        'msg' => '该QQ号已绑定其他账号',
                        'code' => 31019
                    ]);
                }
                $this->success('QQ号绑定成功', url('user/user/index'));
            } else {
                $result = action('user/api/register', [2, ['openid' => $openid, 'type' => 4, 'name' => $oauth_info['nickname']], 0]);
                if ($result['code'] == 0) {
                    $result = action('user/api/login', [2, ['openid' => $openid, 'oauth_type' => 4], 0]);
                    if ($result['code'] == 0) $this->error([
                        'msg' => $result['msg'],
                        'url' => url('user/index/login'),
                        'code' => 31020
                    ]);
                }
                $this->redirect(url('user/user/index'));
            }
        } else {
            $this->error([
                'msg' => 'QQ登录失败',
                'url' => url('user/user/login'),
                'wait' => 3,
                'code' => 31018
            ]);
        }
    }

}
