<?php
/**
 * +------------------------------------------------------------
 * | 用户 user/controller/Module.php
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\user\controller;

use app\common\controller\Init;

class Module extends Init
{

    protected function initialize()
    {
        parent::initialize();
        $this->assign('option', config('option'));
        self::$user = session('user');
        $this->user_setting = load_setting('user');
    }

    function query($attr = [])
    {
        is_string($attr) && $attr = \json_decode($attr, true);
        $where = [];
        if (isset($attr['keywords']) && $attr['keywords'] != '') {
            $where[] = ['name', 'like', '%' . $attr['keywords'] . '%'];
        }
        if (isset($attr['group_id']) && $attr['group_id'] != '') {
            $where[] = ['group_id', '=', $attr['group_id']];
        }
        if (isset($attr['phone'])) {
            $where[] = ['phone', '=', $attr['phone']];
        }
        if (isset($attr['email'])) {
            $where[] = ['email', '=', $attr['email']];
        }
        if (isset($attr['openid'])) {
            $attr['id'] = model('app\user\model\oauth')->where('openid', $attr['openid'])->value('uid');
        }
        if (isset($attr['status'])) {
            $where[] = ['status', '=', $attr['status']];
        }
        if (isset($attr['name'])) {
            $where[] = ['name', '=', $attr['name']];
        }
        if (self::$sys['controller'] != 'admin') {
            if (!isset($attr['id'])) {
                $attr['id'] = intval(session('user.id'));
            }
        }
        $field = (isset($attr['field']) ? $attr['field'] : '');
        $limit = (isset($attr['limit']) ? $attr['limit'] : 20);
        $order = (isset($attr['order']) ? $attr['order'] : 'id desc');
        $user = model('app\user\model\User')->where($where)->field($field)->limit($limit)->order($order);
        if (isset($attr['with'])) $user = $user->with($attr['with']);
        if (isset($attr['id'])) {
            $rs = $user->where('id', $attr['id'])->find();
            if (!empty($rs) && $rs['id'] == self::$user['id']) {
                $admin = db('admin')->alias('a')->field('a.*, r.name role_name, r.power,r.status role_status')->join('__ADMIN_ROLE__ r', 'a.role_id=r.id', 'LEFT')->where('a.id', '=', $rs['id'])->find();
                if (!empty($admin)) $rs['admin'] = 1;
            }
        } else if (isset($attr['page'])) {
            $rs = $user->paginate($limit)->toArray();
        } else {
            $rs = $user->select()->toArray();
        }
        return $rs;
    }

    /**
     * 获得所有模块的管理权限
     * @return array
     */
    public function get_nav_map()
    {
        $modules = get_dir(Env::get('app_path'));
        $_controller = self::$sys['controller'];
        $_map = [];
        foreach ($modules as $v) {
            if ($v == 'common' || !is_file(Env::get('app_path') . $v . '/config/app.php')) continue;
            $_cfg = include Env::get('app_path') . $v . '/config/app.php';
            if (isset($_cfg['nav'][$_controller]) && !empty($_cfg['nav'][$_controller])) {
                $nav = [];
                foreach ($_cfg['nav'][$_controller] as $kk => $vv) {
                    $nav[$v . '_' . $_controller . '_' . $kk] = (is_array($vv) ? $vv[0] : $vv);
                }
                $_map[$v] = ['name' => $_cfg['name'], 'controller' => $_controller, 'nav' => $nav];
            }
        }
        return $_map;
    }

}
