<?php
/**
 * +------------------------------------------------------------
 * | 用户 user/controller/User.php
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-03-12 22:51:41
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-03-12 22:51:41
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\user\controller;

use app\user\model\User as U;
use app\user\model\Auth;
use app\common\controller\Fields;

class User extends Module
{

    public function initialize()
    {
        parent::initialize();
        $this->_where = ['id' => session('user.id')];
    }

    /*
     * 首页
     */
    public function index()
    {
        $rs = session('user');
        $rs['total'] = [
            'info' => db('data')->where('user_id', '=', session('user.id'))->count(),
            'company' => 0,
            'comment' => 0
        ];
        return view('', ['rs' => $rs]);
    }

    /*
     * 修改密码
     */
    public function pwd()
    {
        if (request()->isPost()) {
            $data = input('post.');
            $result = action('user/api/pwd', [$data, 0]);
            if ($result['code'] == 1) {
                session('user.pwd', pwd_md5($data['newpwd']));
                $this->success($result['msg']);
            } else {
                $this->error([
                    'msg' => $result['msg'],
                    'code' => 33001
                ]);
            }
        } else {
            return view('');
        }
    }

    /**
     * 修改资料
     */
    public function modify()
    {
        if (self::$sys['method'] == 'post') {
            $data = get_array_keys(input('post.'), 'address,qq,mappoint,fields');
            if (empty($data['fields'])) unset($data['fields']);
            model('user')->where($this->_where)->update($data);
            session('user', array_merge(session('user'), $data));
            $this->success('您的资料已更新');
        } else {
            $this->assign('fields', load_fields(self::$user['group_id'], 0, '', 1, 'user'));
            $this->assign('rs', self::$user);
            return view();
        }
    }

    /*
     * 安全中心
     */
    public function safe()
    {
        return view('', [
            'user' => U::get(session('user.id'))
        ]);
    }

    /*
     * 用户解绑手机号
     */
    public function unbind_phone($phone = '')
    {
        $result = action('user/api/unbind_phone', [[
            'phone' => $phone,
        ], 0]);
        if ($result['code'] == 1) {
            $this->success($result['msg']);
        } else {
            $this->error([
                'msg' => $result['msg'],
                'code' => 33002
            ]);
        }
    }

    /*
     * 解绑邮箱
     */
    public function unbind_email($email = '')
    {
        $result = action('user/api/unbind_phone', [[
            'email' => $email,
        ], 0]);
        if ($result['code'] == 1) {
            $this->success($result['msg']);
        } else {
            $this->error([
                'msg' => $result['msg'],
                'code' => 33003
            ]);
        }
    }

    /*
     * 用户绑定手机号
     */
    public function bind_phone($phone = '', $code = '')
    {
        $result = action('user/api/bind_phone', [[
            'phone' => $phone,
            'code' => $code
        ], 0]);
        if ($result['code'] == 1) {
            $this->success($result['msg']);
        } else {
            $this->error([
                'msg' => $result['msg'],
                'code' => 33004
            ]);
        }
    }

    /*
    * 认证
    */
    function auth()
    {
        if (request()->isPost()) {
            $auth_info = db('user_auth')->where('user_id', '=', self::$user['id'])->find();
            $data = input('post.');
            $validate = validate('Auth');
            if ($validate->check($data) !== true) return json(['code' => 0, 'msg' => $validate->getError()]);
            $data['status'] = 2;
            $data['result'] = '您已提交身份认证，正在审核中...';
            if (empty($data['image'])) {
                $image = action('files/api/upload', [[], 0]);
                if (isset($image['success'])) $data['image'] = array_column($image['success'], 'path');
            }
            if (empty($data['image']) || count($data['image']) != 2) return json(['code' => 33005, 'msg' => '请正确上传身份证图片...']);
            if (!empty($auth_info)) {
                if ($auth_info['status'] != 3) return json(['code' => 33006, 'msg' => '您已' . ($auth_info['status'] == 1 ? '' : '提交') . '认证']);
                model('auth')->allowField(true)->save($data, ['user_id' => self::$user['id']]);
            } else {
                model('auth')->allowField(true)->data($data)->save();
            }
            //更新附件信息
            $source = [];
            if (!empty($auth_info)) {
                $source[] = [
                    'data_id' => self::$user['id'],
                    'path' => explode(',', $auth_info['image']),
                    'fields' => 'auth|image'
                ];
            }
            $update_file_info[] = [
                'data_id' => self::$user['id'],
                'path' => $data['image'],
                'fields' => 'auth|image',
            ];
            action('files/api/update_file_info', [$update_file_info, $source]);
            return json(['code' => 1, 'msg' => '提交成功']);
        } else {
            $rs['status'] = 0;
            $auth_info = model('auth')->where('user_id', '=', self::$user['id'])->find();
            return json(['code' => 1, 'data' => $auth_info]);
        }
    }

}
