<?php
/**
 * +------------------------------------------------------------
 * | 管理员模型 admin/model/Admin.php
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-03-28 10:28:23
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-04-28 10:28:23
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\user\model;

use app\common\model\Init;

class Admin extends Init
{

    public function role()
    {
        return $this->hasOne('Role', 'id', 'role_id');
    }

    function getLoginTimeAttr($value)
    {
        return $value ? date('m-d H:i', $value) : '未登录';
    }

    function setAllowWeekAttr($value)
    {
        return empty($value) ? '' : join(',', $value);
    }

    function setAllowTimeAttr($value)
    {
        return empty($value) ? '' : join(',', $value);
    }

    function getAllowWeekAttr($value)
    {
        return empty($value) ? [] : explode(',', $value);
    }

    function getAllowTimeAttr($value)
    {
        return empty($value) ? [] : explode(',', $value);
    }

}