<?php
/**
 * +------------------------------------------------------------
 * | 数据 data/controller/Module.php
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018/7/4
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018/7/4
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\user\validate;

use think\Validate;

class Edit extends Validate
{
    protected $rule = [
        'again_pwd' => 'confirm:pwd',
        'memo' => 'max:255',
        'email' => 'email|max:50',
        'phone' => 'mobile',
        'title' => 'max:10',
        'role_id' => 'number'
    ];

    protected $message = [
        'name.max' => '数据非法，账号过长',
        'again_pwd.confirm' => '两次密码输入不一致',
        'memo.max' => '备注内容过长',
        'email.email' => '邮箱格式错误',
        'email.max' => '邮箱过长',
        'phone.mobile' => '手机号格式错误',
        'title.max' => '字段长度过长',
        'role_id.number' => '角色id数据非法'
    ];
}