<?php
/**
 * +------------------------------------------------------------
 * | 用户组数据验证器
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018/7/5
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018/7/5
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\user\validate;

use think\Validate;

class Group extends Validate
{
    protected $rule = [
        'name' => 'require|max:20',
        'setting' => 'require',
        'status' => 'number',
        'memo' => 'max:30'
    ];

    protected $message = [
        'name.require' => '用户组名称不能为空',
        'name.max' => '用户组名称过长',
        'setting.require' => '请设置用户组权限',
        'status.number' => '用户组状态参数非法',
        'memo.max' => '用户组备注过长'
    ];
}