<?php
/**
 * +------------------------------------------------------------
 * | 短信配置 (config/sms.php)
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

return [
    // HTTP 请求的超时时间（秒）
    'timeout' => 5.0,

    // 默认发送配置
    'default' => [

        'strategy' => \Overtrue\EasySms\Strategies\OrderStrategy::class,

        // 默认可用的发送网关
        'gateways' => [
            'huyi'
        ],
    ],
    // 可用的网关配置
    'gateways' => [
        'errorlog' => [
            'file' => Env::get('runtime_path') . 'log/sms.log',
        ],
        //网关支持有：juhe，yunpian
        'juhe' => [
            'app_key' => ''
        ],
        'aliyun' => [
            'access_key_id' => '',
            'access_key_secret' => '',
            'sign_name' => '',
        ],
        'alidayu' => [
            'app_key' => '',
            'app_secret' => '',
            'sign_name' => '',
        ],
        'yuntongxun' => [
            'app_id' => '',
            'account_sid' => '',
            'account_token' => '',
            'is_sub_account' => false,
        ],
        'sendcloud' => [
            'sms_user' => '',
            'sms_key' => '',
            'timestamp' => false, // 是否启用时间戳
        ],
        'baidu' => [
            'ak' => '',
            'sk' => '',
            'invoke_id' => '',
            'domain' => '',
        ],
        'huyi' => [
            'api_id' => '',
            'api_key' => '',
        ],
        'yunpian' => [
            'api_key' => '',
        ],
        'submail' => [
            'app_id' => '',
            'app_key' => '',
            'project' => '',
        ],
        'luosimao' => [
            'api_key' => '',
        ],
        'huaxin' => [
            'user_id' => '',
            'password' => '',
            'account' => '',
            'ip' => '',
            'ext_no' => '',
        ],
        'chuanglan' => [
            'account' => '',
            'password' => '',
            // \Overtrue\EasySms\Gateways\ChuanglanGateway::CHANNEL_VALIDATE_CODE  => 验证码通道（默认）
            // \Overtrue\EasySms\Gateways\ChuanglanGateway::CHANNEL_PROMOTION_CODE => 会员营销通道
            'channel' => \Overtrue\EasySms\Gateways\ChuanglanGateway::CHANNEL_VALIDATE_CODE,
            // 会员营销通道 特定参数。创蓝规定：api提交营销短信的时候，需要自己加短信的签名及退订信息
            'sign' => '【通讯云】',
            'unsubscribe' => '回TD退订',
        ],
        'rongcloud' => [
            'app_key' => '',
            'app_secret' => '',
        ],
        'tianyiwuxian' => [
            'username' => '',
            'password' => '',
            'gwid' => '',
        ],
        'twilio' => [
            'account_sid' => '', // sid
            'from' => '', // 发送的号码 可以在控制台购买
            'token' => '', // apitoken
        ],
        'qcloud' => [
            'sdk_app_id' => '', // SDK APP ID
            'app_key' => '', // APP KEY
        ],
        'avatardata' => [
            'app_key' => '', // APP KEY
        ],
    ],
    //验证码短信配置
    'SMS' => [
        //在这里填写使用平台中的模板id
        //如果使用的平台是用内容发布，请填写模板内容，并将变量替换成#code#
        //其他类型短信请自行扩展
        'juhe' => '',
        'aliyun' => '',
        'alidayu' => '',
        'yuntongxun' => '',
        'sendcloud' => '',
        'baidu' => '',
        'huyi' => '您的验证码是：#code#。请不要把验证码泄露给其他人。',
        'avatardata' => '',
        'twilio' => '',
        'tianyiwuxian' => '',
        'rongcloud' => '',
        'chuanglan' => '',
        'huaxin' => '',
        'luosimao' => '',
        'submail' => '',
        'yunpian' => '',
        'cache_time' => ''
    ]
];
