<?php

/**
 * +------------------------------------------------------------
 * | CIM分页类 (Pager.php)
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018-09-16
 * +------------------------------------------------------------
 * | @copyright: CIM信息聚合系统 (https://cimxx.com)
 * +------------------------------------------------------------
 */

class Pager
{
    public $firstRow; // 起始行数
    public $listRows; // 列表每页显示行数
    public $parameter; // 分页跳转时要带的参数
    public $prevPage;
    public $nextPage;
    public $totalRows; // 总行数
    public $totalPages; // 分页总页面数
    public $rollPage = 5;// 分页栏每页显示的页数

    private $p = 'page'; //分页参数名
    private $url = ''; //当前链接URL
    private $nowPage = 1;

    /**
     * 架构函数
     * @param array $totalRows 总的记录数
     * @param array $listRows 每页显示记录数
     * @param array $parameter 分页跳转的参数
     */
    public function __construct($totalRows, $listRows = 20, $parameter = array())
    {
        config('var_page') && $this->p = config('var_page'); //设置分页参数名称
        /* 基础设置 */
        $this->totalRows = $totalRows; //设置总记录数
        $this->listRows = $listRows;  //设置每页显示行数
        $this->parameter = empty($parameter) ? input('param.') : $parameter;
        $this->nowPage = max(1, intval(input('param.' . $this->p)));
        $this->firstRow = $this->listRows * ($this->nowPage - 1);
    }

    /**
     * 生成链接URL
     * @param  integer $page 页码
     * @return string
     */
    private function url($page)
    {
        return str_replace(urlencode('[PAGE]'), $page, $this->url);
    }

    /**
     * 返回所有分页相关元素
     */
    public function result()
    {
        $result = [];
        if (0 == $this->totalRows) return;

        /* 生成URL */
        $this->parameter[$this->p] = '[PAGE]';
        $this->url = url(request()->module() . '/' . strtolower(request()->controller()) . '/' . request()->action(), $this->parameter);
        /* 计算分页信息 */
        $this->totalPages = ceil($this->totalRows / $this->listRows); //总页数
        if (!empty($this->totalPages) && $this->nowPage > $this->totalPages) {
            $this->nowPage = $this->totalPages;
        }

        $result['page'] = $this->nowPage;
        $result['total'] = $this->totalPages;
        $result['count'] = $this->totalRows;
        $result['rows'] = $this->listRows;
        $result['current'] = $this->url($this->nowPage);
        $result['prev'] = ($this->nowPage > 1) ? $this->url($this->nowPage - 1) : '';
        $result['next'] = ($this->nowPage < $this->totalPages) ? $this->url($this->nowPage + 1) : '';
        $result['first'] = $this->url(1);
        $result['last'] = $this->url($this->totalPages);
        $result['nav'] = [];

        /* 计算分页临时变量 */
        $delimiter = $this->rollPage / 2;
        for ($i = 1; $i <= $this->rollPage; $i++) {
            if (($this->nowPage - $delimiter) <= 0) {
                $n = $i;
            } elseif (($this->nowPage + $delimiter - 1) >= $this->totalPages) {
                $n = $this->totalPages - $this->rollPage + $i;
            } else {
                $n = $this->nowPage - ceil($delimiter) + $i;
            }
            if ($n > 0 && $n <= $this->totalPages) {
                $result['nav'][$n] = $this->url($n);
            }
        }
        return $result;
    }

}
