-- --------------------------------------------------------
-- CIM城市信息聚合系统 0.9.3
--
-- MYSQL版本要求 >= 5.7
--
-- 感谢您关注CIM，获取更多信息请访问 https://cimxx.com
--
-- --------------------------------------------------------

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';


--
-- Database: `cim`
-- Version: 0.9.3_181222
--


--
-- 表的结构 `cim_addons`
--

DROP TABLE IF EXISTS `cim_addons`;
CREATE TABLE `cim_addons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `desc` varchar(200) NOT NULL DEFAULT '',
  `version` varchar(10) NOT NULL DEFAULT '',
  `author` varchar(20) NOT NULL DEFAULT '',
  `setting` varchar(2000) NOT NULL DEFAULT '',
  `admin` tinyint(4) NOT NULL DEFAULT '0',
  `create_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- 表的结构 `cim_admin`
--

DROP TABLE IF EXISTS `cim_admin`;
CREATE TABLE `cim_admin` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '角色ID',
  `title` varchar(10) NOT NULL DEFAULT '' COMMENT '姓名',
  `memo` varchar(255) NOT NULL DEFAULT '' COMMENT '备注',
  `create_admin_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '创建者ID',
  `create_admin_name` varchar(20) NOT NULL DEFAULT '' COMMENT '创建者帐号',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `login_ip` varchar(15) NOT NULL DEFAULT '' COMMENT '登录IP',
  `login_total` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '登录次数',
  `login_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '登录时间',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `allow_week` varchar(20) NOT NULL DEFAULT '' COMMENT '允许登录周',
  `allow_time` varchar(80) NOT NULL DEFAULT '' COMMENT '允许登录小时',
  `user_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='管理员';

--
-- 表的结构 `cim_admin_role`
--

DROP TABLE IF EXISTS `cim_admin_role`;
CREATE TABLE `cim_admin_role` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '角色类型',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '角色名称',
  `power` text NOT NULL COMMENT '角色权限',
  `memo` varchar(500) NOT NULL DEFAULT '' COMMENT '备注',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态 0正常 1禁用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='管理员角色';

--
-- 表的结构 `cim_area`
--

DROP TABLE IF EXISTS `cim_area`;
CREATE TABLE `cim_area` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` smallint(6) unsigned NOT NULL DEFAULT '0',
  `name` varchar(20) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='地区';


SET NAMES utf8mb4;

--
-- 表的结构 `cim_article`
--

DROP TABLE IF EXISTS `cim_article`;
CREATE TABLE `cim_article` (
  `data_id` int(11) unsigned NOT NULL DEFAULT '0',
  `content` text CHARACTER SET utf8mb4 NOT NULL,
  `title` varchar(80) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `keywords` varchar(100) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `description` varchar(200) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  PRIMARY KEY (`data_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='数据内容';

--
-- 表的结构 `cim_block`
--

DROP TABLE IF EXISTS `cim_block`;
CREATE TABLE `cim_block` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL DEFAULT '',
  `key` varchar(20) NOT NULL DEFAULT '' COMMENT '标识',
  `setting` text NOT NULL,
  `memo` varchar(255) NOT NULL DEFAULT '',
  `admin_id` varchar(255) NOT NULL DEFAULT '' COMMENT '具备权限的管理员，多个使用逗号分割',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0',
  `refresh_time` int(11) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='区块';

--
-- 表的结构 `cim_block_data`
--

DROP TABLE IF EXISTS `cim_block_data`;
CREATE TABLE `cim_block_data` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `block_id` smallint(6) unsigned NOT NULL DEFAULT '0',
  `data_id` int(11) unsigned NOT NULL DEFAULT '0',
  `column_id` smallint(6) unsigned NOT NULL DEFAULT '0',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `name` varchar(100) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `thumb` varchar(100) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `url` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `extend_fields` varchar(1000) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0',
  `end_time` int(11) unsigned NOT NULL DEFAULT '0',
  `list_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `fields` json DEFAULT NULL,
  `delete_time` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `column_id` (`column_id`),
  KEY `block_id` (`block_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='区块数据';

--
-- 表的结构 `cim_cert`
--

DROP TABLE IF EXISTS `cim_cart`;
CREATE TABLE `cim_cart` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL DEFAULT '',
  `key` varchar(15) NOT NULL DEFAULT '',
  `extend` varchar(200) NOT NULL DEFAULT '',
  `create_time` int(11) NOT NULL DEFAULT '0',
  `memo` varchar(100) NOT NULL DEFAULT '',
  `data_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- 表的结构 `cim_column`
--

DROP TABLE IF EXISTS `cim_column`;
CREATE TABLE `cim_column` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` smallint(6) unsigned NOT NULL DEFAULT '0',
  `model` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(20) NOT NULL DEFAULT '',
  `key` varchar(20) NOT NULL DEFAULT '',
  `title` varchar(50) NOT NULL DEFAULT '',
  `keywords` varchar(100) NOT NULL DEFAULT '',
  `description` varchar(200) NOT NULL DEFAULT '',
  `url` varchar(200) NOT NULL DEFAULT '' COMMENT '外链URL',
  `setting` varchar(2000) NOT NULL DEFAULT '',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0',
  `list_order` smallint(6) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`),
  KEY `module` (`model`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='栏目';

--
-- 表的结构 `cim_comment`
--

DROP TABLE IF EXISTS `cim_comment`;
CREATE TABLE `cim_comment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `column_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '栏目id',
  `data_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '数据ID',
  `comment_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '评论ID',
  `content` varchar(500) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '内容',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '发布时间',
  `to_user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '回复用户ID',
  `to_user_name` varchar(20) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '回复用户昵称',
  `reply_count` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '回复数',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态 0待审  1正常',
  `os` tinyint(1) NOT NULL DEFAULT '0',
  `floor` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '楼层',
  `type` varchar(10) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '评论类型',
  `display` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否显示在我的摊位',
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `type_data_id` (`data_id`),
  KEY `type_uid` (`user_id`),
  KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='评论';

--
-- 表的结构 `cim_data`
--

DROP TABLE IF EXISTS `cim_data`;
CREATE TABLE `cim_data` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `column_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `area_id` smallint(6) unsigned NOT NULL DEFAULT '0',
  `name` varchar(100) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `thumb` varchar(50) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `hits` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `list_order` smallint(6) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0',
  `end_time` int(11) unsigned NOT NULL DEFAULT '0',
  `delete_time` int(11) unsigned NOT NULL DEFAULT '0',
  `fields` json DEFAULT NULL,
  `ip` varchar(15) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT 'ip',
  `port` varchar(6) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '端口',
  `os` varchar(20) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '来源',
  `behavior` varchar(1000) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '行为',
  `top_end_time` int(11) NOT NULL DEFAULT '0',
  `comment_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '评论数量',
  `pay` tinyint(1) NOT NULL DEFAULT '0' COMMENT '支付状态0=无需支付，2=待支付，1=已支付',
  PRIMARY KEY (`id`),
  KEY `column_id` (`column_id`),
  KEY `user_id` (`user_id`),
  KEY `area_id` (`area_id`),
  KEY `update_time` (`update_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='数据';

--
-- 表的结构 `cim_data_behavior`
--

DROP TABLE IF EXISTS `cim_data_behavior`;
CREATE TABLE `cim_data_behavior` (
  `name` varchar(15) NOT NULL DEFAULT '' COMMENT '行为名称',
  `data_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '数据id',
  `extend` varchar(1000) NOT NULL DEFAULT '' COMMENT '扩展数据',
  `key` varchar(32) NOT NULL DEFAULT '',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- 表的结构 `cim_data_image`
--

DROP TABLE IF EXISTS `cim_data_image`;
CREATE TABLE `cim_data_image` (
  `data_id` int(11) unsigned NOT NULL DEFAULT '0',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `path` varchar(50) NOT NULL DEFAULT '',
  `intro` varchar(255) NOT NULL DEFAULT '',
  `list_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  KEY `id` (`data_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='数据图片';

--
-- 表的结构 `cim_data_memo`
--

DROP TABLE IF EXISTS `cim_data_memo`;
CREATE TABLE `cim_data_memo` (
  `data_id` int(11) unsigned NOT NULL DEFAULT '0',
  `memo` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`data_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='数据备注';

--
-- 表的结构 `cim_data_text`
--

DROP TABLE IF EXISTS `cim_data_text`;
CREATE TABLE `cim_data_text` (
  `data_id` int(11) unsigned NOT NULL DEFAULT '0',
  `fields_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `value` text NOT NULL,
  PRIMARY KEY (`data_id`,`fields_id`),
  KEY `id` (`data_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='数据扩展字段文本值';

--
-- 表的结构 `cim_feedback`
--

DROP TABLE IF EXISTS `cim_feedback`;
CREATE TABLE `cim_feedback` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(50) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '标题',
  `content` varchar(1000) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '反馈内容',
  `tags` varchar(50) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '标签',
  `linkway` varchar(30) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0待处理，1已查看，2已回复',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- 表的结构 `cim_fields`
--

DROP TABLE IF EXISTS `cim_fields`;
CREATE TABLE `cim_fields` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `relation_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `name` varchar(60) NOT NULL DEFAULT '',
  `key` varchar(20) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `value` varchar(1000) NOT NULL DEFAULT '',
  `unit` varchar(32) NOT NULL DEFAULT '',
  `search` tinyint(1) NOT NULL DEFAULT '0',
  `list_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(3) NOT NULL DEFAULT '0',
  `list_show` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1列表显示，0不显示',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否必填，0否，1是',
  `use` tinyint(1) NOT NULL DEFAULT '1' COMMENT '允许用户使用',
  `orders` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否参与排序',
  `default` varchar(20) NOT NULL DEFAULT '' COMMENT '扩展字段默认值',
  `model` varchar(15) NOT NULL DEFAULT '',
  `search_item` varchar(300) DEFAULT '' NOT NULL,
  PRIMARY KEY (`id`),
  KEY `catid` (`relation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='附加字段';

--
-- 表的结构 `cim_files`
--

DROP TABLE IF EXISTS `cim_files`;
CREATE TABLE `cim_files` (
  `path` varchar(100) NOT NULL DEFAULT '' COMMENT '路径',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '文件类型 0图片 1文件',
  `size` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '附件的大小',
  `ext` varchar(10) NOT NULL DEFAULT '' COMMENT '扩展名',
  `md5` varchar(32) NOT NULL DEFAULT '',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '附件添加时间',
  `extend` json DEFAULT NULL,
  PRIMARY KEY (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='附件';

--
-- 表的结构 `cim_info`
--

DROP TABLE IF EXISTS `cim_info`;
CREATE TABLE `cim_info` (
  `data_id` int(11) unsigned NOT NULL DEFAULT '0',
  `content` varchar(500) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `linkman` varchar(32) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `phone` varchar(13) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `address` varchar(255) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `password` varchar(32) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  PRIMARY KEY (`data_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='信息';

--
-- 表的结构 `cim_keywords`
--

DROP TABLE IF EXISTS `cim_keywords`;
CREATE TABLE `cim_keywords` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='关键字';

--
-- 表的结构 `cim_like`
--

DROP TABLE IF EXISTS `cim_like`;
CREATE TABLE `cim_like` (
  `user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `to_user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `data_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '数据id',
  `type` varchar(10) NOT NULL DEFAULT '',
  `os` tinyint(1) DEFAULT '0',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0',
  `delete_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '删除时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- 表的结构 `cim_links`
--

DROP TABLE IF EXISTS `cim_links`;
CREATE TABLE `cim_links` (
  `data_id` int(11) unsigned NOT NULL DEFAULT '0',
  `url` varchar(100) NOT NULL DEFAULT '',
  `end_time` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`data_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='链接';

--
-- 表的结构 `cim_message`
--

DROP TABLE IF EXISTS `cim_message`;
CREATE TABLE `cim_message` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `content` varchar(100) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '消息内容',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `admin_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '管理员id',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0未读，1已读',
  `extend` varchar(150) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `module` varchar(15) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `url` varchar(100) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- 表的结构 `cim_order`
--

DROP TABLE IF EXISTS `cim_order`;
CREATE TABLE `cim_order` (
  `id` varchar(32) NOT NULL COMMENT '系统订单',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `balance` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0支出，1收入',
  `money` float(10,2) NOT NULL COMMENT '金额',
  `memo` varchar(50) NOT NULL DEFAULT '' COMMENT '备注',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0，交易中，1交易完成，2交易失败',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `payment` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0系统总送，1积分，2余额，3微信，4支付宝',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0积分，1余额',
  `trade_no` varchar(32) NOT NULL DEFAULT '' COMMENT '第三方订单',
  `behavior` varchar(100) NOT NULL DEFAULT '' COMMENT '行为',
  `extend` varchar(200) NOT NULL DEFAULT '' COMMENT '附加数据',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- 表的结构 `cim_order_goods`
--

DROP TABLE IF EXISTS `cim_order_goods`;
CREATE TABLE `cim_order_goods` (
  `order_id` varchar(32) NOT NULL DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `user_credit` smallint(6) NOT NULL DEFAULT '0',
  `user_money` float(10,2) NOT NULL DEFAULT '0.00',
  `money` float(10,2) NOT NULL DEFAULT '0.00',
  `extend` json DEFAULT NULL,
  `behavior` varchar(15) NOT NULL DEFAULT '',
  `create_time` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- 表的结构 `cim_order_log`
--

DROP TABLE IF EXISTS `cim_order_log`;
CREATE TABLE `cim_order_log` (
  `order_id` varchar(32) NOT NULL DEFAULT '',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0',
  `memo` varchar(50) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- 表的结构 `cim_pages`
--

DROP TABLE IF EXISTS `cim_pages`;
CREATE TABLE `cim_pages` (
  `column_id` int(11) unsigned NOT NULL DEFAULT '0',
  `content` text CHARACTER SET utf8mb4 NOT NULL,
  PRIMARY KEY (`column_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='页面';

--
-- 表的结构 `cim_phone`
--

DROP TABLE IF EXISTS `cim_phone`;
CREATE TABLE `cim_phone` (
  `data_id` int(11) unsigned NOT NULL DEFAULT '0',
  `phone` varchar(20) NOT NULL DEFAULT '',
  `address` varchar(50) NOT NULL DEFAULT '',
  `intro` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`data_id`),
  KEY `phone` (`phone`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='便民电话';

--
-- 表的结构 `cim_report`
--

DROP TABLE IF EXISTS `cim_report`;
CREATE TABLE `cim_report` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `column_id` smallint(6) unsigned NOT NULL DEFAULT '0',
  `data_id` int(11) unsigned NOT NULL DEFAULT '0',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0',
  `ip` varchar(15) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `data_id` (`data_id`),
  KEY `type` (`type`),
  KEY `column_id` (`column_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='举报';

--
-- 表的结构 `cim_setting`
--

DROP TABLE IF EXISTS `cim_setting`;
CREATE TABLE `cim_setting` (
  `id` varchar(20) NOT NULL COMMENT '缓存id',
  `value` varchar(2000) NOT NULL DEFAULT '' COMMENT '值',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='设置';

INSERT INTO `cim_setting` (`id`, `value`, `update_time`) VALUES
('cim',	'{\"name\":\"CIM\\u57ce\\u5e02\\u4fe1\\u606f\\u805a\\u5408\\u7cfb\\u7edf\",\"domain\":\"https:\\/\\/cimxx.com\",\"mobile_domain\":\"https:\\/\\/cimxx.com\\/mobile\\/#\",\"title\":\"CIM\\u57ce\\u5e02\\u4fe1\\u606f\\u805a\\u5408\\u7cfb\\u7edf\\u3010\\u8ba9\\u57ce\\u5e02\\u7684\\u4fe1\\u606f\\u66f4\\u6709\\u4ef7\\u503c\\u3011\",\"keywords\":\"\\u5206\\u7c7b\\u4fe1\\u606f,cim,\\u57ce\\u5e02\\u4fe1\\u606f\\u805a\\u5408\\u7cfb\\u7edf\",\"description\":\"\",\"close\":\"1\",\"close_tips\":\"\",\"onlyarea\":\"\\u5317\\u4eac,\\u5b9b\\u57ce,\\u5367\\u9f99,\\u6cb3\\u5357,\\u5185\\u7f51,\\u672c\\u673a\",\"del_m_info\":\"1\",\"del_m_comment\":\"1\",\"mapapi\":\"https:\\/\\/api.map.baidu.com\\/api?v=2.0&ak=ZkkNcmILTigDGm0UbWtL6cfSGS5nhZBD\",\"mapflag\":\"baidu\",\"map_view_level\":\"15\",\"mapapi_charset\":\"\",\"map\":\"\",\"id\":\"cim\",\"mobile\":\"1\"}',	1539306481),
('finance',	'{\"version\":\"0.8.0\",\"money_credit_0\":\"1\",\"money_credit_1\":\"1\",\"money_credit_2\":\"1\",\"id\":\"finance\"}',	1538116261);

--
-- 表的结构 `cim_temp`
--

DROP TABLE IF EXISTS `cim_temp`;
CREATE TABLE `cim_temp` (
  `id` tinyint(3) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `cim_temp` (`id`) VALUES
(0),
(1),
(2),
(3),
(4),
(5),
(6),
(7),
(8),
(9),
(10),
(11),
(12),
(13),
(14),
(15),
(16),
(17),
(18),
(19),
(20),
(21),
(22),
(23),
(24),
(25),
(26),
(27),
(28),
(29),
(30),
(31),
(32),
(33),
(34),
(35),
(36),
(37),
(38),
(39),
(40),
(41),
(42),
(43),
(44),
(45),
(46),
(47),
(48),
(49),
(50),
(51),
(52),
(53),
(54),
(55),
(56),
(57),
(58),
(59),
(60),
(61),
(62),
(63),
(64),
(65),
(66),
(67),
(68),
(69),
(70),
(71),
(72),
(73),
(74),
(75),
(76),
(77),
(78),
(79),
(80),
(81),
(82),
(83),
(84),
(85),
(86),
(87),
(88),
(89),
(90),
(91),
(92),
(93),
(94),
(95),
(96),
(97),
(98),
(99),
(100);

--
-- 表的结构 `cim_user`
--

DROP TABLE IF EXISTS `cim_user`;
CREATE TABLE `cim_user` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT '组id',
  `name` varchar(32) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `email` varchar(60) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `pwd` varchar(32) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `qq` varchar(15) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `phone` varchar(11) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `address` varchar(100) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `mappoint` varchar(50) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00',
  `credit` smallint(5) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `auth` tinyint(1) NOT NULL DEFAULT '0',
  `fields` json DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='用户';

--
-- 表的结构 `cim_user_auth`
--

DROP TABLE IF EXISTS `cim_user_auth`;
CREATE TABLE `cim_user_auth` (
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `name` varchar(15) NOT NULL DEFAULT '' COMMENT '真实姓名',
  `id_card` varchar(18) NOT NULL DEFAULT '' COMMENT '身份证号',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1认证通过，2已提交，3认证未通过',
  `memo` varchar(30) NOT NULL DEFAULT '' COMMENT '描述',
  `image` varchar(100) NOT NULL DEFAULT '' COMMENT '身份证图片',
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- 表的结构 `cim_user_group`
--

DROP TABLE IF EXISTS `cim_user_group`;
CREATE TABLE `cim_user_group` (
  `id` smallint(6) NOT NULL,
  `name` varchar(20) NOT NULL DEFAULT '',
  `setting` varchar(500) NOT NULL DEFAULT '',
  `status` tinyint(3) NOT NULL DEFAULT '0',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0系统内置，1自定义',
  `memo` varchar(30) NOT NULL DEFAULT '' COMMENT '注释',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户组';

--
-- 表的结构 `cim_user_log`
--

DROP TABLE IF EXISTS `cim_user_log`;
CREATE TABLE `cim_user_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` smallint(6) unsigned NOT NULL DEFAULT '0',
  `admin_id` smallint(6) unsigned NOT NULL DEFAULT '0',
  `module` varchar(20) NOT NULL DEFAULT '',
  `action` varchar(20) NOT NULL DEFAULT '',
  `ip` varchar(15) NOT NULL DEFAULT '',
  `port` varchar(6) NOT NULL DEFAULT '',
  `os` varchar(20) NOT NULL DEFAULT '',
  `browser` varchar(50) NOT NULL DEFAULT '',
  `event` varchar(50) NOT NULL DEFAULT '',
  `memo` varchar(500) NOT NULL DEFAULT '',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='用户日志';

--
-- 表的结构 `cim_user_oauth`
--

DROP TABLE IF EXISTS `cim_user_oauth`;
CREATE TABLE `cim_user_oauth` (
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `openid` varchar(32) NOT NULL DEFAULT '' COMMENT '凭证',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '类型(1=微信 2=小程序)',
  `nickname` varchar(30) NOT NULL DEFAULT '' COMMENT '昵称'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- 表的结构 `cim_wechat_reply`
--

DROP TABLE IF EXISTS `cim_wechat_reply`;
CREATE TABLE `cim_wechat_reply` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(60) NOT NULL DEFAULT '',
  `type` varchar(15) NOT NULL DEFAULT '',
  `content` varchar(500) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `ext` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- 表的结构 `cim_words`
--

DROP TABLE IF EXISTS `cim_words`;
CREATE TABLE `cim_words` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `fields` varchar(200) NOT NULL DEFAULT '',
  `level` tinyint(1) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `column_id` tinyint(6) NOT NULL DEFAULT '0' COMMENT '栏目id',
  `url` varchar(100) NOT NULL DEFAULT '' COMMENT '链接地址',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='词库';