/**
 * +------------------------------------------------------------
 * | 评论 (cim/comment.js)
 * +------------------------------------------------------------
 * | @copyright: CIM (https://cimxx.com)
 * +------------------------------------------------------------
 * | 
 * | 
 * +------------------------------------------------------------
 */

define(['require', 'template', 'layer'], function (require, template, layer) {

    var comment = {
        tpl: $('#tpl_comment').html(),
        tpl_empty: $('#tpl_comment_empty').html(),
        tpl_reply: $('#tpl_comment_reply').html(),
        tpl_add: $('#tpl_comment_add').html(),
        init: function () {
            $('.comment_data').each(function () {
                if (parseInt($('.comment_count').html()) > 0) {
                    get_comments($(this));
                } else {
                    $(this).html(template(comment.tpl_empty));
                }
            });
            function get_comments($this) {
                var $rs = {
                    type: $this.data('type') != undefined ? $this.data('type') : sys.module,
                    data_id: $this.data('id'),
                    comment_id: ''
                };
                if ($this.data('comment_id') != undefined) {
                    $rs.comment_id = $this.data('comment_id');
                }
                $.getJSON('/index/api/comment', $rs, function (rs) {
                    $this.parent().find('.comment_count').html(rs.data.length);
                    if (rs.data.length > 0) {
                        $this.html(template(($this.data('comment_id') != undefined ? comment.tpl_reply : comment.tpl), rs));
                    } else {
                        $this.html(template(comment.tpl_empty));
                    }
                });
            }
            $('#comment').on('click', '.btn-comment', function () {
                var obj = $(this);
                var data = {
                    user_id: obj.data('user_id') || sys.data.user_id,
                    content: obj.parent().parent().find("textarea[name=content]").val(),
                    column_id: obj.data('column_id') ? obj.data('column_id') : sys.data.cid,
                    data_id: obj.data('id') || sys.view.id,
                    comment_id: obj.data('comment_id')
                };
                if (data.content == '') {
                    layer.msg('请完整输入评论信息');
                    return false;
                }
                $.post("/index/api/comment", data, function (rs) {
                    layer.msg(rs.msg);
                    if (rs.code == 1) {
                        $(".comment_form textarea[name=content]").val('');
                        $('.comment_data').prepend(template(comment.tpl_add, rs)).find('.comment_empty').remove();
                    }
                }, 'json');
            });
            $('#comment').on('click', '.btn_comment_reply', function (e) {
                var id = $(this).data("id");

                var data = {
                    type: $(this).data('type') || sys.module,
                    data_id: $(this).data('id') || sys.view.id,
                    comment_id: $(this).data("comment_id"),
                    to_user_id: $(this).data('uid'),
                    to_user_name: $(this).data('username'),
                };
                var obj = $('#comment_reply_' + data.comment_id);
                if (obj.html() == '') {
                    $.getJSON('/index/api/comment', data, function (rs) {
                        //$this.parent().find('.comment_count').html(rs.data.length);
                        obj.html(template(comment.tpl_reply, rs));

                        obj.on('click', 'button', function () {
                            var _input = obj.find('input');
                            if (_input.data('uid')) data.to_user_id = _input.data('uid');
                            if (_input.data('username')) data.to_user_name = _input.data('username');
                            data.content = _input.val();
                            $.post("/index/api/comment", data, function (rs) {
                                layer.msg(rs.msg);
                                if (rs.code == 0) obj.find('input').val('');
                                obj.find('.comment_post').before(template(comment.tpl_add, rs));
                                return false;
                            }, 'json');
                        });
                    });
                } else {
                    if (obj.hasClass('hide')) {
                        obj.removeClass('hide');
                    } else {
                        obj.addClass('hide');
                    }
                }
                obj.on('click', 'a.reply_up', function () {
                    obj.addClass('hide');
                });
            });
            $('#comment').on('click', '.btn_floor_reply', function (e) {
                $('#comment_reply_' + $(this).data('id')).find('.comment_post input').data('uid', $(this).data('uid')).data('username', $(this).data('username')).val('@' + $(this).data('username') + ' ').focus();
            });
        },
        add: function () {

        },
    };

    return comment;
});