/**
 * +------------------------------------------------------------
 * | 附件 (cim/files.js)
 * +------------------------------------------------------------
 * | @copyright: CIM (https://cimxx.com)
 * +------------------------------------------------------------
 */

define(['require', 'layer'], function (require, layer) {

    var files = {
        list : [],
        wrap : $("[rel=cim_upload]"),
        preview : $("[rel=cim_upload] [rel=preview]"),
        item : $('[rel=cim_upload] [rel=preview] .item'),
        limit : 0,
        init : function(){
            var self = this;
            self.wrap.find('input[type=file]').on('change', function(){
                var files_list = $(this).get(0).files;
                self.limit = $(this).data('length');
                for (var i=0; i<files_list.length; i++) {
                    if (!/image\/\w+/.test(files_list[i].type)) continue;
                    if (i >= $(this).data('length')) break;
                    self.check(files_list[i]);
                }
            });
            self.preview.on('click', 'em', function(){
                self.list.splice($(this).parent().index(), 1);
                $(this).parent().remove();
            });
        },
        render : function(file) {
            var reader = new FileReader();
            reader.readAsDataURL(file);
            reader.onloadend = function () {
                files.preview.append('<div class="item"><img src="' + this.result + '" alt="" /><em>&times;</em></div>');
            }
        },
        check : function(file) {
            if (this.list.length>0) {
                for (var i=0; i<this.list.length; i++) {
                    if (file.name == files.list[i].name) {
                        layer.msg('文件《'+ file.name +'》已选择');
                        return false;
                    }
                }
            }
            require(['plugin/browser-md5-file.min'], function(md5) {
                md5(file, function(err, id) {
                    $.post("/files/api/check_md5", { md5: id }, function(rs) {
                        if (files.list.length >= files.limit) {
                            layer.msg('上传数量已达到最大限额');
                            return false;
                        }else{
                            if (rs.code == 1) {
                                rs = rs.data;
                                if (rs.success_count == 1) {
                                    if ($.inArray(rs.success[0].path, files.list)>-1) {
                                        layer.msg('文件《'+ file.name +'》已选择');
                                        return false;
                                    }
                                    files.list.push(rs.success[0].path);
                                }
                            }else{
                                files.list.push(file);
                            }
                            files.render(file);
                        }
                    }, "json");
                });
            });
        },
    };
    return files;
});