/**
 * +------------------------------------------------------------
 * | 数据 (cim/index.js)
 * +------------------------------------------------------------
 * | @copyright: CIM (https://cimxx.com)
 * +------------------------------------------------------------
 */

;(function (factory) {
    if (typeof define === "function" && define.amd) {
        define(factory);
    } else {
        if (typeof window.cim != "function") window.cim = {};
        window.cim.index = factory();
    }
})(function () {
    var index = {

        like: function () {

        },
        hits: function () {
            var $hits = $('[rel=hits]');
            $hits.each(function () {
                var $this = $(this);
                var id = $this.data('id');
                $.get('/index/api/hits?id=' + id, function (rs) {
                    $this.text(rs);
                });
            });
        },
        highlight: function (text) {
            $('*[rel=highlight]').each(function () {
                $(this).html($(this).html().replace(new RegExp(text, 'gm'), '<em class="highlight">' + text + '</em>'));
            });
        },

        top: function () {

        },
        redpack: function () {
            $('[rel=redpacket]').each(function () {
                $(this).click(function () {
                    var id = $(this).data('id');
                    var cid = $(this).data('cid');
                    var key = $(this).data('key');
                    var param = {
                        id: id,
                        cid: cid,
                        key: key
                    };
                    $.post("/index/api/view_behavior", param, function (rs) {
                        console.log(rs);
                        var data = rs;
                        var peopleHtml = '';
                        if (data.history.length == 0) {
                            peopleHtml = '<div class="text-center mt-lg mb-md">暂时还没有人获得红包哦,去试试手气吧</div><hr>';
                        } else {
                            for (var i = 0; i < data.history.length; i++) {
                                peopleHtml = peopleHtml + "<div class='text-center col-xs-2 mb-sm'><img src='${data.history[i].avatar}' height='60' width='60' class='img-rounded'> <p class='mt-sm'>${data.history[i].name}</p></div>";
                            }
                            peopleHtml = '<p class="text-center mt-sm mb-sm">他们已经抢到了红包</p><hr class="mt-sm mb-md">' + peopleHtml;
                        }
                        var html = "<div style='padding:30px'><div class='row'><p class='text-center mb-md' style='font-size:22px;color:#ff2d50'>通过移动端登录分享即可获得红包哦</p><hr class='mb-md'> <div class='col-xs-12 text-center'> <img src='/index/api/qr_code?content=${data.mobile_url}' width='160' height='160' alt=''></div> </div> <div class='row'> ${peopleHtml} </div></div>";
                        require(['layer'], function (layer) {
                            layer.open({
                                type: 1,
                                shadeClose: true,
                                title: false,
                                area: ['560px', '500px'],
                                content: html
                            });
                        });
                    });
                });
            });
        },
        report: function () {
            console.log('report');
        },
        comment: function () {
            var $comment = $('[rel=comment]');
            if ($comment.length > 0) {
                $comment.each(function () {
                    if (parseInt($(this).data('count')) > 0) {
                        var params = {
                            "data_id": $(this).data('data_id')
                        };
                        $.getJSON('/index/api/comment', params, function (rs) {
                            if (rs.data.length > 0) {
                                var tpl_id = $this.data('comment_id') != undefined ? 'tpl_comment_reply' : 'tpl_comment';
                                $(this).children('comment_data').html(template(tpl_id, rs));
                            } else {
                                $(this).children('comment_data').html(template($('#tpl_comment_empty').html()));
                            }
                        });
                    } else {
                        $(this).children('comment_data').html(template($('#tpl_comment_empty').html()));
                    }
                });
            }
        }
    };

    return index;
});