/**
 * +------------------------------------------------------------
 * | 消息 (cim/message.js)
 * +------------------------------------------------------------
 * | @copyright: CIM (https://cimxx.com)
 * +------------------------------------------------------------
 * | meter() 计价器
 * | 
 * +------------------------------------------------------------
 */

;(function (factory){
    if ( typeof define === "function" && define.amd ) {
        define(factory);
    } else {
        if ( typeof window.cim != "function" ) window.cim = {};
        window.cim.message = factory();
    }
})(function(){
    var message = {
        //计价器
        meter : function() {
            if (arguments.length==0) {
                $('[name=num]').bind('input propertychange', function() {
                    var $num = $(this);
                    if (Number($num.val()) >= $num.attr('max')) {
                        $num.val($num.attr('max')); //限制置顶最大天数
                    }
                    if ($num.data('credit')) $('[rel=credit]').text(parseFloat(Number($num.val()) * 100 * Number($num.data('credit')) / 100));
                    if ($num.data('money')) $('[rel=money]').text(parseFloat(Number($num.val()) * 100 * Number($num.data('money')) / 100));
                });
            }
        },
        remove : function(){
            
        }
    };

    return message;
});