/**
 * +------------------------------------------------------------
 * | 配置 (config.js)
 * +------------------------------------------------------------
 * | @copyright: CIM (https://cimxx.com)
 * +------------------------------------------------------------
 * | require.js 参数配置
 * | js接口配置
 * +------------------------------------------------------------
 */

require.config({
    baseUrl: "/static/js/",
    paths: {
        "jquery": ["https://cdn.staticfile.org/jquery/1.12.4/jquery.min", "plugin/jquery/jquery-1.12.1.min"],
        "bootstrap": ["https://cdn.staticfile.org/twitter-bootstrap/3.3.7/js/bootstrap.min", "plugin/bootstrap/js/bootstrap.min"],
        "cookie": ["https://cdn.staticfile.org/jquery-cookie/1.4.1/jquery.cookie.min", "plugin/jquery/jquery.cookie.min"],
        "axios": "plugin/axios/axios.min",
        "cropper": "plugin/cropper/cropper.min",
        "upload": "plugin/jquery/jquery.upload",
        "lazyload": "plugin/jquery/jquery.lazyload",
        "jstorage": "plugin/jStorage.min",
        "laydate": "plugin/laydate/laydate",
        "layer": ["https://cdn.staticfile.org/layer/2.3/layer", "plugin/layer/layer"],
        "md5": "plugin/md5/browser-md5-file.min",
        "moment": "plugin/moment/moment-with-locales.min",
        "sortable": "plugin/sortable/sortable.min",
        "swiper": "plugin/swiper/swiper.min",
        "tagging": "plugin/tagging",
        "baidutemplate": "plugin/baiduTemplate",
        "template": ["https://cdn.staticfile.org/template_js/0.7.1-1/template.min", "plugin/template"],
        "validator": "plugin/validator/local/zh-CN",
        "vue": "plugin/vue/vue.min",
        "simditor": ["https://cdn.staticfile.org/simditor/2.3.21/lib/simditor.min", "plugin/simditor/simditor"],
        "webuploader": ["https://cdn.staticfile.org/webuploader/0.1.1/webuploader.html5only.min", "plugin/webuploader/webuploader.html5only.min"],
    },
    map: {
        "*": {
            css: "plugin/require-css/css.min"
        }
    },
    shim: {
        "cropper": ["css!plugin/cropper/cropper.min.css"],
        "jstorage": {
            exports: "$.jStorage"
        },
        "laydate": {
            deps: ["css!plugin/laydate/theme/default/laydate.css"],
            exports: "laydate"
        },
        "cookie": ["jquery"],
        "upload": ["jquery"],
        "lazyload": ["jquery"],
        "layer": ["css!https://cdn.staticfile.org/layer/2.3/skin/layer.css"],
        "moment": ["/static/js/plugin/moment/moment.min.js"],
        "simditor": {
            deps: ["jquery", "css!plugin/simditor/simditor.css", "plugin/simditor/module", "plugin/simditor/hotkeys", "plugin/simditor/uploader"],
            exports: "Simditor"
        },
        "webuploader": {
            deps: ["css!https://cdn.staticfile.org/webuploader/0.1.1/webuploader.css"],
            exports: "WebUploader"
        },
        "swiper": {
            deps: ["css!plugin/swiper/swiper.css"],
            exports: "Swiper"
        },
        "tagging": ["jquery"],
        "validator": ["/static/js/plugin/validator/jquery.validator.js?css"],
    },
    urlArgs: "v=1222",
    waitSeconds: 200
});

var API = {
    "comment" : "/index/api/comment",
    "report" : "/index/api/report",
    "hits" : "/index/api/hits",
};