define(['require', 'common'], function(require, common) {

    //添加标签
    common.captcha();
    var tags;
    if ($('[rel=tags]').length) {
        require(['tagging', 'layer'], function(tagging, layer) {
            tags = $("[rel=tags]").tagging({
                "type-zone-placeholder": "按回车或空格生成标签",
                "type-zone-class": "type-zone",
                "edit-on-delete": false,
                "tag-on-blur": false,
                "tags-limit": 5,
                "no-duplicate-text": "已存在标签:",
                "no-duplicate-callback": function(rs) {
                    layer.msg(rs[0]);
                }
            });
            $('.pre-tags label').click(function() {
                var txt = $(this).text();
                console.log(txt)
                tags[0].tagging("add", $(this).text().trim());
            });
        });
    }
    require(['layer'], function(layer) {
        $('[rel=submit]').click(function() {
            var tagList = tags[0].tagging("getTags");
            var title = $('[name=title]').val();
            var content = $('[name=content]').val();
            var linkway = $('[name=linkway]').val();
            var captcha = $('[name=captcha]').val();
            if (!content) {
                layer.msg('请填写反馈内容');
                return false;
            }
            if (!captcha) {
                layer.msg('请输入验证码');
                return false;
            }
            $.ajax({
                type: 'POST',
                url: '/index/api/feedback_form',
                data: { tags: tagList, title: title, content: content, linkway: linkway, captcha: captcha },
                daratype: "json",
                success: function(data) {
                    if (data.code == 1) {
                        $('[name=title]').val('');
                        $('[name=content]').val('');
                        $('[name=linkway]').val('');
                        $('[name=captcha]').val('');
                        tags[0].tagging("reset")
                        layer.msg(data.msg);
                    } else {
                        layer.msg("再试试。。。反馈提交失败");
                    }
                }
            });
        })
    });
});